#!/usr/bin/perl

#
### CONTROL PANEL SCRIPT FOR ULTIMATE BULLETIN BOARD ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1997, 1998.
#
#       ------------ cpanel2.cgi -------------
#
#  This file contains some of the control panel functionality for
#  the UBB.  It is called from the controlpanel pages (cp.html).
#
#  NOTE: you MAY NOT redistribute this script under any
#  circumstance.  This means that you may not sell, trade, or in
#  any other way give this script to another user who is not
#  licensed to use it.  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";

print ("Content-type: text/html\n\n");
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "mods.file";
require "Date.pl";
require "UltBB.setup";
require "Styles.file";
require "ubb_library.pl";
require "ubb_library2.pl";
};


if ($@) {
    print "Error including required files: $@\n";
    print "Make sure these files exist, permissions are set properly, and paths are set correctly.";
 exit;
}

&ReadParse;

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	if ($Name eq "ViewEntire") {
			$ViewEntire = $Value;
		}
	if ($Name eq "NN") {
			$SearchName = $Value;
			$SearchName =~tr/A-Z/a-z/; 
			}
	if ($Name eq "BBEmail") {
			$BBEmail = $Value;
			$BBEmail =~ s/@/\\@/;
			}
			
	if ($Name eq "Forum1") {
			$Forum1 = $Value;
			$Forum1 =~ s/"/&quot;/g;
		}
	
	if ($Name eq "BBRules") {
			$BBRules = $Value;
			$BBRules =~ s/"/&quot;/g;
			$BBRules =~ s/\@/\\@/g;
			$BBRules = &ConvertReturns($BBRules);
			}
		if ($Name eq "censorwords") {
			$censorwords = $Value;
			$censorwords = &EliminateReturns($censorwords);
			$censorwords =~ s/<BR>//ig;
			$censorwords =~ s/<P>//ig;
			$censorwords =~ s/"/&quot;/g;
			$censorwords =~ s/\@/\\@/g;
			}
		if ($Name eq "YourCopyrightNotice") {
			$YourCopyrightNotice = $Value;
			$YourCopyrightNotice = &EliminateReturns($YourCopyrightNotice);
			$YourCopyrightNotice =~ s/"/&quot;/g;
			$YourCopyrightNotice =~ s/<BR>//ig;
			$YourCopyrightNotice =~ s/<P>//ig;
			$YourCopyrightNotice =~ s/\@/\\@/g;
			}
		if ($Name eq "Header") {
			$Header = $Value;
			$Header =~ s/"/\\"/g;
		#	$Header = &ConvertReturns($Header);
			$Header =~ s/\@/\\@/g;
			}
		if ($Name eq "Footer") {
			$Footer = $Value;
			$Footer =~ s/"/\\"/g;
		#	$Footer = &ConvertReturns($Footer);
			$Footer =~ s/\@/\\@/g;
			}
	if ($Name eq "ForumStatus1") {
			$ForumStatus1 = $Value;
			}
	
	
	if ($Name eq "MyHomePage") {
			$MyHomePage = $Value;
			}
	
	if ($Name eq "HomePageURL") {
			$HomePageURL = $Value;
			}
	
	if ($Name eq "number") {
			$number = $Value;
			}

	if ($Name eq "UpdateType") {
			$UpdateType = $Value;
			}		
	if ($Name eq "TotalForums") {
			$TotalForums = $Value;
			}
	if ($Name eq "BBName") {
			$BBName = $Value;
			}
	if ($Name eq "ForumsPath") {
			$ForumsPath = $Value;
			}
			if ($Name eq "MembersPath") {
			$MembersPath = $Value;
			}
			if ($Name eq "CGIPath") {
			$CGIPath = $Value;
			}
				if ($Name eq "VariablesPath") {
			$VariablesPath = $Value;
			}
	if ($Name eq "MembersCGIPath") {
			$MembersCGIPath = $Value;
			}
			if ($Name eq "NonCGIPath") {
			$NonCGIPath = $Value;
			}
			if ($Name eq "CGIURL") {
			$CGIURL = $Value;
			}
			if ($Name eq "NonCGIURL") {
			$NonCGIURL = $Value;
			}
		
		if ($Name eq "UserNameCheck") {
			$UserNameCheck = $Value;
			$UserNameCheckFile = $UserNameCheck;
			$UserNameCheckFile =~ s/ /_/g; #remove spaces
			}

		if ($Name eq "UserName") {
			$UserName = $Value;
			$UserNameFile = $UserName;
			$UserNameFile =~ s/ /_/g; #remove spaces
		}
			if ($Name eq "Password") {
			$Password = $Value;
			}
			if ($Name eq "PasswordCheck") {
			$PasswordCheck = $Value;
			}
				if ($Name eq "action") {
			$action = $Value;
			}
			
} #end foreach loop

if ($VariablesPath eq "") {
	$VariablesPath = "$CGIPath";
}

#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$PageBackground");
}
if ($action eq "mods") {
&Mods;
}

if ($action eq "doupdate") {
##verify that this user is an administrator

$NameFound = "no";
  if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
    } 

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserName.cgi");
			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
#determine number of total forums
open (FORUMFILE, "$VariablesPath/forums.cgi");
	@forums = <FORUMFILE>;
close (FORUMFILE);
@forums = grep(/\|/, @forums);
$TotalForums = @forums;

&ConvertForums2HTML("1", "$TotalForums", "0");
   
	   }  else {
	   &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} #end do update (threads) sr

if ($action eq "setgenvars") {
&SetGenVars;
}
if ($action eq "doindex") {
   &DoIndex;
}

if ($action eq "ContinueUpdate") {
&ConvertForums2HTML("$number", "$TotalForums", "$in{'StartWith'}");
}

if ($action eq "sendstyle") {
&SendStyle;
}
if ($action eq "getmatches") {
&GetMatches;
}

if ($action eq "updatepermiss") {
&UpdatePermiss;
}

if ($action eq "sendvarID") {
&SendVarID;
}


if ($action eq "DoGenVars") {
&DoGenVars;
}


if ($action eq "ContinueIndexing") {
&ReIndex("$in{'start'}", "$in{'threadpoint'}");
}


sub SendVarID {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator
$NameFound = "no";
if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
	} 
if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoGenVars;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

} # end SendVarsID sr

sub DoGenVars {

			$BBRules =~ s/&quot;/"/ig;
			$BBRules =~ s/<BR>/\n/ig;
			$BBRules =~ s/<p>/\n\n/ig;

if ($DaysPruneDefault eq "") {
	$Days20 = "SELECTED";
}
if ($DaysPruneDefault == 1) {
	$Days1 = "SELECTED";
}

if ($DaysPruneDefault == 2) {
	$Days2 = "SELECTED";
}

if ($DaysPruneDefault == 5) {
	$Days5 = "SELECTED";
}

if ($DaysPruneDefault == 10) {
	$Days10 = "SELECTED";
}

if ($DaysPruneDefault == 20) {
	$Days20 = "SELECTED";
}

if ($DaysPruneDefault == 30) {
	$Days30 = "SELECTED";
}

if ($DaysPruneDefault == 45) {
	$Days45 = "SELECTED";
}

if ($DaysPruneDefault == 60) {
	$Days60 = "SELECTED";
}

if ($DaysPruneDefault == 75) {
	$Days75 = "SELECTED";
}

if ($DaysPruneDefault == 100) {
	$Days100 = "SELECTED";
}

if ($DaysPruneDefault == 365) {
	$Days365 = "SELECTED";
}
		
if ($CategoryView eq "yes") {
	$CategoryViewOn = "CHECKED";
}  else {
	$CategoryViewOff = "CHECKED";
}
			
if ($SMTPEmail eq "Off") {
	$SMTPOff = "CHECKED";
}  else {
	$SMTPOn = "CHECKED";
}
if ($EmailVerify eq "ON") {
	$EmailVerifyOn = "CHECKED";
}  else {
	$EmailVerifyOff = "CHECKED";
}

if ($EditOption eq "ON") {
	$EditOptionOn = "CHECKED";
}  else {
	$EditOptionOff = "CHECKED";
}						
if ($ForumDescriptions eq "yes") {
	$ForumDescriptionsOn = "CHECKED";
}  else {
	$ForumDescriptionsOff = "CHECKED";
}
		
if ($Censor eq "ON") {
	$CensorOn = "CHECKED";
}  else {
	$CensorOff = "CHECKED";
}

if ($ForumTotalOption eq "Both") {
	$FTOBoth = "CHECKED";
}
elsif  ($ForumTotalOption eq "Topics"){
	$FTOTopics = "CHECKED";
}	else {
$FTOPosts = "CHECKED";
}



if ($AllowSignature eq "YES") {
	$AllowSigYes = "CHECKED";
}  else {
	$AllowSigNo = "CHECKED";
}	
if ($UseEmail eq "ON") {
	$EmailOn = "CHECKED";
}  else {
	$EmailOff = "CHECKED";
}		
		
if ($EmailBlock eq "ON") {
	$EmailBlockOn = "CHECKED";
}  else {
	$EmailBlockOff = "CHECKED";
}		

if ($TimeFormat eq "24HR") {
	$Time24HR = "CHECKED";
}  else {
	$TimeAMPM = "CHECKED";
}		
if ($DateFormat eq "Euro") {
	$DateEuro = "CHECKED";
}
elsif ($DateFormat eq "EuroX") {
	$DateEuroX = "CHECKED";
}
elsif ($DateFormat eq "USX") {
	$DateUSX = "CHECKED";
}  else {
	$DateUS = "CHECKED";
}

if ($EmailCheck eq "true") {
	$EmailTrue = "CHECKED";
}  else {
	$EmailFalse = "CHECKED";
}
if ($CGIPath eq "") {
	@cgipath = split(/\//, $ENV{'SCRIPT_FILENAME'});
	pop(@cgipath);
	$CGIPath = join("\/", @cgipath);
	$VariablesPath = $CGIPath;
	$MembersPath = ("$CGIPath" . "/Members");
}
if ($NonCGIPath eq "") {
	$NonCGIPath = "$ENV{'DOCUMENT_ROOT'}";
	$ForumsPath = "$ENV{'DOCUMENT_ROOT'}";
}

if ($NonCGIURL eq "") {
	$NonCGIURL = "http://$ENV{'HTTP_HOST'}";
	$CGIURL = "http://$ENV{'HTTP_HOST'}";
	$HomePageURL = "http://$ENV{'HTTP_HOST'}";
	$BBEmail = "$ENV{'SERVER_ADMIN'}";
}

if ($MemberMinimum eq "") {
	$MemberMinimum = "31";
}

if ($TimeZoneOffset eq "") {
	$TimeZoneOffset = "0";
}

$PageTitle = "Set Variables";
&HEADERHTML;

print<<THIS;
To check your environmental variables, <A HREF="cpanel.cgi?action=env">click here</A>.
<P>
Socket Test: To check to see if the Socket module is included on the Perl installation on your web server, <A HREF="ubbmisc.cgi?action=sockettest">click here</A>. If you receive an error or a blank page, then Socket may not be installed (<A HREF="http://www.ultimatebb.com/home/faq.html#socket" target="_blank">Read This</A>, if Socket is not installed.).
<P>
<b>Note: if you are configuring your system for the first time, you MUST start with General Variables below!</B>

<P><HR>
<B>Variables: &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; <A HREF="#GENVAR">General Variables</A> | <A HREF="cpanel.cgi?action=style">Styles</a> | <A HREF="cpanel.cgi?action=logintoforums">Forums</a></B>
<HR>

<BR>
<BR>
<U><B><FONT SIZE="4" FACE="COurier New" COLOR="#800000"><A NAME="GENVAR">General Variables</A></FONT></B></U>
<P>
<FORM ACTION="cpanel2.cgi" NAME="THEFORM" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="setgenvars">
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">absolute paths</FONT></B>
</TD></TR>
<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Absolute paths reflect the physical locations of directories on a server.  They are the complete locations, not the locations from the web root, but from the server root.  Absolute paths on Win32/NT servers are displayed differently than on UNIX systems.  For instance, note the following samples for UNIX and NT:
<p>
For UNIX servers:  &nbsp;&nbsp;&nbsp;&nbsp;<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">/usr/home/yourdomain/www/cgi-bin</font>
<BR>
For Win32/NT servers:&nbsp;&nbsp;&nbsp;&nbsp; <FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000">C:/home/yourdomain/cgi-bin</FONT>
<P>
Note: the paths listed above are examples, not your actual paths.
<P>
If you are installing on Win32/NT, be sure to use the format above for your absolute paths (note the forward slashes, rather than backward slashes).
<BR>
If you are installing for the first time, the UBB will attempt to provide complete or partial absolute paths for you.  These paths may not be accurate or complete, but they will give you a headstart.  All absolute path fields MUST be provided for your UBB to run.</B></FONT>
</td></tr>
<tr bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path for your UBB CGI DIRECTORY</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="CGIPath" VALUE="$CGIPath" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path of your UBB NON CGI Directory</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="NonCGIPath" VALUE="$NonCGIPath" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path to Members Directory</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="$LinkColor">This path should end in /Members (as in "/usr/home/yourdomain/www/cgi-bin/Members")</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="MembersPath" VALUE="$MembersPath" SIZE=40 MAXLENGTH=250>
</td></tr>
<tr bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Absolute Path to Directory Where Your Custom Variable Files  Reside</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><B>You should use the same absolute path that you used for your CGI directory above</B>.  If for some reason you cannot write to files in your CGI directory, however, you should place these files (UltBB.setup, forums.cgi, mods.file, Styles.file) in a directory below the web root so that they cannot be accessed by anyone from the browser. </FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="VariablesPath" VALUE="$VariablesPath" SIZE=40 MAXLENGTH=250>
</td></tr>
</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">URLs</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Please provide the following complete hyperlinks.  Use complete hyperlinks, such as http://www.yourdomain.com/cgi-bin, rather than relative links such as "/cgi-bin"</B></FONT>
</td></tr>

<tr bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>URL for your UBB CGI Directory</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="CGIURL" VALUE="$CGIURL" SIZE=40 MAXLENGTH=250>
</td></tr>

<tr bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>URL for your UBB Non-CGI Directory</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="NonCGIURL" VALUE="$NonCGIURL" SIZE=40 MAXLENGTH=250>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Home Page URL</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The complete URL for your home page (not the bulletin board).  This will be used for links back to your homepage.</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="HomePageURL" VALUE="$HomePageURL" SIZE=40 MAXLENGTH=250>
</td></tr>
</table>
<P>

<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Display Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Please complete the following fields, which provide information such as your BB Name, the name of your home page, the email address to be displayed, headers and footers to use on each page, etc.</B></FONT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Email Address</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">This is email address that will be shown so that users can contact you</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="BBEmail" VALUE="$BBEmail" SIZE=30 MAXLENGTH=250>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Name of Your Bulletin Board</B><br></FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="BBName" VALUE="$BBName" SIZE=30 MAXLENGTH=250>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Name of Your Home Page</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The name of your homepage, which will listed for links back to your homepage.</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="MyHomePage" VALUE="$MyHomePage" SIZE=30 MAXLENGTH=250>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Default Topic View (Days)</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The default number of days for the "Show Topics Going Back X Days" option.  Users are able to customize this through preferences, but this is the default that will be given, otherwise.  Recommended: 20.</FONT>
</td>
<td width=50% valign=top>
<SELECT NAME="DaysPruneDefault">
	<OPTION value="1" $Days1>Show topics from last day
	<OPTION value="2" $Days2>Show topics from last 2 days
	<OPTION value="5" $Days5>Show topics from last 5 days
	<OPTION value="10" $Days10>Show topics from last 10 days
	<OPTION value="20" $Days20>Show topics from last 20 days
	<OPTION value="30" $Days30>Show topics from last 30 days
	<OPTION value="45" $Days45>Show topics from last 45 days
	<OPTION value="60" $Days60>Show topics from last 60 days
	<OPTION value="75" $Days75>Show topics from last 75 days
	<OPTION value="100" $Days100>Show topics from last 100 days
	<OPTION value="365" $Days365>Show topics from the last year
</SELECT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Header</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can add your own customized header graphic, ad banner, text, etc.  This header will appear at the top of each primary UBB page.  This is completely optional.  Leave this field blank if you don't need to use it.</FONT>
</td>
<td width=50% valign=top>
<TEXTAREA NAME="Header" COLS="30" ROWS="5" WRAP="VIRTUAL">$Header</TEXTAREA>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Footer</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can add your own customized footer graphic, ad banner, text, etc.  This header will appear near the bottom of each primary UBB page.  This is completely optional.  Leave this field blank if you don't need to use it.</FONT>
</td>
<td width=50% valign=top>
<TEXTAREA NAME="Footer" COLS="30" ROWS="5" WRAP="VIRTUAL">$Footer</TEXTAREA>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Category View Option</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">If you have numerous forums, or merely an ecletic collection of forums, you may want to assign categories to each forum.  You assign the category names when you Set Forums.  In order to have your forums displayed in Catgory format, you must click on the yes button to the right.</FONT></td>
<td width=50% valign=top>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080">
<INPUT TYPE="RADIO" NAME="CategoryView" VALUE="yes" $CategoryViewOn> yes 
<INPUT TYPE="RADIO" NAME="CategoryView" VALUE="no" $CategoryViewOff> no
</FONT></CENTER>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Display Forum Descriptions?</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">If you have many forums, you may not want to display your forum descriptions.  If not, check no.</FONT></td>
<td width=50% valign=top>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="ForumDescriptions" VALUE="yes" $ForumDescriptionsOn> yes
<INPUT TYPE="RADIO" NAME="ForumDescriptions" VALUE="no" $ForumDescriptionsOff> no
</FONT></CENTER>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Bulletin Board Rules</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can customize the exact wording for your bulletin board's rules.  Just edit the wording in the box to the right.</FONT>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>$BBName Rule Wording:</B><br></FONT>
<TEXTAREA NAME="BBRules" ROWS=8 COLS=35 wrap="virtual">$BBRules
</TEXTAREA>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Your Copyright Wording</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">This wording will appear in smaller print directly above the copyright wording concerning the UBB program itself. You can leave this blank or provide any wording you like.</FONT>
</td>
<td width=50% valign=top>
<TEXTAREA NAME="YourCopyrightNotice" ROWS=3 COLS=30 WRAP="VIRTUAL">$YourCopyrightNotice
</TEXTAREA>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Block Public Display of User Email Addresses?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The default option is to have registered user's email addresses viewable on the pages for which the user has posted a note.  You may prevent all user email addresses from being displayed by selecting "Block Email Address Display" in the field to the right.  These addresses will still be available to you if you check the user's info in the "User Info/Permissions" area of the Control Panel.</FONT>
</td><td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="EmailBlock" VALUE="ON" $EmailBlockOn> Block Public Display of User Email Addresses<BR>
<INPUT TYPE="RADIO" NAME="EmailBlock" VALUE="OFF" $EmailBlockOff> Show User Email Addresses</FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Allow Signatures?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You may allow your users to use their own unique signatures when they post messages.  Note: your users will be permitted to use UBB Code (but not HTML) in their signature files.  The UBB Code Image tag will not be permitted, however.</FONT>
</td><td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="AllowSignature" VALUE="YES" $AllowSigYes> Allow Signatures<BR>
<INPUT TYPE="RADIO" NAME="AllowSignature" VALUE="NO" $AllowSigNo> Don't Allow Signatures</FONT>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Show Total Topics/Posts/Both?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">On the first UBB display page that lists all of your forums, you may display either the total topics within each forum, the total posts within each forum, or both the total topics and total posts.</FONT>
</td><td width=50% valign=top>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="ForumTotalOption" VALUE="Topics" $FTOTopics> Show Total Topics Only<BR>
<INPUT TYPE="RADIO" NAME="ForumTotalOption" VALUE="Posts" $FTOPosts> Show Total Posts Only<BR>
<INPUT TYPE="RADIO" NAME="ForumTotalOption" VALUE="Both" $FTOBoth> Show Both Total Topics and Total Posts
</FONT>
</td></tr>
</table>
<P>
<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Email Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>The UBB provides two methods for handling all functions that involve email.  The preferred method is to use your SMTP email server via the Perl Sockets module.  This is the most efficient means of delivering email.  To use this, you must have an email account on the server that you are using (or have access to an SMTP email server that will allow you to relay to it).  You must also have the Perl Socket module installed (that is a standard module in Perl 5, but some web hosts do not include it).  An alternative means of delivering email is with UNIX sendmail. You must be using a UNIX web server in oder to use Sendmail.</B></FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email On/Off</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">To enable all functions that send email to users, set this field to on.  If for some reason email features don't seem to be working for your system, you may simply turn them off.</FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="UseEmail" VALUE="ON" $EmailOn> on
<INPUT TYPE="RADIO" NAME="UseEmail" VALUE="OFF" $EmailOff> off</FONT></CENTER>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Server Name</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">This is the SMTP email server that will be used to send email from the UBB.  Use whatever you use for your email account (check your email settings under "SMTP server").  This is used for the Sockets option.  If you are using Sendmail to perform your Email functions (see next row for Email Process options), you may leave this field blank.
</FONT><BR>
<INPUT TYPE="TEXT" NAME="EmailServer" VALUE="$EmailServer" SIZE=25 MAXLENGTH=50>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Process To Use</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Select the Email Method (described above) you wish to use.  Note that the sendmail option will not work with Win32/NT web servers.  You also must know the location of your web server's sendmail program in order to use the sendmail option.  If you select Sendmail, be sure to complete the field to the right.</FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080">
<INPUT TYPE="RADIO" NAME="SMTPEmail" VALUE="On" $SMTPOn> SMTP Email/Sockets<BR>
<INPUT TYPE="RADIO" NAME="SMTPEmail" VALUE="Off" $SMTPOff> SendMail</FONT></CENTER>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>SendMail Location</B></font><P><FONT SIZE="1" FACE="Verdana, Arial">If you are using the Sendmail Email option, you must designate the location of the UNIX sendmail program on your web server below.  You must list the absolute path to the sendmail program.  For example, your sendmail location may be: /usr/bin/sendmail<BR></FONT>
<BR>
<INPUT TYPE="TEXT" NAME="SendMailLocation" VALUE="$SendMailLocation" SIZE=25 MAXLENGTH=50>
</td></tr>

</table>
<P>

<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Date/Time Display Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>The UBB can display dates and times in a number of different formats.  Remember that the times listed are based on the location of your web server, which may be different than the time zone where you reside/work.  You can change the time zone displayed by using the Time Zone Offset field.  For instance, if you are on the East Coast of the US, but your server is on the West Coast of the US, you could use EST as your Time Zone to display, but you would have to offset the server time to reflect that (by typing a 3 in the Time Zone Offset field, reflecting the 3 hours difference).  If the Time Zone difference is negative, use a negative number (as in -2).</B></FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Time Zone</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The time of each posting is based on the time zone where your server is located.  If you want your users to know the time zone, provide it here (e.g., ET, CT, PT, etc.).  You may also leave this blank if you would prefer not to show a time zone.  You may type a different time zone than your server uses, but if you do so be sure to provide a time zone offset in the next field.</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="TimeZone" VALUE="$TimeZone" SIZE=20 MAXLENGTH=35>
</td></tr>


<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Server Time Zone Offset</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can offset the time drawn from your web server.  For instance, if your server time is EST (US), but you want all time to reflect Pacific Time (US), you would have to offset your server time by placing the time zone difference in this field (for this example, that would be -3.  You would place -3 in this field).  The default is for there to be no server time zone offset (0).</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="TimeZoneOffset" VALUE="$TimeZoneOffset" SIZE=3 MAXLENGTH=4>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Date Format</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">European Format is DD-MM-YR, while US format is MM-DD-YR.  Expanded formats include full month name.</FONT>
</td>
<td width=50%>
<FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="US" $DateUS> US Format (e.g., 04-25-98)<BR>
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="USX" $DateUSX> Expanded US Format (e.g., April 25, 1998)<BR>
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="Euro" $DateEuro> European Format (e.g., 25-04-98)<BR>
<INPUT TYPE="RADIO" NAME="DateFormat" VALUE="EuroX" $DateEuroX> Expanded European Format (e.g., 25 April 1998)
</font>
</td></tr>
<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Time Format</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You can have time displayed in AM/PM format, or in 24-hour format.</FONT>
</td>
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="TimeFormat" VALUE="AMPM" $TimeAMPM> Use AM/PM Time Format<BR>
<INPUT TYPE="RADIO" NAME="TimeFormat" VALUE="24HR" $Time24HR> User 24-Hour Format Time (eg, 23:15)
</font>
</td></tr>
</table>
<P>

<table border=0 width=100%>
<TR bgcolor="#000000"><TD COLSPAN=2 align=center><B><FONT SIZE="2" FACE="Verdana, Arial" color="#FFFF00">Miscellaneous Options</FONT></B>
</TD></TR>

<TR bgcolor="#FCF0C0">
<TD colspan=2><FONT SIZE="1" FACE="Verdana, Arial">
<B>Below are numerous configuration options for your UBB.</B></FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Verify User Email Address During Registration?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">For tighter security, you may want to require that your registered users have valid email addresses.  This is accomplished by mailing their password to them at the email address they register.  To enable email verification during registration, click yes in the field to the right.</FONT>
</td><td valign=top width=50%>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="EmailVerify" VALUE="ON" $EmailVerifyOn> yes
<INPUT TYPE="RADIO" NAME="EmailVerify" VALUE="OFF" $EmailVerifyOff> no</FONT></CENTER>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Email Duplicate Check</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">The default option is to require unique email addresses for each registered user.  This means that no two users can have the same email address. You can disable this requirement by checking the "Unique Email Not Required" box.</FONT>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><INPUT TYPE="RADIO" NAME="EmailCheck" VALUE="true" $EmailTrue> Unique Email Required<br>
<INPUT TYPE="RADIO" NAME="EmailCheck" VALUE="false" $EmailFalse> Unique Email Not Required
</FONT>
</td></tr>

<TR bgcolor="#f7f7f7">
<td width=50%>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Minimum Number of Messages For Full Member Status</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Registered users are initially called Junior Members.  After a certain number of postings, the member will be automatically upgraded to full Member.  The default is 31 messages, but you can reset this value here.</FONT>
</td>
<td width=50% valign=top>
<INPUT TYPE="TEXT" NAME="MemberMinimum" VALUE="$MemberMinimum" SIZE=5 MAXLENGTH=5>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Censor Option</B><br></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">You may have certain words censored on your BB.  Words you choose to censor will be replaced by asterisks.  All subjects and messages will be affected. To activate the censor function, check the "yes" button below.  To deactivate, press the "no" button.  List all censored words in the field to the right.</FONT>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="Censor" VALUE="ON" $CensorOn> yes
<INPUT TYPE="RADIO" NAME="Censor" VALUE="OFF" $CensorOff> no
</FONT></CENTER>
</td>
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Censor Words</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Type all words you want censored in the field below.  Do not use commas to separate words, just use spaces.  For example, type "dog cat boy", rather than "dog, cat, boy."  If you type "dog", all words containing the string "dog" would be censored (dogma, for instance, would appear as "***ma").  To censor more accurately, you can require that censors occur only for exact words.  You can do this by placing a censor word in curly braces, as in {dog}.  Signifying "dog" in the curly braces would mean that dogma would appear as dogma, but dog would appear as "***".  Thus your censor list may appear as cat "{dog} {barn} barn."
</FONT><BR>
<TEXTAREA NAME="censorwords" ROWS=3 COLS=30 WRAP="VIRTUAL">$censorwords
</TEXTAREA>
</td></tr>

<TR bgcolor="#dedfdf">
<td width=50% valign=top>
<FONT SIZE="2" FACE="Verdana, Arial"><B>Allow User Editing of Messages?</B><BR></FONT>
<FONT SIZE="1" FACE="Verdana, Arial" COLOR="#000080">Administrators and moderators can always edit and delete messages.  You may want to allow your users to edit their own messages.  They will not be able to edit other users' messages.  To do so, select "yes" to the right.</FONT>
</td><td width=50%>
<CENTER><FONT SIZE="2" FACE="Verdana, Arial" COLOR="#000080"><INPUT TYPE="RADIO" NAME="EditOption" VALUE="ON" $EditOptionOn> yes
<INPUT TYPE="RADIO" NAME="EditOption" VALUE="OFF" $EditOptionOff> no</FONT></CENTER>
</td></tr>
</table>
<P>
<br>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#000080"><B>Enter your UserName & Password:</font>
<P>
<FONT Size="1" FACE="Verdana, Arial" COLOR="#808000">(NOTE: if you are configuring your BB for the first time, type your default UserName and Password here)</font>
<p>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#000080">
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER>
<p><center>
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit General Variables"></center>
</form>
</BODY></HTML>
THIS
}


sub SendStyle {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator
$NameFound = "no";
if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
	} 

if ($NameFound eq "yes") {

	@theprofile = &OpenProfile("$UserName.cgi");
	
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcessStyle;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK



################
sub DoProcessStyle {
open (FILE, ">$VariablesPath/Styles.file") or die("Unable to open setup file for writing.");

foreach $one(@in) {
	($Name, $Value) = split ("=", $one);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	$Value =~ s/\@/\\@/g;
	$Value =~ s/"/\\"/g;
	print FILE ("\$$Name = \"$Value\";\n");
}

	print FILE ("1;\n");
close (FILE);
chmod (0777, "$VariablesPath/Styles.file");

$ConfirmLine = "The Ultimate Bulletin Board Style variables have been updated.<P>Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<br>";
&ConfirmHTML2;
} ## END DO PROCESS VARS


}  ## END SendStyle subroutine

sub UpdatePermiss {

@theprofile = &OpenProfile("$UserNameCheck.cgi");

if ($in{'PasswordCheck'} eq "$theprofile[1]") {
	$Status = "$theprofile[8]";
	&CheckStatus;
	   if ($AdminStatus eq "true") {
			&UpdateThePermissions;
		}  else {
			&StandardHTML("Sorry, but you are not authorized to perform this function.  Use your Back button.");
		} #end if adminstatus is true 
}  else {
&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
}
}  ## END UPdatePermiss SR ###


sub GetMatches {

##verify that this user is an administrator

$NameFound = "no";
if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
	} 

if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
			
	if ($Password eq "$theprofile[1]") {
	$Permission = "$theprofile[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   	   
if ($ViewEntire eq "Yes") {
	&GetAll;
	} else {
	&DoSearch;
	}
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
		
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK


## if admin priviledges, conduct search


sub GetAll {
&GetMemberListArray; #returns @members array

	@members = sort(@members);
	$TotalProfiles = @members;
	
if ($TotalProfiles > 0) {	

print <<HTML_TOP;
<HTML>
<HEAD><TITLE>
Ultimate Bulletin Board - Set Permissions - All Members</title>


<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}



function SetCursor() {
var thisUserNameCP = getCookie("UserNameCP");
var thisPasswordCP = getCookie("PasswordCP");

if (thisUserNameCP != null) {  
thisUserNameCP = unescape(thisUserNameCP);
thisPasswordCP = unescape(thisPasswordCP);

	document.PERMISS.UserNameCheck.value = thisUserNameCP;
document.PERMISS.PasswordCheck.value = thisPasswordCP;
	}  else {
	document.PERMISS.UserNameCheck.focus();
	}
}

function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to complete one or more of the form fields.");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
<body bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<FONT Size="2" FACE="Verdana, Arial">
<center>
<B><FONT SIZE="5" FACE="Courier New">Ultimate Bulletin Board<br>Set Permissions </FONT></B></center>
<p>
There are currently $TotalProfiles registered bulletin board members.
Make any changes necessary and then click on "Submit" to modify any/all user records.  Check the delete box on the left for all registrations you want deleted.<br><br>

<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="PERMISS" onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="updatepermiss">

<center>
<table width=600>
<tr bgcolor="#cccc99">
<td valign=bottom>
<FONT SIZE="1" FACE="Verdana, Arial">
<B>Delete?</B></font>
</td>
<td valign=bottom width=140><FONT SIZE="1" FACE="Verdana, Arial"><B>User Name<BR>Date Registered</B></FONT></td>
<td valign=bottom ><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000"><B>Able to post notes?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000"><B>Authorized Administrator?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Status</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Total Posts</B></FONT></td>
</tr>
HTML_TOP



for $line(@members) {

@searchrow = &OpenProfile("$line");

$UNCoded = $searchrow[0];
$UNCoded =~ tr/ /+/;
$Posts = $searchrow[7];
$Permission = $searchrow[4];
&CheckPermissions;
$DateReg = $searchrow[10];
$WriteYes = "";
$WriteNo = "";
$AdminYes="";
$AdminNo="";

if ($AdminWrite eq "true") {
   $WriteYes = "CHECKED";
}  else {
   $WriteNo = "CHECKED";
}
if ($AdminPermission eq "true") {
   $AdminYes = "CHECKED";
}  else {
   $AdminNo = "CHECKED";
}
####
if ($AltColor eq "") {
	$AltColor = "#dedfdf";
}
if ($AltColor eq "#f7f7f7") {
	$AltColor = "#dedfdf";
}  else {
$AltColor = "#f7f7f7";
}

print <<GUTS;
<tr bgcolor="$AltColor">
<td align=center>
<INPUT TYPE="CHECKBOX" NAME="Delete::$searchrow[0]" VALUE="yes">
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><A HREF="cpanel.cgi?action=getbio4admin&UserName=$UNCoded">$searchrow[0]</A><BR>$DateReg</font></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminWrite::$searchrow[0]" VALUE="true" $WriteYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminWrite::$searchrow[0]" VALUE="false" $WriteNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminPermission::$searchrow[0]" VALUE="true" $AdminYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminPermission::$searchrow[0]" VALUE="false" $AdminNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$searchrow[8]</FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$searchrow[7]</FONT></td>
</tr>
GUTS

####
} #end FOREACH

print <<ENDHTML;
</table>
</center>
<br>
<CENTER><FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER>
<p>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Permission Changes Now">
</form><FONT COLOR="#C0C0C0">
<BR><BR>Powered by: Ultimate Bulletin Board<br>
&copy; Madrona Park, Inc., 1998.<BR><BR>.</CENTER>
</FONT>
</FONT>
</body>
</html>
ENDHTML
}  else {
&StandardHTML("Sorry, but we couldn't find any users that matched your search criteria.  Please go back and try again!");
}

}  ## END GET ALL SR ##

sub DoSearch {
&GetMemberListArray;  #returns @members array
$TotalMembers = @members;
$CheckEmail = "$in{'Email'}";
$Search = 0;

foreach $member(@members) {

@searchfile = &OpenProfile("$member");
$bad = "no";

#start UserName check block

	if ($SearchName ne "") {

		unless ($searchfile[0] =~ /$SearchName/i) {
			$bad = "yes";
		}
	} 


	if (($CheckEmail ne "") && ($bad ne "yes")) {
			unless ($searchfile[2] =~ /$CheckEmail/i) {
				$bad = "yes";
			}
	} 
	# Check number of posts
	
	if (($in{'Posts'} ne "") && ($bad ne "yes")) {
		$PostNumber = $searchfile[7];
		$Math = $in{'Math'};
		if ($Math eq "GT") {
			unless ($PostNumber >= $in{'Posts'}) {
				$bad = "yes";
		}
		}
		if ($Math eq "LT") {
			unless ($PostNumber <= $in{'Posts'}) {
				$bad = "yes";	
			}  
		}
		if ($Math eq "EQ") {
			unless ($PostNumber == $in{'Posts'}) {
				$bad = "yes";
			}
		}
		
	} 

#start validation block

if ($bad ne "yes")  {
$Search++;

$line = ("$searchfile[0]" .  "|" .  "$searchfile[2]" .  "|"  . "$searchfile[4]" . "|" . "$searchfile[8]" . "|" . "$searchfile[7]" . "|" . "$searchfile[10]");
push (@final, $line);
}  

#close validation block

}  #end FOREACH $member


if ($Search > 0) {	

@final = sort(@final);

print <<HTML_TOP;
<HTML>
<HEAD>

<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}

function SetCursor() {
var thisUserNameCP = getCookie("UserNameCP");
var thisPasswordCP = getCookie("PasswordCP");

if (thisUserNameCP != null) {  
thisUserNameCP = unescape(thisUserNameCP);
thisPasswordCP = unescape(thisPasswordCP);

	document.PERMISS.UserNameCheck.value = thisUserNameCP;
document.PERMISS.PasswordCheck.value = thisPasswordCP;
	}   else {
	document.PERMISS.UserNameCheck.focus();
}
}

function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to complete one or more of the form fields.");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}

// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
<TITLE>
Ultimate Bulletin Board - Set Permissions - All Members</title></head>
<body bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<FONT Size="2" FACE="Verdana, Arial">

<CENTER><b>
<FONT SIZE="5" FACE="Courier New">Ultimate Bulletin Board<br>Set Permissions </FONT></B>
</center>
<p>
Total Registered Users: <FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000"><b>$TotalMembers</B></FONT><BR>
Search Matches: <FONT SIZE="2" FACE="Verdana, Arial" COLOR="#800000"><b>$Search</B></FONT>
<P>
Make any changes necessary and then click on "Submit" to modify any/all user records.  Check the delete box on the left for all registrations you want deleted.<br><br>

<FORM ACTION="cpanel2.cgi" METHOD="POST" NAME="PERMISS"  onSubmit="return Check(this)">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="updatepermiss">
<center>
<table width=95%>
<tr bgcolor="#cccc99">
<td valign=bottom>
<FONT SIZE="1" FACE="Verdana, Arial">
<B>Delete?</B></font>
</td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>User Name<BR>Date Registered</B></FONT></td>
<td valign=bottom ><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000"><B>Able to post notes?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial" COLOR="#FF0000"><B>Authorized Administrator?</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Status</B></FONT></td>
<td valign=bottom><FONT SIZE="1" FACE="Verdana, Arial"><B>Total Posts</B></FONT></td>
</tr>
HTML_TOP

foreach $line2(@final) {
		
	@searchrow = split (/\|/, $line2);
	
$UNCoded = $searchrow[0];
$UNCoded =~ tr/ /+/;

$Permission = $searchrow[2];
$DateReg = $searchrow[5];
&CheckPermissions;
$WriteYes = "";
$WriteNo = "";
$AdminYes="";
$AdminNo="";

if ($AdminWrite eq "true") {
   $WriteYes = "CHECKED";
}  else {
   $WriteNo = "CHECKED";
}
if ($AdminPermission eq "true") {
   $AdminYes = "CHECKED";
}  else {
   $AdminNo = "CHECKED";
}
if ($AltColor eq "") {
	$AltColor = "#dedfdf";
}
if ($AltColor eq "#f7f7f7") {
	$AltColor = "#dedfdf";
} else {
$AltColor = "#f7f7f7"
}

print <<GUTS;
<tr bgcolor=$AltColor>
<td align=center>
<INPUT TYPE="CHECKBOX" NAME="Delete::$searchrow[0]" VALUE="yes">
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial"><A HREF="cpanel.cgi?action=getbio4admin&UserName=$UNCoded">$searchrow[0]</A><BR>$DateReg</font></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminWrite::$searchrow[0]" VALUE="true" $WriteYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminWrite::$searchrow[0]" VALUE="false" $WriteNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">
<INPUT TYPE="RADIO" NAME="AdminPermission::$searchrow[0]" VALUE="true" $AdminYes>Yes &nbsp;&nbsp;
<INPUT TYPE="RADIO" NAME="AdminPermission::$searchrow[0]" VALUE="false" $AdminNo>No
</FONT>
</td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$searchrow[3]</FONT></td>
<td><FONT SIZE="1" FACE="Verdana, Arial">$searchrow[4]</FONT></td></tr>
GUTS

} #end FOREACH

print <<ENDHTML;
</table>
<br>
<FONT Size="2" FACE="Verdana, Arial" COLOR="#800000"><B>For security reasons, re-enter your UserName & Password: <BR>
UserName: <INPUT TYPE="TEXT" NAME="UserNameCheck" SIZE=25 MAXLENGTH=25>&nbsp;&nbsp;&nbsp;&nbsp; Password <INPUT TYPE="PASSWORD" NAME="PasswordCheck" SIZE=13 MAXLENGTH=13></FONT></B></CENTER><P>
<CENTER><INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit Permission Changes Now">
</form><FONT COLOR="#C0C0C0">
<BR><BR>Powered by: Ultimate Bulletin Board<BR>
&copy; Madrona Park, Inc., 1998.<BR><BR>.</CENTER>
</FONT>
</FONT>
</body>
</html>
ENDHTML
}  else {
&StandardHTML("Sorry, but we couldn't find any users that matched your search criteria.  Please go back and try again!");
}
}  ##END DOSEARCH SR ###
}  #end GetMatches SR ###


sub SetGenVars {
### CHECK USERNAME - must be an admin
##verify that this user is an administrator

$NameFound = "no";
  if (-e "$MembersPath/$UserNameCheckFile.cgi") {
      $NameFound = "yes";
    } 

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserNameCheck.cgi");
			
	if ($in{'PasswordCheck'} eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcessGenVars;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. <P>If you are configuring your bulletin board for the first time, this is probably due to the fact that you did not set the proper variable for your CGI Directory absolute path.<P>Use your Back button to try again.");
}  ##END IF/ELSE NAME CHECK BLOCK
}  ##END Set Gen Vars

sub DoProcessGenVars {
if ((-e "$in{'NonCGIPath'}/ubbcode.html") && (-e "$in{'CGIPath'}/cpanel.cgi")) {
$variable1=('$BBEmail = ' . '"' . $BBEmail . '";');
$variable2=('$MembersPath = ' . '"' . $in{'MembersPath'} . '";');
$variable3=('$MyHomePage = ' . '"' . $MyHomePage . '";');
$variable4=('$HomePageURL = ' . '"' . $HomePageURL . '";');
$variable5=('$BBName = ' . '"' . $BBName . '";');
$variable6=('$ForumsPath = ' . '"' . $in{'NonCGIPath'} . '";');
$variable7=('$CGIPath = ' . '"' . $in{'CGIPath'} . '";');
$variable8=('$NonCGIPath = ' . '"' . $in{'NonCGIPath'} . '";');
$variable9=('$CGIURL = ' . '"' . $in{'CGIURL'} . '";');
$variable10=('$NonCGIURL = ' . '"' . $in{'NonCGIURL'} . '";');
$variable12=('$EmailCheck = ' . '"' . $in{'EmailCheck'} . '";');
$variable13=('$TimeZone = ' . '"' . &decodeURL($in{'TimeZone'}) . '";');
$variable14=('$Censor = ' . '"' . $in{'Censor'} . '";');
$variable15=('$censorwords = ' . '"' . $censorwords . '";');
$variable16=('$MemberMinimum = ' . '"' . $in{'MemberMinimum'} . '";');
$variable17=('$BBRules = ' . '"' . $BBRules . '";');
$variable18=('$DaysPruneDefault = ' . '"' . $in{'DaysPruneDefault'} . '";');
$variable19=('$CategoryView = ' . '"' . $in{'CategoryView'} . '";');
$variable20=('$ForumDescriptions = ' . '"' . $in{'ForumDescriptions'} . '";');
$variable21=('$DateFormat = ' . '"' . $in{'DateFormat'} . '";');
$variable22=('$TimeZoneOffset = ' . '"' . $in{'TimeZoneOffset'} . '";');
$variable23=('$TimeFormat = ' . '"' . $in{'TimeFormat'} . '";');
$variable24=('$YourCopyrightNotice = ' . '"' . $YourCopyrightNotice . '";');
$variable25=('$UseEmail = ' . '"' . $in{'UseEmail'} . '";');
$variable26=('$EmailServer = ' . '"' . $in{'EmailServer'} . '";');
$variable27=('$EmailVerify = ' . '"' . $in{'EmailVerify'} . '";');
$variable28=('$EditOption = ' . '"' . $in{'EditOption'} . '";');
$variable29=('$SMTPEmail = ' . '"' . $in{'SMTPEmail'} . '";');
$variable30=('$SendMailLocation = ' . '"' . $in{'SendMailLocation'} . '";');
$variable31=('$EmailBlock = ' . '"' . $in{'EmailBlock'} . '";');
$variable32=('$Header = ' . '"' . $Header . '";');
$variable33=('$Footer = ' . '"' . $Footer . '";');
$variable34=('$VariablesPath = ' . '"' . $VariablesPath . '";');
$variable35=('$AllowSignature = ' . '"' . $in{'AllowSignature'} . '";');
$variable36=('$ForumTotalOption = ' . '"' . $in{'ForumTotalOption'} . '";');

open (FILE, ">$VariablesPath/UltBB.setup") or die("Unable to open setup file for writing.");

	print FILE ("$variable0\n");
	print FILE ("$variable1\n");
	print FILE ("$variable2\n");
	print FILE ("$variable3\n");
	print FILE ("$variable4\n");
	print FILE ("$variable5\n");
	print FILE ("$variable6\n");
	print FILE ("$variable7\n");
	print FILE ("$variable8\n");
	print FILE ("$variable9\n");
	print FILE ("$variable10\n");
	print FILE ("$variable12\n");
	print FILE ("$variable13\n");
	print FILE ("$variable14\n");
	print FILE ("$variable15\n");
	print FILE ("$variable16\n");
	print FILE ("$variable17\n");
	print FILE ("$variable18\n");
	print FILE ("$variable19\n");
	print FILE ("$variable20\n");
	print FILE ("$variable21\n");
	print FILE ("$variable22\n");
	print FILE ("$variable23\n");
	print FILE ("$variable24\n");
	print FILE ("$variable25\n");
	print FILE ("$variable26\n");
	print FILE ("$variable27\n");
	print FILE ("$variable28\n");
	print FILE ("$variable29\n");
	print FILE ("$variable30\n");
	print FILE ("$variable31\n");
	print FILE ("$variable32\n");
	print FILE ("$variable33\n");
	print FILE ("$variable34\n");
	print FILE ("$variable35\n");
	print FILE ("$variable36\n");
	print FILE ("1;\n");
close (FILE);

# create forum directories and set permissions on directories
unless (-e "$in{'NonCGIPath'}/Forum1") {
chmod(0777, "$in{'NonCGIPath'}");
chmod(0755, "$in{'CGIPath'}");
chmod(0777, "$in{'MembersPath'}");
chmod(0777, "$in{'MembersPath'}/Admin5.cgi");
mkdir ("$in{'NonCGIPath'}/Forum1", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum1");
mkdir ("$in{'NonCGIPath'}/Forum2", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum2");
mkdir ("$in{'NonCGIPath'}/Forum3", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum3");
mkdir ("$in{'NonCGIPath'}/Forum4", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum4");
mkdir ("$in{'NonCGIPath'}/Forum5", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum5");
mkdir ("$in{'NonCGIPath'}/Forum6", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum6");
mkdir ("$in{'NonCGIPath'}/Forum7", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum7");
mkdir ("$in{'NonCGIPath'}/Forum8", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum8");
mkdir ("$in{'NonCGIPath'}/Forum9", 0777);
chmod(0777, "$in{'NonCGIPath'}/Forum9");
}

###############################################
## Perform diagnostic checks/update if necessary
if (-e "$NonCGIPath/ubbdiagnostic.file") {
open(DIAG, "$NonCGIPath/ubbdiagnostic.file");
@diag = <DIAG>;
close(DIAG);

foreach $diagline(@diag) {
	if ($diagline =~ m/SetLastTimes/) {
		$SLT = "true";
	}
	if ($diagline =~ m/ConvertAnnouncements/) {
		$CA = "true";
	}
	if ($diagline =~ m/ConvertToUBBFiles/) {
		$CTUF = "true";
	}
	if ($diagline =~ m/CreateLastForumNums/) {
		$CLFN = "true";
	}
}


if ($CTUF ne "true") {
	&RenameMess;
}

if ($CA ne "true") {
	&MoveAnnc;
}

if ($SLT ne "true") {
	&SetLastTimes;
}

if ($CLFN ne "true") {
	&SetLastThreadNums;
}
}  else {

#convert message files to ubb files
&RenameMess;
#move announcements to ANNC subdirectories
&MoveAnnc;
#reset last time files
&SetLastTimes;
#create last thread number file in each forum
&SetLastThreadNums;



#create ubbdiagnostic file--
open(DIAG, ">$NonCGIPath/ubbdiagnostic.file");
print DIAG ("SetLastTimes\n");
print DIAG ("ConvertAnnouncements\n");
print DIAG ("ConvertToUBBFiles\n");
print DIAG ("CreateLastForumNums\n");
close(DIAG);
chmod (0777, "$NonCGIPath/ubbdiagnostic.file");
}


## END DIAGNOSTIC CHECK/UPDATE

$UserName = "$UserNameCheck";
$UserName =~ tr/ /+/;
$Password = "$PasswordCheck";
$Password =~ tr/ /+/;

$ConfirmLine = "The Ultimate Bulletin Board General Variables have been updated.<P>
Note that in order to have these changes reflected in old threads, you need to update those threads.  You can do this using the \"Update Threads\" control panel option.  Depending on the number of threads you have stored on your system, the updating process can be time-consuming.  It is thus recommended that you do not update your threads until after you have made all control panel setting changes.<P>";
&ConfirmHTML2;

}  else {
&StandardHTML("Sorry, but you have not set the correct absolute path variables.  Please use your back button to try again.  We cannot process your variables without the proper absolute paths.");
}
} ## END DO PROCESS GENERAL VARS SR

sub DoIndex {
##verify that this user is an administrator
$NameFound = "no";
if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
	} 

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserName.cgi");
			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &ReIndex("1", "0");
 	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again.  Use your Back button.");
	}
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK
} # end DoIndex sr


sub Mods {
##verify that this user is an administrator
$NameFound = "no";
if (-e "$MembersPath/$UserNameFile.cgi") {
      $NameFound = "yes";
	} 

if ($NameFound eq "yes") {
	@profilestats = &OpenProfile("$UserName.cgi");
			
	if ($Password eq "$profilestats[1]") {
	$Permission = "$profilestats[4]";
	&CheckPermissions;
	   if ($AdminPermission eq "true") {
	   &DoProcess;
	   }  else {
	    &StandardHTML("Sorry, but you are not an administrator.");
	   }
	} else {
	&StandardHTML("Sorry, but the password you entered was not correct.  Please try again. Use your Back button.");
	}
	
	
}  else {
&StandardHTML("Sorry, but we couldn't find a record for the UserName you entered.  Please try again. Use your Back button.");
}  ##END IF/ELSE NAME CHECK BLOCK

sub DoProcess {

&GetMemberListArray;  #returns @members array

## now we have our current Member list (in filename format)

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	if ($Name =~ m/NewMod/) {
	($Trash, $Number) = split(/Mod/, $Name);
	$Combine = ("$Number" . "::" . "$Value");
	push (@GoodMods, $Combine);
	}
} # end foreach $row

#	for (@GoodMods2) {
#		($Trash, $ModSplit) = split(/::/, $_);
#		push (@GoodMods, $ModSplit);
#	}

#now Moderator names are in order

for (@GoodMods) {
	$modmatch = "false";
	($ForumNumber, $ModName) = split(/::/, $_);
	if (($ModName ne "none") && ($ModName ne "")) {
		$ModCoded = "$ModName";
		$ModCoded =~ s/ /_/g; #convert spaces
			for $matcher(@members) {
				if ($matcher eq "$ModCoded.cgi") {
					$modmatch = "true";
$modline = ('$Forum' . "$ForumNumber" . 'Moderator = "' . "$ModName" . '"' . ";\n");
		push(@modarray, $modline);
				} #end if modcoded
			} #end for $matcher

	if ($modmatch ne "true") {
		$error = "true";
		$errorline = ("$errorline" .  "The moderator name \"$_\" is not a valid UserName.<br>");
	} # end if $modmatch
} # if not "none"
} # end for

if ($error ne "true") {
	open (MODS, ">$VariablesPath/mods.file") || die("Unable to open Mods file.");
		print MODS (@modarray);
		print MODS ("1;\n");
	close (MODS);

## UPDATE MEMBER PROFILES FOR ALL MODERATORS

for (@GoodMods) {
	($ForumNumber, $ModName) = split(/::/, $_);
	if (($ModName ne "none") && ($ModName ne "")) {
	$ModCoded = "$ModName";
	$ModCoded =~ s/ /_/g; #convert spaces
		@modprof = &OpenProfile("$ModName.cgi");
		$Status = $modprof[8];
			&CheckStatus;
			if ($AdminStatus ne "true") {
						
				open (UPDATE, ">$MembersPath/$ModCoded.cgi");
				print UPDATE ("$modprof[0]|");
					print UPDATE ("$modprof[1]|");
					print UPDATE ("$modprof[2]|");
					print UPDATE ("$modprof[3]|");
					print UPDATE ("$modprof[4]|");
					print UPDATE ("$modprof[5]|");
					print UPDATE ("$modprof[6]|");
					print UPDATE ("$modprof[7]|");
					print UPDATE ("Moderator|");
					print UPDATE ("$modprof[9]|");
					print UPDATE ("$modprof[10]|");
					print UPDATE ("$modprof[11]|");
					print UPDATE ("$modprof[12]\n");
			close (UPDATE);
			}  ## END IF madprof
	}  # END if not "none"
} # end for


## Delete Moderator status from users who are no longer Moderators

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	if ($Name =~ m/OldMod/) {
	push (@OldMods, $Value);
	}
} # end foreach $row

for $oldie(@OldMods) {
	$SaveOldie = "no";
	for $checkthis(@GoodMods) {
		($ForumNum, $TheGoodModName) = split(/::/, $checkthis);
		if ($oldie eq "$TheGoodModName") {
		$SaveOldie = "yes";
		}
	}
	if (($SaveOldie ne "yes") && ($oldie ne "none") && ($oldie ne "")) {
		$OldieFile = "$oldie";
		$OldieFile =~ s/ /_/g; #remove spaces
		@oldmod = &OpenProfile("$oldie.cgi");  #only change
			$Status = $oldmod[8];
			$TotalPosts = $oldmod[7];
			&CheckStatus;
			
			if ($AdminStatus ne "true") {
				if ($TotalPosts < $MemberMinimum) {
					$Status = "Junior Member";
				}  else {
					$Status = "Member";
				}
				###
				
				open (UPDATE, ">$MembersPath/$OldieFile.cgi");
					print UPDATE ("$oldmod[0]|");
					print UPDATE ("$oldmod[1]|");
					print UPDATE ("$oldmod[2]|");
					print UPDATE ("$oldmod[3]|");
					print UPDATE ("$oldmod[4]|");
					print UPDATE ("$oldmod[5]|");
					print UPDATE ("$oldmod[6]|");
					print UPDATE ("$oldmod[7]|");
					print UPDATE ("$Status|");
					print UPDATE ("$oldmod[9]|");
					print UPDATE ("$oldmod[10]|");
					print UPDATE ("$oldmod[11]|");
					print UPDATE ("$oldmod[12]\n");
			close (UPDATE);
		}  ## END IF ADMIN status ne true
	}

} 


$ConfirmLine = "The forum moderators have been successfully updated.";
&ConfirmHTML2;

} else {

print<<Error;
<HTML><BODY BGCOLOR="#FFFFFF" link="#000080" vlink="#808000">
<br><br><FONT Size="$TextSize" FACE="$FontFace"><B>
Sorry, we could not process the Moderator updates, due to the following error(s).
<P>
<FONT COLOR="#FF0000">$errorline</FONT>
<p>
Use your back button to go back to the Moderator page, or use the links below.
<p>
Return to: <br>
<ul>
<A HREF="$NonCGIURL/controlpanel.html">Control Panel</A><br>
<A HREF="$CGIURL/Ultimate.cgi?action=intro">Bulletin Board</A>
</ul>
</B></FONT>
</BODY></HTML>
Error

}#end if/else error ne true
}  ## END DO PROCESS SR

}  # END MODS SR


sub CheckStatus {

		if ($Status =~ m/Administrator/) {
			$AdminStatus = "true";
			} else {
			$AdminStatus = "false";
		}
		

		if ($Status =~ m/Moderator/) {
			$ModStatus = "true";
		} else {
			$ModStatus = "false";
		}
		if ($Permission =~ m/Write/) {
			$AdminWrite = "true";
		} else {
			$AdminWrite = "false";
		}

} #end CheckStatus




sub HEADERHTML {

if ($in{'UserName'} eq "") {
$UserName = "";
$Password = "";

}
print<<HEADER;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");

var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if ((testUserNameCP == null) && (CookieUNCP != "")){
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	} 
	
function SetCursor() {
var thisUserNameCP = getCookie("UserNameCP");
var thisPasswordCP = getCookie("PasswordCP");

if (thisUserNameCP != null) {  
thisUserNameCP = unescape(thisUserNameCP);
thisPasswordCP = unescape(thisPasswordCP);

	document.THEFORM.UserNameCheck.value = thisUserNameCP;
document.THEFORM.PasswordCheck.value = thisPasswordCP;
	}  
}

function Check(form)  {
if ((form.Password.value == "") || (form.UserName.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR>
<center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<P>
<FONT SIZE="2" FACE="Verdana, Arial">
HEADER
} #end HEADERHTML sr

sub HEADER2HTML {
print<<HEADER2HTML;
<HTML>
<HEAD>
	<TITLE>$BBName</TITLE>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE

var testUserNameCP = getCookie("UserNameCP");
var CookieUNCP = escape("$UserName");
var CookiePWCP = escape("$Password");

	if (testUserNameCP == null) {
	  	document.cookie = "UserNameCP=" + CookieUNCP + ";";
		document.cookie = "PasswordCP=" + CookiePWCP + ";";
	}

function SetCursor() {
var thisUserNameCP = getCookie("UserNameCP");
var thisPasswordCP = getCookie("PasswordCP");

if (thisUserNameCP != null) {  
thisUserNameCP = unescape(thisUserNameCP);
thisPasswordCP = unescape(thisPasswordCP);

	document.THEFORM.UserNameCheck.value = thisUserNameCP;
document.THEFORM.PasswordCheck.value = thisPasswordCP;
	}  
}


function Check(form)  {
if ((form.PasswordCheck.value == "") || (form.UserNameCheck.value == ""))  {
	alert ("You forgot to fill in the Username and/or Password fields.  These are required entries!");
	return false
	}  else  {
	return true
	}
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length; 
            return unescape(dc.substring(begin, end));  }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</HEAD>
<BODY bgcolor="#FFFFFF" link="#000080" vlink="#808000" onLoad="SetCursor()">
<BR><center>
<FONT SIZE="5" FACE="Courier New"><B>$PageTitle</B></FONT>
</center>
<p>
HEADER2HTML
} #end HEADERHTML2 sr


sub UpdateThePermissions {
foreach $row2(@in) {
	($Name, $Value) = split ("=", $row2);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
	
		$matchAW = $row2 =~ m/AdminWrite/;
		if ($matchAW eq "1")  {
		    ($type, $UserName) = split(/::/, $Name);
			if ($Value eq "true") {
			       $Value = "Write";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserName|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserName") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserName|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1

		$matchAP = $row2 =~ m/AdminPermission/;
		if ($matchAP eq "1")  {
		    ($type, $UserName) = split(/::/, $Name);
			if ($Value eq "true") {
			       $Value = "Admin";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserName|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserName") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserName|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1

	$matchDelete = $row2 =~ m/Delete/;
		if ($matchDelete eq "1")  {
		    ($type, $UserName) = split(/::/, $Name);
			if ($Value eq "yes") {
			       $Value = "Delete";
				   }  else {
				      $Value = "";
			}
			
			$changeline = ("$UserName|$Value");
			$skippush = "no";
			
			if ($arraylength > 0) {
			$arrayline = 0;
			   foreach $checker(@changes) {
			       ($this, $that) = split(/\|/, $checker);
				   
				   if ($this eq "$UserName") {
				       $skippush = "yes";
				       $changes[$arrayline] = ("$UserName|$that$Value");
					} 
					$arrayline++;
			}  # foreach checker
		} ## if array length greater than 0
		
	if ($skippush eq "no") {
		    push(@changes, $changeline);
			}
          		   
			$arraylength = @changes;
			
}  ## IF match = 1
	}  # end foreach row2

##have array of changes now
##open each profile to make changes

foreach $updatename(@changes) {
($thisname, $Permission) = split(/\|/, $updatename);
$thisNameCoded = $thisname;
$thisNameCoded =~ s/ /_/g; #remove spaces

	if ($Permission =~ m/Delete/) {
			unlink("$MembersPath/$thisNameCoded.cgi");
		}  else {
		#in case file permissions are off...
		chmod (0777, "$MembersPath/$thisnameCoded.cgi");
		@theprofile = &OpenProfile("$thisname.cgi");    
	
	$Status = "$theprofile[8]";
	
		if ($Permission =~ m/Admin/) {
			$Status = "Administrator";
		} else { 
			open (MODS, "$VariablesPath/mods.file");
				@modslist = <MODS>;
			close (MODS);

			$ModsTotal = @modslist;

			for ($x = 1; $x <= $ModsTotal; $x++) {
				$GetModerator = ("Forum" . "$x" . "Moderator");
				$Moderator = $$GetModerator;
				push(@modsarray, $Moderator);
			}

			CHECKMODS: foreach (@modsarray) {
				if ($_ eq "$thisname") {
					$Status = "Moderator";
					$Modfound = "yes";
					last CHECKMODS;
				}
			}
		if ($Modfound ne "yes") {
			if ($theprofile[7] < $MemberMinimum) {
				$Status = "Junior Member";
				}  else {
					$Status = "Member";
				}
		}
	} # end if/else admin

	open (MEMBERSHIP, ">$MembersPath/$thisNameCoded.cgi") or die("Unable to open Members directory.");

	print MEMBERSHIP ("$thisname|");
	print MEMBERSHIP ("$theprofile[1]|");
	print MEMBERSHIP ("$theprofile[2]|");
	print MEMBERSHIP ("$theprofile[3]|");
	print MEMBERSHIP ("$Permission|");
	print MEMBERSHIP ("$theprofile[5]|");
	print MEMBERSHIP ("$theprofile[6]|");
	print MEMBERSHIP ("$theprofile[7]|");
	print MEMBERSHIP ("$Status|");
	print MEMBERSHIP ("$theprofile[9]|");
	print MEMBERSHIP ("$theprofile[10]|");
	print MEMBERSHIP ("$theprofile[11]|");
	print MEMBERSHIP ("$theprofile[12]\n|");
close (MEMBERSHIP);
}  # END IF match del
}  ## FOREACH

$ConfirmLine = "We have made the changes you requested.";
&ConfirmHTML;

} # End UpdateThePermissions sr

sub RenameMess {

#convert old files to new files--- (new in 5.10)

open (FORUMFILE, "$VariablesPath/forums.cgi");
	@sortforums = <FORUMFILE>;
close (FORUMFILE);

for (@sortforums) {

@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

opendir (FORUMDIR, "$ForumsPath/Forum$x"); 
    @thesefiles = readdir(FORUMDIR);
closedir (FORUMDIR);

@files = grep(/\.(n|m)/, @thesefiles);
@files = sort(@files);
$oldfiletotal = @files;

foreach $one(@files) {
$Notes = "";

if ($one =~ /^\d\d\d\d\d\d-000000/) {
#it is a father
open (FATHER, "$ForumsPath/Forum$x/$one");
@father = <FATHER>;
close (FATHER);

($threadnum, $junk, $junk2, $replies) = split(/-/, $one);
($replies, $junk3) = split(/\./, $replies);
$TotReplies = substr($replies, 0, 6);
$TotReplies = $TotReplies + 0;

if ($one =~ /X/) {
	$Notes = "X";
	}
if ($one =~ /n/) {
	$Notes .= "N";
	}

chomp($father[0]);
chomp($father[1]);
chomp($father[2]);
$Subject = $father[3];
chomp($Subject);
$email = $father[4];
chomp($email);
chomp($father[5]);

$StatsLine = "A||$Notes||$TotReplies||$father[0]||$Subject";

$NewFatherName = "$threadnum.ubb";
$FatherLine = "Z||000000||$father[0]||$father[1]||$father[2]||$email||$father[5]";

open (RENAMEPOP, ">$ForumsPath/Forum$x/$NewFatherName");
print RENAMEPOP ("$StatsLine\n");
print RENAMEPOP ("$FatherLine\n");
close (RENAMEPOP);


chmod (0666, "$ForumsPath/Forum$x/$NewFatherName");

##unlink "$ForumsPath/Forum$x/$one";


}  else {
#add to reply file
open (REPLY, "$ForumsPath/Forum$x/$one");
@reply = <REPLY>;
close (REPLY);

($threadnum, $replynum, $junk, $junk2) = split(/-/, $one);
$NewReplyName = "$threadnum.ubb";

#put reply info on one line
$UName = $reply[0];
chomp($UName);
$Date = $reply[1];
chomp($Date);
$TheTime = $reply[2];
chomp($TheTime);
$Subject = $reply[3];
chomp($Subject);
$Email = $reply[4];
chomp($Email);
$Message = $reply[5];
chomp($Message);
$ReplyLine = ("Z||$replynum||$UName||$Date||$TheTime||$Email||$Message");

open (RENAMEPOP, ">>$ForumsPath/Forum$x/$NewReplyName");
print RENAMEPOP ("$ReplyLine\n");
close (RENAMEPOP);

chmod (0666, "$ForumsPath/Forum$x/$NewReplyName");
##unlink "$ForumsPath/Forum$x/$one";
}
}

}  # end for each forum
}  # end Rename Mess sr

sub MoveAnnc {

#move annc to sep. ANNC directories- new in 5.10
open (FORUMFILE, "$VariablesPath/forums.cgi");
	@sortforums = <FORUMFILE>;
close (FORUMFILE);

for (@sortforums) {

@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

opendir (FORUMDIR, "$ForumsPath/Forum$x"); 
    @files = readdir(FORUMDIR);
closedir (FORUMDIR);

@annc = grep(/\.annc/, @files);


mkdir("$ForumsPath/Forum$x/ANNC", 0777);
chmod (0777, "$ForumsPath/Forum$x/ANNC");

foreach $one(@annc) {

open (ANNC, "$ForumsPath/Forum$x/$one");
@thisann = <ANNC>;
close (ANNC);
	
open (ANNC, ">$ForumsPath/Forum$x/ANNC/$one");
foreach $line(@thisann) {
chomp($line);
print ANNC ("$line\n");
}
close (ANNC);
chmod (0777, "$ForumsPath/Forum$x/ANNC/$one");
}
}  # end for each forum

}  # end Move Annc sr (new in 5.10)

sub SetLastThreadNums {

# set thread number info to lastnumber.file
# new in 5.10

open (FORUMFILE, "$VariablesPath/forums.cgi");
	@sortforums = <FORUMFILE>;
close (FORUMFILE);

for (@sortforums) {

@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

opendir (FORUMDIR, "$ForumsPath/Forum$x"); 
    my @files = readdir(FORUMDIR);
closedir (FORUMDIR);

my @ubbfiles = grep(/\.ubb/, @files);
my $topiccount = @ubbfiles;
#sort the ubb files
@ubbfiles = sort(@ubbfiles);
#reverse array so that largest number is first
@ubbfiles = reverse(@ubbfiles);
my $lastnumber = $ubbfiles[0];
($lastnumber, $junk) = split(/\./, $lastnumber);

$ThreadTotal = 0;
#determine number of total posts
foreach $threadfile(@ubbfiles) {
	open(THREAD, "$ForumsPath/Forum$x/$threadfile");
	@countit = <THREAD>;
close(THREAD);

@countit = grep(/^Z/, @countit);
$ThisTotal = @countit;
$ThreadTotal = $ThreadTotal + $ThisTotal;
}

if (-e "$ForumsPath/Forum$x/lastnumber.file") {
chmod (0666, "$ForumsPath/Forum$x/lastnumber.file");
}

#print number to lastnumber.file
open (UBB, ">$ForumsPath/Forum$x/lastnumber.file");
print UBB ("$lastnumber\n");
print UBB ("$topiccount\n");
print UBB ("$ThreadTotal\n");
close (UBB);

chmod (0666, "$ForumsPath/Forum$x/lastnumber.file");
}  # end for each forum
} #end SetLastThreadNums sr (new in 5.10)