#!/usr/bin/perl

#
###                         PRIMARY UBB SCRIPT                ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1998.
#
#       ------------ Ultimate.cgi -------------
#
#  This file contains intro functionality for the UBB.
#
#  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file

require "UltBB.setup";
require "Date.pl";
require "mods.file";
require "Styles.file";
require "cookie-lib.pl";
require "ubb_library.pl";
};

&ReadParse;

if ($in{'action'} eq "Redirect") {
print "Location: $in{'GoTo'}\n\n";
exit;
 } #end Redirect check
 
print ("Content-type: text/html\n\n");

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
		if ($Name eq "forum") {
			$Forum = $Value;
			$Forum =~ s/\/\\//g;
			$ForumCoded = &HTMLIFY($Forum);
			$ForumCoded =~ tr/ /+/;
			$Forum = &UNHTMLIFY($Forum);
	}
		if ($Name eq "TopicSubject") {
			$TopicSubject = $Value;
			$TopicSubject =~ s/<.+?>//g;
				$TopicSubject = &UNHTMLIFY($TopicSubject);
	}
		if ($Name eq "UserName") {
		$UserName = $Value;
		$UserNameFile = $UserName;
		$UserNameFile =~ s/ /_/g; #remove spaces
	}
	if ($Name eq "BypassCookie") {
		$BypassCookie = $Value;
	}
	if ($Name eq "category") {
			$category = $Value;
	}
		if ($Name eq "PasswordConfirm") {
			$PasswordConfirm = $Value;
		}

		if ($Name eq "number") {
			$number = $Value;
	}
		if ($Name eq "DaysPrune") {
			$DaysPrune = $Value;
	}
	if ($Name eq "topic") {
			$topic = $Value;
	}

	if ($Name eq "Email") {
			$Email = $Value;
			$Email =~tr/A-Z/a-z/; 
	}
	if ($Name eq "URL") {
			$URL = &CleanThis($Value);
			$URL = &PipeCleaner($URL);
	}
	if ($Name eq "Permissions") {
			$Permissions = $Value;
	}
	if ($Name eq "Occupation") {
			$Occupation = &CleanThis($Value);
			$Occupation = &PipeCleaner($Occupation);
	}
	if ($Name eq "Location") {
			$Location = &CleanThis($Value);
			$Location = &PipeCleaner($Location);
	}
	if ($Name eq "TotalPosts") {
		$TotalPosts = $Value;
	}
	if ($Name eq "Status") {
		$Status = $Value;
	}
	if ($Name eq "Interests") {
			$Interests = &CleanThis($Value);
			$Interests = &PipeCleaner($Value);
	}
		if ($Name eq "sendto") {
			$sendto = $Value;
	}
}  # end FOREACH $row

if ($VariablesPath eq "") {
	$VariablesPath = $CGIPath;
}


#adjust bgcolor variables
if ($BGColor ne ""){
$BGColor = qq(bgcolor="$BGColor");
}
if ($AltColumnColor1 ne ""){
$AltColumnColor1 = qq(bgcolor="$AltColumnColor1");
}
if ($AltColumnColor2 ne ""){
$AltColumnColor2 = qq(bgcolor="$AltColumnColor2");
}
if ($CategoryStripColor ne ""){
$CategoryStripColor = qq(bgcolor="$CategoryStripColor");
}
if ($TableColorStrip ne ""){
$TableColorStrip = qq(bgcolor="$TableColorStrip");
}
if ($PageBackground ne ""){
$PageBackground = qq(background="$PageBackground");
}

$ReplyMessage = $in{'ReplyMessage'};
$Message = $in{'Message'};

		$SubjectCoded = &HTMLIFY($TopicSubject);
		$SubjectCoded =~ tr/ /+/;

if (@in == 0) {
&Intro;
}
 
if ($in{'action'} eq "intro") {
 &Intro;
 }  

if ($in{'action'} eq "agree") {
 &Agree;
 } 
 if ($in{'action'} eq "email") {
 &DoEmail($in{'ToWhom'});
 }  

  
if ($in{'action'} eq "register") {
   &Register;
 }  
 
if ($in{'action'} eq "rules") {
 &Rules;
 }  
 
if ($in{'action'} eq "lostpw") {
	if ($UseEmail eq "ON") {
 &LostPW;
 }  else {
 &StandardHTML("Sorry, but this feature is not available, per your administrator's directions.  Use your back button to return to the BB.");
 }
 }  
 

 ## INTRO PAGE SUBROUTINES ####
 
sub Intro {

&get_cookie;  #retrieves all current cookies

if ($cookie{DaysPrune}) {
$DaysPrune = "$cookie{DaysPrune}";
}  else {
$DaysPrune = $DaysPruneDefault;
}

if ($BypassCookie eq "true") {
	$NoNewLogin = "true";
	$SessionLogin = "$cookie{sessionLogin}";
	
}  else {
	$NoNewLogin = "false";
	$SessionLogin = "$cookie{lastLogin}";
	$SessionLoginDT = "$cookie{LastLoginDT}";
}
&decodeURL($SessionLoginDT);

	&GetDateTime;

if ($cookie{LastLoginDT}) {
$Legend = "<img src=\"$NonCGIURL/on.gif\" width=22 height=15 border=0 alt=\"On\">&nbsp;&nbsp; New Posts Since Your Last Visit<BR><img src=\"$NonCGIURL/off.gif\" width=22 height=15 border=0 alt=\"off\">&nbsp;&nbsp; No New Posts Since Your Last Visit";

if ($cookie{sessionLoginDT}) {
$UseDT = $cookie{sessionLoginDT};
}  else {
$UseDT = $cookie{LastLoginDT};
}

#split the d/t string
my ($StoredDate, $StoredTime, $TheAMPM) = split(/ /, $UseDT);
my $FormatDate = "";
my $FormatTime = "";

#format date-----------------------------------

if ($DateFormat eq "US") {
	$FormatDate = $StoredDate;
}
elsif ($DateFormat eq "Euro") {
	$FormatDate = &DateFormat("$StoredDate", "Euro");
}
elsif ($DateFormat eq "USX") {
	$FormatDate = &DateFormat("$StoredDate", "USExpanded");
} else {
	$FormatDate = &DateFormat("$StoredDate", "EuroExpanded");
}

#format time--------------------------------
if ($TimeFormat eq "AMPM") {
	$FormatTime = "$StoredTime $TheAMPM";
} else {
	my ($gethr, $getmin) = split(/:/, $StoredTime);
	&ConvertTo24Hour;
	$FormatTime = "$gethr:$getmin";
}

#combine date/time line
$LastLoginTime = ("You last visited: $FormatDate $FormatTime $TimeZone");
}  else {
$LastLoginTime = "";
}


# check Forum Total option--
if ($ForumTotalOption eq "Topics") {
$TopRow = "<td NOWRAP valign=bottom align=center>
<B><FONT SIZE=\"1\" FACE=\"$FontFace\" COLOR=\"$TableStripTextColor\">Topics</FONT></B>
</td>";
$TheColSpan = "5";
}
elsif ($ForumTotalOption eq "Posts") {
$TopRow = "<td NOWRAP valign=bottom align=center>
<b><FONT SIZE=\"1\" FACE=\"$FontFace\" COLOR=\"$TableStripTextColor\">Posts</FONT></B>
</td>";
$TheColSpan = "5";
}  else {
$TopRow = "<td NOWRAP valign=bottom align=center><b>
<FONT SIZE=\"1\" FACE=\"$FontFace\" COLOR=\"$TableStripTextColor\">Topics</FONT></B>
</td><td NOWRAP valign=bottom align=center><B>
<FONT SIZE=\"1\" FACE=\"$FontFace\" COLOR=\"$TableStripTextColor\">Posts</FONT></B>
</td>";
$TheColSpan = "6";
}

&ForumsTopHTML;

&get_cookie;  #retrieves all current cookies

open (FORUMFILE, "$VariablesPath/forums.cgi");
	@forums = <FORUMFILE>;
close (FORUMFILE);
@forums = grep(/\|/, @forums);

if ($category ne "") {
for $forumline(@forums) {
	@forumfacts = split(/\|/, $forumline);
	if ($forumfacts[0] eq "$category") {
		push(@sortforums, $forumline);
	}
	
}

}  else {

if ($CategoryView eq "yes") {
@sortforums = sort(@forums); #sorts forums by category
}  else  {
@sortforums = @forums;
} #end if/else categoryview eq yes
}  #end category limitation check

$forumcategory = "";

for (@sortforums) {
@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

$GetHour = "";
$GetMinute = "";
$MilHour = "";
$TheDate = "";
$LatestTime = "";

if ($CategoryView eq "yes") {
$thisforumcategory = &decodeURL($thisforuminfo[0]);
if ($thisforumcategory ne "$forumcategory") {
print<<CategoryHeader;
<TR $CategoryStripColor><TD colspan=$TheColSpan>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><B> $thisforumcategory</B></FONT>
</td></tr>
CategoryHeader
}
$forumcategory = "$thisforumcategory";
} # end if categoryview eq yes

## Get Forum Data from lastnumber.file(s)
open (FORUMDATA, "$ForumsPath/Forum$x/lastnumber.file"); 
 my @data = <FORUMDATA>;
close (FORUMDATA);
$TotalTopics = $data[1];
chomp($TotalTopics);
$TotalPosts = $data[2];
chomp($TotalPosts);

if ($TotalTopics eq "") {
	$TotalTopics = "0";
	}
	
if ($TotalPosts eq "") {
	$TotalPosts = "0";
	}

if ($TotalTopics > 0) {
#open lasttime.file for forum
open (LTime, "$ForumsPath/Forum$x/lasttime.file"); 
    @lasttime = <LTime>;
close (LTime);

$LastDate = $lasttime[0];
$LastTime = $lasttime[1];
chomp($LastDate);
chomp($LastTime);

#split time
($GetHour, $GetMinute) = split(/:/, $LastTime);
($GetMinute, $AMpm) = split(/ /, $GetMinute);
chomp($AMpm);
($GetMonth, $GetDate, $GetYear) = split(/-/, $LastDate);

	&MilitaryTime2;
	$MilTime = "$MilHour:$GetMinute";

if ($TimeFormat eq "24HR") {
	$LatestTime = "$MilTime";
} else {
	$LatestTime = "$LastTime";
}
	
	
if ($DateFormat eq "US") {
	$TheDate = $LastDate;
	$DateWording = "All dates are in MM-DD-YY format.";
	$Breaker = "";
	$DateSize = "2";
}
elsif ($DateFormat eq "Euro") {
	$TheDate = &DateFormat("$LastDate", "Euro");
	$DateWording = "All dates are in DD-MM-YY format.";
	$Breaker = "";
	$DateSize = "2";
}
elsif ($DateFormat eq "USX") {
	$TheDate = &DateFormat("$LastDate", "USExpanded");
	$Breaker = "<BR>";
	$DateSize = "1";
} else {
	$TheDate = &DateFormat("$LastDate", "EuroExpanded");
	$Breaker ="<BR>";
		$DateSize = "1";
}
	
}  else {
$GetMonth = "";
$GetDate= "";
$GetYear = "";
$LatestTime = "";
$TheDate = "";
}

@thisforum = &GetForumRecord($x);

$ForumName = $thisforum[1];
$Moderator = ("Forum" . "$x" . "Moderator");
$Moderator = $$Moderator;
$ForumDesc = $thisforum[2];
$OnOff = $thisforum[3];
chomp($OnOff);

$ForumCoded = &HTMLIFY($ForumName);
$ForumCoded =~ tr/ /+/;
$ForumDesc =~ s/&quot;/"/g;

if ($ForumDescriptions eq "no") {
	$ForumDesc = "";
}

if ($GetMonth ne "") {

# Compare Last Login Time to Last Post Time.. 

$LPMonth = $GetMonth;

if ($GetYear > 96)  {
	$JYear = ("19" . "$GetYear");
	} else  {
		$JYear = ("20" . "$GetYear");
	}
$LastPostJulian = &jday($LPMonth, $GetDate, $JYear);

$LPTime = ("$MilHour" . "$GetMinute");
$LastPostJulian = ($LastPostJulian + ($LPTime * 0.0001));

if ($LastPostJulian > $SessionLogin) {
	$NewStuffIcon = "<IMG SRC=\"$NonCGIURL/on.gif\" BORDER=0>";
} else {
	$NewStuffIcon = "<IMG SRC=\"$NonCGIURL/off.gif\" BORDER=0>";
}


}  else {
	$NewStuffIcon = "<IMG SRC=\"$NonCGIURL/off.gif\" BORDER=0>";

} # end if/else month ne ""


unless ($cookie{lastLogin}) {
	$NewStuffIcon = "";
	$Legend = "";
}



# check Forum Total option--
if ($ForumTotalOption eq "Topics") {
$GutsRow = qq(<td $AltColumnColor2 align=center valign=top NOWRAP>
<FONT SIZE='2' FACE="$FontFace">$TotalTopics</FONT>
</td><td $AltColumnColor1 NOWRAP valign=top align=center>
<FONT SIZE="$DateSize" FACE="$FontFace">$TheDate $Breaker<FONT COLOR="$TimeColor" SIZE="$DateSize" FACE="$FontFace">$LatestTime</FONT>
</td><td $AltColumnColor2 valign=top>
<FONT SIZE='2' FACE="$FontFace">$Moderator</FONT></td></tr>);
}
elsif ($ForumTotalOption eq "Posts") {
$GutsRow = qq(<td $AltColumnColor2 align=center valign=top NOWRAP>
<FONT SIZE='2' FACE="$FontFace">$TotalPosts</FONT>
</td><td $AltColumnColor1 NOWRAP valign=top align=center>
<FONT SIZE="$DateSize" FACE="$FontFace">$TheDate $Breaker<FONT COLOR="$TimeColor" SIZE="$DateSize" FACE="$FontFace">$LatestTime</FONT>
</td><td $AltColumnColor2 valign=top>
<FONT SIZE='2' FACE="$FontFace">$Moderator</FONT></td></tr>);
}  else {
$GutsRow = qq(<td $AltColumnColor2 align=center valign=top NOWRAP>
<FONT SIZE='2' FACE="$FontFace">$TotalTopics</FONT>
</td><td $AltColumnColor1 align=center valign=top NOWRAP>
<FONT SIZE='2' FACE="$FontFace">$TotalPosts</FONT>
</td><td $AltColumnColor2 NOWRAP valign=top align=center>
<FONT SIZE="$DateSize" FACE="$FontFace">$TheDate $Breaker<FONT COLOR="$TimeColor" SIZE="$DateSize" FACE="$FontFace">$LatestTime</FONT>
</td>
<td $AltColumnColor1 valign=top>
<FONT SIZE='2' FACE="$FontFace">$Moderator</FONT></td></tr>);
}

if ($OnOff eq "On") {
&ForumsGutsHTML;
} ## End IF ONOFF Conditional
}

&ForumsBottomHTML;
}  #END INTRO SR ###


sub ForumsTopHTML {
print <<INTROHTML;
<HTML>
<HEAD><TITLE>$BBName - powered by the Ultimate Bulletin Board</title>
<SCRIPT LANGUAGE="JavaScript">
<!-- HIDE
var noNewLogin = "$NoNewLogin";
var dc = document.cookie;
var sessionLogin = escape("$SessionLogin");
var sessionLoginDT = escape("$SessionLoginDT");

if (document.cookie) {
var DaysPrune = getCookie("DaysPrune");
	if (DaysPrune == null) {
		var DaysPrune = "$DaysPruneDefault";
	}
} else {
var DaysPrune = "$DaysPruneDefault";
}

expireDate = new Date;
expireDate.setYear(expireDate.getYear()+1);

if (noNewLogin != "true") {

var CookieLogin = escape("$LastLoginJulian");
var CookieLoginDT = escape("$LastLoginDT");

	  document.cookie = "lastLogin=" + CookieLogin + ";expires=" + expireDate.toGMTString() + ";";
  document.cookie = "LastLoginDT=" + CookieLoginDT + ";expires=" + expireDate.toGMTString() + ";";
	  document.cookie = "sessionLogin=" + sessionLogin + ";";
document.cookie = "sessionLoginDT=" + sessionLoginDT + ";";
}

function getCookie(name){
var cname = name + "=";               
var dc = document.cookie;
if (dc.length > 0) {              
    begin = dc.indexOf(cname);
	 if (begin != -1) {           
        begin += cname.length;
		end = dc.indexOf(";", begin);
            if (end == -1) end = dc.length;
            return unescape(dc.substring(begin, end));        }
}
return null;
}
// STOP HIDING FROM OTHER BROWSERS -->
</SCRIPT>
</head>
 <BODY $BGColor  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT FACE="$FontFace" SIZE="$TextSize">
$Header
<center>
<table border=0 width=$TableWidth>
<tr>
<TD>
<CENTER>
<A HREF="Ultimate.cgi"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A>
</CENTER>
</td>
<td>
<CENTER>
<B><FONT SIZE="3" FACE="$FontFace" COLOR="$BBTitleFontColor">$BBName</FONT></B>
<br><FONT SIZE="1" FACE="$FontFace">
<A HREF="$CGIURL/ubbmisc.cgi?action=editbio&Browser=$Browser&DaysPrune=$DaysPrune&LastLogin=$in{'LastLogin'}"><ACRONYM TITLE="Click here to edit your profile.">profile</ACRONYM></A> | <A HREF="$CGIURL/Ultimate.cgi?action=agree"><ACRONYM TITLE="Registration is free!">register</ACRONYM></A> | <A HREF="$CGIURL/ubbmisc.cgi?action=setprefs"><ACRONYM TITLE="Set your preferences.">prefs</ACRONYM></A> | <A HREF="$NonCGIURL/faq.html" target=_blank><ACRONYM TITLE="Frequently Asked Questions">faq</ACRONYM></A> | <A HREF="$CGIURL/search.cgi?action=intro"><ACRONYM TITLE="Perform a search by keyword, date, or name.">search</ACRONYM></A>
</FONT>
</CENTER>
</td></TR>
</table>
<table border=0 width=$TableWidth>
<TR>
<td colspan=5 align=left>
<FONT SIZE="1" FACE="$FontFace">$LastLoginTime</font>
</td></tr>
<tr $TableColorStrip>
<TD>&nbsp;</TD>
<td valign=bottom>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor"><B>Forum</B></FONT>
</td>
$TopRow
<td NOWRAP valign=bottom align=center>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor"><B>Last Post</B></FONT>
</td>
<td valign=bottom>
<FONT SIZE="1" FACE="$FontFace" COLOR="$TableStripTextColor"><B>Moderator</B></FONT>
</td></tr>
INTROHTML
}  ## END FORUMS TOP HTML

sub ForumsGutsHTML {
print <<ForumSummary;
<TR><TD valign=top>$NewStuffIcon</td>
<TD $AltColumnColor1 valign=top><FONT SIZE='2' FACE='$FontFace'><B>
<A HREF="$CGIURL/forumdisplay.cgi?action=topics&forum=$ForumCoded&number=$x&DaysPrune=$DaysPrune&LastLogin=$LastLogin">$ForumName</A></B><BR>
$ForumDesc
</FONT>
</td>
$GutsRow
ForumSummary
}  ## END FORUMS GUTS HTML

sub ForumsBottomHTML {
print <<BOTTOMhtml;
</table>
</center>
<P>
<FONT SIZE="1" FACE="$FontFace" COLOR="$VisitedLinkColor">All times are $TimeZone.  $DateWording</FONT>
<P>
$Legend
<P><center></font>
BOTTOMhtml

&PageBottomHTML;
}  ## END Forums Bottom HTML subroutine


### END Intro Page Subroutines ####
 
sub LostPW {
&StandardTopHTML;
print<<LostPassword;
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<br><BR><B>
<FONT SIZE="$TextSize" FACE="$FontFace">
You can have your username and password emailed to you by providing your email address.  We will then email the username and password info we have associated with the email address you provide.  This information will be sent to the email address you type below.
<P>
<center>
<FORM ACTION="ubbmisc.cgi" METHOD="POST">Your Email Address: &nbsp;&nbsp;&nbsp;
<INPUT TYPE="TEXT" NAME="sendto" SIZE=35 MAXLENGTH=90>
<P>
<input type="Hidden" name="action" value="pwrequest">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Request UserName/Password Now">
</FORM>
</center>
</B>
</FONT>
<p>
</BODY></HTML>
LostPassword
}


sub Agree {
print <<Agreement;
<HTML>
 <BODY $BGColor  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor">
$Header
<table border=0><TR><TD>
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle"  BORDER=0></A></TD><TD align=center><FONT SIZE="+1" FACE="$FontFace" COLOR="$LinkColor"><B>$BBName Rules</B></FONT></td></tr></table> 
<br><BR>
<FONT SIZE="$TextSize" FACE="$FontFace">
Registration for this bulletin board is completely free!  If you agree to our rules below, you should press the "Agree" button, which will enable you to register.  If you do not agree, press the "Cancel" button.
<HR width=90%>
<CENTER><B><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">$BBName Rules & Policies</B></CENTER>
<P>
<Blockquote>
$BBRules</FONT>
</blockquote>
<HR width=90%><CENTER>
<FORM ACTION="Ultimate.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="register">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Agree">
</FORM>
<FORM ACTION="Ultimate.cgi" METHOD="POST">
<INPUT TYPE="HIDDEN" NAME="action" VALUE="intro">
<INPUT TYPE="HIDDEN" NAME="BypassCookie" VALUE="true">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Cancel">
</FORM>
$Footer
</CENTER>
</FONT>
<p></font>
</BODY></HTML>
Agreement
}

sub Register {
if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {
$EmailVerifyHTML = "<tr><TD $AltColumnColor2 colspan=2><FONT SIZE=\"$TextSize\" FACE=\"$FontFace\" COLOR=\"$LinkColor\">IMPORTANT: We will email your registration password to the email address you provide.  Thus, failure to provide your actual email address will mean you can not post any messages or replies on this bulletin board.</FONT></td></tr>";

$PasswordWording1 = "UserNames can be up to 25 characters.  Please use only letters and numbers.";
$PasswordWording2 = "";

} else {

$EmailVerifyHTML = "<TR><TD $AltColumnColor2><FONT SIZE=\"$TextSize\" FACE=\"$FontFace\"><B>Password*</B></FONT></TD><TD><INPUT TYPE=\"PASSWORD\" NAME=\"Password\" VALUE=\"\" SIZE=13 MAXLENGTH=13> </TD></TR><TR><TD><FONT SIZE=\"$TextSize\" FACE=\"$FontFace\"><B>Enter Password Again*</B></FONT></TD><TD><INPUT TYPE=\"PASSWORD\" NAME=\"PasswordConfirm\" VALUE=\"\" SIZE=13 MAXLENGTH=13></TD></tr>";

$PasswordWording1 = "UserNames can be up to 25 characters and passwords can be a maximum of 13 characters.  Please use only letters and numbers.  Passwords are case-sensitive.  This means that \"Howard\" is distinct from \"HOWARD.\"";

$PasswordWording2 = "In addition, your passwords are not encrypted and can be seen by the BB administrators.  Do not use a password that you would be afraid to reveal to anyone.";
}

if ($AllowSignature eq "YES") {
		$SigStatus = "enabled";
	}	else {
		$SigStatus = "not enabled";
	}

print<<RegHTML;
<HTML>
<HEAD>
	<TITLE>$BBName Registration</TITLE>
</HEAD>
 <BODY $BGColor  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<FONT SIZE="3" FACE="$FontFace" COLOR="$TextColor">
$Header
<A HREF="Ultimate.cgi?action=intro&BypassCookie=true"><IMG SRC="$NonCGIURL/$BBTitle" BORDER=0></A>
<FONT SIZE="3" FACE="$FontFace" COLOR="$LinkColor"><B>
Bulletin Board Registration
</B></FONT>
<P>
<table border=0>
<tr>
<td colspan=2>
<FONT SIZE="$TextSize" FACE="$FontFace">
<B>In order to post messages on this Bulletin Board, you must first register.  
<BR><BR>
$PasswordWording1
 
<BR><BR>
Note: all of the information provided on this page (with the exception of your password) will be viewable by anyone visiting the bulletin board.  Thus, if you don't feel comfortable about completing certain fields, just leave them blank.  $PasswordWording2 Required fields are marked by an asterisk.
<br><br></B></FONT>
</td></tr>
<tr>
<FORM NAME="Register" METHOD=POST ACTION="ubbmisc.cgi">

<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>User Name*</B></FONT></TD>
<TD><INPUT TYPE="TEXT" NAME="UserName" VALUE="" SIZE=25 MAXLENGTH=25>
 </TD>
</TR>
$EmailVerifyHTML
<TR>
	<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>Email*</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="Email" VALUE="" SIZE=30 MAXLENGTH=50>
 </TD>
</TR>
<TR>
	<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace"><B>City, State, Country</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="Location" VALUE="" SIZE=30 MAXLENGTH=50>
 </TD></tr>

<TR>
	<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>Occupation</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="Occupation" VALUE="" SIZE=30 MAXLENGTH=50>
 </TD>
</TR>

<TR>
	<TD $AltColumnColor2><FONT SIZE="$TextSize" FACE="$FontFace"><B>Homepage</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="URL" VALUE="http://" SIZE=30 MAXLENGTH=100>
 </TD></tr>
<TR>
	<TD $AltColumnColor1><FONT SIZE="$TextSize" FACE="$FontFace"><B>Interests</B></FONT></TD>
	<TD><INPUT TYPE="TEXT" NAME="Interests" VALUE="" SIZE=30 MAXLENGTH=200>
 </TD></tr>
 <TR>
	<TD $AltColumnColor2 valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>Signature</B></font><BR><FONT SIZE="1" FACE="$FontFace">Optional signature you may use to appear at bottom of your posts. Note: The Signature feature is currently $SigStatus by this bulletin board's administrator.  You may use <A HREF="$NonCGIURL/ubbcode.html">UBB Code</A> in this field, but not HTML.  The UBB Code Image tag is not permitted, however.</B></FONT></TD>
	<TD><TEXTAREA NAME="Signature" ROWS=3 COLS=25 WRAP=PHYSICAL>
</TEXTAREA>
 </TD></tr>
 
</TABLE>
<P>
<FONT SIZE="$TextSize" COLOR="$LinkColor" FACE="$FontFace"><B>
Set Your Preferences:</b> if you are using a browser that supports cookies, we can store some default preferences on your browser for you.  With the exception of the "email view" option below, if your browser does not support cookies, or you have cookies turned off, these preferences will not be set.
</font>
<P>
<table border=0>
<tr $AltColumnColor1>
<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>Store Username & Password in browser memory for 1 year (otherwise you will have to type your username and password once per browser session)</B></FONT></TD>
<TD valign=top><CENTER><FONT SIZE="$TextSize" FACE="$FontFace"><INPUT TYPE="RADIO" NAME="NameStorage" VALUE="yes" CHECKED>
 yes <INPUT TYPE="RADIO" NAME="NameStorage" VALUE="no"> no</font>
</CENTER> </TD>
</TR>

<TR $AltColumnColor2>
	<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>Default Topic View:</B></FONT></TD>
	<TD valign=top><CENTER><SELECT NAME="DaysPrune">
	<OPTION value="1">Show topics from last day
	<OPTION value="2">Show topics from last 2 days
	<OPTION value="5">Show topics from last 5 days
	<OPTION value="10">Show topics from last 10 days
	<OPTION value="20" SELECTED>Show topics from last 20 days
	<OPTION value="30">Show topics from last 30 days
	<OPTION value="45">Show topics from last 45 days
	<OPTION value="60">Show topics from last 60 days
	<OPTION value="75">Show topics from last 75 days
	<OPTION value="100">Show topics from last 100 days
	<OPTION value="365" $Days365>Show topics from the last year
	</SELECT>
</CENTER>
	
 </TD></tr>
<tr $AltColumnColor1>
<TD valign=top><FONT SIZE="$TextSize" FACE="$FontFace"><B>Keep your email address viewable to other users when you post notes?</B></FONT></TD>
<TD valign=top><CENTER><FONT SIZE="$TextSize" FACE="$FontFace"><INPUT TYPE="RADIO" NAME="EmailView" VALUE="yes" CHECKED>
 yes <INPUT TYPE="RADIO" NAME="EmailView" VALUE="no"> no</font>
</CENTER> </TD>
</TR>
</TABLE>
<BR><BR>
<CENTER>
<INPUT TYPE="HIDDEN" NAME="action" VALUE="RegSubmit">
<INPUT TYPE="SUBMIT" NAME="Submit" VALUE="Submit">
<INPUT TYPE="RESET" NAME="Reset" VALUE="Reset">
</FORM>
<BR><BR>
$Footer</center><BR></font></BODY>
</HTML>
RegHTML
}  ## END Register SR ##

