unit mxdmmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  msMx, msMxCls, StdCtrls, agWsock, ComCtrls, ExtCtrls;

type
  TMXForm = class(TForm)
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    ListBox1: TListBox;
    Label3: TLabel;
    ResolveButton: TButton;
    CancelButton: TButton;
    StatusBar: TStatusBar;
    Bevel1: TBevel;
    MXResolver: TmsMXResolver;
    procedure ResolveButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure MXResolverClosingConnection(Sender: TObject);
    procedure MXResolverSendingQuery(Sender: TObject);
    procedure MXResolverWaitingForResponse(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MXForm: TMXForm;

implementation

{$R *.DFM}

procedure TMXForm.ResolveButtonClick(Sender: TObject);
var
  i : Integer;
begin
  CancelButton.Enabled:=true;
  ResolveButton.Enabled:=false;
  try
    ListBox1.Clear;
    MXResolver.DNSAddress:=Edit1.Text;
    MXResolver.Domain:=Edit2.Text;
    MXResolver.Resolve;
    for i:=0 to MXResolver.MXList.Count-1 do
      ListBox1.Items.Add(IntToStr(MXResolver.MXList[i].Preference)+' - '
        +MXResolver.MXList[i].Exchanger);
  finally
    CancelButton.Enabled:=false;
    ResolveButton.Enabled:=true;
  end;
end;

procedure TMXForm.CancelButtonClick(Sender: TObject);
begin
  MXResolver.Cancel;
end;

procedure TMXForm.MXResolverClosingConnection(Sender: TObject);
begin
  StatusBar.SimpleText:='Connection closed';
end;

procedure TMXForm.MXResolverSendingQuery(Sender: TObject);
begin
  StatusBar.SimpleText:='Sending query';
end;

procedure TMXForm.MXResolverWaitingForResponse(Sender: TObject);
begin
  StatusBar.SimpleText:='Waiting for response';
end;

end.
