unit Mxdmmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, msmx, ExtCtrls, StdCtrls;

type
  TMXForm = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    ListBox1: TListBox;
    ResolveButton: TButton;
    CancelButton: TButton;
    StatusBar: TPanel;
    MXResolver: TmsMXResolver;
    procedure ResolveButtonClick(Sender: TObject);
    procedure MXResolverClosingConnection(Sender: TObject);
    procedure MXResolverSendingQuery(Sender: TObject);
    procedure MXResolverWaitingForResponse(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MXForm: TMXForm;

implementation

{$R *.DFM}

procedure TMXForm.ResolveButtonClick(Sender: TObject);
var
  i : Integer;
begin
  CancelButton.Enabled:=true;
  ResolveButton.Enabled:=false;
  try
    ListBox1.Clear;
    MXResolver.DNSAddress:=Edit1.Text;
    MXResolver.Domain:=Edit2.Text;
    MXResolver.Resolve;
    for i:=0 to MXResolver.MXList.Count-1 do
      ListBox1.Items.Add(IntToStr(MXResolver.MXList[i].Preference)+' - '
        +MXResolver.MXList[i].Exchanger);
  finally
    CancelButton.Enabled:=false;
    ResolveButton.Enabled:=true;
  end;
end;

procedure TMXForm.MXResolverClosingConnection(Sender: TObject);
begin
  StatusBar.Caption:='Connection closed';
end;

procedure TMXForm.MXResolverSendingQuery(Sender: TObject);
begin
  StatusBar.Caption:='Sending query';
end;

procedure TMXForm.MXResolverWaitingForResponse(Sender: TObject);
begin
  StatusBar.Caption:='Waiting for response';
end;

end.
