(**********************************************)
(*  The Internet Mail Suite  1.9.2            *)
(*  (c) ArGo Software Design, 1996,1997,1998. *)
(**********************************************)
unit msuucode;

{$I msdef.inc}

interface

uses SysUtils, Classes, Forms, msUtils, agTypes;

{$IFNDEF WIN32}
type
  ShortString=string;
{$ENDIF}

function IsUUCodeStart(s : string) : boolean;
function UUPickFileName(s : string) : string;
procedure UUMakeBinData(const InStr : ShortString; var OutStr : ShortString);
procedure UUMakeTextData(const InStr : ShortString; var OutStr : ShortString);

implementation

{$IFNDEF WIN32}
uses ms16utls;
{$ENDIF}

const
  Table : string =
  '`!"#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_';
  {12345678901234567890123456789012345678901234567890123456789012345}
  {         1         2         3         4         5         6     }

const
  MaxChars = 45;

function IsUUCodeStart(s : string) : boolean;
{ i.e. if the line is:
begin 666 filename.ext}
begin
  Result:=false;
  if (Copy(UpperCase(s),1,5)='BEGIN') and (Length(s)>=9) then
  begin
    Delete(s,1,5);
    s:=Trim(s);
    try
      StrToInt(Copy(s,1,3));
      Result:=true;
    except
      {Do Nothing}
    end;
  end;
end;

function UUPickFileName(s : string) : string;
var
  i : Integer;
begin
  Delete(s,1,10);
  if s[1]='"' then {if contains quotes}
  begin
    Delete(s,1,1);
    i:=Pos('"',s);
    if i>0 then
      Result:=Copy(s,1,i-1)
    else
      Result:='';
  end
  else
  begin
    i:=Pos(' ',s);
    if i>0 then
      Result:=Copy(s,1,i-1)
    else
      Result:=s;
  end;
end;

{$IFNDEF OLDENCODING}

function ByteFromTable(Ch : Char) : byte;
begin
  if Ch=' ' then Ch:='_';
  if (Ch>='!') and (Ch<='_') then
    Result:=Ord(Ch)-32
  else
  if Ch='`' then
    Result:=0
  else
    raise EMessageParserError.Create('Invalid Character');
end;

procedure UUMakeBinData(const InStr : ShortString; var OutStr : ShortString);
var
  i,j : Integer;
  l : LongInt;
  InSLen : byte absolute InStr;
  OutSLen : byte absolute OutStr;
begin
  Application.ProcessMessages;
  i:=2; OutStr:='';
  while i<=InSLen do
  begin
    l:=0; j:=1;
    while (j<=4) and (i+j-1<=InSLen) do
    begin
      l:=l shl 6;
      l:=ByteFromTable(InStr[i+j-1]) or l;
      Inc(j);
    end;
    while (j<=4) do {Pad with zeroes}
    begin
      l:=l shl 6;
      Inc(j);
    end;
    for j:=2 DownTo 0 do
      OutStr:=Concat(OutStr,Char((l shr (8*j)) and $000000FF));
    Inc(i,4);
  end;
  SetLength(OutStr,ByteFromTable(InStr[1]));
end;

procedure UUMakeTextData(const InStr : ShortString; var OutStr : ShortString);
var
  i,j,k : Integer;
  l : LongInt;
  InSLen : byte absolute InStr;
  OutSLen : byte absolute OutStr;
  ss : string;
begin
  Application.ProcessMessages;
  i:=1; OutStr:='';
  while i<=InSLen do
  begin
    l:=0;
    if i+2<=InSLen then k:=3
      else k:=(InSLen-i+1);
    for j:=1 to k do
    begin
      l:=l shl 8;
      l:=Byte(InStr[i+j-1]) or l;
    end;
    for j:=k+1 to 3 do {Pad with zeros}
      l:=4*l;
    ss:='';
    for j:=0 to k do
      ss:=Concat(ss,Table[((l shr (6*j)) and $0000003F)+1]);
    for j:=Length(ss) downto 1 do
      OutStr:=Concat(OutStr,ss[j]);
    Inc(i,k);
  end;
  if Length(InStr)=MaxChars then SetLength(OutStr,4*MaxChars div 3) else
  begin
    if InSLen mod 3=0 then k:=0 else k:=1;
    SetLength(OutStr,4*Length(InStr) div 3 + k);
  end;
  OutStr:=Concat(Table[Length(InStr)+1],OutStr);
end;

{$ELSE}
function ByteFromTable(Ch : Char) : byte;
var
  i : byte;
begin
  i:=1;
  while (Ch<>Table[i]) and (i<=64) do Inc(i);
  if i>64 then
  begin
    Result:=0;
    if Ch<>' ' then
      raise EMessageParserError.Create('Invalid Character');
  end
  else
   Result:=i-1;
end;

procedure UUMakeBinData(const InStr : ShortString; var OutStr : ShortString);
var
  i,j,k,b,m : word;
  InSLen : byte absolute InStr;
  ActualLen : byte;
  TheBits : TBits;
begin
  TheBits:=TBits.Create;
  TheBits.Size:=8*MaxChars+1;
  k:=0;
  ActualLen:=4*ByteFromTable(InStr[1]) div 3;
  if ActualLen<>(4*MaxChars div 3) then
    ActualLen:=InSLen-1;
  for i:=2 to ActualLen+1 do
  begin
    b:=ByteFromTable(InStr[i]);
    for j:=5 DownTo 0 do
    begin
      m:=1 shl j;
      if (b and m = m) then
        TheBits[k]:=true;
      Inc(k);
    end;
  end;
  k:=0;
  OutStr:='';
  for i:=1 to MaxChars do
  begin
    b:=0;
    for j:=7 DownTo 0 do
    begin
      if TheBits[k] then b:= b or (1 shl j);
      Inc(k);
    end;
    OutStr:=Concat(OutStr,Char(b));
  end;
  SetLength(OutStr,ByteFromTable(InStr[1]));
  TheBits.Free;
end;

procedure UUMakeTextData(const InStr : ShortString; var OutStr : ShortString);
var
  i,j,k,b,m : Integer;
{
  CheckSum : word;
}
  TheBits : TBits;
  s : string;
begin
  k:=0;
  TheBits:=TBits.Create;
  TheBits.Size:=8*MaxChars+1;
  for i:=1 to MaxChars do
  begin
    b:=Byte(InStr[i]);
    for j:=7 DownTo 0 do
    begin
      m:=1 shl j;
      if (b and m = m) then
        TheBits[k]:=true;
      Inc(k);
    end;
  end;
  s:=''; k:=0; m:=4*(MaxChars div 3);
  OutStr:='';
{
  CheckSum:=0;
}
  for i:=1 to m do
  begin
    b:=0;
    for j:=5 DownTo 0 do
    begin
      if TheBits[k] then b:= b or (1 shl j);
      Inc(k);
    end;
    OutStr:=Concat(OutStr,Table[b+1]);
{
    if FCheckSums then
      Inc(CheckSum,b);
}
  end;
  if Length(InStr)=MaxChars then SetLength(OutStr,4*MaxChars div 3)
    else SetLength(OutStr,4*Length(InStr) div 3 + 1);
{
  if FCheckSums then
    s:=Concat(s,Table[CheckSum mod 64 + 1]);
}
  OutStr:=Concat(Table[Length(InStr)+1],OutStr);
  TheBits.Free;
end;
{$ENDIF}

end.
