(**********************************************)
(*  The Internet Mail Suite  1.9.2            *)
(*  (c) ArGo Software Design, 1996,1997,1998. *)
(**********************************************)
unit mssmtp;

{$I msdef.inc}

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinProcs,
{$ENDIF}
  SysUtils, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, msUtils, msMsgCls, msmsg,
  msCls, msConst, agConst, agTypes, agSocket, msMB;

type
  TmsSMTP = class(TmsMailBase)
  private
    { Private declarations }
    FOnPrepare : TNotifyEvent;
    FOnSending : TNotifyEvent;
    FOnMailSent : TNotifyEvent;
    FOnAddressRejected : TmsAddressRejectedEvent;
    FMailMessage : TmsMessage;
    FTempFileStream : TTempFileStream;
    procedure DoPrepare(Sender : TObject);
    procedure DoSending(Sender : TObject);
    procedure DoMailSent(Sender : TObject);
    procedure DoAddressRejected(Sender : TObject; const TheAddress,
      ServerReply : string; var Proceed : boolean);
  protected
    { Protected declarations }
    procedure SendEnvelope;
    procedure SendBody;
    procedure LogIn; override;
    procedure LogOut; override;
    procedure PrepareMessage;
    procedure Notification(AComponent : TComponent;
               Operation : TOperation); override;
  public
    { Public declarations }
    ActualRecipients : TStrings;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Open; override;
    procedure Send;
    procedure Send_Message;
    procedure Reset;
  published
    { Published declarations }
    property MailMessage : TmsMessage read FMailMessage write FMailMessage;
    property DefaultPort;
    property OnProgress;
    property OnPrepare : TNotifyEvent read FOnPrepare write FOnPrepare;
    property OnSending : TNotifyEvent read FOnSending write FOnSending;
    property OnMailSent : TNotifyEvent read FOnMailSent write FOnMailSent;
    property OnAddressRejected : TmsAddressRejectedEvent read FOnAddressRejected
       write FOnAddressRejected;
  end;

implementation

constructor TmsSMTP.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  ActualRecipients:=TStringList.Create;
{Initialize the variables}
  ServiceName:='smtp';
  DefaultPort:=25;
end;

destructor TmsSMTP.Destroy;
begin
  ActualRecipients.Free;
  inherited Destroy;
end;

procedure TmsSMTP.Notification(AComponent : TComponent;
              Operation : TOperation);
begin
  inherited Notification(AComponent, Operation);
  if (Operation=opRemove) and (AComponent=FMailMessage) then
    FMailMessage:=nil;
end;

procedure TmsSMTP.DoPrepare(Sender : TObject);
begin
  if Assigned(FOnPrepare) then
    FOnPrepare(Sender);
end;

procedure TmsSMTP.DoSending(Sender : TObject);
begin
  if Assigned(FOnSending) then
    FOnSending(Sender);
end;

procedure TmsSMTP.DoMailSent(Sender : TObject);
begin
  if Assigned(FOnMailSent) then
    FOnMailSent(Sender);
end;

procedure TmsSMTP.DoAddressRejected(Sender : TObject; const TheAddress,
  ServerReply : string; var Proceed : boolean);
begin
  if Assigned(FOnAddressRejected) then
    FOnAddressRejected(Sender, TheAddress, ServerReply, Proceed);
end;

procedure TmsSMTP.Open;
begin
  Verify;
  Reinit;
  inherited Open;
end;

procedure TmsSMTP.PrepareMessage;
begin
  DoPrepare(Self);
  FMailMessage.SaveToStream(FTempFileStream);
end;

procedure TmsSMTP.LogIn;
var
  rs : Integer;
begin
  Connect;
  rs:=RecvLines;
  if (rs div 100)<>2 then
    raise EServerError.Create(TempS);
{First try just HELO LocalHost, if rejected, then just HELO}
  SendLine('HELO '+LocalHost);
  rs:=RecvLines;
  if (rs div 100)<>2 then
  begin
    SendLine('HELO');
    rs:=RecvLines;
    if (rs div 100)<>2 then
      raise EServerError.Create(TempS);
  end;
end;

procedure TmsSMTP.LogOut;
var
  rs : Integer;
begin
  Application.ProcessMessages;
  SendLine('QUIT');
  rs:=RecvLines;
  if (rs div 100)<>2 then
    raise EServerError.Create(TempS);
end;

procedure TmsSMTP.SendEnvelope;
var
  i,rs : Integer;
  Proceed : boolean;
begin
  DoSending(Self);
  if FMailMessage.Sender.Address<>'' then
  begin
    SendLine('MAIL FROM:<'+FMailMessage.Sender.Address+'>');
    rs:=RecvLines;
    if (rs div 100)<>2 then
      raise EServerError.Create(TempS);
  end;
  if ActualRecipients.Count>0 then
  begin
    for i:=0 to ActualRecipients.Count-1 do
    begin
      Proceed:=false;
      SendLine('RCPT TO:<'+ActualRecipients[i]+'>');
      rs:=RecvLines;
      if (rs div 100)<>2 then
      begin
        DoAddressRejected(Self,ActualRecipients[i],TempS,Proceed);
        if not Proceed then
          raise EServerError.Create(TempS);
      end;
    end;
  end
  else
  begin
    for i:=0 to FMailMessage.Recipients.Count-1 do
    begin
      Proceed:=false;
      SendLine('RCPT TO:<'+FMailMessage.Recipients[i].Address+'>');
      rs:=RecvLines;
      if (rs div 100)<>2 then
      begin
        DoAddressRejected(Self,FMailMessage.Recipients[i].Address,TempS,Proceed);
        if not Proceed then
          raise EServerError.Create(TempS);
      end;
    end;
    for i:=0 to FMailMessage.CC.Count-1 do
    begin
      Proceed:=false;
      SendLine('RCPT TO:<'+FMailMessage.CC[i].Address+'>');
      rs:=RecvLines;
      if (rs div 100)<>2 then
      begin
        DoAddressRejected(Self,FMailMessage.CC[i].Address,TempS,Proceed);
        if not Proceed then
          raise EServerError.Create(TempS);
      end;
    end;
    for i:=0 to FMailMessage.BCC.Count-1 do
    begin
      Proceed:=false;
      SendLine('RCPT TO:<'+FMailMessage.BCC[i].Address+'>');
      rs:=RecvLines;
      if (rs div 100)<>2 then
      begin
        DoAddressRejected(Self,FMailMessage.BCC[i].Address,TempS,Proceed);
        if not Proceed then
          raise EServerError.Create(TempS);
      end;
    end;
  end;
  SendLine('DATA');
  rs:=RecvLines;
  if (rs div 100)<>3 then
    raise EServerError.Create(TempS);
end;

procedure TmsSMTP.SendBody;
var
  rs : Integer;
begin
  SendStream(FTempFileStream);
  SendLine('');
  SendLine('.');
  rs:=RecvLines;
  if (rs div 100)<>2 then
    raise EServerError.Create(TempS);
end;

procedure TmsSMTP.Send_Message;
begin
  if not Assigned(FMailMessage) then
    Error(msSMailMessageRequired);
  FMailMessage.Verify;
  FTempFileStream:=TTempFileStream.Create;
  try
    PrepareMessage;
    SendEnvelope;
    SendBody;
    DoMailSent(Self);
  finally
    FTempFileStream.Free;
  end;
end;

procedure TmsSMTP.Send;
begin
  try
    OpenConnection;
    Send_Message;
  finally
    CloseConnection;
  end;
end;

procedure TmsSMTP.Reset;
var
  rs : Integer;
begin
  if not OnLine then
    OpenConnection;
  SendLine('RSET');
  rs:=RecvLine(TempS);
  if (rs div 100)<>2 then
    raise EServerError.Create(TempS);
end;

end.
