(**********************************************)
(*  The Internet Mail Suite  1.9.2            *)
(*  (c) ArGo Software Design, 1996,1997,1998. *)
(**********************************************)
unit mspop3cl;

{$I msDef.inc}

interface

uses Classes, msMsgCls;

type
  TmsAction = (raRetrieve,raDelete);

  TmsActionSet = set of TmsAction;

  TmsRemoteInfoItem = class
  protected
    Action : TmsActionSet;
    procedure SetMarkedToDelete(Value : boolean);
    function GetMarkedToDelete : boolean;
    procedure SetMarkedToRetrieve(Value : boolean);
    function GetMarkedToRetrieve : boolean;
  public
    Size : LongInt;
    Headers : TmsHeaders;
    UIDL : string;
    constructor Create;
    destructor Destroy; override;
    property MarkedToDelete : boolean read GetMarkedToDelete
               write SetMarkedToDelete;
    property MarkedToRetrieve : boolean read GetMarkedToRetrieve
               write SetMarkedToRetrieve;
  end;

  TmsRemoteInfo = class
  private
    { Private declarations }
    FList : TList;
    function GetCount : Integer;
    function GetItem(Index : Integer) : TmsRemoteInfoItem;
  protected
    { Protected declarations }
  public
    { Public declarations }
    constructor Create;
    destructor Destroy; override;
    procedure Clear;
    function Add(Value : TmsRemoteInfoItem) : Integer;
    property Count : Integer read GetCount;
    property Items[Index : Integer] : TmsRemoteInfoItem read GetItem;
         default;
  end;

implementation

{TmsRemoteInfoItem}
constructor TmsRemoteInfoItem.Create;
begin
  inherited Create;
  Headers:=TmsHeaders.Create;
end;

destructor TmsRemoteInfoItem.Destroy;
begin
  Headers.Free;
  inherited Destroy;
end;

procedure TmsRemoteInfoItem.SetMarkedToDelete(Value : boolean);
begin
  if Value then
    Include(Action,raDelete)
  else
    Exclude(Action,raDelete);
end;

function TmsRemoteInfoItem.GetMarkedToDelete : boolean;
begin
  Result:=raDelete in Action;
end;

procedure TmsRemoteInfoItem.SetMarkedToRetrieve(Value : boolean);
begin
  if Value then
    Include(Action,raRetrieve)
  else
    Exclude(Action,raRetrieve);
end;

function TmsRemoteInfoItem.GetMarkedToRetrieve : boolean;
begin
  Result:=raRetrieve in Action;
end;

{TmsRemoteInfo}
constructor TmsRemoteInfo.Create;
begin
  inherited Create;
  FList:=TList.Create;
end;

destructor TmsRemoteInfo.Destroy;
begin
  if FList<>nil then
  begin
    Clear;
    FList.Free;
  end;
  inherited Destroy;
end;

function TmsRemoteInfo.GetCount;
begin
  Result:=FList.Count;
end;

function TmsRemoteInfo.GetItem(Index : Integer) : TmsRemoteInfoItem;
begin
  Result:=TmsRemoteInfoItem(FList[Index]);
end;

procedure TmsRemoteInfo.Clear;
var
  i : Integer;
begin
  for i:=Count-1 DownTo 0 do
    Items[i].Free;
  FList.Clear;
end;

function TmsRemoteInfo.Add(Value : TmsRemoteInfoitem) : Integer;
begin
  Result:=FList.Add(Value);
end;

end.
