(**********************************************)
(*  The Internet Mail Suite  1.9.2            *)
(*  (c) ArGo Software Design, 1996,1997,1998. *)
(**********************************************)
unit msnwscls;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinProcs,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  msMsgCls, msUtils, agSocket;

type
  TmsNewsgroup = class
    FirstArticle : LongInt;
    LastArticle : LongInt;
    Flag : Char;  {'y'-posting allowed, 'n'-posting not allowed, 'm'-moderated}
    Name : string;
  end;

  TmsNewsGroupList = class(TPersistent)
  private
    FList : TList;
    function Get(Index : Integer) : TmsNewsGroup;
    procedure Put(Index : Integer; Value : TmsNewsGroup);
    function GetCount : Integer;
  protected
    function PickAPart(s : string; Position : Integer) : string;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Value : TmsNewsGroup) : Integer;
    procedure SaveToFile(const FileName : string);
    procedure SaveToStream(Stream : TStream);
    procedure LoadFromFile(const FileName : string);
    procedure LoadFromStream(Stream : TStream);
    procedure Clear;
    property Items[Index : Integer] : TmsNewsGroup read Get write Put; default;
    property Count : Integer read GetCount;
  end;

  TmsNgInfoItem = class(TmsHeaders)
  private
    FNumber : LongInt;
  public
    property Number : LongInt read FNumber write FNumber;
  end;

  TmsNgInfoList = class(TPersistent)
  private
    FList : TList;
    function Get(Index : Integer) : TmsNgInfoItem;
    procedure Put(Index : Integer; Value : TmsNgInfoItem);
    function GetCount : Integer;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Value : TmsNgInfoItem) : Integer;
    procedure Clear;
    property Items[Index : Integer] : TmsNgInfoItem read Get write Put; default;
    property Count : Integer read GetCount;
  end;

implementation

{TmsNewsGroupList}
constructor TmsNewsGroupList.Create;
begin
  inherited Create;
  FList:=TList.Create;
end;

destructor TmsNewsGroupList.Destroy;
var
  i : Integer;
begin
  if FList<>nil then
  begin
    for i:=Count-1 DownTo 0 do
      Items[i].Free;
    FList.Free;
  end;
  inherited Destroy;
end;

function TmsNewsGroupList.Get(Index : Integer) : TmsNewsGroup;
begin
  Result:=FList[Index];
end;

procedure TmsNewsGroupList.Put(Index : Integer; Value : TmsNewsGroup);
begin
  FList[Index]:=Value;
end;

function TmsNewsGroupList.GetCount : Integer;
begin
  Result:=FList.Count;
end;

function TmsNewsGroupList.Add(Value : TmsNewsGroup) : Integer;
begin
  Result:=FList.Add(Value);
end;

procedure TmsNewsGroupList.Clear;
var
  i : Integer;
begin
  for i:=Count-1 DownTo 0 do
    Items[i].Free;
  FList.Clear;
end;

procedure TmsNewsGroupList.SaveToStream(Stream : TStream);
var
  s : string;
  i : Integer;
begin
  Stream.Position:=0;
  for i:=0 to Count-1 do
  begin
    with Items[i] do
      s:=Concat(Name,' ',IntToStr(LastArticle),' ',
         IntToStr(FirstArticle),' ',Flag,^M^J);
    Stream.Write(s[1],Length(s));
  end;
end;

procedure TmsNewsGroupList.SaveToFile(const FileName : string);
var
  FileStream : TFileStream;
begin
  FileStream:=TFileStream.Create(FileName, fmCreate or fmOpenWrite);
  try
    SaveToStream(FileStream);
  finally
    FileStream.Free;
  end;
end;

function TmsNewsGroupList.PickAPart(s : string; Position : Integer) : string;
var
  sp : Integer;
  i : Integer;
begin
  Result:=''; sp:=-1;
  for i:=1 to Position do
  begin
    sp:=Pos(' ',s);
    if sp<>0 then
    begin
      Delete(s,1,sp);
      s:=Trim(s);
    end
    else
    begin
      Result:='';
      Break;
    end;
  end;
  if sp<>0 then
  begin
    sp:=Pos(' ',s);
    if sp>0 then
      s:=Trim(Copy(s,1,sp-1))
    else
      s:=Trim(s);
    Result:=s;
  end;
end;

procedure TmsNewsGroupList.LoadFromStream(Stream : TStream);
var
  SL : TStrings;
  NG : TmsNewsGroup;
  i : Integer;
  s : string;
begin
  Stream.Position:=0;
  Clear;
  SL:=TStringList.Create;
  try
    SL.LoadFromStream(Stream);
    for i:=0 to SL.Count-1 do
    begin
      NG:=TmsNewsGroup.Create;
      NG.Name:=PickAPart(SL[i],0);
      NG.LastArticle:=StrToIntDef(PickAPart(SL[i],1),-1);
      NG.FirstArticle:=StrToIntDef(PickAPart(SL[i],2),-1);
      s:=PickAPart(SL[i],3);
      if Length(s)>0 then
        NG.Flag:=s[1];
      Add(NG);
    end;
  finally
    SL.Free;
  end;
end;

procedure TmsNewsGroupList.LoadFromFile(const FileName : string);
var
  FileStream : TFileStream;
begin
  FileStream:=TFileStream.Create(FileName, fmOpenRead);
  try
    LoadFromStream(FileStream);
  finally
    FileStream.Free;
  end;
end;

{Implementation for TmsNgInfoItemList}
constructor TmsNgInfoList.Create;
begin
  inherited Create;
  FList:=TList.Create;
end;

destructor TmsNgInfoList.Destroy;
var
  i : Integer;
begin
  if FList<>nil then
  begin
    for i:=Count-1 DownTo 0 do
      Items[i].Free;
    FList.Free;
  end;
  inherited Destroy;
end;

function TmsNgInfoList.GetCount : Integer;
begin
  Result:=FList.Count;
end;

function TmsNgInfoList.Get(Index : Integer) : TmsNgInfoItem;
begin
  Result:=FList[Index];
end;

procedure TmsNgInfoList.Put(Index : Integer; Value : TmsNgInfoItem);
begin
  FList[Index]:=Value;
end;

function TmsNgInfoList.Add(Value : TmsNgInfoItem) : Integer;
begin
  Result:=FList.Add(Value);
end;

procedure TmsNgInfoList.Clear;
var
  i : Integer;
begin
  for i:=FList.Count-1 DownTo 0 do
    Items[i].Free;
  FList.Clear;
end;

end.
