unit Ms16utls;

{$I msdef.inc}

interface

uses WinProcs, WinTypes, Classes, SysUtils;

{$IFDEF OLDENCODING}
type
  TBits = class
  private
    FContents : PChar;
    FSize : Cardinal;
    procedure SetSize(Value : Cardinal);
    procedure Put(Index : Cardinal; Value : boolean);
    function Get(Index : Cardinal) : boolean;
  public
    constructor Create;
    destructor Destroy; override;
    property Size : Cardinal read FSize write SetSize default $FFFF;
    property Bits[Index : Cardinal] : boolean read Get write Put; default;
  end;
{$ENDIF}

procedure BufToLines(Buf : PChar; SL : TStrings; WrapMargin : Cardinal);
procedure SetLength(var s : string; Len : byte);

implementation

{$IFDEF OLDENCODING}
constructor TBits.Create;
begin
  inherited Create;
  FSize:=$FFFF;
end;

destructor TBits.Destroy;
begin
  if FSize<>$FFFF then
    StrDispose(FContents);
  inherited Destroy;
end;

procedure TBits.SetSize(Value : Cardinal);
begin
  if FSize<>$FFFF then
    StrDispose(FContents);
  FContents:=StrAlloc(Value);
  FSize:=Value;
  FillChar(FContents^,FSize,0);
end;

procedure TBits.Put(Index : Cardinal; Value : boolean);
begin
  if (Index>FSize) or (FSize=$FFFF) then
    raise Exception.Create('Index out of bounds');
  if Value then
    (FContents+Index)^:='1'
  else
    (FContents+Index)^:='0';
end;

function TBits.Get(Index : Cardinal) : boolean;
begin
  if (Index>FSize) or (FSize=$FFFF) then
    raise Exception.Create('Index out of bounds');
  Result:=(FContents+Index)^='1';
end;
{$ENDIF}

const
  ParaSize=4096;

procedure BufToLines(Buf : PChar; SL : TStrings; WrapMargin : Cardinal);
const
  CRLF : PChar = ^M^J;
  WrapChars : Set of Char = [' ','-'];
var
  FirstCRLF : PChar;
  Para : PChar;
  Done : boolean;
  ParaLen : Cardinal;

procedure WrapPara;
var
  SavePara : PChar;
  Position : PChar;
  TempP : PChar;
  WrapDone : boolean;
begin
  SavePara:=Para;
  TempP:=StrAlloc(WrapMargin+1);
  try
    repeat
      WrapDone:=StrLen(Para)<=WrapMargin;
      if not WrapDone then
      begin
        Position:=Para+WrapMargin;
        repeat
          Dec(Position);
        until (Position^ in WrapChars) or (Position=Para);
        if Position=Para then Position:=Para+WrapMargin;
        StrLCopy(TempP,Para,Position-Para);
        Para:=Position;
      end
      else
        StrCopy(TempP,Para);
      SL.Add(StrPas(TempP));
    until WrapDone;
  finally
    StrDispose(TempP);
    Para:=SavePara;
  end;
end;

begin
  SL.Clear;
  Para:=StrAlloc(ParaSize);
  try
    Done:=false;
    repeat
      FirstCRLF:=StrPos(Buf,CRLF);
      Done:=FirstCRLF=nil;
      if Done then
        FirstCRLF:=StrEnd(Buf);
      ParaLen:=FirstCRLF-Buf;
      StrLCopy(Para,Buf,ParaLen);
  {wrapping a paragraph}
      if ParaLen>WrapMargin then
        WrapPara
      else
        SL.Add(StrPas(Para));
  {end wrapping of a paragraph}
      if not Done then
        Buf:=Buf+ParaLen+2;
    until Done;
  finally
    StrDispose(Para);
  end;
end;

procedure SetLength(var s : string; Len : byte);
begin
  s[0]:=Char(Len);
end;

end.
