unit rmmain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls, StdCtrls, msmsg, msmb, mspop3, Buttons,
  IniFiles, Menus, msAbout, msUtils, msMsgCls, agsocket, agTypes, agRasCmp;

type
  TRemotePOPForm = class(TForm)
    ListView1: TListView;
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    UpdateButton: TSpeedButton;
    RetrieveButton: TSpeedButton;
    RetrCopyButton: TSpeedButton;
    DeleteButton: TSpeedButton;
    ResetButton: TSpeedButton;
    TransferButton: TSpeedButton;
    ImageList1: TImageList;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Updateheaders1: TMenuItem;
    Marktoretrieve1: TMenuItem;
    MarktoDelete1: TMenuItem;
    MarktoRetrieveCopy1: TMenuItem;
    ResetAll1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    TransferData1: TMenuItem;
    Setup1: TMenuItem;
    Help1: TMenuItem;
    msRemotePOP1: TmsRemotePOP;
    About1: TMenuItem;
    ExitButton: TSpeedButton;
    SetupButton: TSpeedButton;
    CancelButton: TSpeedButton;
    Cancel1: TMenuItem;
    Bevel1: TBevel;
    procedure UpdateButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure RetrieveButtonClick(Sender: TObject);
    procedure TransferButtonClick(Sender: TObject);
    procedure RetrCopyButtonClick(Sender: TObject);
    procedure ResetButtonClick(Sender: TObject);
    procedure Setup1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure msRemotePOP1Cancel(Sender: TObject);
    procedure msRemotePOP1Open(Sender: TObject);
    procedure msRemotePOP1UpdatingInfo(Sender: TObject);
    procedure msRemotePOP1InfoUpdated(Sender: TObject);
    procedure msRemotePOP1DataTransfered(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure Exit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure ListView1Change(Sender: TObject; Item: TListItem;
      Change: TItemChange);
    procedure msRemotePOP1NextInfoUpdated(Sender: TObject;
      Current: Integer);
    procedure msRemotePOP1Closed(Sender: TObject);
    procedure msRemotePOP1Closing(Sender: TObject);
    procedure msRemotePOP1TransferringData(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure msRemotePOP1UserMessageSave(Sender: TObject; Num: Integer;
      Contents: TMemoryStream);
    procedure agRas1Disconnected(Sender: TObject);
    procedure agRas1StatusChange(Sender: TObject; RASStatusStr: string);
    procedure msRemotePOP1Error(Sender: TObject; var Msg: string);
  private
    { Private declarations }
    IniName : string;
    Item : TListItem;
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  RemotePOPForm: TRemotePOPForm;

implementation

uses rmdemosu;

{$R *.DFM}

procedure TRemotePOPForm.msRemotePOP1NextInfoUpdated(Sender: TObject;
  Current: Integer);
var
  s,TZ : string;
  Addr,AName : string;
  DT : TDateTime;
begin
  with msRemotePOP1 do
  begin
    Item:=ListView1.Items.Add;
    Item.Caption:=RemoteInfo[Current].Headers.GetFieldBody('Subject');
    s:=RemoteInfo[Current].Headers.GetFieldBody('From');
    SplitAddress(s,Addr,AName);
    if AName<>'' then s:=AName
      else s:=Addr;
    Item.Subitems.Add(s);
    Item.SubItems.Add(IntToStr(RemoteInfo[Current].Size));
    s:=RemoteInfo[Current].Headers.GetFieldBody('Date');
    MailDateToDateTime(s,DT,TZ);
    if DT<>0 then
      s:=DateTimeToStr(DT);
    Item.SubItems.Add(s);
    StatusBar1.SimpleText:=IntToStr(Current+1)+'/'+IntToStr(TotalMessages);
  end;
end;

procedure TRemotePOPForm.UpdateButtonClick(Sender: TObject);
begin
  if ListView1.Items.Count>0 then
    ListView1.Items.Clear;
  CancelButton.Enabled:=true;
  Cancel1.Enabled:=true;
  msRemotePOP1.UpdateRemoteInfo;
  CancelButton.Enabled:=false;
  Cancel1.Enabled:=false;
end;

procedure TRemotePOPForm.DeleteButtonClick(Sender: TObject);
var
  i : Integer;
begin
  with ListView1 do
  begin
    for i:=0 to Items.Count-1 do
    if Items[i].Selected then
    begin
      msRemotePOP1.MarkToDelete(i);
      Items[i].StateIndex:=2;
    end;
  end;
end;

procedure TRemotePOPForm.RetrieveButtonClick(Sender: TObject);
var
  i : Integer;
begin
  with ListView1 do
  begin
    for i:=0 to Items.Count-1 do
    if Items[i].Selected then
    begin
      msRemotePOP1.MarkToRetrieve(i);
      msRemotePOP1.MarkToDelete(i);
      Items[i].StateIndex:=0;
    end;
  end;
end;

procedure TRemotePOPForm.TransferButtonClick(Sender: TObject);
begin
  ListView1.Items.Clear;
  CancelButton.Enabled:=true;
  Cancel1.Enabled:=true;
  msRemotePOP1.Transfer;
  msRemotePOP1.UpdateRemoteInfo;
  CancelButton.Enabled:=false;
  Cancel1.Enabled:=false;
end;

procedure TRemotePOPForm.RetrCopyButtonClick(Sender: TObject);
var
  i : Integer;
begin
  with ListView1 do
  begin
    for i:=0 to Items.Count-1 do
    if Items[i].Selected then
    begin
      msRemotePOP1.MarkToRetrieve(i);
      Items[i].StateIndex:=1;
    end;
  end;
end;

procedure TRemotePOPForm.ResetButtonClick(Sender: TObject);
var
  i : Integer;
begin
  for i:=0 to ListView1.Items.Count-1 do
  begin
    msRemotePOP1.Reset(i);
    ListView1.Items[i].StateIndex:=-1;
  end;
end;

procedure TRemotePOPForm.Setup1Click(Sender: TObject);
begin
  with TSetupDlg.Create(Self) do
  try
    ServerEdit.Text:=msRemotePOP1.Server;
    UserNameEdit.Text:=msRemotePOP1.UserName;
    PasswordEdit.Text:=msRemotePOP1.Password;
    LogFileNameEdit.Text:=msRemotePOP1.LogFileName;
    AttDirEdit.Text:=msRemotePOP1.MessageDirectory;
    if ShowModal=mrOk then
    begin
      msRemotePOP1.Server:=ServerEdit.Text;
      msRemotePOP1.UserName:=UserNameEdit.Text;
      msRemotePOP1.Password:=PasswordEdit.Text;
      msRemotePOP1.LogFileName:=LogFileNameEdit.Text;
      msRemotePOP1.MessageDirectory:=AttDirEdit.Text;
    end;
  finally
    free;
  end;
end;

procedure TRemotePOPForm.FormCreate(Sender: TObject);
begin
  IniName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    msRemotePOP1.Server:=ReadString('Setup','Server','');
    msRemotePOP1.UserName:=ReadString('Setup','User Name','');
    msRemotePOP1.Password:=ReadString('Setup','Password','');
    msRemotePOP1.LogFileName:=ReadString('Setup','Log File','');
    msRemotePOP1.MessageDirectory:=ReadString('Setup','Messages','');
  finally
    free;
  end;
  DisableControls;
end;

procedure TRemotePOPForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  with TIniFile.Create(IniName) do
  try
    WriteString('Setup','Server',msRemotePOP1.Server);
    WriteString('Setup','User Name',msRemotePOP1.UserName);
    WriteString('Setup','Password',msRemotePOP1.Password);
    WriteString('Setup','Log File',msRemotePOP1.LogFileName);
    WriteString('Setup','Messages',msRemotePOP1.MessageDirectory);
  finally
    free;
  end;
end;

procedure TRemotePOPForm.msRemotePOP1Cancel(Sender: TObject);
begin
  StatusBar1.SimpleText:='Operation has been canceled';
end;

procedure TRemotePOPForm.msRemotePOP1Open(Sender: TObject);
begin
  StatusBar1.SimpleText:='Opening connection';
end;

procedure TRemotePOPForm.msRemotePOP1UpdatingInfo(Sender: TObject);
begin
  StatusBar1.SimpleText:='Updating headers';
end;

procedure TRemotePOPForm.msRemotePOP1InfoUpdated(Sender: TObject);
begin
  StatusBar1.SimpleText:=IntToStr(msRemotePOP1.RemoteInfo.Count)+' message(s)';
end;

procedure TRemotePOPForm.msRemotePOP1DataTransfered(Sender: TObject);
begin
  StatusBar1.SimpleText:='Data has been transfered';
end;

procedure TRemotePOPForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  if msRemotePOP1.OnLine then
    msRemotePOP1.CloseConnection;
end;

procedure TRemotePOPForm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TRemotePOPForm.About1Click(Sender: TObject);
begin
  with TAboutDlg.Create(Self) do
  try
    ProgramName.Caption:='Remote Mail Demo';
    ProductVersion.Caption:=msVersion;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TRemotePOPForm.EnableControls;
var
  i : Integer;
begin
  for i:=0 to ComponentCount-1 do
  begin
    if (Components[i] is TSpeedButton) and ((Components[i] as TSpeedButton).Tag=1)
      then (Components[i] as TSpeedButton).Enabled:=true;
    if (Components[i] is TMenuItem) and ((Components[i] as TMenuItem).Tag=1)
      then (Components[i] as TMenuItem).Enabled:=true;
  end;
end;

procedure TRemotePOPForm.DisableControls;
var
  i: Integer;
begin
  for i:=0 to ComponentCount-1 do
  begin
    if (Components[i] is TSpeedButton) and ((Components[i] as TSpeedButton).Tag=1)
      then (Components[i] as TSpeedButton).Enabled:=false;
    if (Components[i] is TMenuItem) and ((Components[i] as TMenuItem).Tag=1)
      then (Components[i] as TMenuItem).Enabled:=false;
  end;
end;

procedure TRemotePOPForm.ListView1Change(Sender: TObject;
  Item: TListItem; Change: TItemChange);
begin
  if ListView1.Items.Count>0 then EnableControls
    else DisableControls;
end;

procedure TRemotePOPForm.msRemotePOP1Closed(Sender: TObject);
begin
  StatusBar1.SimpleText:='Connection closed';
end;

procedure TRemotePOPForm.msRemotePOP1Closing(Sender: TObject);
begin
  StatusBar1.SimpleText:='Closing connection';
end;

procedure TRemotePOPForm.msRemotePOP1TransferringData(Sender: TObject);
begin
  StatusBar1.SimpleText:='Transferring data';
end;

procedure TRemotePOPForm.CancelButtonClick(Sender: TObject);
begin
  msRemotePOP1.Cancel;
  ListView1.Items.Clear;
end;

procedure TRemotePOPForm.FormResize(Sender: TObject);
begin
  Bevel1.Width:=Width;
end;

procedure TRemotePOPForm.msRemotePOP1UserMessageSave(Sender: TObject;
  Num: Integer; Contents: TMemoryStream);
//Duplicates default behavior - the same will happen if this event
//is not attached.  But you can handle the incoming messages your way.
var
  FileName : string;
begin
  FileName:=Concat(msRemotePOP1.MessageDirectory,'msg_',IntToStr(Num),'.eml');
  Contents.SaveToFile(FileName);
end;

procedure TRemotePOPForm.agRas1Disconnected(Sender: TObject);
begin
  StatusBar1.SimpleText:='Disconnected';
end;

procedure TRemotePOPForm.agRas1StatusChange(Sender: TObject;
  RASStatusStr: string);
begin
  StatusBar1.SimpleText:=RASStatusStr;
end;

procedure TRemotePOPForm.msRemotePOP1Error(Sender: TObject;
  var Msg: string);
begin
  StatusBar1.SimpleText:=Msg;
end;

end.
