unit Ftpmain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, Buttons, Menus, IniFiles, agsocket, agftp,
  agTypes, StdCtrls, msUtils, ComCtrls, agFtpCls;

type
  TFTPForm = class(TForm)
    ToolBar: TPanel;
    ConnectButton: TSpeedButton;
    DisconnectButton: TSpeedButton;
    ChDirButton: TSpeedButton;
    UpdButton: TSpeedButton;
    RetrieveFileButton: TSpeedButton;
    StoreFileButton: TSpeedButton;
    MkDirButton: TSpeedButton;
    DeleteButton: TSpeedButton;
    CancelButton: TSpeedButton;
    ExitButton: TSpeedButton;
    agFTP1: TagFTP;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Connect1: TMenuItem;
    Disconnect1: TMenuItem;
    Retrieve1: TMenuItem;
    Store1: TMenuItem;
    Cancel1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    Directory1: TMenuItem;
    Change1: TMenuItem;
    ChangeUp1: TMenuItem;
    Create1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    RenameButton: TSpeedButton;
    Rename1: TMenuItem;
    Delete1: TMenuItem;
    StatusBar: TStatusBar;
    LogMemo: TMemo;
    LogOnOffButton: TSpeedButton;
    FTPListView: TListView;
    ImageList1: TImageList;
    procedure FormCreate(Sender: TObject);
    procedure ConnectButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure About1Click(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure RetrieveFileButtonClick(Sender: TObject);
    procedure StoreFileButtonClick(Sender: TObject);
    procedure UpdButtonClick(Sender: TObject);
    procedure MkDirButtonClick(Sender: TObject);
    procedure ChDirButtonClick(Sender: TObject);
    procedure DisconnectButtonClick(Sender: TObject);
    procedure RenameButtonClick(Sender: TObject);
    procedure CancelButtonClick(Sender: TObject);
    procedure DeleteButtonClick(Sender: TObject);
    procedure agFTP1Cancel(Sender: TObject);
    procedure agFTP1Closed(Sender: TObject);
    procedure agFTP1Open(Sender: TObject);
    procedure FTPListViewDblClick(Sender: TObject);
    procedure agFTP1TransferEnd(Sender: TObject);
    procedure agFTP1TransferStart(Sender: TObject);
    procedure agFTP1Error(Sender: TObject; var Msg: String);
    procedure agFTP1LineTransmitted(Sender: TObject; const TheLine: String);
    procedure LogOnOffButtonClick(Sender: TObject);
    procedure agFTP1TransferProgress(Sender: TObject; Perc,
      Transferred: Integer);
  private
    { Private declarations }
    IniName : string;
    FTPEntry : TagFTPDirEntry;
    TheFileSize : LongInt;
    procedure EnableControls;
    procedure DisableControls;
    procedure TransferOn;
    procedure TransferOff;
    function GetFileSize(const FileName : string) : LongInt;
    procedure FillFTPListView;
    procedure UpdateFTPListView;
  public
    { Public declarations }
  end;

var
  FTPForm: TFTPForm;

implementation

uses FtpConn, msAbout, ftptrans;

{$R *.DFM}

procedure TFTPForm.EnableControls;
var
  i : Integer;
  Btn : TSpeedButton;
begin
  with ToolBar do
  begin
    for i:=0 to ControlCount-1 do
    if Controls[i] is TSpeedButton then
    begin
      Btn:=(Controls[i] as TSpeedButton);
      if Btn.Tag=1 then Btn.Enabled:=true
      else
      if Btn.Tag>=2 then Btn.Enabled:=false;
    end;
  end;
  Directory1.Enabled:=false;
  for i:=0 to File1.Count-1 do
  begin
    if File1[i].Tag=1 then File1[i].Enabled:=true
    else
    if File1[i].Tag=2 then File1[i].Enabled:=false;
  end;
end;

procedure TFTPForm.DisableControls;
var
  i : Integer;
  Btn : TSpeedButton;
begin
  with ToolBar do
  begin
    for i:=0 to ControlCount-1 do
    if Controls[i] is TSpeedButton then
    begin
      Btn:=(Controls[i] as TSpeedButton);
      if Btn.Tag=1 then Btn.Enabled:=false
      else
      if Btn.Tag>=2 then Btn.Enabled:=true
      else
         Btn.Enabled:=true;
    end;
  end;
  Directory1.Enabled:=true;
  for i:=0 to File1.Count-1 do
  begin
    if File1[i].Tag=1 then File1[i].Enabled:=false
    else
    if File1[i].Tag>=2 then File1[i].Enabled:=true;
  end;
end;

procedure TFTPForm.TransferOn;
var
  i : Integer;
  Btn : TSpeedButton;
begin
  FTPListView.Enabled:=false;
  with ToolBar do
  begin
    for i:=0 to ControlCount-1 do
    if Controls[i] is TSpeedButton then
    begin
      Btn:=(Controls[i] as TSpeedButton);
      Btn.Enabled:=Btn.Tag=3; {Only cancel stays enabled}
    end;
  end;
  Directory1.Enabled:=false;
  for i:=0 to File1.Count-1 do
    File1[i].Enabled:=File1[i].Tag=3
end;

procedure TFTPForm.TransferOff;
begin
  FTPListView.Enabled:=true;
  DisableControls;
end;

procedure TFTPForm.FormCreate(Sender: TObject);
begin
  EnableControls;
  IniName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    agFTP1.Server:=ReadString('Setup','Server','ftp.borland.com');
    agFTP1.UserName:=ReadString('Setup','User Name','anonymous');
    agFTP1.Password:=ReadString('Setup','Password','guest@');
    agFTP1.TransferType:=TTransferType(ReadInteger('Setup','Transfer Type',0));
    agFTP1.LogFileName:=ReadString('Setup','Log File','');
    LogOnOffButton.Down:=ReadBool('Setup','Log Memo',true);
    agFTP1.UseProxy:=ReadBool('Setup','Use Proxy',false);
    agFTP1.Proxy:=ReadString('Setup','Proxy Server','');
    agFTP1.ProxyType:=TFTPProxyType(ReadInteger('Setup','Proxy Type',0));
    LogMemo.Visible:=LogOnOffButton.Down;
  finally
    free;
  end;
end;

procedure TFTPForm.ConnectButtonClick(Sender: TObject);
var
  Proceed : boolean;
  i : Integer;
begin
  Proceed:=false;
  with TFTPConnectDlg.Create(Self) do
  try
    ServerEdit.Text:=agFTP1.Server;
    UserNameEdit.Text:=agFTP1.UserName;
    PasswordEdit.Text:=agFTP1.Password;
    TransferTypeComboBox.ItemIndex:=Ord(agFTP1.TransferType);
    LogFileNameEdit.Text:=agFTP1.LogFileName;
    ProxyCheckBox.Checked:=agFTP1.UseProxy;
    i:=Pos(':',agFTP1.Proxy);
    if i>0 then
    begin
      ProxyServerEdit.Text:=Copy(agFTP1.Proxy,1,i-1);
      ProxyPortEdit.Text:=Copy(agFTP1.Proxy,i+1,Length(agFTP1.Proxy));
    end
    else
    begin
      ProxyServerEdit.Text:=agFTP1.Proxy;
      ProxyPortEdit.Text:='21';
    end;
    ServerTypeRadioGroup.ItemIndex:=Ord(agFTP1.ProxyType);
    if not ProxyCheckBox.Checked then
    begin
      ProxyServerEdit.Enabled:=false;
      ProxyPortEdit.Enabled:=false;
      ServerTypeRadioGroup.Enabled:=false;
    end;
    if ShowModal=mrOK then
    begin
      Proceed:=true;
      agFTP1.Server:=ServerEdit.Text;
      agFTP1.UserName:=UserNameEdit.Text;
      agFTP1.Password:=PasswordEdit.Text;
      agFTP1.TransferType:=TTransferType(TransferTypeComboBox.ItemIndex);
      agFTP1.LogFileName:=LogFileNameEdit.Text;
      agFTP1.UseProxy:=ProxyCheckBox.Checked;
      agFTP1.Proxy:=ProxyServerEdit.Text+':'+Trim(ProxyPortEdit.Text);
      agFTP1.ProxyType:=TFTPProxyType(ServerTypeRadioGroup.ItemIndex);
    end;
  finally
    Free;
  end;
  if Proceed then
  begin
    agFTP1.OpenConnection;
    UpdateFTPListView;
  end;
end;

procedure TFTPForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  if agFTP1.OnLine then
    agFTP1.CloseConnection;
  with TIniFile.Create(IniName) do
  try
    WriteString('Setup','Server',agFTP1.Server);
    WriteString('Setup','User Name',agFTP1.UserName);
    WriteString('Setup','Password',agFTP1.Password);
    WriteInteger('Setup','Transfer Type',Ord(agFTP1.TransferType));
    WriteString('Setup','Log File',agFTP1.LogFileName);
    WriteBool('Setup','Log Memo',LogOnOffButton.Down);
    WriteBool('Setup','Use Proxy',agFTP1.UseProxy);
    WriteString('Setup','Proxy Server',agFTP1.Proxy);
    WriteInteger('Setup','Proxy Type',Ord(agFTP1.ProxyType));
  finally
    free;
  end;
end;

procedure TFTPForm.About1Click(Sender: TObject);
begin
  with TAboutDlg.Create(Self) do
  try
    ProgramName.Caption:='agFTP Component Demo';
    ProductVersion.Caption:=msVersion;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TFTPForm.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TFTPForm.FillFTPListView;
var
  Item : TListItem;
  i : Integer;
begin
  for i:=0 to agFTP1.Directory.Count-1 do
  begin
    FTPEntry:=agFTP1.Directory[i];
    Item:=FTPListView.Items.Add;
    Item.Caption:=FTPEntry.FileName;
    Item.SubItems.Add(IntToStr(FTPEntry.Size));
    Item.SubItems.Add(DateTimeToStr(FTPEntry.Date));
    Item.StateIndex:=Ord(FTPEntry.Kind)-1;
  end;
end;

procedure TFTPForm.UpdateFTPListView;
begin
  FTPListView.Items.Clear;
  TransferOn;
  try
    agFTP1.GetDirectory;
  finally
    TransferOff;
  end;
  FillFTPListView;
end;

procedure TFTPForm.RetrieveFileButtonClick(Sender: TObject);
begin
  if FTPListView.Selected<>nil then
  begin
    FTPEntry:=agFTP1.Directory[FTPListView.Selected.Index];
    if (FTPEntry.FileName<>'') and (FTPEntry.Kind=fkFile) then
    begin
      SaveDialog1.FileName:=FTPEntry.FileName;
      if SaveDialog1.Execute then
      begin
        TransferOn;
        try
          TheFileSize:=FTPEntry.Size;
          agFTP1.RetrieveFile(FTPEntry.FileName,SaveDialog1.FileName);
        finally
          TransferOff;
        end;
      end;
    end;
  end;
end;

function TFTPForm.GetFileSize(const FileName : string) : LongInt;
var
  f : file;
begin
  AssignFile(f,FileName);
  Reset(f,1);
  try
    Result:=FileSize(f);
  finally
    CloseFile(f);
  end;
end;

procedure TFTPForm.StoreFileButtonClick(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    TransferOn;
    try
      TheFileSize:=GetFileSize(OpenDialog1.FileName);
      agFTP1.StoreFile(OpenDialog1.FileName,ExtractFileName(OpenDialog1.FileName));
    finally
      TransferOff;
    end;
    UpdateFTPListView;
  end;
end;

procedure TFTPForm.UpdButtonClick(Sender: TObject);
begin
  agFTP1.ChangeToUpperDirectory;
  UpdateFTPListView;
end;

procedure TFTPForm.MkDirButtonClick(Sender: TObject);
var
  DirName : string;
begin
  DirName:='';
  if InputQuery('Create Directory','Type a Name of Directory:',DirName) then
  begin
    agFTP1.MakeDirectory(DirName);
    UpdateFTPListView;
  end;
end;

procedure TFTPForm.ChDirButtonClick(Sender: TObject);
var
  DirName : string;
begin
  DirName:='';
  if InputQuery('Change Directory','Type a Name of Directory:',DirName) then
  begin
    agFTP1.ChangeDirectory(DirName);
    UpdateFTPListView;
  end;
end;

procedure TFTPForm.DisconnectButtonClick(Sender: TObject);
begin
  agFTP1.CloseConnection;
  EnableControls;
  FTPListView.Items.Clear;
end;

procedure TFTPForm.RenameButtonClick(Sender: TObject);
var
  OldName, NewName : string;
begin
  if FTPListView.Selected<>nil then
  begin
    FTPEntry:=agFTP1.Directory[FTPListView.Selected.Index];
    if FTPEntry.Kind=fkLink then Exit;
    OldName:=FTPEntry.FileName;
    NewName:='';
    if OldName<>'' then
    begin
      if FTPEntry.Kind=fkDirectory then
      begin
        if InputQuery('Rename','Rename directory '+OldName+' to:',NewName) then
          agFTP1.RenameFile(OldName,NewName);
      end
      else
      begin
        if InputQuery('Rename File','Rename file '+OldName+' to:',NewName) then
          agFTP1.RenameFile(OldName,NewName);
      end;
      UpdateFTPListView;
    end;
  end;
end;

procedure TFTPForm.CancelButtonClick(Sender: TObject);
begin
  if agFTP1.RetrievingList then
    agFTP1.AbortTransfer
  else
    agFTP1.Cancel;
end;

procedure TFTPForm.DeleteButtonClick(Sender: TObject);
begin
  if FTPListView.Selected<>nil then
  begin
    FTPEntry:=agFTP1.Directory[FTPListView.Selected.Index];
    if FTPEntry.Kind=fkLink then Exit;
    if FTPEntry.FileName<>'' then
    begin
      if FTPEntry.Kind=fkDirectory then
        agFTP1.DeleteDirectory(FTPEntry.FileName)
      else
        agFTP1.Delete_File(FTPEntry.FileName);
      UpdateFTPListView;
    end;
  end;
end;

procedure TFTPForm.agFTP1Cancel(Sender: TObject);
begin
  StatusBar.SimpleText:='Operation has been canceled';
end;

procedure TFTPForm.agFTP1Closed(Sender: TObject);
begin
  StatusBar.SimpleText:='Connection closed';
end;

procedure TFTPForm.agFTP1Open(Sender: TObject);
begin
  StatusBar.SimpleText:='Opening connection';
end;

procedure TFTPForm.FTPListViewDblClick(Sender: TObject);
begin
  if FTPListView.Selected<>nil then
  begin
    FTPEntry:=agFTP1.Directory[FTPListView.Selected.Index];
    if FTPEntry.FileName='' then exit;
    if FTPEntry.Kind=fkDirectory then
    begin
      agFTP1.ChangeDirectory(FTPEntry.FileName);
      UpdateFTPListView;
    end
    else
    if FTPEntry.Kind=fkLink then
    begin
      try
        agFTP1.ChangeDirectory(FTPEntry.LinkPtr);
        UpdateFTPListView;
      except
        on ESocketError do
        begin
          SaveDialog1.FileName:='';
          if SaveDialog1.Execute then
          begin
            TransferOn;
            try
              agFTP1.RetrieveFile(FTPEntry.LinkPtr,SaveDialog1.FileName);
            finally
              TransferOff;
            end;
          end;
        end
        else
          raise;
      end;
    end
    else
      RetrieveFileButtonClick(Sender);
  end;
end;

procedure TFTPForm.agFTP1TransferEnd(Sender: TObject);
begin
  if TransferForm.Showing then
    TransferForm.Hide;
  if agFTP1.TransferringFile then
    MessageBeep(MB_ICONASTERISK);
  StatusBar.SimpleText:='';
end;

procedure TFTPForm.agFTP1TransferStart(Sender: TObject);
begin
  if agFTP1.TransferringFile then
  begin
    StatusBar.SimpleText:='Starting file transfer';
    TransferForm.ShowProgress(0,0);
    TransferForm.Show;
  end
  else
  if agFTP1.RetrievingList then
    StatusBar.SimpleText:='Retrieving directory';
end;

procedure TFTPForm.agFTP1Error(Sender: TObject; var Msg: String);
begin
  StatusBar.SimpleText:=Msg;
end;

procedure TFTPForm.agFTP1LineTransmitted(Sender: TObject;
  const TheLine: string);
begin
  LogMemo.Lines.Add(TheLine);
end;

procedure TFTPForm.LogOnOffButtonClick(Sender: TObject);
begin
  LogMemo.Visible:=LogOnOffButton.Down;
end;

procedure TFTPForm.agFTP1TransferProgress(Sender: TObject; Perc,
  Transferred: Integer);
begin
  if TransferForm.Showing then
    TransferForm.ShowProgress(Transferred, TheFileSize);
end;

end.
