unit popview;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, ExtCtrls, StdCtrls, ComCtrls, msmsg, ShellApi;

type
  TMsgViewDlg = class(TForm)
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    FromLabel: TLabel;
    DateLabel: TLabel;
    SubjectLabel: TLabel;
    Panel2: TPanel;
    ListView1: TListView;
    BodyMemo: TMemo;
    ImageList1: TImageList;
    Panel3: TPanel;
    CloseButton: TButton;
    PopupMenu1: TPopupMenu;
    Execute1: TMenuItem;
    Save1: TMenuItem;
    SaveDialog1: TSaveDialog;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure ListView1DblClick(Sender: TObject);
    procedure CloseButtonClick(Sender: TObject);
    procedure Save1Click(Sender: TObject);
    procedure PopupMenu1Popup(Sender: TObject);
  private
    { Private declarations }
    TempPath : string;
    FMessage : TmsCustomMessage;
    procedure AddFileToListView(const FileName : string);
    procedure SetMessage(Value : TmsCustomMessage);
  public
    { Public declarations }
    property MailMessage : TmsCustomMessage write SetMessage;
  end;

var
  MsgViewDlg: TMsgViewDlg;

implementation

{$R *.DFM}

uses msUtils;

procedure TMsgViewDlg.AddFileToListView(const FileName : string);
var
  Item : TListItem;
  Icon : TIcon;
  j : word;
begin
  Item:=ListView1.Items.Add;
  Item.Caption:=ExtractFileName(FileName);
  Icon:=TIcon.Create;
  j:=0;
  Icon.Handle:=ExtractAssociatedIcon(hInstance,PChar(FileName),j);
  if Icon.Handle<>0 then
    Item.ImageIndex:=ImageList1.AddIcon(Icon);
end;

procedure TMsgViewDlg.SetMessage(Value : TmsCustomMessage);
var
  i : Integer;
  Path : string;
  s1, s2 : string;
  DT : TDateTime;
begin
  FMessage:=Value;
  BodyMemo.Lines:=FMessage.Body;
  s1:=FMessage.Headers.GetFieldBody('From');
  SplitAddress(s1,s1,s2);
  if s2<>'' then
    FromLabel.Caption:=s2
  else
    FromLabel.Caption:=s1;
  s1:=FMessage.Headers.GetFieldBody('Date');
  MailDateToDateTime(s1,DT,s2);
  if DT<>0 then
    DateLabel.Caption:=DateTimeToStr(DT)+' '+s2
  else
    DateLabel.Caption:='Unknown';
  SubjectLabel.Caption:=FMessage.Headers.GetFieldBody('Subject');;
  for i:=0 to FMessage.Attachments.Count-1 do
  begin
    FMessage.SaveAttachment(i,TempPath);
    Path:=TempPath+FMessage.Attachments[i].FileName;
    AddFileToListView(Path);
  end;
end;

procedure TMsgViewDlg.FormCreate(Sender: TObject);
var
  Buf : PChar;
begin
  Buf:=StrAlloc(255);
  GetTempPath(255,Buf);
  TempPath:=StrPas(Buf);
  StrDispose(Buf);
end;

procedure TMsgViewDlg.FormClose(Sender: TObject; var Action: TCloseAction);
var
  i : Integer;
  F : file;
begin
  if Assigned(FMessage) then
  begin
    for i:=0 to FMessage.Attachments.Count-1 do
    begin
      AssignFile(F,TempPath+FMessage.Attachments[i].FileName);
      System.Erase(F);
    end;
  end;
end;

procedure TMsgViewDlg.ListView1DblClick(Sender: TObject);
var
  s : string;
  TheHandle : THandle;
  i : Integer;
begin
  if ListView1.Selected<>nil then
  begin
    i:=ListView1.Selected.Index;
    s:=TempPath+ListView1.Items[i].Caption;
    TheHandle:=ShellExecute(Application.Handle,'Open',PChar(s),nil,nil,SW_SHOW);
    if TheHandle<=HINSTANCE_ERROR then
      raise Exception.Create('Unable to run ShellExec. Error code='+IntToStr(TheHandle));
  end;
end;

procedure TMsgViewDlg.CloseButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TMsgViewDlg.Save1Click(Sender: TObject);
begin
  if ListView1.Selected<>nil then
  begin
    SaveDialog1.FileName:=ListView1.Items[ListView1.Selected.Index].Caption;
    if SaveDialog1.Execute then
      FMessage.Attachments[ListView1.Selected.Index].Contents.SaveToFile(SaveDialog1.FileName);
  end;
end;

procedure TMsgViewDlg.PopupMenu1Popup(Sender: TObject);
begin
  if ListView1.Selected=nil then
  begin
    Execute1.Enabled:=false;
    Save1.Enabled:=false;
  end
  else
  begin
    Execute1.Enabled:=true;
    Save1.Enabled:=true;
  end;
end;

end.
