unit popmain;

interface

uses
  WinProcs, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ExtCtrls, msmsg, msmb, mspop3, popsu, agTypes,
  IniFiles, Menus, agsocket, StdCtrls, Gauges;

type
  TTPOPDemoForm = class(TForm)
    Panel1: TPanel;
    StatusBar1: TPanel;
    RetrieveButton: TSpeedButton;
    CancelButton: TSpeedButton;
    SetupButton: TSpeedButton;
    ExitButton: TSpeedButton;
    msPOP1: TmsPOP;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Retrieve1: TMenuItem;
    Cancel1: TMenuItem;
    Exit1: TMenuItem;
    Setup1: TMenuItem;
    Help1: TMenuItem;
    About1: TMenuItem;
    Bevel1: TBevel;
    ListBox1: TListBox;
    ProgressBar1: TGauge;
    procedure RetrieveButtonClick(Sender: TObject);
    procedure msPOP1Cancel(Sender: TObject);
    procedure msPOP1Open(Sender: TObject);
    procedure msPOP1Retrieved(Sender: TObject; Current: Integer);
    procedure msPOP1Retrieving(Sender: TObject; Current: Integer);
    procedure CancelButtonClick(Sender: TObject);
    procedure ExitButtonClick(Sender: TObject);
    procedure SetupButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure msPOP1Closed(Sender: TObject);
    procedure msPOP1Closing(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure msPOP1Error(Sender: TObject; var Msg: OpenString);
    procedure ListBox1DblClick(Sender: TObject);
    procedure msPOP1Progress(Sender: TObject; Perc: Integer;
      Transferred: Longint);
  private
    { Private declarations }
    IniName : string;
    procedure EnableControls;
    procedure DisableControls;
  public
    { Public declarations }
  end;

var
  TPOPDemoForm: TTPOPDemoForm;

implementation

uses popview, msabout;

{$R *.DFM}

procedure TTPOPDemoForm.EnableControls;
begin
  RetrieveButton.Enabled:=true;
  CancelButton.Enabled:=false;
  SetupButton.Enabled:=true;
  ExitButton.Enabled:=true;
  Retrieve1.Enabled:=true;
  Cancel1.Enabled:=false;
  Exit1.Enabled:=true;
  Setup1.Enabled:=true;
  Help1.Enabled:=true;
end;

procedure TTPOPDemoForm.DisableControls;
begin
  RetrieveButton.Enabled:=false;
  CancelButton.Enabled:=true;
  SetupButton.Enabled:=false;
  ExitButton.Enabled:=false;
  Retrieve1.Enabled:=false;
  Cancel1.Enabled:=true;
  Exit1.Enabled:=false;
  Setup1.Enabled:=false;
  Help1.Enabled:=false;
end;

procedure TTPOPDemoForm.RetrieveButtonClick(Sender: TObject);
begin
  msPOP1.MessageList.Clear;
  ListBox1.Items.Clear;
  ListBox1.Cursor:=crHourGlass;
  DisableControls;
  try
    msPOP1.RetrieveAllMessages(true); {true - LeaveOnServer}
  finally
    EnableControls;
    ListBox1.Cursor:=crDefault;
  end;
end;

procedure TTPOPDemoForm.msPOP1Cancel(Sender: TObject);
begin
  StatusBar1.Caption:='Canceled';
end;

procedure TTPOPDemoForm.msPOP1Open(Sender: TObject);
begin
  StatusBar1.Caption:='Opening connection';
end;

procedure TTPOPDemoForm.msPOP1Retrieved(Sender: TObject; Current: Integer);
var
  i : Integer;
  s : string;
begin
  i:=msPOP1.MessageList.Count-1;
  s:=msPOP1.MessageList[i].Subject;
  if s='' then s:='No Subject';
  ListBox1.Items.Add(s);
end;

procedure TTPOPDemoForm.msPOP1Retrieving(Sender: TObject; Current: Integer);
begin
  StatusBar1.Caption:='Retrieving message '+IntToStr(Current+1)+
                             ' of '+IntToStr(msPOP1.TotalMessages);
end;

procedure TTPOPDemoForm.CancelButtonClick(Sender: TObject);
begin
  msPOP1.Cancel;
end;

procedure TTPOPDemoForm.ExitButtonClick(Sender: TObject);
begin
  Close;
end;

procedure TTPOPDemoForm.SetupButtonClick(Sender: TObject);
begin
  with TSetupDlg.Create(Self) do
  try
    ServerEdit.Text:=msPOP1.Server;
    UserNameEdit.Text:=msPOP1.UserName;
    PasswordEdit.Text:=msPOP1.Password;
    LogFileNameEdit.Text:=msPOP1.LogFileName;
    if ShowModal=mrOk then
    begin
      msPOP1.Server:=ServerEdit.Text;
      msPOP1.UserName:=UserNameEdit.Text;
      msPOP1.Password:=PasswordEdit.Text;
      msPOP1.LogFileName:=LogFileNameEdit.Text;
    end;
  finally
    free;
  end;
end;

procedure TTPOPDemoForm.FormCreate(Sender: TObject);
begin
  IniName:=ChangeFileExt(Application.ExeName,'.ini');
  with TIniFile.Create(IniName) do
  try
    msPOP1.Server:=ReadString('Setup','Server','');
    msPOP1.UserName:=ReadString('Setup','User Name','');
    msPOP1.Password:=ReadString('Setup','Password','');
    msPOP1.LogFileName:=ReadString('Setup','Log File','');
  finally
    free;
  end;
end;

procedure TTPOPDemoForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  with TIniFile.Create(IniName) do
  try
    WriteString('Setup','Server',msPOP1.Server);
    WriteString('Setup','User Name',msPOP1.UserName);
    WriteString('Setup','Password',msPOP1.Password);
    WriteString('Setup','Log File',msPOP1.LogFileName);
  finally
    free;
  end;
end;

procedure TTPOPDemoForm.msPOP1Closed(Sender: TObject);
begin
  StatusBar1.Caption:='Connection closed';
end;

procedure TTPOPDemoForm.msPOP1Closing(Sender: TObject);
begin
  StatusBar1.Caption:='Closing connection';
end;

procedure TTPOPDemoForm.About1Click(Sender: TObject);
begin
  with TAboutDlg.Create(Self) do
  try
    ProgramName.Caption:='msPOP Component Demo';
    ProductVersion.Caption:=msVersion;
    ShowModal;
  finally
    Free;
  end;
end;

procedure TTPOPDemoForm.FormResize(Sender: TObject);
begin
  Bevel1.Width:=Width;
end;

procedure TTPOPDemoForm.msPOP1Error(Sender: TObject; var Msg: OpenString);
begin
  StatusBar1.Caption:=Msg;
end;

procedure TTPOPDemoForm.ListBox1DblClick(Sender: TObject);
begin
  if ListBox1.ItemIndex>=0 then
  begin
    MsgViewDlg:=TMsgViewDlg.Create(Self);
    MsgViewDlg.MailMessage:=msPOP1.MessageList[ListBox1.ItemIndex];
    MsgViewDlg.ShowModal;
    MsgViewDlg.Free;
  end;
end;

procedure TTPOPDemoForm.msPOP1Progress(Sender: TObject; Perc: Integer;
  Transferred: Longint);
begin
  ProgressBar1.Progress:=Perc;
end;

end.
