//---------------------------------------------------------------------------
#pragma warn -dup
#pragma warn -sig
#include <vcl\vcl.h>
#include <vcl\inifiles.hpp>
#include <stdlib.h>
#pragma hdrstop

#include "smtpmain.h"
#include "smtpsu.h"
#include "msabout.h"
//---------------------------------------------------------------------------
#pragma link "msmsg"
#pragma link "mssmtp"
#pragma link "msmb"
#pragma link "agsocket"
#pragma resource "*.dfm"
TSMTPForm *SMTPForm;
//---------------------------------------------------------------------------
__fastcall TSMTPForm::TSMTPForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::EnableControls(void)
{
  int i;
  TSpeedButton *SB;
  for (i=0; i==ToolBar->ControlCount;)
  {
    SB=(TSpeedButton *)ToolBar->Controls[i];
    SB->Enabled=SB->Tag != 1;
  }
  ListView1->Enabled=true;
  Send1->Enabled=true;
  Cancel1->Enabled=false;
  Attach1->Enabled=true;
  Exit1->Enabled=true;
  Setup1->Enabled=true;
  Help1->Enabled=true;
  SendInfoPanel->Enabled=true;
  ProgressBar1->Visible=false;
  BodyMemo->Enabled=true;
  Cursor=crDefault;
  ListView1->Cursor=crDefault;
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::DisableControls(void)
{
  int i;
  TSpeedButton *SB;
  for (i=0; i==ToolBar->ControlCount;)
  {
    SB=(TSpeedButton *)ToolBar->Controls[i];
    SB->Enabled=SB->Tag == 1;
  }
  ListView1->Enabled=false;
  Send1->Enabled=false;
  Cancel1->Enabled=true;
  Attach1->Enabled=false;
  Exit1->Enabled=false;
  Setup1->Enabled=false;
  Help1->Enabled=false;
  SendInfoPanel->Enabled=false;
  ProgressBar1->Visible=true;
  BodyMemo->Enabled=false;
  Cursor=crHourGlass;
  ListView1->Cursor=crHourGlass;
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::AddFileToListView(const AnsiString FileName)
{
  TListItem *Item;
  TIcon *Icon;
  unsigned short j=0;
  Item=ListView1->Items->Add();
  Item->Caption=FileName;
  Icon=new TIcon();
  Icon->Handle=ExtractAssociatedIcon(HInstance,FileName.c_str(),&j);
  if (Icon->Handle)
  {
    Item->ImageIndex=ImageList1->AddIcon(Icon);
  }
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::WMDropFiles(TMessage& Message)
{
  char* FileName=(char *)malloc(255);
  HDROP Drop=(HANDLE)Message.WParam;
  DragQueryFile(Drop,0,FileName,255);
  AddFileToListView(FileName);
  DragFinish(Drop);
  free(FileName);
  Message.Result=0;
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::SendButtonClick(TObject *Sender)
{
  msMessage1->Recipients->Clear();
  msMessage1->Recipients->AddAddress(ToEdit->Text,"");
  msMessage1->Subject=SubjectEdit->Text;
  msMessage1->Body=BodyMemo->Lines;
  msMessage1->Attachments->Clear();
  for (int i=0; i<ListView1->Items->Count; i++)
    msMessage1->Attachments->AddFile(ListView1->Items->Item[i]->Caption);
  DisableControls();
  try
  {
   msSMTP1->Send();
   EnableControls();
  }
  catch(...)
  {
   EnableControls();
  }
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::AttachButtonClick(TObject *Sender)
{
  TOpenDialog* OpenDialog=new TOpenDialog(this);
  try
  {
   OpenDialog->Filter="All Files (*.*)|*.*";
   if (OpenDialog->Execute())
     AddFileToListView(OpenDialog->FileName);
   delete OpenDialog;
  }
  catch(...)
  {
   delete OpenDialog;
   throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::ExitButtonClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::About1Click(TObject *Sender)
{
  TAboutDlg *AboutDlg=new TAboutDlg(this);
  try
  {
   AboutDlg->ProgramName->Caption="TmsSMTP Component Demo for C++ Builder";
   AboutDlg->ProductVersion->Caption=msVersion;
   AboutDlg->ShowModal();
   delete AboutDlg;
  }
  catch(...)
  {
   delete AboutDlg;
   throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::Setup1Click(TObject *Sender)
{
  SetupDlg=new TSetupDlg(this);
  try
  {
   SetupDlg->ServerEdit->Text=msSMTP1->Server;
   SetupDlg->UserAddressEdit->Text=msMessage1->Sender->Address;
   SetupDlg->UserNameEdit->Text=msMessage1->Sender->Name;
   SetupDlg->LogFileNameEdit->Text=msSMTP1->LogFileName;
   SetupDlg->CharSetComboBox->ItemIndex=(int)msMessage1->CharSet;
   SetupDlg->EncodingComboBox->ItemIndex=(int)msMessage1->Encoding;
   SetupDlg->ShowModal();
   if (SetupDlg->ModalResult==mrOk)
   {
     msSMTP1->Server=SetupDlg->ServerEdit->Text;
     msMessage1->Sender->Address=SetupDlg->UserAddressEdit->Text;
     msMessage1->Sender->Name=SetupDlg->UserNameEdit->Text;
     msSMTP1->LogFileName=SetupDlg->LogFileNameEdit->Text;
     msMessage1->CharSet=(TCharSet)SetupDlg->CharSetComboBox->ItemIndex;
     msMessage1->Encoding=(TMsgEncoding)SetupDlg->EncodingComboBox->ItemIndex;
   }
   delete SetupDlg;
  }
  catch(...)
  {
   delete SetupDlg;
   throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::FormCreate(TObject *Sender)
{
  IniFileName=ChangeFileExt(Application->ExeName,".INI");
  TIniFile *IniFile=new TIniFile(IniFileName);
  msSMTP1->Server=IniFile->ReadString("Setup","Server","");
  msMessage1->Sender->Address=IniFile->ReadString("Setup","EMail Address","");
  msMessage1->Sender->Name=IniFile->ReadString("Setup","Name","");
  msSMTP1->LogFileName=IniFile->ReadString("Setup","Log File","");
  msMessage1->CharSet=(TCharSet)IniFile->ReadInteger("Setup","CharSet",0);
  msMessage1->Encoding=(TMsgEncoding)IniFile->ReadInteger("Setup","Encoding",0);
  delete IniFile;
  DragAcceptFiles(Handle,true);
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  TIniFile *IniFile=new TIniFile(IniFileName);
  IniFile->WriteString("Setup","Server",msSMTP1->Server);
  IniFile->WriteString("Setup","EMail Address",msMessage1->Sender->Address);
  IniFile->WriteString("Setup","Name",msMessage1->Sender->Name);
  IniFile->WriteString("Setup","Log File",msSMTP1->LogFileName);
  IniFile->WriteInteger("Setup","CharSet",(int)msMessage1->CharSet);
  IniFile->WriteInteger("Setup","Encoding",(int)msMessage1->Encoding);
  delete IniFile;
  DragAcceptFiles(Handle,false);
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::msSMTP1Cancel(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Operation has been canceled";
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::msSMTP1Closed(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Connection closed";
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::msSMTP1Closing(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Closing connection";
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::msSMTP1Error(TObject *Sender, AnsiString &Msg)
{
  StatusBar1->Panels->Items[0]->Text=Msg;
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::msSMTP1MailSent(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Mail sent";
  ProgressBar1->Position=0;
  MessageBeep(MB_ICONASTERISK);
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::msSMTP1Open(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Opening connection";
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::msSMTP1Prepare(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Preparing message";
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::msSMTP1Sending(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Sending message";
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::CancelButtonClick(TObject *Sender)
{
  msSMTP1->Cancel();	
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::FormResize(TObject *Sender)
{
  Bevel1->Width=Width;	
}
//---------------------------------------------------------------------------
void __fastcall TSMTPForm::msSMTP1Progress(TObject *Sender, int Perc,
      int Transferred)
{
  ProgressBar1->Position=Perc;
}
//---------------------------------------------------------------------------

