//---------------------------------------------------------------------------
#pragma warn -dup
#include <vcl\vcl.h>
#pragma hdrstop

#include "httpmain.h"
//---------------------------------------------------------------------------
#pragma link "aghttp"
#pragma link "agsocket"
#pragma resource "*.dfm"
THTTPForm *HTTPForm;
//---------------------------------------------------------------------------
__fastcall THTTPForm::THTTPForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::EnableControls(void)
{
  URLEdit->Enabled=true;
  GetButton->Enabled=true;
  CancelButton->Enabled=false;
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::DisableControls(void)
{
  URLEdit->Enabled=false;
  GetButton->Enabled=false;
  CancelButton->Enabled=true;
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::SaveData(void)
{
  SaveDialog1->FileName=agHTTP1->FileName;
  if (SaveDialog1->Execute())
    agHTTP1->InStream->SaveToFile(SaveDialog1->FileName);
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::GetButtonClick(TObject *Sender)
{
  DisableControls();
  try
  {
   agHTTP1->URL=URLEdit->Text;
   agHTTP1->Get();
   Memo1->Lines=agHTTP1->Headers;
   if (MessageDlg("Do you want to save the retrieved data?",
                  mtConfirmation,TMsgDlgButtons() << mbYes << mbNo,0)==mrYes)
     SaveData();
   EnableControls();
  }
  catch(...)
  {
   EnableControls();
   throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::CancelButtonClick(TObject *Sender)
{
  agHTTP1->Cancel();
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::agHTTP1Cancel(TObject *Sender)
{
  StatusBar1->SimpleText="Operation canceled";
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::agHTTP1Closed(TObject *Sender)
{
  StatusBar1->SimpleText="Connection closed";
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::agHTTP1Error(TObject *Sender, AnsiString &Msg)
{
  StatusBar1->SimpleText=Msg;
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::agHTTP1Open(TObject *Sender)
{
  StatusBar1->SimpleText="Opening connection";
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::agHTTP1Sending(TObject *Sender)
{
  StatusBar1->SimpleText="Sending request";
}
//---------------------------------------------------------------------------
void __fastcall THTTPForm::agHTTP1Progress(TObject *Sender, int Perc,
      int Transferred)
{
  StatusBar1->SimpleText=(AnsiString)(int)Transferred+" bytes received";
}
//---------------------------------------------------------------------------

