//---------------------------------------------------------------------------
#pragma warn -dup
#include <vcl\vcl.h>
#pragma hdrstop

#include "popview.h"
#include <shellapi.h>
#include <msutils.hpp>
//---------------------------------------------------------------------------
#pragma link "msmsg"
#pragma resource "*.dfm"
TMsgViewDlg *MsgViewDlg;
//---------------------------------------------------------------------------
__fastcall TMsgViewDlg::TMsgViewDlg(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TMsgViewDlg::AddFileToListView(const AnsiString FileName)
{
  unsigned short j=0;
  TListItem* Item=ListView1->Items->Add();
  Item->Caption=ExtractFileName(FileName);
  TIcon* Icon=new TIcon();
  Icon->Handle=ExtractAssociatedIcon(HInstance,FileName.c_str(),&j);
  if (Icon->Handle)
  {
    Item->ImageIndex=ImageList1->AddIcon(Icon);
  }
}
//---------------------------------------------------------------------------
void __fastcall TMsgViewDlg::SetMessage(TmsCustomMessage* Value)
{
  AnsiString Path;
  AnsiString s1, s2;
  TDateTime DT;
  FMessage=Value;
  BodyMemo->Lines=FMessage->Body;
  s1=FMessage->Headers->GetFieldBody("From");
  SplitAddress(s1,s1,s2);
  if (s2!="")
    FromLabel->Caption=s2;
  else
    FromLabel->Caption=s1;
  s1=FMessage->Headers->GetFieldBody("Date");
  MailDateToDateTime(s1,DT,s2);
  DateLabel->Caption=DT.DateTimeString()+" "+s2;
  SubjectLabel->Caption=FMessage->Headers->GetFieldBody("Subject");
  for (int i=0; i<FMessage->Attachments->Count; i++)
  {
   FMessage->SaveAttachment(i,TempPath);
   Path=TempPath+FMessage->Attachments->Items[i]->FileName;
   AddFileToListView(Path);
  }
}
//---------------------------------------------------------------------------
void __fastcall TMsgViewDlg::FormClose(TObject *Sender, TCloseAction &Action)
{
  AnsiString s;
  for (int i=0; i<FMessage->Attachments->Count; i++)
  {
   s=TempPath+FMessage->Attachments->Items[i]->FileName;
   remove(s.c_str());
  }
}
//---------------------------------------------------------------------------
void __fastcall TMsgViewDlg::ListView1DblClick(TObject *Sender)
{
  if (ListView1->Selected)
  {
    int i=ListView1->Selected->Index;
    AnsiString s=TempPath+ListView1->Items->Item[i]->Caption;
    HANDLE TheHandle=ShellExecute(Application->Handle,"Open",s.c_str(),
         NULL,NULL,SW_SHOW);
    if ((int)TheHandle<=HINSTANCE_ERROR)
      MessageDlg("Unable to run ShellExec. Error code="+(AnsiString)(int)TheHandle,
                 mtError,TMsgDlgButtons() << mbOK,0);
  }
}
//---------------------------------------------------------------------------
void __fastcall TMsgViewDlg::FormCreate(TObject *Sender)
{
  char* Buf=(char *)malloc(255);
  GetTempPath(255,Buf);
  TempPath=Buf;
  free(Buf);
}
//---------------------------------------------------------------------------
void __fastcall TMsgViewDlg::CloseButtonClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------
void __fastcall TMsgViewDlg::Save1Click(TObject *Sender)
{
  if (ListView1->Selected)
  {
    int i=ListView1->Selected->Index;
    SaveDialog1->FileName=FMessage->Attachments->Items[i]->FileName;
    if (SaveDialog1->Execute())
      FMessage->Attachments->Items[i]->Contents->SaveToFile(SaveDialog1->FileName);
  }
}
//---------------------------------------------------------------------------
void __fastcall TMsgViewDlg::PopupMenu1Popup(TObject *Sender)
{
  Execute1->Enabled=(ListView1->Selected != NULL);
  Save1->Enabled=(ListView1->Selected != NULL);
}
//---------------------------------------------------------------------------