//---------------------------------------------------------------------------
#pragma warn -dup
#pragma warn -sig
#include <vcl\vcl.h>
#include <vcl\inifiles.hpp>
#pragma hdrstop

#include "popmain.h"
#include "msabout.h"
#include "popsu.h"
#include "popview.h"
//---------------------------------------------------------------------------
#pragma link "mspop3"
#pragma link "msmb"
#pragma link "agsocket"
#pragma link "agRasCmp"
#pragma resource "*.dfm"
TPOPForm *POPForm;
//---------------------------------------------------------------------------
__fastcall TPOPForm::TPOPForm(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::EnableControls(void)
{
  RetrieveButton->Enabled=true;
  CancelButton->Enabled=false;
  SetupButton->Enabled=true;
  ExitButton->Enabled=true;
  Retrieve1->Enabled=true;
  Cancel1->Enabled=false;
  Exit1->Enabled=true;
  Setup1->Enabled=true;
  Help1->Enabled=true;
  ListView1->Cursor=crDefault;
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::DisableControls(void)
{
  RetrieveButton->Enabled=false;
  CancelButton->Enabled=true;
  SetupButton->Enabled=false;
  ExitButton->Enabled=false;
  Retrieve1->Enabled=false;
  Cancel1->Enabled=true;
  Exit1->Enabled=false;
  Setup1->Enabled=false;
  Help1->Enabled=false;
  ListView1->Cursor=crHourGlass;
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::About1Click(TObject *Sender)
{
  TAboutDlg *AboutDlg=new TAboutDlg(this);
  try
  {
   AboutDlg->ProgramName->Caption="msPOP component Demo";
   AboutDlg->ProductVersion->Caption=msVersion;
   AboutDlg->ShowModal();
   delete AboutDlg;
  }
  catch(...)
  {
   delete AboutDlg;
   throw;
  }
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::SetupButtonClick(TObject *Sender)
{
  TSetupDlg *SetupDlg=new TSetupDlg(this);
  try
  {
   SetupDlg->ServerEdit->Text=msPOP1->Server;
   SetupDlg->UserNameEdit->Text=msPOP1->UserName;
   SetupDlg->PasswordEdit->Text=msPOP1->Password;
   SetupDlg->RasComboBox->Items=agRas1->Entries;
   SetupDlg->RasComboBox->Items->Insert(0,"None");
   SetupDlg->RasComboBox->ItemIndex=RasServiceNo;
   SetupDlg->LogFileNameEdit->Text=msPOP1->LogFileName;
   if (SetupDlg->ShowModal()==mrOk)
   {
     msPOP1->Server=SetupDlg->ServerEdit->Text;
     msPOP1->UserName=SetupDlg->UserNameEdit->Text;
     msPOP1->Password=SetupDlg->PasswordEdit->Text;
     RasServiceNo=SetupDlg->RasComboBox->ItemIndex;
     if (RasServiceNo)
       agRas1->Service=agRas1->Entries->Strings[RasServiceNo-1];
     msPOP1->LogFileName=SetupDlg->LogFileNameEdit->Text;
   }
  }
  catch(...)
  {
   delete SetupDlg;
   throw;
  }
 delete SetupDlg;
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::FormCreate(TObject *Sender)
{
  IniFileName=ChangeFileExt(Application->ExeName,".INI");
  TIniFile *IniFile=new TIniFile(IniFileName);
  msPOP1->Server=IniFile->ReadString("Setup","Server","");
  msPOP1->UserName=IniFile->ReadString("Setup","User Name","");
  msPOP1->Password=IniFile->ReadString("Setup","Password","");
  RasServiceNo=IniFile->ReadInteger("Setup","RAS",0);
  msPOP1->LogFileName=IniFile->ReadString("Setup","Log File","");
  if (RasServiceNo)
    agRas1->Service=agRas1->Entries->Strings[RasServiceNo-1];
  delete IniFile;
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::FormClose(TObject *Sender, TCloseAction &Action)
{
  TIniFile *IniFile=new TIniFile(IniFileName);
  IniFile->WriteString("Setup","Server",msPOP1->Server);
  IniFile->WriteString("Setup","User Name",msPOP1->UserName);
  IniFile->WriteString("Setup","Password",msPOP1->Password);
  IniFile->WriteInteger("Setup","RAS",RasServiceNo);
  IniFile->WriteString("Setup","Log File",msPOP1->LogFileName);
  delete IniFile;
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::RetrieveButtonClick(TObject *Sender)
{
  msPOP1->MessageList->Clear();
  ListView1->Items->Clear();
  DisableControls();
  try
  {
   msPOP1->RetrieveAllMessages(true); //true - LeaveOnServer
  }
  catch(...)
  {
   EnableControls();
   throw;
  }
  EnableControls();
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::agRas1Disconnected(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Disconnected";
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::agRas1StatusChange(TObject *Sender,
	AnsiString RASStatusStr)
{
  StatusBar1->Panels->Items[0]->Text=RASStatusStr;
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::msPOP1Cancel(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Opening connection";
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::msPOP1Closed(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Connection closed";
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::msPOP1Closing(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Closing connection";
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::msPOP1Error(TObject *Sender, AnsiString &Msg)
{
  StatusBar1->Panels->Items[0]->Text=Msg;
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::msPOP1Open(TObject *Sender)
{
  StatusBar1->Panels->Items[0]->Text="Opening connection";
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::msPOP1Retrieved(TObject *Sender, int Num)
{
  int i=msPOP1->MessageList->Count-1;
  TListItem *Item=ListView1->Items->Add();
  Item->Caption=msPOP1->MessageList->Items[i]->Subject;
  if (Item->Caption=="")
    Item->Caption="No Subject";
  Item->ImageIndex=0;
  ProgressBar1->Position=0;
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::msPOP1Retrieving(TObject *Sender, int Num)
{
  StatusBar1->Panels->Items[0]->Text=
     "Retrieving message "+AnsiString(Num+1)+
     " of "+AnsiString(msPOP1->TotalMessages);
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::ExitButtonClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::CancelButtonClick(TObject *Sender)
{
  msPOP1->Cancel();
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::ListView1DblClick(TObject *Sender)
{
  TMsgViewDlg* MsgViewDlg;
  if (ListView1->Selected)
  {
    MsgViewDlg= new TMsgViewDlg(this);
    try
    {
     MsgViewDlg->MailMessage=msPOP1->MessageList->Items[ListView1->Selected->Index];
     MsgViewDlg->ShowModal();
     delete MsgViewDlg;
    }
    catch(...)
    {
     delete MsgViewDlg;
     throw;
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::FormResize(TObject *Sender)
{
  Bevel1->Width=Width;
}
//---------------------------------------------------------------------------
void __fastcall TPOPForm::msPOP1Progress(TObject *Sender, int Perc,
	long Transferred)
{
  ProgressBar1->Position=Perc;
}
//---------------------------------------------------------------------------