unit agwhois;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinProcs,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  agsocket, agTypes;

type
  TagWhoIs = class(TagSocket)
  private
    { Private declarations }
    FQuery : string;
    FInStream : TMemoryStream;
    FOnSendingQuery : TNotifyEvent;
    procedure DoSendingQuery(Sender : TObject);
  protected
    { Protected declarations }
    procedure RecvData;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Execute;
    property InStream : TMemoryStream read FInStream;
  published
    { Published declarations }
    property Server;
    property Query : string read FQuery write FQuery;
    property DefaultPort;
    property TimeOut;
    property OnProgress;
    property OnOpen;
    property OnClosing;
    property OnClosed;
    property OnCancel;
    property OnError;
    property OnSendingQuery : TNotifyEvent read FOnSendingQuery write FOnSendingQuery;
  end;

implementation

constructor TagWhoIs.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  DefaultPort:=43;
  ServiceName:='whois';
  FInStream:=TMemoryStream.Create;
end;

destructor TagWhoIs.Destroy;
begin
  FInStream.Free;
  inherited Destroy;
end;

procedure TagWhoIs.DoSendingQuery(Sender : TObject);
begin
  if Assigned(FOnSendingQuery) then FOnSendingQuery(Sender);
end;

procedure TagWhoIs.RecvData;
begin
  FInStream.Clear;
  RecvStream(FInStream,-1);
  FInStream.Position:=0;
end;

procedure TagWhoIs.Execute;
begin
  ReInit;
  Open;
  try
    Connect;
    DoSendingQuery(Self);
    SendLine(FQuery);
    RecvData;
  finally
    Close;
  end;
end;

end.
