unit agtypes;

{$I msdef.inc}

interface

uses Classes, SysUtils, agConst;

const
  msVersion = '1.9.2';
  MaxBufSize = $4000;

type
  TUnits = (utOctets,utLines);
  TmsProtocol = (ptTCP,ptUDP);

  TmsErrorEvent = procedure(Sender : TObject; var Msg : string) of Object;
  TmsProgressEvent = procedure(Sender : TObject; Perc : Integer;
                         Transferred : LongInt) of Object;
  TmsNumNotifyEvent = procedure(Sender : TObject; Num : Integer) of Object;
  TmsUserMsgSaveEvent = procedure(Sender : TObject; Num : Integer;
                                  Contents : TMemoryStream) of Object;
  TmsLineTransmitEvent = procedure(Sender : TObject; const TheLine : string)
                                  of Object;
  TmsAddressRejectedEvent = procedure(Sender : TObject; const TheAddress,
     ServerReply : string; var Proceed : boolean) of Object;

  ESocketError = class(Exception);

  EServerError = class(Exception);

  EMessageParserError = class(Exception);

  ECanceledError = class(Exception)
    constructor Create;
  end;

  ETimedOutError = class(Exception)
    constructor Create;
  end;

implementation

constructor ECanceledError.Create;
begin
  inherited CreateRes(agSCanceled);
end;

constructor ETimedOutError.Create;
begin
  inherited CreateRes(agSTimedOut);
end;

end.
