(**********************************************)
(*  The Internet Mail Suite  1.9.2            *)
(*  (c) ArGo Software Design, 1996,1997,1998. *)
(**********************************************)
unit Agtime;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinProcs,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  agsocket, agConst, agTypes, msUtils;

type
  TagTime = class(TagSocket)
  private
    { Private declarations }
    FDateTime : TDateTime;
  protected
    { Protected declarations }
    procedure RecvData;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    procedure Execute;
    property DateTime : TDateTime read FDateTime;
  published
    { Published declarations }
    property Server;
    property DefaultPort;
    property TimeOut;
    property OnOpen;
    property OnConnected;
    property OnClosing;
    property OnClosed;
    property OnCancel;
    property OnError;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Internet Mail Suite', [TagTime]);
end;

const
  SecsInDay = 86400;
{$IFDEF WIN32}
  Shift = 2;
{$ELSE}
  Shift = 693596;
{$ENDIF}

function NetTimeToDateTime(NetTime : LongInt) : TDateTime;
var
  i : Integer;
  r : Double;
begin
  r:=0;
  for i:=0 to 3 do
    r:=r*256+((NetTime shr (8*i)) and $000000FF);
  Result:=r/SecsInDay+Shift;
end;

constructor TagTime.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  DefaultPort:=37;
  ServiceName:='time';
end;

procedure TagTime.RecvData;
var
  TheStream : TMemoryStream;
  NetTime : LongInt;
  rc : Integer;
begin
  TheStream:=TMemoryStream.Create;
  try
    RecvStream(TheStream,-1);
    TheStream.Position:=0;
    rc:=TheStream.Read(NetTime,4);
    TheStream.Position:=0;
    if rc<>4 then
      Error(agSTimeServerError);
    FDateTime:=NetTimeToDateTime(NetTime);
  finally
    TheStream.Free;
  end;
end;

procedure TagTime.Execute;
begin
  ReInit;
  Open;
  try
    Connect;
    RecvData;
  finally
    Close;
  end;
end;

end.
