(**********************************************)
(*  The Internet Mail Suite  1.9.2            *)
(*  (c) ArGo Software Design, 1996,1997,1998. *)
(**********************************************)
unit agFtpCls;

interface

uses Classes, Dialogs;

type

{$IFNDEF WIN32}
  ShortString = string;
{$ENDIF}

  TServerType = (stAuto, stUnix, stDos, stHP3000, stAS400);
  TFTPProxyType = (fpUserNoLogon, fpProxyOpen);
  TFileKind = (fkUnknown, fkFile, fkDirectory, fkLink);

  TagFTPDirEntry=class
    Kind : TFileKind;
    FileName : ShortString;
    Size : LongInt;
    Date : TDateTime;
    LinkPtr : ShortString;
  end;

  TagFTPDirList = class(TPersistent)
  private
    FList : TList;
    FServerType : TServerType;
    function Get(Index : Integer) : TagFTPDirEntry;
    procedure Put(Index : Integer; Value : TagFTPDirEntry);
    function GetCount : Integer;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(Value : TagFTPDirEntry) : Integer;
    procedure Assign(Source : TPersistent); override;
    function AddString(const s : string) : Integer;
    procedure Clear;
    property Items[Index : Integer] : TagFTPDirEntry read Get write Put; default;
    property Count : Integer read GetCount;
    property ServerType : TServerType read FServerType write FServerType;
  end;

implementation

uses msUtils, agFtpUt, SysUtils;

constructor TagFTPDirList.Create;
begin
  inherited Create;
  FList:=TList.Create;
end;

destructor TagFTPDirList.Destroy;
var
  i : Integer;
begin
  if FList<>nil then
  begin
    for i:=Count-1 DownTo 0 do
      Items[i].Free;
    FList.Free;
  end;
  inherited Destroy;
end;

function TagFTPDirList.Get(Index : Integer) : TagFTPDirEntry;
begin
  Result:=FList[Index];
end;

procedure TagFTPDirList.Put(Index : Integer; Value : TagFTPDirEntry);
begin
  FList[Index]:=Value;
end;

function TagFTPDirList.GetCount : Integer;
begin
  Result:=FList.Count;
end;

procedure TagFTPDirList.Clear;
var
  i : Integer;
begin
  for i:=Count-1 DownTo 0 do
    Items[i].Free;
  FList.Clear;
end;

function TagFTPDirList.Add(Value : TagFTPDirEntry) : Integer;
begin
  Result:=FList.Add(Value);
end;

procedure TagFTPDirList.Assign(Source : TPersistent);
var
  i : Integer;
  DirEntry : TagFTPDirEntry;
  SourceList : TagFTPDirList;
begin
  if Source is TagFTPDirList then
  begin
    Clear;
    SourceList:=Source as TagFTPDirList;
    for i:=0 to SourceList.Count-1 do
    begin
      DirEntry:=TagFTPDirEntry.Create;
      DirEntry.Kind:=SourceList[i].Kind;
      DirEntry.FileName:=SourceList[i].FileName;
      DirEntry.Size:=SourceList[i].Size;
      DirEntry.Date:=SourceList[i].Date;
      DirEntry.LinkPtr:=SourceList[i].LinkPtr;
      Add(DirEntry);
    end;
  end
  else
    inherited Assign(Source);
end;

function TagFTPDirList.AddString(const s : string) : Integer;
var
  TempS, s1, s2 : string;
  i : Integer;
  FTPEntry : TagFTPDirEntry;
begin
  TempS:=s;
  FTPEntry:=TagFTPDirEntry.Create;
  try
    if FServerType=stDos then
    begin
      s1:=PickString(TempS,0,true);
      s2:=PickString(TempS,1,true);
      FTPEntry.Date:=DOSFTPDateTimeToDateTime(s1+' '+s2);
      if Pos('<dir>',LowerCase(TempS))>0 then
        FTPEntry.Kind:=fkDirectory
      else
        FTPEntry.Kind:=fkFile;
      i:=LastPos(' ',TempS);
      if i>0 then
      begin
        FTPEntry.FileName:=Copy(TempS,i+1,Length(TempS));
        System.Delete(TempS,i,Length(TempS));
        TempS:=Trim(TempS);
        i:=LastPos(' ',TempS);
        FTPEntry.Size:=StrToIntDef(Copy(TempS,i+1,Length(TempS)),0);
      end;
    end
    else
    if FServerType=stUnix then
    begin
       case TempS[1] of
         'd': FTPEntry.Kind:=fkDirectory;
         'l': FTPEntry.Kind:=fkLink;
         else FTPEntry.Kind:=fkFile;
       end;
       FTPEntry.FileName:=PickString(TempS,8,false);
       if FTPEntry.FileName='' then
       begin
         Insert(' ',TempS,25);
         FTPEntry.FileName:=PickString(TempS,8,false);
       end;
       if FTPEntry.FileName='' then
       begin
         Insert(' ',TempS,7);
         FTPEntry.FileName:=PickString(TempS,8,false);
       end;
       if FTPEntry.Kind=fkLink then
         FTPEntry.LinkPtr:=PickString(TempS,11,true);
       FTPEntry.Size:=PickNumber(TempS,4);
       s1:=Concat(PickString(TempS,5,true),' ',PickString(TempS,6,true),
              ' ',PickString(TempS,7,true));
       try
         FTPEntry.Date:=UnixFTPDateTimeToDateTime(s1);
       except
         FTPEntry.Date:=now;
       end;
       if FTPEntry.Kind=fkLink then
         FTPEntry.LinkPtr:=PickString(TempS,10,true);
    end
    else
    if FServerType=stHP3000 then
    begin
      if s='' then
      begin
        FTPEntry.Kind:=fkDirectory;
        FTPEntry.FileName:='..';
      end
      else
      begin
        if s[16]='F' then
          FTPEntry.Kind:=fkFile
        else
          FTPEntry.Kind:=fkDirectory;
        FTPEntry.FileName:=Copy(s,62,Length(s));
      end;
    end
    else
    if FServerType=stAS400 then
    begin
      if s='' then
      begin
        FTPEntry.Kind:=fkDirectory;
        FTPEntry.FileName:='..';
      end
      else
      begin
        if Copy(s,41,4)='*FLR' then
          FTPEntry.Kind:=fkDirectory
        else
          FTPEntry.Kind:=fkFile;
        FTPEntry.Size:=StrToIntDef(Trim(Copy(s,1,21)),0);
        FTPEntry.FileName:=Copy(s,51,Length(s));
        if FTPEntry.Kind=fkDirectory then
          FTPEntry.FileName:=Copy(FTPEntry.FileName,1,Length(FTPEntry.FileName)-1);
      end;
    end
    else
      raise Exception.Create('');
    Result:=Add(FTPEntry);
  except
    FTPEntry.Kind:=fkUnknown;
    FTPEntry.FileName:=s;
    Result:=Add(FTPEntry);
  end;
end;

end.
