(**********************************************)
(*  The Internet Mail Suite  1.9.2            *)
(*  (c) ArGo Software Design, 1996,1997,1998. *)
(**********************************************)
unit agfinger;

interface

uses
{$IFDEF WIN32}
  Windows,
{$ELSE}
  WinProcs,
{$ENDIF}
  Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  agsocket, agConst, agTypes, msUtils;

type
  TagFinger = class(TagSocket)
  private
    { Private declarations }
    FQuery : string;
    FInStream : TMemoryStream;
    FOnSendingQuery : TNotifyEvent;
    procedure SetQuery(Value : string);
    procedure DoSendingQuery(Sender : TObject);
  protected
    { Protected declarations }
    AddInfo : string;
    procedure RecvData;
  public
    { Public declarations }
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure Execute;
    property InStream : TMemoryStream read FInStream;
  published
    { Published declarations }
    property Query : string read FQuery write SetQuery;
    property DefaultPort;
    property TimeOut;
    property OnOpen;
    property OnProgress;
    property OnClosing;
    property OnClosed;
    property OnCancel;
    property OnError;
    property OnSendingQuery : TNotifyEvent read FOnSendingQuery write FOnSendingQuery;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Internet Mail Suite', [TagFinger]);
end;

constructor TagFinger.Create(AOwner : TComponent);
begin
  inherited Create(AOwner);
  DefaultPort:=79;
  ServiceName:='finger';
  FInStream:=TMemoryStream.Create;
end;

destructor TagFinger.Destroy;
begin
  FInStream.Free;
  inherited Destroy;
end;

procedure TagFinger.SetQuery(Value : string);
var
  i : Integer;
begin
  if Pos('@',Value)=0 then
    Error(agSAtRequired);
  FQuery:=Value;
  i:=Pos('@',Value);
  AddInfo:=Copy(Value,1,i-1);
  System.Delete(Value,1,i);
  Server:=Trim(Value);
end;

procedure TagFinger.DoSendingQuery(Sender : TObject);
begin
  if Assigned(FOnSendingQuery) then FOnSendingQuery(Sender);
end;

procedure TagFinger.RecvData;
begin
  FInStream.Clear;
  RecvStream(FInStream,-1);
  FInStream.Position:=0;
end;

procedure TagFinger.Execute;
begin
  ReInit;
  Open;
  try
    Connect;
    DoSendingQuery(Self);
    SendLine(AddInfo);
    RecvData;
  finally
    Close;
  end;
end;

end.
