unit agConst;

interface

const
  agSBase = 57000;
  agSTimedOut = agSBase;  {Operation Timed Out}
  agSCanceled = agSTimedOut+1; {Operation has been canceled}
  agSServerRequired = agSCanceled+1; {Server property is required}
  agSBadVersion = agSServerRequired+1; {Invalid Winsock version}
  agSResolving = agSBadVersion+1; {Error resolving remote host}
  agSServiceRequired = agSResolving+1; {Service name is required}
  agSProxyPortRequired = agSServiceRequired+1; {Proxy port is required}
  agSInvalidURL = agSProxyPortRequired+1; {Invalid URL format}
  agSNotConnected = agSInvalidURL+1; {You have to connect to the server first}
  agSBusy = agSNotConnected+1; {Server is busy}
  agSFuncNotFound = agSBusy+1; {Function %s not found}
  agSWinsockNotLoaded = agSFuncNotFound+1; {Winsock is not loaded}
  agSWinsockNotFound = agSWinsockNotLoaded+1; {Winsock not found}
  agSAtRequired = agSWinsockNotFound+1; {Invalid query format.  @ symbol does not present}
  agSTimeServerError = agSAtRequired+1; {Server returned invalid reply}
{The following is for MX Resolver}
  agSDNSDifferentIDs = agSTimeServerError+1; {IDs in the query and response are different}
  agSDNSNoResponse = agSDNSDifferentIDs+1; {This is not a response}
  agSDNSFormatError = agSDNSNoResponse+1; {Domain server was unable to interpret a query}
  agSDNSServerFailure = agSDNSFormatError+1; {Domain server failure}
  agSDNSBadDomain = agSDNSServerFailure+1; {Domain name does not exist}
  agSDNSNotImplemented = agSDNSBadDomain+1; {Not implemented}
  agSDNSRefused = agSDNSNotImplemented+1; {Domain server refused to return the information}

implementation

end.
