;-----------------------------------------------------------------------
;	This TSR program displays "[Hello]" to screen,
;	whenever a line begin with 'H' is displayed.
;	To make and run this program:
;	> lasm hellot
;	> lil hellot /t
;	> hellot   -> terminate but stays on memory
;	> dir      -> display 'Hello!' when any file name begin with 'H'.
;	> hellot   -> remove itself from memory
;-----------------------------------------------------------------------
IDDAT	equ	12345
	assume	cs:cseg, ds:cseg, es:cseg
cseg	segment
	org	100h
	jmp	transient

;-----------------------------------------------
;	Resident Code
;-----------------------------------------------
resident:

; write to stdout ?
;-Z0
	pushf
	.if	ah != 40h || bx != 1
	 popf
	 jmp	dword ptr cs:[int21h]
	.endif
;-Z1

; when writing to stdout
	push	ax
	push	bx
	push	dx
	push	ds

; is line begin with 'H' or 'h' ?
	mov	bx, dx
	mov	al, [bx]
	or	al, 20h
	cmp	al, 'h'
	jne	outfin

; displays 'Hello!'
	mov	ax, cs
	mov	ds, ax
	mov	dx, offset msg
	mov	ah, 09h
	int	21h

; restore registers and jump to original int 21h
outfin:
	pop	ds
	pop	dx
	pop	bx
	pop	ax
	popf
	jmp	dword ptr cs:[int21h]

;-----------------------------------------------
;	Resident Data
;-----------------------------------------------
id	dw	IDDAT
int21h	dw	?, ?
msg	db	'[Hello] $'

res_size:

;-----------------------------------------------
;	Non-Resident Code
;-----------------------------------------------
transient:

; get int 21h vector
	mov	ax, 3521h
	int	21h

; is already resident ?
	cmp	word ptr es:[id], IDDAT
	je	remove

;-----------------------------------------------
;	Newly Reside
;-----------------------------------------------

; save original int 21h vector
	mov	[int21h], bx
	mov	[int21h+2], es

; set new int 21h vector
	mov	dx, offset resident
	mov	ax, 2521h
	int	21h

; display message as 'resided'
	mov	dx, offset msg_ins
	mov	ah, 09h
	int	21h

; keep process termination
	mov	dx, offset res_size
	mov	cl, 4
	shr	dx, cl
	inc	dx
	mov	ax, 3100h
	int	21h

;-----------------------------------------------
;	Remove From Memory
;-----------------------------------------------
remove:

; restore original int 21h vector
	push	ds
	mov	dx, es:[int21h]
	mov	ds, es:[int21h+2]
	mov	ax, 2521h
	int	21h
	pop	ds

; free memory
	push	es
	mov	es, es:[2Ch]
	mov	ah, 49h
	int	21h
	pop	es
	mov	ah, 49h
	int	21h

; display message as 'removed'
	mov	dx, offset msg_rmv
	jnc	dsp
	mov	dx, offset msg_err
dsp:	mov	ah, 09h
	int	21h

; terminate
	mov	ax, 4C00h
	int	21h

;-----------------------------------------------
;	Non-Resident Data
;-----------------------------------------------
msg_ins	db	'resided', 0Dh, 0Ah, '$'
msg_rmv	db	'removed', 0Dh, 0Ah, '$'
msg_err	db	'memory free error', 0Dh, 0Ah, '$'

cseg	ends
	end
