VERSION 2.00
Begin Form TableForm 
   BackColor       =   &H00008000&
   Caption         =   "FanTan"
   ClientHeight    =   6255
   ClientLeft      =   1185
   ClientTop       =   1410
   ClientWidth     =   7470
   Height          =   6945
   Icon            =   FANTAN.FRX:0000
   KeyPreview      =   -1  'True
   Left            =   1125
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   417
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   498
   Top             =   780
   Width           =   7590
   Begin Socket Sock 
      AutoResolve     =   -1  'True
      Backlog         =   1
      Binary          =   -1  'True
      Blocking        =   -1  'True
      Broadcast       =   0   'False
      BufferSize      =   0
      HostAddress     =   ""
      HostFile        =   ""
      HostName        =   ""
      Index           =   0
      InLine          =   0   'False
      Interval        =   0
      KeepAlive       =   0   'False
      Left            =   5160
      Linger          =   0
      LocalPort       =   0
      LocalService    =   ""
      Protocol        =   0
      RemotePort      =   0
      RemoteService   =   ""
      ReuseAddress    =   0   'False
      Route           =   -1  'True
      SocketType      =   1
      Timeout         =   0
      Top             =   5220
   End
   Begin MMControl Player 
      Enabled         =   0   'False
      Height          =   375
      Left            =   1560
      TabIndex        =   2
      Top             =   5280
      Visible         =   0   'False
      Width           =   3540
   End
   Begin CommandButton PassBtn 
      Caption         =   "Pass"
      Height          =   435
      Left            =   6300
      TabIndex        =   0
      Top             =   5700
      Width           =   1035
   End
   Begin Label PlayerName 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00008000&
      Caption         =   "Player 1"
      Height          =   195
      Index           =   0
      Left            =   120
      TabIndex        =   7
      Top             =   5940
      Visible         =   0   'False
      Width           =   1455
   End
   Begin Label PlayerName 
      Alignment       =   1  'Right Justify
      BackColor       =   &H00008000&
      Caption         =   "Player 4"
      Height          =   195
      Index           =   3
      Left            =   6060
      TabIndex        =   6
      Top             =   5340
      Visible         =   0   'False
      Width           =   1215
   End
   Begin Label PlayerName 
      BackColor       =   &H00008000&
      Caption         =   "Player 3"
      Height          =   195
      Index           =   2
      Left            =   5760
      TabIndex        =   5
      Top             =   120
      Visible         =   0   'False
      Width           =   1575
   End
   Begin Label PlayerName 
      BackColor       =   &H00008000&
      Caption         =   "Player 2"
      Height          =   195
      Index           =   1
      Left            =   180
      TabIndex        =   4
      Top             =   660
      Visible         =   0   'False
      Width           =   1215
   End
   Begin Label StatusMsg 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackColor       =   &H0080FFFF&
      BorderStyle     =   1  'Fixed Single
      Enabled         =   0   'False
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00008000&
      Height          =   315
      Left            =   3660
      TabIndex        =   3
      Top             =   480
      Visible         =   0   'False
      Width           =   105
   End
   Begin Label Pot 
      Alignment       =   2  'Center
      BackColor       =   &H00008000&
      Caption         =   "Pot: 0"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H0000FFFF&
      Height          =   315
      Left            =   120
      TabIndex        =   1
      Top             =   240
      Width           =   1035
   End
   Begin Menu FileMenu 
      Caption         =   "&File"
      Begin Menu NewGameOption 
         Caption         =   "&New Game"
      End
      Begin Menu ScoreOption 
         Caption         =   "&Score..."
      End
      Begin Menu SoundOption 
         Caption         =   "Soun&d"
         Checked         =   -1  'True
      End
      Begin Menu OptionsOption 
         Caption         =   "&Options..."
      End
      Begin Menu Sep1 
         Caption         =   "-"
      End
      Begin Menu ExitOption 
         Caption         =   "E&xit"
      End
   End
   Begin Menu HelpMenu 
      Caption         =   "&Help"
      Begin Menu HelpOption 
         Caption         =   "&How to play..."
      End
      Begin Menu Sep2 
         Caption         =   "-"
      End
      Begin Menu AboutOption 
         Caption         =   "&About Fantan..."
      End
   End
End
Dim fReady As Integer
Dim fRecv As Integer
Dim fCanPaint As Integer
Dim fTryConnect As Integer
Dim LastSocket As Integer
Dim stWidth As Integer
Dim stHeight As Integer

Dim gMsgBuf As String
Dim gSockErrorMsg As String

Const KEY_F1 = &H70
Const KEY_F2 = &H71
Const KEY_F3 = &H72
Const KEY_F4 = &H73
Const KEY_F5 = &H74
Const KEY_F6 = &H75
Const KEY_F7 = &H76
Const KEY_F8 = &H77
Const KEY_F9 = &H78
Const KEY_F10 = &H79

Const YELLOW = &HFFFF&
Const BLACK = 0

Sub AboutOption_Click ()
    AboutForm.Show 1

End Sub

Sub Broadcast (sbuf As String)
    Dim xs As Integer

    For xs = 1 To LastSocket
        Client_Send xs, sbuf
    Next xs

End Sub

Sub CheckAutoPlay ()
    Dim xp As Integer
    Dim xcard As Integer
    Dim winner As Integer
    Dim sbuf As String
    
    winner = False
    Do While IsComputerPlayer(xCurPlayer) Or IsRemotePlayer(xCurPlayer)
        If IsComputerPlayer(xCurPlayer) Then
            xcard = BestCard(xCurPlayer)
            xp = xCurPlayer
            If xcard = 0 Then
                PlayPass
                sbuf = NS_PASS + " " + Format$(xp)
            Else
                PlayCard xCurPlayer, xcard
                sbuf = NS_PLAYCARD + " " + Format$(xp) + " " + StrCard(xp, xcard)
            End If
            Broadcast sbuf
        ElseIf IsRemotePlayer(xCurPlayer) Then
            StatusMsg.Caption = "Waiting for " + GetPlayerName(xCurPlayer) + "..."
            StatusMsg.Enabled = True
            StatusMsg.Visible = True
            DoEvents
            Do
                WaitForMessage 'wait for card to be played
            Loop While NetNumArg = MyNetID()
            StatusMsg.Visible = False
            StatusMsg.Enabled = False
            DoEvents
            xp = xCurPlayer
            If NetMessage = NC_PASS Then
                PlayPass
                If fNetType = NT_SERVER Then
                    sbuf = NS_PASS + " " + Format$(xp)
                    Broadcast sbuf
                End If
            Else
                xcard = CardIndex(xCurPlayer, NetStrArg)
                PlayCard xCurPlayer, xcard
                If fNetType = NT_SERVER Then
                    sbuf = NS_PLAYCARD + " " + Format$(xp) + " " + StrCard(xp, xcard)
                    Broadcast sbuf
                End If
            End If
        End If
        PlayerName(xp - 1).ForeColor = BLACK
        If CardsToPlay(xp) = 0 Then
            winner = True
            Exit Do
        End If
        PlayerName(xCurPlayer - 1).ForeColor = YELLOW
    Loop
    
    If winner Then
        DoWinStuff
        Fantan_Start
    End If

End Sub

Sub Client_Cleanup ()
    If Sock(0).Connected Then
        DebugOut "C", 0, "SOCKET_CLOSE"
        Sock(0).Action = SOCKET_CLOSE
    End If

End Sub

Sub Client_Send (xs As Integer, sbuf As String)
    Dim xbuf As String

    If Sock(xs).Connected Then
        DebugOut "S", xs, sbuf
        xbuf = sbuf + NL
        Sock(xs).SendLen = Len(xbuf)
        Sock(xs).SendData = xbuf
    End If

End Sub

Sub Client_Setup ()
    gSockErrorMsg = ""
    fTryConnect = True
    Sock(0).AddressFamily = AF_INET
    Sock(0).Protocol = IPPROTO_IP
    Sock(0).SocketType = SOCK_STREAM
    Sock(0).Binary = True
    Sock(0).BufferSize = 1024
    Sock(0).Blocking = False
    Sock(0).HostName = NetHostSystem
    Sock(0).RemotePort = IPPORT_FANTAN
    Sock(0).Action = Socket_Connect
    fTryConnect = False

    If Len(gSockErrorMsg) > 0 Then
        fNetType = 0
    End If

End Sub

Sub DebugOut (code As String, nid As Integer, sbuf As String)
    Dim dch As Integer

    If fDebug Then
        dch = FreeFile
        Open "c:\tmp\ft.log" For Append As #dch
        Print #dch, code; nid; sbuf
        Close #1
    End If

End Sub

Sub DoWinStuff ()
    AdjustScores
    PaintTable
    ScoresForm.Show 1
    DoEvents

End Sub

Sub ExitOption_Click ()
    Dim xs As Integer

    If fNetType = NT_SERVER Then
        Broadcast NS_GAMEOVER
        For xs = 1 To LastSocket
            If Sock(xs).Connected Then
                WaitForMessage
            End If
        Next xs
    End If

    If fNetType = NT_CLIENT Then
        Server_Send NS_GAMEOVER + " " + Format$(MyNetID())
        WaitForMessage
    End If

    Unload Me
    
End Sub

Sub Fantan_Start ()
    Dim xp As Integer
    Dim pname As String
    
    fCanPaint = False
    MousePointer = 11
    For xp = 1 To nPlayers
        pname = GetPlayerName(xp)
        If Len(pname) Then
            PlayerName(xp - 1).Caption = pname
        End If
        PlayerName(xp - 1).Visible = True
    Next xp
    If fNetType = NT_CLIENT Then
        WaitForMessage 'will get deck of cards from server
        DebugOut "X", NetNumArg, NetStrArg
        WaitForMessage 'who's dealing
        DebugOut "X", NetNumArg, NetStrArg
        xdlr = xDealer
        CreateDeck NetStrArg
        xDealer = xdlr
        xCurPlayer = xDealer + 1
        If xCurPlayer > nPlayers Then
            xCurPlayer = 1
        End If
    Else
        DeckShuffle
        If fNetType = NT_SERVER Then
            SendDeck
        End If
    End If
    DealCards
    MousePointer = 0
    Me.Cls
    PlayerName(0).Left = Val(PlayerName(0).Tag)
    PlayerName(1).Top = Val(PlayerName(1).Tag)
    PlayerName(2).Left = Val(PlayerName(2).Tag)
    PlayerName(3).Top = Val(PlayerName(3).Tag)
    PaintTable
    fCanPaint = True
    CheckAutoPlay
    
End Sub

Sub FileMenu_Click ()
    If Len(Dir$(PassSound)) = 0 Then
        SoundOption.Enabled = False
    Else
        SoundOption.Enabled = True
    End If

End Sub

Sub Form_Activate ()
    Static first_time As Integer

    If first_time = 0 Then
        first_time = 1
        ok = True
        Do
            SetupForm.Show 1
            DoEvents
            If fCancel Then
                ExitOption_Click
            End If
            If fNetType = NT_SERVER Then
                Server_Setup 'fNetType will be set to 0 if there's a problem
                If fNetType <> NT_SERVER Then
                    ok = False
                    If Len(gSockErrorMsg) = 0 Then
                        gSockErrorMsg = "Network connection failed."
                    End If
                    MsgBox gSockErrorMsg, 48
                Else
                    MessagePump 'wait for network players to join in
                    ReadyToPlay
                End If
            ElseIf fNetType = NT_CLIENT Then
                Client_Setup 'fNetType will be set to 0 if there's a problem
                If fNetType <> NT_CLIENT Then
                    ok = False
                    If Len(gSockErrorMsg) = 0 Then
                        gSockErrorMsg = "Network connection failed."
                    End If
                    MsgBox gSockErrorMsg, 48
                Else
                    MessagePump 'get player names
                End If
            End If
            StatusMsg.Visible = False
            StatusMsg.Enabled = False
        Loop Until ok
        Fantan_Start
    End If

End Sub

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
    If KeyCode = KEY_F1 Then
        GetHelp
    ElseIf KeyCode = KEY_F2 Then
        fReady = True
        fRecv = True 'break out of loop waiting for client messages
        StatusMsg.Enabled = False
        StatusMsg.Visible = False
        StatusMsg.Caption = ""
    End If

End Sub

Sub Form_Load ()
    Dim i As Integer

    'fDebug = 1
    NL = Chr$(10)
    CRLF = Chr$(13) + Chr$(10)
    fCanPaint = True
    fDoSound = SoundOption.Checked
    fTryConnect = False

    Me.ScaleMode = 3 'Everything is in pixel units
    'Use Tag property to save original locations of Player names
    PlayerName(0).Tag = Format$(PlayerName(0).Left)
    PlayerName(1).Tag = Format$(PlayerName(1).Top)
    PlayerName(2).Tag = Format$(PlayerName(2).Left)
    PlayerName(3).Tag = Format$(PlayerName(3).Top)

    Player.Command = "Open"
    FanTan_Init

    SoundOption.Checked = fDoSound
    
    'Initial player names
    Load OptionsForm
    For i = 2 To 4
        If Len(gPlayerName(i - 1)) > 0 Then
            SetPlayerName i, gPlayerName(i - 1)
        Else
            SetPlayerName i, OptionsForm.PlayerName(i - 2).Text
        End If
    Next i
    Unload OptionsForm

    stWidth = GetMinTableWidth()
    stHeight = GetMinTableHeight()
    
End Sub

Sub Form_MouseDown (Button As Integer, Shift As Integer, x As Single, y As Single)
    Dim xp As Integer
    Dim xcard As Integer
    Dim mx As Integer, my As Integer
    Dim winner As Integer
    Dim sbuf As String
    
    If Not PlayerCanPlay(xCurPlayer) Then
        Exit Sub
    End If

    winner = False
    mx = x: my = y
    xcard = CardHitTest(xCurPlayer, mx, my)
    If IsCardPlayable(xCurPlayer, xcard) Then
        xp = xCurPlayer
        PlayCard xCurPlayer, xcard
        PlayerName(xp - 1).ForeColor = BLACK
        If fNetType = NT_CLIENT Then
            'notify server what card we are playing
            sbuf = NS_PLAYCARD + " " + Format$(MyNetID()) + " " + StrCard(xp, xcard)
            Server_Send sbuf
        ElseIf fNetType = NT_SERVER Then
            sbuf = NS_PLAYCARD + " " + Format$(xp) + " " + StrCard(xp, xcard)
            Broadcast sbuf
        End If
        If CardsToPlay(xp) = 0 Then
            winner = True
        Else
            PlayerName(xCurPlayer - 1).ForeColor = YELLOW
            CheckAutoPlay
        End If
    Else
        ShowNotPlayable xcard
    End If
    
    If winner Then
        DoWinStuff
        Fantan_Start
    End If
    
End Sub

Sub Form_Paint ()
    If fCanPaint Then OnPaint

End Sub

Sub Form_Resize ()
    Dim w As Integer, h As Integer

    If stWidth > 0 And stHeight > 0 Then
        Me.ScaleWidth = stWidth
        Me.ScaleHeight = stHeight
        w = Me.ScaleWidth: h = Me.ScaleHeight
        SetTableSize w, h
        Me.Cls
        PaintTable
    End If
    
End Sub

Sub Form_Unload (Cancel As Integer)
    Player.Command = "Close"
    If fNetType = NT_CLIENT Then
        Client_Cleanup
    ElseIf fNetType = NT_SERVER Then
        Server_Cleanup
    End If
    FanTan_Cleanup
    End

End Sub

Sub GetMessage ()
    Dim sbuf As String

    If fNetType = NT_CLIENT Then
        'Message from Server
        Select Case GetNetCode(gMsgBuf)
        Case NC_OK
            fReady = True
        Case NC_PLAYERID
            'First aknowledgement from server
            StatusMsg.Caption = "Waiting for dealer to start game..."
            StatusMsg.Enabled = True
            StatusMsg.Visible = True
            SetMyNetID NetNumArg
            'Tell server the name of this player
            sbuf = NS_PLAYERNAME + " " + Format$(MyNetID()) + " " + GetPlayerName(1)
            Server_Send sbuf
        Case NC_GAMESTART
            fReady = True
        Case NC_PLAYERNAME
            SetNetPlayer NetNumArg, NetStrArg
        Case NC_DEALER
            xDealer = xpid(NetNumArg)
            fReady = True
        Case NC_PLAYCARD
            fReady = True
        Case NC_PASS
            fReady = True
        Case NC_GAMEOVER
            Server_Send NS_OK
            MsgBox "Dealer has terminated game.", 16
            Unload Me
        Case NC_SAY
            If NetNumArg <> MyNetID() Then
                MsgBox GetPlayerName(xpid(NetNumArg)) + ": " + NetStrArg
            End If
            fRecv = False 'act as if we never got this message since it is not expected
        End Select
        Exit Sub
    End If

    'Message from client
    Select Case GetNetCode(gMsgBuf)
    Case NC_OK 'general acknowledgement
        fReady = True
    Case NC_PLAYERNAME
        MsgBox NetStrArg + " has joined the game.", 64
        SetPlayerName NetNumArg, NetStrArg
    Case NC_PLAYCARD
        fReady = True
    Case NC_PASS
        fReady = True
    Case NC_GAMEOVER 'client wants to quit
        'Index tells us who's quitting; let computer take over
        Client_Send NetNumArg - 1, NS_OK
        MsgBox GetPlayerName(NetNumArg) + " has left the game." + CRLF + "Computer is taking over.", 64
        SetModeToComputer NetNumArg
        PlayerName(NetNumArg - 1).Caption = GetPlayerName(NetNumArg)
    Case NC_SAY
        Broadcast NS_SAY + " " + Format$(NetNumArg) + " " + NetStrArg
        MsgBox GetPlayerName(NetNumArg) + ": " + NetStrArg
        fRecv = False 'act as if we never got this message since it is not expected
    End Select

End Sub

Sub HelpOption_Click ()
    GetHelp

End Sub

Sub MessagePump ()
    fReady = False
    Do
        WaitForMessage
    Loop Until fReady

End Sub

Sub NewGameOption_Click ()
    Fantan_Start
    
End Sub

Sub OptionsOption_Click ()
    Dim i As Integer

    OptionsForm.Show 1
    For i = 2 To 4
        PlayerName(i - 1).Caption = GetPlayerName(i)
    Next i
    DoEvents

End Sub

Sub PassBtn_Click ()
    Dim sbuf As String

    If fNetType = NT_CLIENT Then
        Server_Send NS_PASS + " " + Format$(ftPlayer(xCurPlayer).NetID)
    ElseIf fNetType = NT_SERVER Then
        sbuf = NS_PASS + " " + Format$(xp)
        Broadcast sbuf
    End If
    PlayPass
    CheckAutoPlay
    
End Sub

Sub ReadyToPlay ()
    Dim xs As Integer, xp As Integer, xp2 As Integer
    Dim sbuf As String

    'Notify clients player names and that we are ready to play
    For xp = 1 To 4
        If ftPlayer(xp).fRemote Then
            For xp2 = 1 To 4
                sbuf = NS_PLAYERNAME + " " + Format$(xp2) + " " + GetPlayerName(xp2)
                Client_Send xp - 1, sbuf
            Next xp2
        End If
    Next xp

    For xs = 1 To LastSocket
        Client_Send xs, NS_GAMESTART
    Next xs

End Sub

Sub ScoreOption_Click ()
    ScoresForm.Show 1
    DoEvents

End Sub

Sub SendDeck ()
    Dim xs As Integer
    Dim i As Integer, v As Integer
    Dim sbuf As String, dbuf As String

    sbuf = NS_DECK + " "
    For i = 1 To 52
        v = ftDeck.Card(i).Suit * 100 + ftDeck.Card(i).Value
        sbuf = sbuf + Format$(v, "###")
    Next i

    dbuf = NS_DEALER + " " + Format$(xDealer)
    For xs = 1 To LastSocket
        If Sock(xs).Connected Then
            Client_Send xs, sbuf
            Client_Send xs, dbuf
        End If
    Next xs

End Sub

Sub Server_Cleanup ()
    Dim i As Integer

    If Sock(0).Listening Then
        DebugOut "S", 0, "SOCKET_CLOSE"
        Sock(0).Action = SOCKET_CLOSE
    End If

    For i = 1 To LastSocket
        If Sock(i).Connected Then
            DebugOut "S", i, "SOCKET_CLOSE"
            Sock(i).Action = SOCKET_CLOSE
        End If
    Next i

End Sub

Sub Server_Send (sbuf As String)
    Dim xbuf As String

    DebugOut "S", 0, sbuf
    xbuf = sbuf + NL
    Sock(0).SendLen = Len(xbuf)
    Sock(0).SendData = xbuf

End Sub

Sub Server_Setup ()
    gSockErrorMsg = ""
    fTryConnect = True
    Sock(0).AddressFamily = AF_INET
    Sock(0).Protocol = IPPROTO_IP
    Sock(0).SocketType = SOCK_STREAM
    Sock(0).Binary = True
    Sock(0).Blocking = False
    Sock(0).LocalPort = IPPORT_FANTAN
    Sock(0).Action = SOCKET_LISTEN
    gTryConnect = False

    If Len(Sock(0).LocalAddress) = 0 Then
        fNetType = 0
        Exit Sub
    End If
    
    If Len(Sock(0).LocalName) > 0 Then
        hostinfo = Sock(0).LocalName + " (" + Sock(0).LocalAddress + ")"
    Else
        hostinfo = Sock(0).LocalAddress
    End If
    
    StatusMsg.Caption = "Waiting for network players..." + CRLF + "Press F2 to play with current players" + CRLF + "Host is " + hostinfo
    StatusMsg.Enabled = True
    StatusMsg.Visible = True

End Sub

Sub Sock_Accept (Index As Integer, SocketId As Integer)
    Dim i As Integer, xp As Integer
    Dim sbuf As String

    For i = 1 To LastSocket
        If Not Sock(i).Connected Then
            Exit For
        End If
    Next i
    
    If i > LastSocket Then
        LastSocket = LastSocket + 1
        i = LastSocket
        Load Sock(i)
    End If

    Sock(i).AddressFamily = AF_INET
    Sock(i).Protocol = IPPROTO_IP
    Sock(i).SocketType = SOCK_STREAM
    Sock(i).Binary = True
    Sock(i).BufferSize = 1024
    Sock(i).Blocking = False
    Sock(i).Accept = SocketId

    xp = NewRemotePlayer(i)
    'Give client their player id; this also serves as an acknowledgement
    sbuf = NS_PLAYERID + " " + Format$(xp)
    Client_Send i, sbuf

End Sub

Sub Sock_Disconnect (Index As Integer)
    Sock(Index).Action = SOCKET_CLOSE 'this sets Connected property to False

End Sub

Sub Sock_LastError (Index As Integer, ErrorCode As Integer, ErrorString As String, Response As Integer)
    DebugOut "E", Index, Format$(ErrCode)

    If fTryConnect Then
        gSockErrorMsg = ErrorString
        Response = SOCKET_ERRIGNORE
    End If

    If ErrCode = WSAECONNRESET Then
        Sock(Index).Action = SOCKET_CLOSE
        Response = SOCKET_ERRIGNORE
    End If

End Sub

Sub Sock_Read (Index As Integer, DataLength As Integer, IsUrgent As Integer)
    Dim rbuf As String

    Sock(Index).RecvLen = DataLength
    rbuf = Sock(Index).RecvData
    gMsgBuf = gMsgBuf + rbuf

    DebugOut "R", Index, rbuf
    fRecv = True

End Sub

Sub SoundOption_Click ()
    If fDoSound Then
        fDoSound = False
    Else
        fDoSound = True
    End If
    SoundOption.Checked = fDoSound

End Sub

Sub WaitForMessage ()
    If Len(gMsgBuf) = 0 Then
        fRecv = False
        Do
            DoEvents
        Loop Until fRecv
    End If
    GetMessage

End Sub

