Global CRLF As String
Global NL As String

Const nOverlap = 16     'size of cards overlap in pixels
Const nsGap = 8         'size of small gap in pixels
Const nbGap = 16        'size of big gap in pixels

Global fDebug As Integer
Global fCancel As Integer
Global fDoSound As Integer
Global gPlayerName(3) As String 'computer player names
Global PassSound As String  'name of file containing sound to play when player passes
Global HelpFile As String
Global nSpeed As Integer 'animation speed
Global Const nAvgSpeed = 8
Global Const nIncSpeed = 4

Global NetHostSystem As String
Global fNetType As Integer
Global Const NT_NIL = 0
Global Const NT_SERVER = 1
Global Const NT_CLIENT = 2
Global Const IPPORT_FANTAN = 7117

Global NetMessage As Integer
Global NetNumArg As Integer
Global NetStrArg As String
Global NetMsgText As String

'Network messages
Global Const NC_OK = 1              'message acknowledgement
Global Const NS_OK = "OK"
Global Const NC_PLAYERID = 2        'identify or assign a remote player's id
Global Const NS_PLAYERID = "IP"
Global Const NC_PLAYERNAME = 3      'identify or assign a remote player's name
Global Const NS_PLAYERNAME = "NM"
Global Const NC_GAMESTART = 4       'we're starting with the players we have
Global Const NS_GAMESTART = "GS"
Global Const NC_GAMEOVER = 5        'somebody wants out
Global Const NS_GAMEOVER = "GO"
Global Const NC_DECK = 6            'this is the deck we're using
Global Const NS_DECK = "DK"
Global Const NC_DEALER = 7          'identifies dealer of current game
Global Const NS_DEALER = "DL"
Global Const NC_PLAYCARD = 8        'current card being played
Global Const NS_PLAYCARD = "PC"
Global Const NC_PASS = 9            'current player passes
Global Const NS_PASS = "PS"
Global Const NC_SAY = 10            'chat message
Global Const NS_SAY = "SY"

Dim cdt_state As Integer
Dim ftIniFile As String
Dim ftStake As Integer
Dim fGameOver As Integer

Dim dxCard As Integer   'actual width of card bitmap
Dim dyCard As Integer   'actual height of card bitmap
Dim wCard As Integer    'width of card bitmap
Dim hCard As Integer    'height of card bitmap
Dim wTable As Integer
Dim hTable As Integer
Dim backCard As Integer

Dim xFirstCard(4) As Integer
Dim yFirstCard(4) As Integer
Dim xPlayArea(4) As Integer
Dim yPlayArea(4) As Integer

Type Card
    Suit As Integer
    Value As Integer
    Round As Integer
    w(16) As Integer
End Type

Type deck
    top As Integer
    Card(52) As Card
End Type

Type Player
    Name As String
    nWins As Integer
    Score As Integer
    HandScore As Integer
    nMisplays As Integer
    ncards As Integer
    fComputer As Integer
    fRemote As Integer
    xSocket As Integer
    NetID As Integer
    Hand(13) As Card
End Type

Type Game
    Round As Integer
    Pot As Integer
    hiCard(4) As Card
    loCard(4) As Card
End Type

Global ftDeck As deck
Global ftPlayer(8) As Player
Global ftGame As Game
Global nPlayers As Integer
Global xDealer As Integer
Global xCurPlayer As Integer

Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

Global Const SRCCOPY = &HCC0020 ' (DWORD) dest = source
Global Const DSTINVERT = &H550009 ' Invert dest

Declare Function BitBlt Lib "GDI" (ByVal hDestDC As Integer, ByVal x As Integer, ByVal y As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal hSrcDC As Integer, ByVal XSrc As Integer, ByVal YSrc As Integer, ByVal dwRop As Long) As Integer
Declare Function DeleteObject Lib "GDI" (ByVal hObject As Integer) As Integer
Declare Function SelectObject Lib "GDI" (ByVal hDC As Integer, ByVal hObject As Integer) As Integer
Declare Function CreateCompatibleDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function DeleteDC Lib "GDI" (ByVal hDC As Integer) As Integer
Declare Function CreateCompatibleBitmap Lib "GDI" (ByVal hDC As Integer, ByVal nWidth As Integer, ByVal nHeight As Integer) As Integer
Declare Function GetDeviceCaps Lib "GDI" (ByVal hDC As Integer, ByVal nIndex As Integer) As Integer
Declare Function CreateBitmap Lib "GDI" (ByVal nWidth As Integer, ByVal nHeight As Integer, ByVal nPlanes As Integer, ByVal nBitCount As Integer, ByVal lpBits As Any) As Integer
Declare Function CreateSolidBrush Lib "GDI" (ByVal crColor As Long) As Integer
Declare Function Rectangle Lib "GDI" (ByVal hDC As Integer, ByVal X1 As Integer, ByVal Y1 As Integer, ByVal X2 As Integer, ByVal Y2 As Integer) As Integer
Declare Function CreatePen Lib "GDI" (ByVal nPenStyle As Integer, ByVal nWidth As Integer, ByVal crColor As Long) As Integer
Declare Function WinHelp Lib "User" (ByVal hWnd As Integer, ByVal lpHelpFile As String, ByVal wCommand As Integer, dwData As Any) As Integer
Declare Function GetWindowsDirectory Lib "Kernel" (ByVal lpBuffer As String, ByVal nSize As Integer) As Integer

Sub AddToPot (nunits As Integer)
    If fDoSound = True Then
        'TableForm.Player.FileName = "c:\windows\ringin.wav"
        'TableForm.Player.Command = "Sound"
    End If
    ftGame.Pot = ftGame.Pot + nunits
    TableForm.Pot.Caption = "Pot: " + Format$(ftGame.Pot)

End Sub

Sub AdjustScores ()
    Dim xp As Integer
    Dim n As Integer, xwinner As Integer

    For xp = 1 To nPlayers
        n = CardsToPlay(xp)
        ftPlayer(xp).HandScore = ftPlayer(xp).HandScore - n
        If ftPlayer(xp).nMisplays Then
            For xp2 = 1 To nPlayers
                If xp2 <> xp Then
                    ftPlayer(xp2).HandScore = ftPlayer(xp2).HandScore + (ftPlayer(xp).nMisplays * 3)
                End If
            Next xp2
            ftPlayer(xp).HandScore = ftPlayer(xp).HandScore - (ftPlayer(xp).nMisplays * 9)
        End If
        If n = 0 Then
            xwinner = xp
        End If
        AddToPot n
    Next xp

    ftPlayer(xwinner).nWins = ftPlayer(xwinner).nWins + 1
    ftPlayer(xwinner).HandScore = ftPlayer(xwinner).HandScore + ftGame.Pot

    For xp = 1 To nPlayers
        SortHand xp
        ftPlayer(xp).Score = ftPlayer(xp).Score + ftPlayer(xp).HandScore
    Next xp

    fGameOver = True

End Sub

Sub AnimateClose (xsuit As Integer)
    Dim hpen, hbrush
    Dim hmemdc, hbmp, hbmpOld
    Dim v As Integer
    Dim yhi As Integer, ylo As Integer, inc As Integer
    
    ht = hCard * 3 + nsGap
    hmemdc = CreateCompatibleDC(TableForm.hDC)
    cplanes = GetDeviceCaps(hmemdc, 14) 'PLANES
    cpixelbits = GetDeviceCaps(hmemdc, 12) 'BITSPIXEL
    hbmp = CreateBitmap(wCard * 2, ht, cplanes, cpixelbits, 0&)
    hbmpOld = SelectObject(hmemdc, hbmp)
    hpen = CreatePen(0, 1, TableForm.BackColor)
    hbrush = CreateSolidBrush(TableForm.BackColor)
    hpen = SelectObject(hmemdc, hpen)
    hbrush = SelectObject(hmemdc, hbrush)
    
    retv = Rectangle(hmemdc, 0, 0, wCard, ht)
    retv = cdtDraw(hmemdc, 0, Int(ht / 2) - Int(hCard / 2), xcdt(7, xsuit), ordFaces, 0&)
    yhi = Int(ht / 2) - hCard - 2
    retv = cdtDraw(hmemdc, 0, yhi, xcdt(13, xsuit), ordFaces, 0&)
    ylo = Int(ht / 2) + 2
    retv = cdtDraw(hmemdc, 0, ylo, xcdt(1, xsuit), ordFaces, 0&)
    
    inc = 0
    Do
        inc = inc + 1
        retv = BitBlt(hmemdc, wCard, 0, wCard, Int(ht / 2), hmemdc, 0, yhi - inc, SRCCOPY)
        retv = BitBlt(hmemdc, wCard, hCard + inc, wCard, hCard, hmemdc, 0, ylo + (inc * 2), SRCCOPY)
        retv = BitBlt(TableForm.hDC, xPlayArea(xsuit), yPlayArea(xsuit) - hCard - 2, wCard, hCard * 2 + 4, hmemdc, wCard, 0, SRCCOPY)
    Loop Until inc > Int(hCard / 2)
    
    hbrush = SelectObject(hmemdc, hbrush)
    hpen = SelectObject(hmemdc, hpen)
    retv = DeleteObject(hbrush)
    retv = DeleteObject(hpen)
    retv = SelectObject(hmemdc, hbmpOld)
    retv = DeleteObject(hbmp)
    retv = DeleteDC(hmemdc)
    
    retv = cdtDraw(TableForm.hDC, xPlayArea(xsuit), yPlayArea(xsuit) - Int(hCard / 2) - 1, backCard, ordBacks, TableForm.BackColor)

End Sub

Sub AnimatePlayCard (xp As Integer, xcard As Integer)
    Dim xc As Integer, xcd As Integer
    Dim pcard As Card, v As Integer
    Dim srcrect As RECT, destrect As RECT, trect As RECT
    Dim hdcbg, hbmpbg, hdcwork, hbmpwork
    Dim x As Integer, y As Integer
    Dim adir As Integer, speed As Integer
    Dim b As Double, m As Double, dxdy As Double
                       
    xcd = 0
    For xc = 1 To xcard
        If ftPlayer(xp).Hand(xc).Round = 0 Then
            xcd = xcd + 1
        End If
    Next xc

    If xp = 1 Then
        srcrect.left = xFirstCard(xp) + xcd * nOverlap
        srcrect.top = yFirstCard(xp)
    ElseIf xp = 2 Then
        srcrect.left = xFirstCard(xp)
        srcrect.top = yFirstCard(xp) + xcd * nOverlap
    ElseIf xp = 3 Then
        srcrect.left = xFirstCard(xp) - xcd * nOverlap
        srcrect.top = yFirstCard(xp)
    ElseIf xp = 4 Then
        srcrect.left = xFirstCard(xp)
        srcrect.top = yFirstCard(xp) - xcd * nOverlap
    End If
    srcrect.right = srcrect.left + wCard
    srcrect.bottom = srcrect.top + hCard

    pcard = ftPlayer(xp).Hand(xcard)
    v = xcdt(pcard.Value, pcard.Suit)
    If pcard.Value = 7 Then
        y = yPlayArea(pcard.Suit) - Int(hCard / 2)
    ElseIf pcard.Value > 7 Then
        y = yPlayArea(pcard.Suit) - hCard - 2
    ElseIf pcard.Value < 7 Then
        y = yPlayArea(pcard.Suit) + 2
    End If
    destrect.left = xPlayArea(pcard.Suit)
    destrect.top = y
    destrect.right = destrect.left + wCard
    destrect.bottom = destrect.top + hCard

    If srcrect.left < destrect.left Then trect.left = srcrect.left Else trect.left = destrect.left
    If srcrect.top < destrect.top Then trect.top = srcrect.top Else trect.top = destrect.top
    If srcrect.right > destrect.right Then trect.right = srcrect.right Else trect.right = destrect.right
    If srcrect.bottom > destrect.bottom Then trect.bottom = srcrect.bottom Else trect.bottom = destrect.bottom

    dxdy = (destrect.left - srcrect.left) / (destrect.top - srcrect.top)
    b = srcrect.top + (-srcrect.left / dxdy)
    m = (destrect.top - b) / destrect.left
    speed = nSpeed

    If destrect.left >= srcrect.left Then
        'moving card to the right
        If destrect.top >= srcrect.top Then
            'moving card down and right
            If destrect.left - srcrect.left >= destrect.top - srcrect.top Then
                'faster in x direction
                adir = 8
            Else
                'faster in y direction
                adir = 7
            End If
        Else
            'moving card up and right
            If destrect.left - srcrect.left >= srcrect.top - destrect.top Then
                'faster in x direction
                adir = 1
            Else
                'faster in y direction
                adir = 2
            End If
        End If
    Else
        If destrect.top >= srcrect.top Then
            'moving card down and left
            If srcrect.left - destrect.left >= destrect.top - srcrect.top Then
                'faster in x direction
                adir = 5
            Else
                'faster in y direction
                adir = 6
            End If
        Else
            'moving card up and left
            If srcrect.left - destrect.left >= srcrect.top - destrect.top Then
                'faster in x direction
                adir = 4
            Else
                'faster in y direction
                adir = 3
            End If
        End If
    End If

    hdcbg = CreateCompatibleDC(TableForm.hDC)
    cplanes = GetDeviceCaps(hdcbg, 14) 'PLANES
    cpixelbits = GetDeviceCaps(hdcbg, 12) 'BITSPIXEL
    hbmpbg = CreateBitmap(trect.right - trect.left, trect.bottom - trect.top, cplanes, cpixelbits, 0&)
    hbmpbg = SelectObject(hdcbg, hbmpbg)
    retv = BitBlt(hdcbg, 0, 0, trect.right - trect.left, trect.bottom - trect.top, TableForm.hDC, trect.left, trect.top, SRCCOPY)
    retv = cdtDraw(TableForm.hDC, srcrect.left, srcrect.top, v, ordFaces, 0&)

    hdcwork = CreateCompatibleDC(TableForm.hDC)
    hbmpwork = CreateBitmap(wCard + 32, hCard + 32, cplanes, cpixelbits, 0&)
    hbmpwork = SelectObject(hdcwork, hbmpwork)

    'Iterate through each position on "line"
    x = srcrect.left: y = srcrect.top
    Do
        px = x: py = y
        Select Case adir
        Case 1
            x = x + speed
            y = m * x + b
            If x > destrect.left Then x = destrect.left
            If y < destrect.top Then y = destrect.top
        Case 2
            y = y - speed
            x = (y - b) / m
            If y < destrect.top Then y = destrect.top
            If x > destrect.left Then x = destrect.left
        Case 3
            y = y - speed
            x = (y - b) / m
            If y < destrect.top Then y = destrect.top
            If x < destrect.left Then x = destrect.left
        Case 4
            x = x - speed
            y = m * x + b
            If x < destrect.left Then x = destrect.left
            If y < destrect.top Then y = destrect.top
        Case 5
            x = x - speed
            y = m * x + b
            If x < destrect.left Then x = destrect.left
            If y > destrect.top Then y = destrect.top
        Case 6
            y = y + speed
            x = (y - b) / m
            If y > destrect.top Then y = destrect.top
            If x < destrect.left Then x = destrect.left
        Case 7
            y = y + speed
            x = (y - b) / m
            If y > destrect.top Then y = destrect.top
            If x > destrect.left Then x = destrect.left
        Case 8
            x = x + speed
            y = m * x + b
            If x > destrect.left Then x = destrect.left
            If y > destrect.top Then y = destrect.top
        End Select
        Select Case adir
        Case 1 To 2
            retv = BitBlt(hdcwork, 0, 0, wCard + 32, hCard + 32, hdcbg, px - trect.left, y - trect.top, SRCCOPY)
            retv = cdtDraw(hdcwork, x - px, 0, v, ordFaces, 0&)
            retv = BitBlt(TableForm.hDC, px, y, wCard + (x - px), hCard + (py - y), hdcwork, 0, 0, SRCCOPY)
        Case 3 To 4
            retv = BitBlt(hdcwork, 0, 0, wCard + 32, hCard + 32, hdcbg, x - trect.left, y - trect.top, SRCCOPY)
            retv = cdtDraw(hdcwork, 0, 0, v, ordFaces, 0&)
            retv = BitBlt(TableForm.hDC, x, y, wCard + (px - x), hCard + (py - y), hdcwork, 0, 0, SRCCOPY)
        Case 5 To 6
            retv = BitBlt(hdcwork, 0, 0, wCard + 32, hCard + 32, hdcbg, x - trect.left, py - trect.top, SRCCOPY)
            retv = cdtDraw(hdcwork, 0, y - py, v, ordFaces, 0&)
            retv = BitBlt(TableForm.hDC, x, py, wCard + (px - x), hCard + (y - py), hdcwork, 0, 0, SRCCOPY)
        Case 7 To 8
            retv = BitBlt(hdcwork, 0, 0, wCard + 32, hCard + 32, hdcbg, px - trect.left, py - trect.top, SRCCOPY)
            retv = cdtDraw(hdcwork, x - px, y - py, v, ordFaces, 0&)
            retv = BitBlt(TableForm.hDC, px, py, wCard + (x - px), hCard + (y - py), hdcwork, 0, 0, SRCCOPY)
        End Select
    Loop Until x = destrect.left And y = destrect.top
    
    hbmpwork = SelectObject(hdcwork, hbmpwork)
    retv = DeleteObject(hbmpwork)
    retv = DeleteObject(hdcwork)
    hbmpbg = SelectObject(hdcbg, hbmpbg)
    retv = DeleteObject(hbmpbg)
    retv = DeleteDC(hdcbg)

End Sub

Function BestCard (xp As Integer) As Integer
    Dim i As Integer, n As Integer
    Dim d As Integer
    Dim xcard As Integer, nplay As Integer
    Dim ncards As Integer
    
    'Uses w() array to keep info about cards
    'to pick the best play from all playable cards
    'w(1) = 1 if card is playable
    'w(2) = relative index from 7 (A,K=6 2,Q=5 3,J=4 etc)
    'w(3) = distance between playable card and worst card
    'w(4) = number of cards in hand between playable card and worst card
    'w(5) = 1 if next higher/lower card is held by us

    ncards = ftPlayer(xp).ncards
    'Clear work variables
    For n = 1 To ncards
        For i = 1 To 16
            ftPlayer(xp).Hand(n).w(i) = 0
        Next i
    Next n

    nplay = 0
    For n = 1 To ncards
        If IsCardPlayable(xp, n) Then
            xcard = n
            nplay = nplay + 1
            ftPlayer(xp).Hand(n).w(1) = 1   'flag card as playable
            ftPlayer(xp).Hand(n).w(2) = Abs(7 - ftPlayer(xp).Hand(n).Value)
            'compute number of cards above or below playable card
            For i = 1 To ncards
                If i <> n And ftPlayer(xp).Hand(i).Suit = ftPlayer(xp).Hand(n).Suit Then
                    If ftPlayer(xp).Hand(n).Value >= 7 And ftPlayer(xp).Hand(i).Value > ftPlayer(xp).Hand(n).Value Then
                        ftPlayer(xp).Hand(n).w(4) = ftPlayer(xp).Hand(n).w(4) + 1
                        If ftPlayer(xp).Hand(n).Value + 1 = ftPlayer(xp).Hand(i).Value Then
                            ftPlayer(xp).Hand(n).w(5) = 1
                        End If
                    End If
                    If ftPlayer(xp).Hand(n).Value <= 7 And ftPlayer(xp).Hand(i).Value < ftPlayer(xp).Hand(n).Value Then
                        ftPlayer(xp).Hand(n).w(4) = ftPlayer(xp).Hand(n).w(4) + 1
                        If ftPlayer(xp).Hand(n).Value - 1 = ftPlayer(xp).Hand(i).Value Then
                            ftPlayer(xp).Hand(n).w(5) = 1
                        End If
                    End If
                End If
            Next i
        End If
    Next n
    
    If nplay = 0 Then
        BestCard = 0
        Exit Function
    End If
    
    If nplay = 1 Then
        BestCard = xcard
        Exit Function
    End If

    'For each playable card, set w(3) to the distance to worst card in suit
    For n = 1 To ncards
        If ftPlayer(xp).Hand(n).w(1) Then
            For i = 1 To ncards
                If i <> n And ftPlayer(xp).Hand(n).Suit = ftPlayer(xp).Hand(i).Suit Then
                    If (ftPlayer(xp).Hand(n).Value >= 7 And ftPlayer(xp).Hand(i).Value > ftPlayer(xp).Hand(n).Value) Or (ftPlayer(xp).Hand(n).Value <= 7 And ftPlayer(xp).Hand(i).Value < ftPlayer(xp).Hand(n).Value) Then
                        If Abs(ftPlayer(xp).Hand(n).Value - ftPlayer(xp).Hand(i).Value) > ftPlayer(xp).Hand(n).w(3) Then
                            ftPlayer(xp).Hand(n).w(3) = Abs(ftPlayer(xp).Hand(n).Value - ftPlayer(xp).Hand(i).Value)
                        End If
                    End If
                End If
            Next i
        End If
    Next n

    'Look to play card that with largest gap between playable card and worst card
    maxv = 0
    For n = 1 To ncards
        d = ftPlayer(xp).Hand(n).w(3) - ftPlayer(xp).Hand(n).w(4)
        If d = maxv Then
            xcard = 0
        End If
        If d > maxv Then
            maxv = d
            xcard = n
        End If
    Next n
    
    If xcard <> 0 Then
        BestCard = xcard
        Exit Function
    End If

    'Last resort, play card closest to worst card (A or K)
    maxv = 0
    For n = 1 To ncards
        If ftPlayer(xp).Hand(n).w(2) = maxv Then
            xcard = 0
        End If
        If ftPlayer(xp).Hand(n).w(2) > maxv Then
            maxv = ftPlayer(xp).Hand(n).w(2)
            xcard = n
        End If
    Next n

    If xcard <> 0 Then
        BestCard = xcard
        Exit Function
    End If

    If xcard = 0 Then
        For n = 1 To ncards
            If ftPlayer(xp).Hand(n).w(1) Then
                xcard = n
                Exit For
            End If
        Next n
    End If
    BestCard = xcard 'play anything for now
    
End Function

Function CardHitTest (xp As Integer, x As Integer, y As Integer) As Integer
    Dim n As Integer
    Dim rleft As Integer, rtop As Integer
    Dim rright As Integer, rbottom As Integer
    
    If xp = 1 Then
        rleft = xFirstCard(1)
        rtop = yFirstCard(1)
        rright = rleft + (CardsToPlay(1) * nOverlap + wCard)
        rbottom = rtop + hCard
    ElseIf xp = 2 Then
        rleft = xFirstCard(2)
        rtop = yFirstCard(2)
        rright = rleft + wCard
        rbottom = rtop + (CardsToPlay(2) * nOverlap + hCard)
    ElseIf xp = 3 Then
        rleft = xFirstCard(3) - (CardsToPlay(3) * nOverlap)
        rtop = yFirstCard(3)
        rright = xFirstCard(3) + wCard
        rbottom = rtop + hCard
        Debug.Print rleft, rright
    ElseIf xp = 4 Then
        rleft = xFirstCard(4)
        rtop = yFirstCard(4) - (CardsToPlay(4) * nOverlap)
        rright = rleft + wCard
        rbottom = yFirstCard(4) + hCard
    End If
    
    n = 0
    If x >= rleft And x < rright And y >= rtop And y < rbottom Then
        If xp = 1 Then
            n = Int((x - rleft) / nOverlap) + 1
        ElseIf xp = 2 Then
            n = Int((y - rtop) / nOverlap) + 1
        ElseIf xp = 3 Then
            n = Int((rright - x) / nOverlap) + 1
        ElseIf xp = 4 Then
            n = Int((rbottom - y) / nOverlap) + 1
        End If
        If n > CardsToPlay(xp) Then Let n = CardsToPlay(xp)
        'Debug.Print "clicked"; n; "th card"
        n = PlayableCard(xp, n)
        'Debug.Print "clicked card"; n
    End If
    
    CardHitTest = n
    
End Function

Function CardIndex (xp As Integer, scard As String) As Integer
    Dim i As Integer
    Dim xsuit As Integer
    Dim xvalue As Integer

    xsuit = Val(Mid$(scard, 1, 1))
    xvalue = Val(Mid$(scard, 2, 2))
    For i = 1 To ftPlayer(xp).ncards
        If xsuit = ftPlayer(xp).Hand(i).Suit And xvalue = ftPlayer(xp).Hand(i).Value Then
            CardIndex = i
            Exit Function
        End If
    Next i
    
    CardIndex = 0

End Function

Function CardsToPlay (xp As Integer) As Integer
    Dim i As Integer, n As Integer
    
    n = 0
    For i = 1 To ftPlayer(xp).ncards
        If ftPlayer(xp).Hand(i).Round = 0 Then
            n = n + 1
        End If
    Next i
    CardsToPlay = n
    
End Function

Sub CardToString ()

End Sub

Sub CreateDeck (ByVal deck As String)
    Dim ix As Integer
    
    For ix = 1 To 52
        ftDeck.Card(ix).Suit = Val(Left$(deck, 1))
        ftDeck.Card(ix).Value = Val(Mid$(deck, 2, 2))
        deck = Mid$(deck, 4)
    Next ix

    GameSetup

End Sub

Sub DealCards ()
    Dim ncards As Integer
    Dim xp As Integer, xr As Integer
    
    For xp = 1 To nPlayers
        ftPlayer(xp).ncards = 0
    Next xp
    
    xp = xDealer + 1
    If xp > nPlayers Then xp = 1
    xr = 1
    For ncards = 1 To 52
        ftPlayer(xp).Hand(xr) = ftDeck.Card(DealNextCard())
        ftPlayer(xp).ncards = ftPlayer(xp).ncards + 1
        ftPlayer(xp).Hand(xr).Round = 0
        xp = xp + 1
        If xp > nPlayers Then
            xp = 1
        End If
        If xp = xDealer + 1 Or (xDealer = nPlayers And xp = 1) Then
            xr = xr + 1
        End If
    Next ncards
    
    For xp = 1 To nPlayers
        ftPlayer(xp).HandScore = ftPlayer(xp).HandScore - 1
        AddToPot 1
        If Not ftPlayer(xp).fComputer And Not ftPlayer(xp).fRemote Then
            SortHand xp
        End If
    Next xp
        
End Sub

Function DealNextCard () As Integer
    If ftDeck.top > 52 Then
        DealNextCard = 0
        Exit Function
    End If
            
    DealNextCard = ftDeck.top
    ftDeck.top = ftDeck.top + 1
    
End Function

Sub DeckShuffle ()
    Dim n As Integer
    Dim ixn As Integer
    Dim ixv As Integer, ixo As Integer
    Dim c As Card
    
    n = 1
    For ixo = 1 To 4
        For ixv = 1 To 13
            ftDeck.Card(n).Suit = ixo
            ftDeck.Card(n).Value = ixv
            n = n + 1
        Next ixv
    Next ixo
    
    For ixn = 1 To 21 ' number of shuffles
        Randomize
        For ixv = 52 To 1 Step -1
            ixc = Int(ixv * Rnd) + 1
            c = ftDeck.Card(ixc)
            If ixc <> ixv Then
                Do
                    ftDeck.Card(ixc) = ftDeck.Card(ixc + 1)
                    ixc = ixc + 1
                Loop While ixc < ixv
                ftDeck.Card(ixv) = c
            End If
        Next ixv
        DoEvents
    Next ixn

    GameSetup
    
End Sub

Sub FanTan_Cleanup ()
    If cdt_state Then
        retv = cdtTerm()
        cdt_state = False
    End If

    UpdateIniFile
    
End Sub

Sub FanTan_Init ()
    Dim xp As Integer

    fCancel = False
    fDoSound = False
    fGameOver = False
    PassSound = "doe.wav"
    HelpFile = "fantan.hlp"
    ftStake = 100
    nSpeed = nAvgSpeed

    LoadIniFile

    If fDoSound = True And Len(Dir$(PassSound)) = 0 Then
        fDoSound = False
    End If
    
    If Not cdt_state Then
        retv = cdtInit(dxCard, dyCard)
        cdt_state = True
        
        wCard = dxCard
        hCard = dyCard
    
        xDealer = 0
        nPlayers = 4
    
        backCard = ordPlaid
        
        For xp = 1 To nPlayers
            ftPlayer(xp).Score = ftStake
            If xp > 1 Then ftPlayer(xp).fComputer = True
        Next xp
    End If
    
End Sub

Sub GameSetup ()
    Dim ixn As Integer

    fGameOver = False
    ftDeck.top = 1
    xDealer = xDealer + 1
    If xDealer > nPlayers Then
        xDealer = 1
    End If
    xCurPlayer = xDealer + 1
    If xCurPlayer > nPlayers Then
        xCurPlayer = 1
    End If
    ftGame.Round = 1
    ResetPot
    For ixn = 1 To 4
        ftGame.hiCard(ixn).Value = 0
        ftGame.hiCard(ixn).Suit = 0
        ftGame.loCard(ixn).Value = 0
        ftGame.loCard(ixn).Suit = 0
    Next ixn
    For xp = 1 To nPlayers
        ftPlayer(xp).HandScore = 0
        ftPlayer(xp).nMisplays = 0
    Next xp
    
End Sub

Sub GetHelp ()
    Dim retv As Integer

    retv = WinHelp(TableForm.hWnd, HelpFile, 9, 0)

End Sub

Function GetMinTableHeight () As Integer
    GetMinTableHeight = 4 * hCard + 4 * nsGap + 4

End Function

Function GetMinTableWidth () As Integer
    GetMinTableWidth = 6 * wCard + 5 * nsGap + 2 * nbGap

End Function

Function GetNetCode (sbuf As String) As Integer
    Dim cmd As String
    Dim pos As Integer

    pos = InStr(sbuf, NL)
    If pos = 0 Then
        Exit Function
    End If
    cmd = Left$(sbuf, pos - 1)
    sbuf = Mid$(sbuf, pos + 1)
    NetMessage = 0
    If Left$(cmd, 2) = NS_PLAYERID Then
        NetMessage = NC_PLAYERID
        NetNumArg = Val(Mid$(cmd, 4))
    ElseIf Left$(cmd, 2) = NS_PLAYERNAME Then
        NetMessage = NC_PLAYERNAME
        NetNumArg = Val(Mid$(cmd, 4, 1))
        NetStrArg = Trim$(Mid$(cmd, 6))
    ElseIf Left$(cmd, 2) = NS_GAMESTART Then
        NetMessage = NC_GAMESTART
    ElseIf Left$(cmd, 2) = NS_GAMEOVER Then
        NetMessage = NC_GAMEOVER
        NetNumArg = Val(Mid$(cmd, 4, 1))
    ElseIf Left$(cmd, 2) = NS_OK Then
        NetMessage = NC_OK
    ElseIf Left$(cmd, 2) = NS_DECK Then
        NetMessage = NC_DECK
        NetStrArg = Trim$(Mid$(cmd, 4))
    ElseIf Left$(cmd, 2) = NS_DEALER Then
        NetMessage = NC_DEALER
        NetNumArg = Val(Mid$(cmd, 4, 1))
    ElseIf Left$(cmd, 2) = NS_PLAYCARD Then
        NetMessage = NC_PLAYCARD
        NetNumArg = Val(Mid$(cmd, 4, 1))
        NetStrArg = Trim$(Mid$(cmd, 6))
    ElseIf Left$(cmd, 2) = NS_PASS Then
        NetMessage = NC_PASS
        NetNumArg = Val(Mid$(cmd, 4, 1))
    ElseIf Left$(cmd, 2) = NS_SAY Then
        NetMessage = NC_SAY
        NetNumArg = Val(Mid$(cmd, 4, 2))
        NetStrArg = Trim$(Mid$(cmd, 6))
    End If

    GetNetCode = NetMessage

End Function

Function GetPlayerName (xp As Integer) As String
    GetPlayerName = ftPlayer(xp).Name

End Function

Function GetProfileStr (profile As String) As String
    Dim i As Integer
    Dim fn As String
    Dim gotsection As Integer
    Dim pathenv As String
    Dim textline As String
    Dim section As String, envvar As String

    GetProfileStr = ""
    If Len(ftIniFile) = 0 Then
        pathenv = Environ$("PATH")
        i = 0
        On Error GoTo CatchErr
        Do
            If i = 0 Then
                fn = "fantan.ini"
                If Len(Dir$(fn)) = 0 Then fn = ""
            Else
                fn = SubStr(pathenv, i, ";")
                If Len(fn) > 0 Then
                    fn = fn + "\" + "fantan.ini"
                    If Len(Dir$(fn)) = 0 Then fn = ""
                Else
                    Exit Function
                End If
            End If
            i = i + 1
        Loop While Len(fn) = 0
        On Error GoTo 0
        ftIniFile = fn
    End If
    
    gotsection = False
    section = "[" + SubStr(profile, 1, ":") + "]"
    envvar = SubStr(profile, 2, ":")
    ch = FreeFile
    Open ftIniFile For Input Access Read As #ch
    Do While Not EOF(ch)
        Line Input #ch, textline
        If StrComp(textline, section, 1) = 0 Then
            gotsection = True
        Else
            If gotsection And Mid$(textline, 1, 1) = "[" Then gotsection = False
        End If
        If gotsection And StrComp(SubStr(textline, 1, "="), envvar, 1) = 0 Then
            GetProfileStr = SubStr(textline, 2, "=")
            Close #ch
            Exit Function
        End If
    Loop
    Close #ch
    Exit Function

CatchErr:
    fn = ""
    Resume Next

End Function

Function IsCardPlayable (xp As Integer, xcard As Integer) As Integer
    Dim acard As Card
    
    If ftPlayer(xp).Hand(xcard).Round <> 0 Then
        IsCardPlayable = False
        Exit Function
    End If
    
    acard = ftPlayer(xp).Hand(xcard)
    'Debug.Print "checking card"; xcard; "value is"; acard.Value
    If acard.Value = 7 Then
        IsCardPlayable = True 'always playable
    ElseIf acard.Value < 7 Then
        If acard.Value = ftGame.loCard(acard.Suit).Value - 1 Then
            IsCardPlayable = True
        Else
            IsCardPlayable = False
        End If
    Else
        If acard.Value = ftGame.hiCard(acard.Suit).Value + 1 Then
            IsCardPlayable = True
        Else
            IsCardPlayable = False
        End If
    End If
    
End Function

Function IsComputerPlayer (xp As Integer) As Integer
    If ftPlayer(xp).fComputer Then
        IsComputerPlayer = True
    Else
        IsComputerPlayer = False
    End If
    
End Function

Function IsRemotePlayer (xp As Integer) As Integer
    If ftPlayer(xp).fRemote Then
        IsRemotePlayer = True
    Else
        IsRemotePlayer = False
    End If
    
End Function

Sub LoadIniFile ()
    Dim v As Integer
    Dim pname As String

    If fDebug = 0 Then
        fDebug = Val(GetProfileStr("FanTan:Debug"))
    End If

    pstr = GetProfileStr("Fantan:Stake")
    If Len(pstr) > 0 Then ftStake = Val(pstr)
    pstr = GetProfileStr("Fantan:Sound")
    If Len(pstr) > 0 Then fDoSound = Val(pstr)
    pstr = GetProfileStr("Fantan:PassSoundFile")
    If Len(pstr) > 0 Then PassSound = pstr

    SetPlayerName 1, GetProfileStr("Fantan:PlayerName")
    For v = 1 To 3
        pname = GetProfileStr("Fantan:Player" + Format$(v))
        If Len(pname) > 0 Then
            gPlayerName(v) = pname
        End If
    Next v

    pstr = GetProfileStr("Fantan:Speed")
    If Len(pstr) > 0 Then nSpeed = Val(pstr)

End Sub

Function MyNetID () As Integer
    MyNetID = ftPlayer(1).NetID

End Function

Function NewRemotePlayer (x As Integer) As Integer
    Dim xp As Integer

    For xp = 2 To nPlayers
        If ftPlayer(xp).fComputer Then
            ftPlayer(xp).fComputer = False
            ftPlayer(xp).fRemote = True
            ftPlayer(xp).xSocket = x
            NewRemotePlayer = xp
            Exit Function
        End If
    Next xp

    NewRemotePlayer = 0 'no room for more players

End Function

Sub OnPaint ()
    Dim c As Card
    Dim retv As Integer
    Dim ncards As Integer
    Dim xsuit As Integer
    Dim xp As Integer, xr As Integer
    ReDim x(4) As Integer, y(4) As Integer
    ReDim rleft(4) As Integer, rtop(4) As Integer
    Dim v As Integer
    Dim w As Integer, h As Integer
    Dim hdcHand, hbmpHand, hbrush, hpen
    Dim cplanes As Integer, cpixelbits As Integer
    
    x(1) = wTable / 2 - (((CardsToPlay(1) - 1) * nOverlap + wCard) / 2) - 3
    y(1) = hTable - hCard - nsGap
    x(2) = nsGap
    y(2) = hTable / 2 - (((CardsToPlay(2) - 1) * nOverlap + hCard) / 2) - 3
    x(3) = wTable / 2 + (((CardsToPlay(3) - 1) * nOverlap + wCard) / 2) - wCard - 3
    y(3) = nsGap
    x(4) = wTable - nsGap - wCard
    y(4) = hTable / 2 + (((CardsToPlay(4) - 1) * nOverlap + hCard) / 2) - hCard - 3
    rleft(1) = x(1)
    rtop(1) = y(1)
    rleft(2) = x(2)
    rtop(2) = y(2)
    rleft(3) = x(3) - (CardsToPlay(3) - 1) * nOverlap
    rtop(3) = y(3)
    rleft(4) = x(4)
    rtop(4) = y(4) - (CardsToPlay(4) - 1) * nOverlap

    If fGameOver Then
        x(3) = wTable / 2 - (((CardsToPlay(3) - 1) * nOverlap + wCard) / 2) - 3
        y(4) = hTable / 2 - (((CardsToPlay(4) - 1) * nOverlap + hCard) / 2) - 3
        rleft(3) = x(3)
        rtop(4) = y(4)
    End If
    
    For xp = 1 To nPlayers
        xFirstCard(xp) = x(xp)
        yFirstCard(xp) = y(xp)
    Next xp

    hdcHand = CreateCompatibleDC(TableForm.hDC)
    cplanes = GetDeviceCaps(hdcHand, 14) 'PLANES
    cpixelbits = GetDeviceCaps(hdcHand, 12) 'BITSPIXEL
    hbmpHand = CreateBitmap(12 * nOverlap + wCard, 12 * nOverlap + hCard, cplanes, cpixelbits, 0&)
    hbmpHand = SelectObject(hdcHand, hbmpHand)
    hpen = CreatePen(0, 1, TableForm.BackColor)
    hbrush = CreateSolidBrush(TableForm.BackColor)
    hpen = SelectObject(hdcHand, hpen)
    hbrush = SelectObject(hdcHand, hbrush)

    For xp = 1 To nPlayers
        If xp = 1 Or xp = 3 Then
            w = (CardsToPlay(xp) - 1) * nOverlap + wCard
            h = hCard
        ElseIf xp = 2 Or xp = 4 Then
            w = wCard
            h = (CardsToPlay(xp) - 1) * nOverlap + hCard
        End If
        
        retv = Rectangle(hdcHand, 0, 0, w, h)

        For xr = 1 To ftPlayer(xp).ncards
            c = ftPlayer(xp).Hand(xr)
            If c.Round = 0 Then
                v = xcdt(c.Value, c.Suit)
                If v >= 0 And v <= 51 Then
                    If Not fGameOver And (ftPlayer(xp).fComputer Or ftPlayer(xp).fRemote) Then
                        retv = cdtDraw(hdcHand, x(xp) - rleft(xp), y(xp) - rtop(xp), backCard, ordBacks, TableForm.BackColor)
                    Else
                        retv = cdtDraw(hdcHand, x(xp) - rleft(xp), y(xp) - rtop(xp), v, ordFaces, 0&)
                    End If
                End If
                If xp = 1 Or (fGameOver And xp = 3) Then
                    x(xp) = x(xp) + nOverlap
                ElseIf xp = 2 Or (fGameOver And xp = 4) Then
                    y(xp) = y(xp) + nOverlap
                ElseIf xp = 3 Then
                    x(xp) = x(xp) - nOverlap
                ElseIf xp = 4 Then
                    y(xp) = y(xp) - nOverlap
                End If
            End If
        Next xr

        If xp = 1 Or (fGameOver And xp = 3) Then
            x(xp) = xFirstCard(xp)
        ElseIf xp = 2 Or (fGameOver And xp = 4) Then
            y(xp) = yFirstCard(xp)
        ElseIf xp = 3 Then
            x(xp) = x(xp) + nOverlap
        ElseIf xp = 4 Then
            y(xp) = y(xp) + nOverlap
        End If
        
        retv = BitBlt(TableForm.hDC, x(xp), y(xp), w, h, hdcHand, 0, 0, SRCCOPY)
    
    Next xp
    
    'Paint cards played
    x(1) = wTable / 2 - 2 * wCard - nsGap - Int(nsGap / 2)
    y(1) = hTable / 2
    x(2) = x(1) + wCard + nsGap
    y(2) = y(1)
    x(3) = x(2) + wCard + nsGap
    y(3) = y(2)
    x(4) = x(3) + wCard + nsGap
    y(4) = y(3)
    For xsuit = 1 To 4
        rleft(xsuit) = x(xsuit)
        rtop(xsuit) = y(xsuit) - hCard - 2
    Next xsuit
    
    For xsuit = 1 To 4
        xPlayArea(xsuit) = x(xsuit)
        yPlayArea(xsuit) = y(xsuit)
        retv = Rectangle(hdcHand, 0, 0, wCard, hCard * 2 + 4)
        If ftGame.hiCard(xsuit).Value <> 13 Or ftGame.loCard(xsuit).Value <> 1 Then
            retv = cdtDraw(hdcHand, x(xsuit) - rleft(xsuit), y(xsuit) - hCard - 2 - rtop(xsuit), ordCrossHatch, ordBacks, TableForm.BackColor)
            retv = cdtDraw(hdcHand, x(xsuit) - rleft(xsuit), y(xsuit) + 2 - rtop(xsuit), ordCrossHatch, ordBacks, TableForm.BackColor)
        End If
        If ftGame.hiCard(xsuit).Value >= 7 Then
            If ftGame.hiCard(xsuit).Value = 13 And ftGame.loCard(xsuit).Value = 1 Then
                retv = cdtDraw(hdcHand, x(xsuit) - rleft(xsuit), y(xsuit) - Int(hCard / 2) - rtop(xsuit), backCard, ordBacks, 0&)
            Else
                v = xcdt(7, xsuit)
                retv = cdtDraw(hdcHand, x(xsuit) - rleft(xsuit), y(xsuit) - Int(hCard / 2) - rtop(xsuit), v, ordFaces, 0&)
                If ftGame.hiCard(xsuit).Value > 7 Then
                    v = xcdt(ftGame.hiCard(xsuit).Value, xsuit)
                    retv = cdtDraw(hdcHand, x(xsuit) - rleft(xsuit), y(xsuit) - hCard - 2 - rtop(xsuit), v, ordFaces, 0&)
                End If
                If ftGame.loCard(xsuit).Value < 7 And ftGame.loCard(xsuit).Value > 0 Then
                    v = xcdt(ftGame.loCard(xsuit).Value, xsuit)
                    retv = cdtDraw(hdcHand, x(xsuit) - rleft(xsuit), y(xsuit) + 2 - rtop(xsuit), v, ordFaces, 0&)
                End If
            End If
        End If
        retv = BitBlt(TableForm.hDC, rleft(xsuit), rtop(xsuit), wCard, hCard * 2 + 4, hdcHand, 0, 0, SRCCOPY)
    Next xsuit
    
    hbmpHand = SelectObject(hdcHand, hbmpHand)
    hbrush = SelectObject(hdcHand, hbrush)
    hpen = SelectObject(hdcHand, hpen)
    retv = DeleteObject(hbrush)
    retv = DeleteObject(hpen)
    retv = DeleteObject(hbmpHand)
    retv = DeleteDC(hdcCard)
    
End Sub

Sub PaintTable ()
    Dim c As Card
    Dim retv As Integer
    Dim ncards As Integer
    Dim xsuit As Integer
    Dim xp As Integer, xr As Integer
    ReDim x(4) As Integer, y(4) As Integer
    Dim v As Integer
    
    x(1) = wTable / 2 - (((CardsToPlay(1) - 1) * nOverlap + wCard) / 2) - 3
    y(1) = hTable - hCard - nsGap
    x(2) = nsGap
    y(2) = hTable / 2 - (((CardsToPlay(2) - 1) * nOverlap + hCard) / 2) - 3
    x(3) = wTable / 2 + (((CardsToPlay(3) - 1) * nOverlap + wCard) / 2) - wCard - 3
    y(3) = nsGap
    x(4) = wTable - nsGap - wCard
    y(4) = hTable / 2 + (((CardsToPlay(4) - 1) * nOverlap + hCard) / 2) - hCard - 3
    
    If fGameOver Then
        x(3) = wTable / 2 - (((CardsToPlay(3) - 1) * nOverlap + wCard) / 2) - 3
        y(4) = hTable / 2 - (((CardsToPlay(4) - 1) * nOverlap + hCard) / 2) - 3
    End If

    For xp = 1 To nPlayers
        xFirstCard(xp) = x(xp)
        yFirstCard(xp) = y(xp)
    Next xp
    
    xp = xDealer + 1
    If xp > nPlayers Then xp = 1
    xr = 1
    For ncards = 1 To 52
        c = ftPlayer(xp).Hand(xr)
        If c.Round = 0 Then
            v = xcdt(c.Value, c.Suit)
            If v >= 0 And v <= 51 Then
                If Not fGameOver And (ftPlayer(xp).fComputer Or ftPlayer(xp).fRemote) Then
                    retv = cdtDraw(TableForm.hDC, x(xp), y(xp), backCard, ordBacks, TableForm.BackColor)
                Else
                    retv = cdtDraw(TableForm.hDC, x(xp), y(xp), v, ordFaces, 0&)
                End If
            End If
            If xp = 1 Or (fGameOver And xp = 3) Then
                x(xp) = x(xp) + nOverlap
            ElseIf xp = 2 Or (fGameOver And xp = 4) Then
                y(xp) = y(xp) + nOverlap
            ElseIf xp = 3 Then
                x(xp) = x(xp) - nOverlap
            ElseIf xp = 4 Then
                y(xp) = y(xp) - nOverlap
            End If
        End If
        xp = xp + 1
        If xp > nPlayers Then
            xp = 1
        End If
        If xp = xDealer + 1 Or (xDealer = nPlayers And xp = 1) Then
            xr = xr + 1
        End If
    Next ncards
    
    'Paint cards played
    x(1) = wTable / 2 - 2 * wCard - nsGap - Int(nsGap / 2)
    y(1) = hTable / 2
    x(2) = x(1) + wCard + nsGap
    y(2) = y(1)
    x(3) = x(2) + wCard + nsGap
    y(3) = y(2)
    x(4) = x(3) + wCard + nsGap
    y(4) = y(3)
    
    For xsuit = 1 To 4
        xPlayArea(xsuit) = x(xsuit)
        yPlayArea(xsuit) = y(xsuit)
        If ftGame.hiCard(xsuit).Value <> 13 Or ftGame.loCard(xsuit).Value <> 1 Then
            retv = cdtDraw(TableForm.hDC, x(xsuit), y(xsuit) - hCard - 2, ordCrossHatch, ordBacks, TableForm.BackColor)
            retv = cdtDraw(TableForm.hDC, x(xsuit), y(xsuit) + 2, ordCrossHatch, ordBacks, TableForm.BackColor)
        End If
    Next xsuit
    
    For xsuit = 1 To 4
        If ftGame.hiCard(xsuit).Value >= 7 Then
            If ftGame.hiCard(xsuit).Value = 13 And ftGame.loCard(xsuit).Value = 1 Then
                retv = cdtDraw(TableForm.hDC, x(xsuit), y(xsuit) - Int(hCard / 2), backCard, ordBacks, 0&)
            Else
                v = xcdt(7, xsuit)
                retv = cdtDraw(TableForm.hDC, x(xsuit), y(xsuit) - Int(hCard / 2), v, ordFaces, 0&)
                If ftGame.hiCard(xsuit).Value > 7 Then
                    v = xcdt(ftGame.hiCard(xsuit).Value, xsuit)
                    retv = cdtDraw(TableForm.hDC, x(xsuit), y(xsuit) - hCard - 2, v, ordFaces, 0&)
                End If
                If ftGame.loCard(xsuit).Value < 7 And ftGame.loCard(xsuit).Value > 0 Then
                    v = xcdt(ftGame.loCard(xsuit).Value, xsuit)
                    retv = cdtDraw(TableForm.hDC, x(xsuit), y(xsuit) + 2, v, ordFaces, 0&)
                End If
            End If
        End If
    Next xsuit
    
End Sub

Function PlayableCard (xp As Integer, nth As Integer) As Integer
    Dim i As Integer
    
    i = 0
    Do
        i = i + 1
        If ftPlayer(xp).Hand(i).Round = 0 Then
            nth = nth - 1
        End If
    Loop Until nth = 0
    PlayableCard = i
    
End Function

Sub PlayCard (xp As Integer, xcard As Integer)
    Dim acard As Card
    
    acard = ftPlayer(xp).Hand(xcard)
    If IsCardPlayable(xp, xcard) Then
        If acard.Value = 7 Then
            ftGame.hiCard(acard.Suit).Value = 7
            ftGame.loCard(acard.Suit).Value = 7
        ElseIf acard.Value < 7 Then
            ftGame.loCard(acard.Suit).Value = acard.Value
        Else
            ftGame.hiCard(acard.Suit).Value = acard.Value
        End If
        ftGame.hiCard(acard.Suit).Suit = acard.Suit
        ftGame.loCard(acard.Suit).Suit = acard.Suit
        ftPlayer(xp).Hand(xcard).Round = ftGame.Round
        If xp = xDealer Then
            ftGame.Round = ftGame.Round + 1
        End If
        AnimatePlayCard xp, xcard
        QuickPaint xp, xcard
        xCurPlayer = xCurPlayer + 1
        If xCurPlayer > nPlayers Then
            xCurPlayer = 1
        End If
    End If
    
End Sub

Function PlayerCanPlay (xp As Integer) As Integer
    If ftPlayer(xp).fComputer Or ftPlayer(xp).fRemote Then
        PlayerCanPlay = False
    Else
        PlayerCanPlay = True
    End If

End Function

Sub PlayPass ()
    Dim ix As Integer

    'check if player really had a playable card
    nchips = 1
    For ix = 1 To ftPlayer(xCurPlayer).ncards
        If IsCardPlayable(xCurPlayer, ix) Then
            ftPlayer(xCurPlayer).nMisplays = ftPlayer(xCurPlayer).nMisplays + 1
            Exit For
        End If
    Next ix
    
    If fDoSound = True And Len(PassSound) > 0 Then
        TableForm.Player.FileName = PassSound
        TableForm.Player.Command = "Sound"
    End If

    ftPlayer(xCurPlayer).HandScore = ftPlayer(xCurPlayer).HandScore - 1
    AddToPot 1
    xCurPlayer = xCurPlayer + 1
    If xCurPlayer > nPlayers Then
        xCurPlayer = 1
    End If
    
End Sub

Sub QuickPaint (xp As Integer, xcard As Integer)
    Dim acard As Card, pcard As Card
    Dim more As Integer
    Dim i As Integer
    Dim x As Integer, y As Integer, v As Integer, n As Integer
    Dim hdcCard, hbmpCard, hbmpOld, hbrush, hpen
    Dim cplanes As Integer, cpixelbits As Integer
    Dim rleft As Integer, rtop As Integer
    Dim rright As Integer, rbottom As Integer
    
    n = CardsToPlay(xp)
    more = False
    For i = xcard + 1 To ftPlayer(xp).ncards
        If ftPlayer(xp).Hand(i).Round = 0 Then
            more = True
            Exit For
        End If
    Next i
    xecard = 0
    If Not more Then
        For i = xcard - 1 To 1 Step -1
            If ftPlayer(xp).Hand(i).Round = 0 Then
                xecard = i
                Exit For
            End If
        Next i
    End If
        
    i = 0
    xwc = 0
    Do
        i = i + 1
        If ftPlayer(xp).Hand(i).Round = 0 Then
            xwc = xwc + 1
        End If
    Loop Until i = xcard
    xwc = xwc + 1 ' account for card just played
    
    If Not more And xecard Then
        acard = ftPlayer(xp).Hand(xecard)
    End If
    
    x = (xwc - 1) * nOverlap + Int(nOverlap / 2)
    If xp = 1 Then
        rleft = xFirstCard(1) - nOverlap
        rtop = yFirstCard(1)
        rright = xFirstCard(1) + (CardsToPlay(1) * nOverlap + wCard) + nOverlap
        rbottom = rtop + hCard
        splice = xFirstCard(1) + x
    ElseIf xp = 2 Then
        rleft = xFirstCard(2)
        rtop = yFirstCard(2) - nOverlap
        rright = rleft + wCard
        rbottom = yFirstCard(2) + (CardsToPlay(2) * nOverlap + hCard) + nOverlap
        splice = yFirstCard(2) + x
    ElseIf xp = 3 Then
        rleft = xFirstCard(3) - (CardsToPlay(3) * nOverlap) - nOverlap
        rtop = yFirstCard(3)
        rright = xFirstCard(3) + wCard + nOverlap
        rbottom = rtop + hCard
        splice = xFirstCard(3) + wCard - x
        If fGameOver Then
            rleft = xFirstCard(3) - nOverlap
            rright = xFirstCard(3) + (CardsToPlay(3) * nOverlap + wCard) + nOverlap
            splice = xFirstCard(3) + x
        End If
    ElseIf xp = 4 Then
        rleft = xFirstCard(4)
        rtop = yFirstCard(4) - (CardsToPlay(4) * nOverlap) - nOverlap
        rright = rleft + wCard
        rbottom = yFirstCard(4) + hCard + nOverlap
        splice = yFirstCard(4) + hCard - x
        If fGameOver Then
            rtop = yFirstCard(4) - nOverlap
            rbottom = yFirstCard(4) + (CardsToPlay(4) * nOverlap + hCard) + nOverlap
            splice = yFirstCard(4) + x
        End If
    End If
    
    hdcCard = CreateCompatibleDC(TableForm.hDC)
    cplanes = GetDeviceCaps(hdcCard, 14) 'PLANES
    cpixelbits = GetDeviceCaps(hdcCard, 12) 'BITSPIXEL
    hbmpCard = CreateBitmap(rright - rleft, rbottom - rtop, cplanes, cpixelbits, 0&)
    hbmpOld = SelectObject(hdcCard, hbmpCard)
    
    If xp = 1 Or xp = 3 Then
        retv = BitBlt(hdcCard, 0, 0, splice - rleft, hCard, TableForm.hDC, rleft, rtop, SRCCOPY)
        retv = BitBlt(hdcCard, (splice - rleft) - Int(nOverlap / 2), 0, rright - splice, hCard, TableForm.hDC, splice + Int(nOverlap / 2), rtop, SRCCOPY)
        retv = BitBlt(TableForm.hDC, rleft + nOverlap, rtop, n * nOverlap + wCard, hCard, hdcCard, Int(nOverlap / 2), 0, SRCCOPY)
        If xp = 1 Or (fGameOver And xp = 3) Then
            xFirstCard(xp) = xFirstCard(xp) + Int(nOverlap / 2)
            TableForm.PlayerName(xp - 1).left = TableForm.PlayerName(xp - 1).left + Int(nOverlap / 2)
        Else
            xFirstCard(xp) = xFirstCard(xp) - Int(nOverlap / 2)
            TableForm.PlayerName(xp - 1).left = TableForm.PlayerName(xp - 1).left - Int(nOverlap / 2)
        End If
    Else
        retv = BitBlt(hdcCard, 0, 0, wCard, splice - rtop, TableForm.hDC, rleft, rtop, SRCCOPY)
        retv = BitBlt(hdcCard, 0, (splice - rtop) - Int(nOverlap / 2), wCard, rbottom - splice, TableForm.hDC, rleft, splice + Int(nOverlap / 2), SRCCOPY)
        retv = BitBlt(TableForm.hDC, rleft, rtop + nOverlap, wCard, n * nOverlap + hCard, hdcCard, 0, Int(nOverlap / 2), SRCCOPY)
        If xp = 2 Or (fGameOver And xp = 4) Then
            yFirstCard(xp) = yFirstCard(xp) + Int(nOverlap / 2)
            TableForm.PlayerName(xp - 1).top = TableForm.PlayerName(xp - 1).top + Int(nOverlap / 2)
        Else
            yFirstCard(xp) = yFirstCard(xp) - Int(nOverlap / 2)
            TableForm.PlayerName(xp - 1).top = TableForm.PlayerName(xp - 1).top - Int(nOverlap / 2)
        End If
    End If
    
    retv = SelectObject(hdcCard, hbmpOld)
    retv = DeleteObject(hbmpCard)
    retv = DeleteDC(hdcCard)
    
    If Not more And xecard Then
        If xp = 1 Or (fGameOver And xp = 3) Then
            x = xFirstCard(1) + (n - 1) * nOverlap
            y = yFirstCard(1)
        ElseIf xp = 2 Or (fGameOver And xp = 4) Then
            x = xFirstCard(2)
            y = yFirstCard(2) + (n - 1) * nOverlap
        ElseIf xp = 3 Then
            x = xFirstCard(3) - ((n - 1) * nOverlap)
            y = yFirstCard(3)
        ElseIf xp = 4 Then
            x = xFirstCard(4)
            y = yFirstCard(4) - ((n - 1) * nOverlap)
        End If
        If Not fGameOver And (ftPlayer(xp).fComputer Or ftPlayer(xp).fRemote) Then
            retv = cdtDraw(TableForm.hDC, x, y, backCard, ordBacks, 0&)
        Else
            v = xcdt(acard.Value, acard.Suit)
            retv = cdtDraw(TableForm.hDC, x, y, v, ordFaces, 0&)
        End If
    End If
    
    If Not more And xecard = 0 Then
        hpen = CreatePen(0, 1, TableForm.BackColor)
        hbrush = CreateSolidBrush(TableForm.BackColor)
        hpen = SelectObject(TableForm.hDC, hpen)
        hbrush = SelectObject(TableForm.hDC, hbrush)
        retv = Rectangle(TableForm.hDC, rleft, rtop, rright, rbottom)
        hbrush = SelectObject(TableForm.hDC, hbrush)
        hpen = SelectObject(TableForm.hDC, hpen)
        retv = DeleteObject(hbrush)
        retv = DeleteObject(hpen)
    End If
    
    'Put card onto play area
    pcard = ftPlayer(xp).Hand(xcard)
    v = xcdt(pcard.Value, pcard.Suit)
    If pcard.Value = 7 Then
        y = yPlayArea(pcard.Suit) - Int(hCard / 2)
    ElseIf pcard.Value > 7 Then
        y = yPlayArea(pcard.Suit) - hCard - 2
    ElseIf pcard.Value < 7 Then
        y = yPlayArea(pcard.Suit) + 2
    End If
    retv = cdtDraw(TableForm.hDC, xPlayArea(pcard.Suit), y, v, ordFaces, 0&)
    
    If (pcard.Value = 1 And ftGame.hiCard(pcard.Suit).Value = 13) Or (pcard.Value = 13 And ftGame.loCard(pcard.Suit).Value = 1) Then
        AnimateClose pcard.Suit
    End If
    
End Sub

Sub ResetPlayerName (xp As Integer)
    Load OptionsForm
    SetPlayerName xp, OptionsForm.PlayerName(xp - 2).Text
    Unload OptionsForm

End Sub

Sub ResetPot ()
    ftGame.Pot = 0
    TableForm.Pot.Caption = "0"

End Sub

Sub SetCardSize (wform As Integer, hform As Integer)

End Sub

Sub SetModeToComputer (xp As Integer)
    ftPlayer(xp).fRemote = False
    ftPlayer(xp).xSocket = 0
    ftPlayer(xp).fComputer = True
    ResetPlayerName (xp)

End Sub

Sub SetMyNetID (id As Integer)
    ftPlayer(1).NetID = id
    For xp = 2 To 4
        id = id + 1
        If id > nPlayers Then id = 1
        ftPlayer(xp).NetID = id
    Next xp

End Sub

Sub SetNetPlayer (nid As Integer, pname As String)
    Dim xp As Integer

    If nid = ftPlayer(1).NetID Then
        Exit Sub 'we know who we are
    End If

    For xp = 2 To 4
        If ftPlayer(xp).NetID = nid Then
            ftPlayer(xp).fComputer = False
            ftPlayer(xp).fRemote = True
            ftPlayer(xp).NetID = nid
            ftPlayer(xp).Name = pname
            Exit For
        End If
    Next xp

End Sub

Sub SetNumPlayers (n As Integer)
    nPlayers = n

End Sub

Sub SetPlayerName (xp As Integer, ByVal pname As String)
    ftPlayer(xp).Name = pname

End Sub

Sub SetTableSize (w As Integer, h As Integer)
    wTable = w
    hTable = h
    
End Sub

Sub ShowNotPlayable (xcard As Integer)
    Dim sec As Integer
    Dim xc As Integer, xcd As Integer
    Dim pcard As Card, v As Integer
    Dim srcrect As RECT
    Dim hdcbg, hdmpbg, hdcwork, hbmpwork
                       
    If xcard = 0 Then
        Beep
        Exit Sub
    End If

    xcd = 0
    For xc = 1 To xcard - 1
        If ftPlayer(1).Hand(xc).Round = 0 Then
            xcd = xcd + 1
        End If
    Next xc

    srcrect.left = xFirstCard(1) + xcd * nOverlap
    srcrect.top = yFirstCard(1)
    srcrect.right = srcrect.left + wCard
    srcrect.bottom = srcrect.top + hCard

    pcard = ftPlayer(1).Hand(xcard)
    v = xcdt(pcard.Value, pcard.Suit)

    hdcbg = CreateCompatibleDC(TableForm.hDC)
    cplanes = GetDeviceCaps(hdcbg, 14) 'PLANES
    cpixelbits = GetDeviceCaps(hdcbg, 12) 'BITSPIXEL
    hbmpbg = CreateBitmap(wCard, hCard, cplanes, cpixelbits, 0&)
    hbmpbg = SelectObject(hdcbg, hbmpbg)
    
    hdcwork = CreateCompatibleDC(TableForm.hDC)
    cplanes = GetDeviceCaps(hdcwork, 14) 'PLANES
    cpixelbits = GetDeviceCaps(hdcwork, 12) 'BITSPIXEL
    hbmpwork = CreateBitmap(wCard, hCard, cplanes, cpixelbits, 0&)
    hbmpwork = SelectObject(hdcwork, hbmpwork)
    
    retv = BitBlt(hdcbg, 0, 0, wCard, hCard, TableForm.hDC, srcrect.left, srcrect.top, SRCCOPY)
    retv = cdtDraw(hdcwork, 0, 0, v, ordFaces, 0&)
    retv = BitBlt(hdcwork, 0, 0, wCard, hCard, 0, 0, 0, DSTINVERT)
    retv = BitBlt(TableForm.hDC, srcrect.left, srcrect.top, wCard, hCard, hdcwork, 0, 0, SRCCOPY)
    sec = Second(Now)
    Do
    Loop Until Second(Now) <> sec
    retv = BitBlt(TableForm.hDC, srcrect.left, srcrect.top, wCard, hCard, hdcbg, 0, 0, SRCCOPY)

    hbmpwork = SelectObject(hdcwork, hbmpwork)
    retv = DeleteObject(hbmpwork)
    retv = DeleteObject(hdcwork)
    hbmpbg = SelectObject(hdcbg, hbmpbg)
    retv = DeleteObject(hbmpbg)
    retv = DeleteObject(hdcbg)

End Sub

Sub SortHand (xp As Integer)
    Dim i As Integer, j As Integer
    Dim ci As Card, cj As Card
    
    For i = 1 To ftPlayer(xp).ncards
        ci = ftPlayer(xp).Hand(i)
        For j = i + 1 To ftPlayer(xp).ncards
            cj = ftPlayer(xp).Hand(j)
            If cj.Suit < ci.Suit Or (cj.Suit = ci.Suit And cj.Value < ci.Value) Then
                ftPlayer(xp).Hand(i) = cj
                ftPlayer(xp).Hand(j) = ci
                ci = cj
            End If
        Next j
    Next i
    
End Sub

Function StrCard (xp As Integer, xcard As Integer) As String
    Dim v As Integer

    v = ftPlayer(xp).Hand(xcard).Suit * 100 + ftPlayer(xp).Hand(xcard).Value
    StrCard = Format$(v, "###")
    
End Function

Function SubStr (fieldstr As String, pos As Integer, delim As String) As String
    Dim tlen As Integer
    Dim i As Integer, n As Integer, s As Integer

    tlen = Len(fieldstr)
    n = 0
    s = 1
    For i = 1 To tlen
        If Mid$(fieldstr, i, 1) = delim Then n = n + 1
        If n = pos Then
            If i - s <= 0 Then
                SubStr = ""
                Exit Function
            End If
            SubStr = Mid$(fieldstr, s, i - s)
            Exit Function
        End If
        If Mid$(fieldstr, i, 1) = delim Then s = i + 1
    Next
    If n + 1 = pos Then
        SubStr = Mid$(fieldstr, s)
    Else
        SubStr = ""
    End If

End Function

Sub UpdateIniFile ()
    Dim ch As Integer
    Dim i As Integer
    Dim pname As String
    Dim windir As String

    If Len(ftIniFile) = 0 Then
        windir = String$(128, " ")
        retv = GetWindowsDirectory(windir, 128)
        windir = Trim$(windir)
        Do While Right$(windir, 1) = Chr$(0)
            windir = Left$(windir, Len(windir) - 1)
        Loop
        ftIniFile = windir + "\fantan.ini"
    End If

    ch = FreeFile
    On Error Resume Next
    Kill ftIniFile
    Open ftIniFile For Output Access Write As #ch
    
    '[Fantan] section
    Print #ch, "[Fantan]"
    If fDebug Then
        Print #ch, "Debug=1"
    End If
    Print #ch, "Stake="; Format$(ftStake)
    Print #ch, "PlayerName="; GetPlayerName(1)
    For i = 1 To 3
        pname = gPlayerName(i)
        If Len(pname) > 0 Then
            Print #ch, "Player"; Format$(i); "="; pname
        End If
    Next i
    Print #ch, "Sound="; Format$(fDoSound)
    Print #ch, "PassSoundFile="; PassSound
    Print #ch, "Speed="; Format$(nSpeed)

    Print #ch, ""

    Close #ch

End Sub

Function xcdt (cvalue As Integer, csuit As Integer) As Integer
    Dim Suit As Integer

    Suit = csuit
    If Suit = 4 Then
        Suit = 3
    ElseIf Suit = 3 Then
        Suit = 4
    End If
    xcdt = (cvalue - 1) * 4 + (Suit - 1)

End Function

Function xpid (nid As Integer) As Integer
    Dim xp As Integer

    For xp = 1 To 4
        If ftPlayer(xp).NetID = nid Then
            xpid = xp
            Exit Function
        End If
    Next xp

    xpid = 0

End Function

