unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ScktComp;

type
  TModul = class(TDataModule)
    StepOne: TClientSocket;
    StepTwo: TClientSocket;
    StepThree: TClientSocket;
    StepFour: TClientSocket;
    StepFive: TClientSocket;
    StepSix: TClientSocket;
    procedure StepOneConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepTwoConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepThreeConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepFourConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepFiveConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepSixConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepOneLookup(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepOneError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure StepOneDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepOneConnecting(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepTwoDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepThreeDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure StepFourDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure StepFiveDisconnect(Sender: TObject;
      Socket: TCustomWinSocket);
    procedure StepSixDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure StepTwoError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure StepThreeError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure StepFourError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure StepFiveError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure StepSixError(Sender: TObject; Socket: TCustomWinSocket;
      ErrorEvent: TErrorEvent; var ErrorCode: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Modul: TModul;

implementation

uses Unit1;

{$R *.DFM}

procedure TModul.StepOneConnect(Sender: TObject; Socket: TCustomWinSocket);
begin
  Modul.StepTwo.Host:=Main.Target.Text;
  Modul.StepTwo.Port:=113;
  Modul.StepTwo.Open;
end;

procedure TModul.StepTwoConnect(Sender: TObject; Socket: TCustomWinSocket);
begin
  Modul.StepThree.Host:=Main.Target.Text;
  Modul.StepThree.Port:=113;
  Modul.StepThree.Open;
end;

procedure TModul.StepThreeConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Modul.StepFour.Host:=Main.Target.Text;
  Modul.StepFour.Port:=113;
  Modul.StepFour.Open;
end;

procedure TModul.StepFourConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Modul.StepFive.Host:=Main.Target.Text;
  Modul.StepFive.Port:=113;
  Modul.StepFive.Open;
end;

procedure TModul.StepFiveConnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Modul.StepSix.Host:=Main.Target.Text;
  Modul.StepSix.Port:=113;
  Modul.StepSix.Open;
end;

procedure TModul.StepSixConnect(Sender: TObject; Socket: TCustomWinSocket);
begin
  Main.StatusBar.Panels[0].Text:='Freeze done...';
end;

procedure TModul.StepOneLookup(Sender: TObject; Socket: TCustomWinSocket);
begin
  Main.Statusbar.Panels[0].Text:='Looking up ' + Main.Target.Text + '...'
end;

procedure TModul.StepOneError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
  Main.StatusBar.Panels[0].Text:='Socket Error! Step One Fail.';
  ErrorCode:=0;
end;

procedure TModul.StepOneDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Main.StatusBar.Panels[0].Text:='Disconnected from ' + Socket.RemoteAddress + '...';
  Main.Freeze.Enabled:=True;
end;

procedure TModul.StepOneConnecting(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Main.StatusBar.Panels[0].Text:='Connecting to ' + Main.Target.Text + '...'
end;

procedure TModul.StepTwoDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Main.StatusBar.Panels[0].Text:='Disconnected from ' + Socket.RemoteAddress + '...';
  Main.Freeze.Enabled:=True;
end;

procedure TModul.StepThreeDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Main.StatusBar.Panels[0].Text:='Disconnected from ' + Socket.RemoteAddress + '...';
  Main.Freeze.Enabled:=True;
end;

procedure TModul.StepFourDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Main.StatusBar.Panels[0].Text:='Disconnected from ' + Socket.RemoteAddress + '...';
  Main.Freeze.Enabled:=True;
end;

procedure TModul.StepFiveDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Main.StatusBar.Panels[0].Text:='Disconnected from ' + Socket.RemoteAddress + '...';
  Main.Freeze.Enabled:=True;
end;

procedure TModul.StepSixDisconnect(Sender: TObject;
  Socket: TCustomWinSocket);
begin
  Main.StatusBar.Panels[0].Text:='Disconnected from ' + Socket.RemoteAddress + '...';
  Main.Freeze.Enabled:=True;
end;

procedure TModul.StepTwoError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
  Main.StatusBar.Panels[0].Text:='Socket Error! Step Two Fail.';
  ErrorCode:=0;
end;

procedure TModul.StepThreeError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
  Main.StatusBar.Panels[0].Text:='Socket Error! Step Three Fail.';
  ErrorCode:=0;
end;

procedure TModul.StepFourError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
  Main.StatusBar.Panels[0].Text:='Socket Error! Step Four Fail.';
  ErrorCode:=0;
end;

procedure TModul.StepFiveError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
  Main.StatusBar.Panels[0].Text:='Socket Error! Step Five Fail.';
  ErrorCode:=0;
end;

procedure TModul.StepSixError(Sender: TObject; Socket: TCustomWinSocket;
  ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin
  Main.StatusBar.Panels[0].Text:='Socket Error! Step Six Fail.';
  ErrorCode:=0;
end;

end.
