unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Buttons;

type
  TMain = class(TForm)
    LBTarget: TLabel;
    Target: TEdit;
    Freeze: TBitBtn;
    Abort: TBitBtn;
    Exit: TBitBtn;
    StatusBar: TStatusBar;
    Label1: TLabel;
    About: TButton;
    procedure FreezeClick(Sender: TObject);
    procedure AbortClick(Sender: TObject);
    procedure Label5Click(Sender: TObject);
    procedure ExitClick(Sender: TObject);
    procedure AboutClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Main: TMain;

implementation

uses Unit3, Unit2;

{$R *.DFM}

procedure TMain.FreezeClick(Sender: TObject);
begin
  If (Target.Text='') or (Target.Text=' ') Then
    Abort.Kind
  Else
  Begin
    Modul.StepOne.Host:=Target.Text;
    Modul.StepOne.Port:=113;
    Modul.StepOne.Open;
    Freeze.Enabled:=False;
    Target.Enabled:=False;
  End
end;

procedure TMain.AbortClick(Sender: TObject);
begin
  Modul.StepOne.Close;
  Modul.StepTwo.Close;
  Modul.StepThree.Close;
  Modul.StepFour.Close;
  Modul.StepFive.Close;
  Modul.StepSix.Close;
  Freeze.Enabled:=True;
  Target.Enabled:=True;
  Target.SetFocus;
  StatusBar.Panels[0].Text:='';
end;

procedure TMain.Label5Click(Sender: TObject);
begin
  About.ShowModal;
end;

procedure TMain.ExitClick(Sender: TObject);
begin
  if MessageDlg('Do you want to quit now?', mtConfirmation, [mbNo, mbYes], 0) = mrYes then
    Close
  Else
  Begin
    Abort.Kind;
    Target.SetFocus;
  End
end;

procedure TMain.AboutClick(Sender: TObject);
begin
  About.ShowModal;
end;

end.
