#!/usr/bin/perl

#
###                         PRIMARY UBB SCRIPT                ##
#
# Ultimate Bulletin Board is copyright Madrona Park, Inc., 1998.
#
#       ------------ Ultimate.cgi -------------
#
#  This file contains most of the functionality for the UBB.
#
#  Madrona Park, Inc. offers no
#  warranties on this script.  The owner/licensee of the script is
#  solely responsible for any problems caused by installation of
#  the script or use of the script, including messages that may be
#  posted on the BB.
#
#  All copyright notices regarding the Ultimate Bulletin Board
#  must remain intact on the scripts and in the HTML
#  for the scripts.
#
# For more info on the Ultimate BB, 
# see http://www.UltimateBB.com
#
###############################################################
#
#If you are running UBB on IIS,
#you may need to add the following line
#if so, just remove the "#" sign before the print line below
#print "HTTP/1.0 200 OK\n";
eval {
  ($0 =~ m,(.*)/[^/]+,)   && unshift (@INC, "$1"); # Get the script location: UNIX / or Windows /
  ($0 =~ m,(.*)\\[^\\]+,) && unshift (@INC, "$1"); # Get the script location: Windows \
 
#substitute all require files here for the file


require "cgi-lib.pl";
require "UltBB.setup";
require "Date.pl";
require "mods.file";
require "ubb_html.pl";
require "Styles.file";
require "cookie-lib.pl";
require "ubb_library.pl";
require "mail-lib.pl";

};



if (($UseEmail eq "ON") && ($SMTPEmail eq "On")) {
use Socket;
}

&ReadParse;

if ($in{'action'} eq "Redirect") {
print "Location: $in{'GoTo'}\n\n";
exit;
 } #end Redirect check

print ("Content-type: text/html\n\n");

foreach $row(@in) {
	($Name, $Value) = split ("=", $row);
	$Name = &decodeURL($Name);
	$Value = &decodeURL($Value);
		
		if ($Name eq "forum") {
			$Forum = $Value;
			$Forum =~ s/\/\\//g;
			$ForumCoded = &HTMLIFY($Forum);
			$ForumCoded =~ tr/ /+/;
			$Forum = &UNHTMLIFY($Forum);
	}
		if ($Name eq "TopicSubject") {
			$TopicSubject = $Value;
			$TopicSubject =~ s/<.+?>//g;
				$TopicSubject = &UNHTMLIFY($TopicSubject);
	}
		if ($Name eq "UserName") {
		$UserName = $Value;
		$UserNameFile = $UserName;
		$UserNameFile =~ s/ /_/g; #remove spaces
	}
	if ($Name eq "BypassCookie") {
		$BypassCookie = $Value;
	}
	if ($Name eq "category") {
			$category = $Value;
	}
		if ($Name eq "PasswordConfirm") {
			$PasswordConfirm = $Value;
		}

		if ($Name eq "number") {
			$number = $Value;
	}
		if ($Name eq "DaysPrune") {
			$DaysPrune = $Value;
	}
	if ($Name eq "topic") {
			$topic = $Value;
	}

	if ($Name eq "Email") {
			$Email = $Value;
			$Email =~tr/A-Z/a-z/; 
	}
	if ($Name eq "URL") {
			$URL = &CleanThis($Value);
			$URL = &PipeCleaner($URL);
	}
	if ($Name eq "Permissions") {
			$Permissions = $Value;
	}
	if ($Name eq "Occupation") {
			$Occupation = &CleanThis($Value);
			$Occupation = &PipeCleaner($Occupation);
	}
	if ($Name eq "Location") {
			$Location = &CleanThis($Value);
			$Location = &PipeCleaner($Location);
	}
	if ($Name eq "TotalPosts") {
		$TotalPosts = $Value;
	}
	if ($Name eq "Status") {
		$Status = $Value;
	}
	if ($Name eq "Interests") {
			$Interests = &CleanThis($Value);
			$Interests = &PipeCleaner($Value);
	}
		if ($Name eq "sendto") {
			$sendto = $Value;
	}
}  # end FOREACH $row

if ($VariablesPath eq "") {
	$VariablesPath = $CGIPath;
}
$ReplyMessage = $in{'ReplyMessage'};
$Message = $in{'Message'};

@censored = split(/ /, $censorwords);

if ($Censor eq "ON") {
	for (@censored) {
		if (m/({)(.*)(})/) {
			$_ = ("$2 ");
			$wordlength = length($_);
			$wordlength = $wordlength - 1;
			$replaceword = "*" x $wordlength;
			$replaceword = "$replaceword ";
		}  else {
		$wordlength = length($_);
		$replaceword = "*" x $wordlength;
		}
		$TopicSubject =~ s/$_/$replaceword/isg;
	}
}
		$SubjectCoded = &HTMLIFY($TopicSubject);
		$SubjectCoded =~ tr/ /+/;
		

if (@in == 0) {
&Intro;
}
 
if ($in{'action'} eq "intro") {
 &Intro;
 }  



if ($in{'action'} eq "topics") {
 &Topics;
 }  

if ($in{'action'} eq "closethread") {
 &CloseThread;
 }  
 
if ($in{'action'} eq "processclose") {
 &ProcessClose;
 }  
if ($in{'action'} eq "agree") {
 &Agree;
 } 
if ($in{'action'} eq "threadlist") {
 &Threadlist;
 }  
 if ($in{'action'} eq "email") {
 &DoEmail($in{'ToWhom'});
 }  

if ($in{'action'} eq "getannounce") {
 &GetAnnounce;
 }  
if ($in{'action'} eq "reply") {
 &Reply;
 }  

if ($in{'action'} eq "postreply") {
 &PostReply;
 }  
 
if ($in{'action'} eq "newtopic") {
 &NewTopic;
 }  
 
if ($in{'action'} eq "posttopic") {
 &PostTopic;
 }  
 
if ($in{'action'} eq "getbio") {
 &GetBio;
 } 
 
if ($in{'action'} eq "editbio") {
 &EditBio;
 } 
if ($in{'action'} eq "setprefs") {
 &SetPrefs;
 } 
 if ($in{'action'} eq "PrefsSubmit") {
 &PrefsSubmit;
 } 
if ($in{'action'} eq "checkbioid") {
&CheckBioID;
 } 
 
if ($in{'action'} eq "modifybio") {
   &ModifyBio;
 }  
 
if ($in{'action'} eq "register") {
   &Register;
 }  
 if ($in{'action'} eq "RegSubmit") {
 &RegSubmit;
 }
 if ($in{'action'} eq "faq") {
 &FAQ;
 }
 
if ($in{'action'} eq "rules") {
 &Rules;
 }  
 
if ($in{'action'} eq "lostpw") {
	if ($UseEmail eq "ON") {
 &LostPW;
 }  else {
 &EmailDisabled;
 }
 }  
 
if ($in{'action'} eq "pwrequest") {
 &PWRequest;
 } 
 
if ($in{'action'} eq "editpost") {
$TopicNumber = substr($topic, 0, 6);
$TopicNumber = ("$TopicNumber" . "-000000");
&GrabTopic;  #returns $TopicFile
if ($TopicFile =~ /X/) {
	&CantEditHTML;
}  else {
 &EditPost;
 } 
 } #end editpost check
 
if ($in{'action'} eq "submitedit") {
 &SubmitEdit;
 }  

#  to automatically move user to proper version (javscript or non
#  javascript), make your inital link to the BB "Ultimate.cgi"...


sub Intro {

&get_cookie;  #retrieves all current cookies

if ($cookie{DaysPrune}) {
$DaysPrune = "$cookie{DaysPrune}";
}  else {
$DaysPrune = $DaysPruneDefault;
}

if ($BypassCookie eq "true") {
	$NoNewLogin = "true";
	$SessionLogin = "$cookie{sessionLogin}";
	
}  else {
	$NoNewLogin = "false";
	$SessionLogin = "$cookie{lastLogin}";
	$SessionLoginDT = "$cookie{LastLoginDT}";
}
&decodeURL($SessionLoginDT);

	&GetDateTime;

if ($cookie{LastLoginDT}) {
$Legend = "<img src=\"$NonCGIURL/on.gif\" width=22 height=15 border=0 alt=\"On\">&nbsp;&nbsp; New Posts Since Your Last Visit<BR><img src=\"$NonCGIURL/off.gif\" width=22 height=15 border=0 alt=\"off\">&nbsp;&nbsp; No New Posts Since Your Last Visit";

if ($cookie{sessionLoginDT}) {
$UseDT = $cookie{sessionLoginDT};
}  else {
$UseDT = $cookie{LastLoginDT};
}

if ($DateFormat eq "US") {

	if ($TimeFormat eq "AMPM") {
		$LastLoginTime = ("You last visited: $UseDT $TimeZone");
	} else {
		($USDate, $GetTime, $TheAMPM) = split(/ /, $UseDT);
($gethr, $getmin) = split(/:/, $GetTime);

	&ConvertTo24Hour;
	$LastLoginTime = ("You last visited: $USDate $gethr:$getmin $TimeZone");
	}

}  else {  # if Euro Format
	($EuroDate, $GetTime, $TheAMPM) = split(/ /, $UseDT);
($EuroMonth, $EuroDay, $EuroYr) = split(/-/, $EuroDate);
		if ($TimeFormat eq "AMPM") {
$LastLoginTime = ("You last visited: $EuroDay-$EuroMonth-$EuroYr $GetTime $TheAMPM $TimeZone");
	} else {
	($gethr, $getmin) = split(/:/, $GetTime);
	&ConvertTo24Hour;
		$LastLoginTime = ("You last visited: $EuroDay-$EuroMonth-$EuroYr $gethr:$getmin $TimeZone");
	
	}

}
}  else {
$LastLoginTime = "";
}


&ForumsTopHTML;

&get_cookie;  #retrieves all current cookies

open (FORUMFILE, "$VariablesPath/forums.cgi");
	@forums = <FORUMFILE>;
close (FORUMFILE);

if ($category ne "") {
for $forumline(@forums) {
	@forumfacts = split(/\|/, $forumline);
	if ($forumfacts[0] eq "$category") {
		push(@sortforums, $forumline);
	}
	
}

}  else {

if ($CategoryView eq "yes") {
@sortforums = sort(@forums); #sorts forums by category
}  else  {
@sortforums = @forums;
} #end if/else categoryview eq yes
}  #end category limitation check

$forumcategory = "";

for (@sortforums) {
@thisforuminfo = split(/\|/, $_);
chomp($thisforuminfo[8]);
$x = "$thisforuminfo[8]";

$GetHour = "";
$GetMinute = "";
$MilHour = "";
$TheDate = "";
$LatestTime = "";

if ($CategoryView eq "yes") {
$thisforumcategory = &decodeURL($thisforuminfo[0]);
if ($thisforumcategory ne "$forumcategory") {
print<<CategoryHeader;
<TR bgcolor="$CategoryStripColor"><TD colspan=5>
<FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$TextColor"><B> $thisforumcategory</B></FONT>
</td></tr>
CategoryHeader
}
$forumcategory = "$thisforumcategory";
} # end if categoryview eq yes


opendir (FORUMDIR, "$ForumsPath/Forum$x"); 
    @files = readdir(FORUMDIR);
closedir (FORUMDIR);

@files = grep(/\.(n|m)/, @files);
$numberOfPosts = @files;

open (LTime, "$ForumsPath/Forum$x/lasttime.file"); 
    @lasttime = <LTime>;
close (LTime);

$LastDate = $lasttime[0];
$LastTime = $lasttime[1];
chomp($LastDate);
chomp($LastTime);

if ($numberOfPosts eq "") {
	$numberOfPosts = "0";
	}

if ($numberOfPosts > 0) {

#split time/date
($GetHour, $GetMinute) = split(/:/, $LastTime);
($GetMinute, $AMpm) = split(/ /, $GetMinute);
chomp($AMpm);
($GetMonth, $GetDate, $GetYear) = split(/-/, $LastDate);

	&MilitaryTime2;
	$MilTime = "$MilHour:$GetMinute";

if ($TimeFormat eq "24HR") {
	$LatestTime = "$MilTime";
} else {
		$LatestTime = "$LastTime";
	}
	
if ($DateFormat eq "Euro") {
$TheDate = "$GetDate-$GetMonth-$GetYear";
$DateWording = "All dates are in DD-MM-YY format.";
}  else {
$TheDate = "$LastDate";
$DateWording = "All dates are in MM-DD-YY format.";
}
}  else {
$GetMonth = "";
$GetDate= "";
$GetYear = "";
$LatestTime = "";
$TheDate = "";
}

@thisforum = &GetForumRecord($x);

$ForumName = $thisforum[1];
$Moderator = ("Forum" . "$x" . "Moderator");
$Moderator = $$Moderator;
$ForumDesc = $thisforum[2];
$OnOff = $thisforum[3];
chomp($OnOff);

$ForumCoded = &HTMLIFY($ForumName);
$ForumCoded =~ tr/ /+/;
$ForumDesc =~ s/&quot;/"/g;

if ($ForumDescriptions eq "no") {
	$ForumDesc = "";
}

if ($GetMonth ne "") {

# Compare Last Login Time to Last Post Time.. 

$LPMonth = $GetMonth;

if ($GetYear > 96)  {
	$JYear = ("19" . "$GetYear");
	} else  {
		$JYear = ("20" . "$GetYear");
	}
$LastPostJulian = &jday($LPMonth, $GetDate, $JYear);

$LPTime = ("$MilHour" . "$GetMinute");
$LastPostJulian = ($LastPostJulian + ($LPTime * 0.0001));

if ($LastPostJulian > $SessionLogin) {
	$NewStuffIcon = "<IMG SRC=\"$NonCGIURL/on.gif\" BORDER=0>";
} else {
	$NewStuffIcon = "<IMG SRC=\"$NonCGIURL/off.gif\" BORDER=0>";
}


}  else {
	$NewStuffIcon = "<IMG SRC=\"$NonCGIURL/off.gif\" BORDER=0>";

} # end if/else month ne ""


unless ($cookie{lastLogin}) {
	$NewStuffIcon = "";
	$Legend = "";
}

if ($OnOff eq "On") {
&ForumsGutsHTML;
} ## End IF ONOFF Conditional
}

&ForumsBottomHTML;
}  #END INTRO SR ###



sub Topics {

&get_cookie;  #retrieves all current cookies
	$SessionLogin = "$cookie{sessionLogin}";
	$SessionLoginDT = "$cookie{sessionLoginDT}";

if ($DaysPrune eq "") {
$DaysPrune = "$cookie{DaysPrune}";
}
if ($DaysPrune eq "") {
$DaysPrune = $DaysPruneDefault;
}

if ($in{'start'} eq "here") {
	$AddNewSessionLogin = "true";
}

if ($DaysPrune == 1) {
	$Days1 = "SELECTED";
}

if ($DaysPrune == 2) {
	$Days2 = "SELECTED";
}

if ($DaysPrune == 5) {
	$Days5 = "SELECTED";
}

if ($DaysPrune == 10) {
	$Days10 = "SELECTED";
}

if ($DaysPrune == 20) {
	$Days20 = "SELECTED";
}

if ($DaysPrune == 30) {
	$Days30 = "SELECTED";
}

if ($DaysPrune == 45) {
	$Days45 = "SELECTED";
}

if ($DaysPrune == 60) {
	$Days60 = "SELECTED";
}

if ($DaysPrune == 75) {
	$Days75 = "SELECTED";
}

if ($DaysPrune == 100) {
	$Days100 = "SELECTED";
}

if ($DaysPrune == 365) {
	$Days365 = "SELECTED";
}

@thisforum = &GetForumRecord($number);

$Moderator = ("Forum" . "$number" . "Moderator");
$Moderator = $$Moderator;
$Forum = $thisforum[1];
$CustomTitle = $thisforum[9];
chomp($CustomTitle);
if ($CustomTitle eq "") {
$CustomTitle = "$BBTitle";
}

$ForumCoded = &HTMLIFY($Forum);
$ForumCoded =~ tr/ /+/;

@theprofile = &OpenProfile("$Moderator.cgi");
	
$ModeratorEmail = "$theprofile[2]";

#Check Announcements
&CheckAnnouncements("$number");

&TopicTopHTML;
&TopicMidNonIEhtml;

#get Forum Messages
opendir (FORUMDIR, "$ForumsPath/Forum$number"); 
    @forummsgs = readdir(FORUMDIR);
closedir (FORUMDIR);
@forummsgs = grep(/\.(m|n)/, @forummsgs);
@topicarray = grep(/^(\d\d\d\d\d\d)(-000000-)(\d\d\d\d\d\d)(-\d\d\d\d\d\d)/, @forummsgs);

## do date pruning 

($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime (time);

$year = ($year + 1900);

$mon++;

#convert Closing and Current Dates to Julian Dates
$CurrentJulian = &jday($mon, $mday, $year);
$CloseJulian = $CurrentJulian - $DaysPrune;

#configure memo date to Julian
foreach $item(@topicarray) {
	
$MonthOfMessage = substr($item, 14, 2);
$DayOfMessage = substr($item, 16, 2);
$YearOfMessage = substr($item, 18, 2);

if ($YearOfMessage > 96)  {
	$YearOfMessage = ("19" . "$YearOfMessage");
	} else  {
		$YearOfMessage = ("20" . "$YearOfMessage");
	}
	$CheckJulian = &jday($MonthOfMessage, $DayOfMessage, $YearOfMessage);
		
	if ($CheckJulian >= $CloseJulian) {
		push (@finalarray, $item);
	}  
} #end FOREACH $item
############################################

$x = $number;

for (@finalarray) {
&PullTimes;
$TheYear = substr($DaterMatch, 4, 2);
$TheRest = substr($DaterMatch, 0, 4);

if ($TheYear > 96)  {
	$TheYear = ("19" . "$TheYear");
	} else  {
		$TheYear = ("20" . "$TheYear");
	}
$FullDTSort = ("$TheYear" . "$TheRest" . "$hour" . "$min");
$SortString = ("$FullDTSort" . "|" . "$_");
		
		push (@sortedthat, $SortString);
}
	@sortedthis = sort(@sortedthat);
	@sortedthis = reverse(@sortedthis);
	
	for (@sortedthis) {
	($TimeInfo, $topic) = split(/\|/, $_);
	$JYear = substr($TimeInfo, 0, 4);
	$Year = substr($TimeInfo, 2, 2);
	$Month = substr($TimeInfo, 4, 2);
	$Day = substr($TimeInfo, 6, 2);
	$hour = substr($TimeInfo, 8, 2);
	$min = substr($TimeInfo, 10, 2);
	$Replies = substr($topic, 21, 6);
	$RepliesFormat = $Replies + 0;
	
	
	$JMonth = $Month;
	
	
	#format date
	if ($DateFormat eq "Euro") {
	$TheDate = "$Day-$Month-$Year";
	$DateWording = "All dates are in Day-Month-Year format.";
	}  else {
	$TheDate = "$Month-$Day-$Year";
	$DateWording = "All dates are in Month-Day-Year format.";
	}
open (THETOPIC, "$ForumsPath/Forum$number/$topic");
	@stuff = <THETOPIC>;
close (THETOPIC);

$ThreadNumber = substr($topic, 0, 6);

$author = "$stuff[0]";
$subject = "$stuff[3]";
chomp($author);
chomp($subject);

$TopicJulian = &jday($JMonth, $Day, $JYear);
$JTime = ("$hour" . "$min");
$TopicJulian = ($TopicJulian + ($JTime * 0.0001));
#format time option 1
	if ($TimeFormat eq "24HR")  {
		$FormatTime = "$hour:$min";
	}
	&NormalTime;

#format time option 2
	if ($TimeFormat eq "AMPM")  {
		$FormatTime = "$hour:$min $AMPM";
	}

if ($SessionLogin eq "") {
if ($topic =~ /X/) {
	$FolderIcon = "<IMG SRC=\"$NonCGIURL/yellockfolder.gif\" WIDTH=14 HEIGHT=15 BORDER=0>";
	}  else {
		$FolderIcon = "<IMG SRC=\"$NonCGIURL/closed.gif\" WIDTH=14 HEIGHT=11 BORDER=0>";
	}
} else {
if ($TopicJulian > $SessionLogin) {
	if ($topic =~ /X/) {
	$FolderIcon = "<IMG SRC=\"$NonCGIURL/redlockfolder.gif\" WIDTH=14 HEIGHT=15 BORDER=0>";
	}  else {
	$FolderIcon = "<IMG SRC=\"$NonCGIURL/closedb.gif\" WIDTH=14 HEIGHT=11 BORDER=0>";
	}
	$NewThreadPosts = "yes";
}  else {

	if ($topic =~ /X/) {
	$FolderIcon = "<IMG SRC=\"$NonCGIURL/yellockfolder.gif\" WIDTH=14 HEIGHT=15 BORDER=0>";
	}  else {
	$FolderIcon = "<IMG SRC=\"$NonCGIURL/closed.gif\" WIDTH=14 HEIGHT=11 BORDER=0>";
	}

	$NewThreadPosts = "no";

}
}

&TopicGutsNonIEhtml;

}

&TopicBottomNonIEhtml;
&GetForumSelectList;
if ($SessionLogin ne "") {
&TopicBottom2JShtml;
}  else {
&TopicBottom2NonJShtml;
}

}  ## END TOPICS SR ####

sub Threadlist {

$TopicNumber = substr($topic, 0, 13);
&GrabTopic;

open (GETTOPIC, "$ForumsPath/Forum$number/$TopicFile");
	@topicguts = <GETTOPIC>;
close (GETTOPIC);

$UNCoded = $topicguts[0];
$UNCoded =~ tr/ /+/;
$TopicSubject = $topicguts[3];
	$SubjectCoded = &HTMLIFY($TopicSubject);
			$SubjectCoded =~ tr/ /+/;
			
# Check to see if this thread has been closed...
if ($TopicFile =~ m/X/) {
		$ThisThreadClosed = "<IMG SRC=\"$NonCGIURL/lock.gif\" WIDTH=9 HEIGHT=11 BORDER=0 ALT=\"Thread Closed\">&nbsp;&nbsp;Thread Closed";
		$CloseOption = "";
		$ReplyButton = "<IMG SRC=\"$NonCGIURL/$ThreadClosed\" BORDER=0>";
	}  else {
		$ThisThreadClosed = "";
		$CloseOption = "<CENTER><FONT SIZE=\"1\" FACE=\"$FontFace\"><IMG SRC=\"$NonCGIURL/lock.gif\" WIDTH=9 HEIGHT=11 BORDER=0 ALT=\"Thread Closed\"> To close this thread, <A HREF=\"Ultimate.cgi?action=closethread&topic=$topic&TopicSubject=$SubjectCoded&number=$number&LastLogin=$in{'LastLogin'}&DaysPrune=$DaysPrune&forum=$ForumCoded\">click here</A> (moderator or admin only).<br></FONT></CENTER><BR>";
	$ReplyButton = "<IMG SRC=\"$NonCGIURL/$BBReply\" BORDER=0 ALT=\"Post A Reply\">";
	}

&ThreadTopHTML;
		
chomp ($topicguts[1]);
chomp ($topicguts[2]);
chomp ($topicguts[5]);

## determine JulianTime for post,
## first post that is older than LastLoginJulian
## receives A NAME tag

$NameTag = "";
$NameFinish = "";

$theDate = "$topicguts[1]";
#format date
if ($DateFormat eq "Euro") {
@datearray = split(/-/, $topicguts[1]);
chomp($datearray[2]);
$ThisDate = "$datearray[1]-$datearray[0]-$datearray[2]";
}  else {
$ThisDate = "$topicguts[1]";
}
$theTime = "$topicguts[2]";
#format time option 1
	if ($TimeFormat eq "24HR")  {
		($SplitTime, $TheAMPM) = split(/ /, $topicguts[2]);
		chomp($TheAMPM);
		($gethr, $getmin) = split(/:/, $SplitTime);
		&ConvertTo24Hour;
		$FormatTime = "$gethr:$getmin";
	} else {
		$FormatTime = "$topicguts[2]";
	}

	$PostFolder = "$NonCGIURL/posticon.gif";
	
&ThreadGutsNonIEhtml;

#get Replies to this topic
opendir (FORUMDIR, "$ForumsPath/Forum$number"); 
    @forummsgs = readdir(FORUMDIR);
closedir (FORUMDIR);

@forummsgs = grep(/\.(m|n)/, @forummsgs);

$ThisTopicNumber = substr($topic, 0, 6);
@threadmsgs = grep(/^$ThisTopicNumber/, @forummsgs);
#sort to find all replies to this topic

foreach $msg(@threadmsgs) {
		$ReplyNumber = substr($msg, 7, 6);
		if ($ReplyNumber > 0) {
			push  (@replyarray, $msg);
		}
}
@replyarray = sort(@replyarray);

#### @replyarray holds all replies to the topic in question

$AlternateColor = "$AltColumnColor2";

foreach $matchreply(@replyarray) {
	open (REPLY, "$ForumsPath/Forum$number/$matchreply");
		@replyguts = <REPLY>;
	close (REPLY);
	
$UserNameCoded = $replyguts[0];
$UserNameCoded =~ tr/ /+/;
			
chomp ($replyguts[1]);
chomp ($replyguts[2]);
chomp ($replyguts[5]);

## determine JulianTime for post,
## first post that is older than LastLoginJulian

$NameTag = "";
$NameFinish = "";

$theDate = "$replyguts[1]";

#format date
if ($DateFormat eq "Euro") {
@datearray = split(/-/, $replyguts[1]);
chomp($datearray[2]);
$ThisDate = "$datearray[1]-$datearray[0]-$datearray[2]";
}  else {
$ThisDate = "$replyguts[1]";
}
#format time option 1
	if ($TimeFormat eq "24HR")  {
		@timearray = split(/ /, $replyguts[2]);
		chomp($timearray[1]);
		($gethour, $getmin) = split(/:/, $timearray[0]);
		
		if ($timearray[1] eq "PM") {		
		if ($gethour < 12) {
			$gethour = ($gethour  + 12);
		}
	}
	if ($AMpm eq "AM") {		
		if ($gethour == 12) {
			$gethour = "0";
		}
	}
	$gethour = sprintf ("%2d", $gethour);
	$gethour =~tr/ /0/;
	$getmin = sprintf ("%2d", $getmin);
	$getmin =~tr/ /0/;
	
		$FormatTime = "$gethour:$getmin";
	} else {
		$FormatTime = "$replyguts[2]";
	}
$theTime = "$replyguts[2]";

&ThreadRepliesNonIEhtml;

#rotate thru alt colors
if ($AlternateColor eq "$AltColumnColor1") {
	$AlternateColor = "$AltColumnColor2";
	}  else {
	$AlternateColor = "$AltColumnColor1";
	}
}

&ThreadBottomNonIEhtml;
&GetForumSelectList;
&ThreadBottom2NonIEhtml;

} #END THREADLIST SR ####


sub Reply {
#verify that topic number exists
opendir (FORUMFILE, "$ForumsPath/Forum$number");
	@forums = readdir(FORUMFILE);
closedir (FORUMFILE);

	@forums = grep(/\.(m|n)/, @forums);
$Found = "no";
$ThreadStart = substr($topic, 0, 13);
	LOOKFORIT: for (@forums) {
		if ($_ =~ /$ThreadStart/) {
			$Found = "yes";
			$TopicFile = "$_";
			last LOOKFORIT;
		}
	}


if ($Found eq "yes") {
	
# if thread is closed, say so
if ($TopicFile =~ /X/) {
&ThreadClosedHTML;
}  else {

@thisforum = &GetForumRecord($number);
$CustomTitle = $thisforum[9];

#chomp the last field to remove carriage returns
$UBBImages = "$thisforum[10]";

if ($CustomTitle eq "") {
$CustomTitle = "$BBTitle";
}

if ($thisforum[4] eq "is") {
	$ISHTML = "*HTML is ON";
	$HTMLAllowed = "yes";
}  else {
	$ISHTML = "*HTML is OFF";
	$HTMLAllowed = "no";
}
 
if ($thisforum[5] eq "is") {
	$ISUBB = "*UBB Code is ON";
	$UBBAllowed = "yes";
}  else {
	$ISUBB = "*UBB Code is OFF";
	$UBBAllowed = "no";
}

if (($UBBImages eq "OFF") && ($UBBAllowed eq "yes")) {
	$UBBImagesWording = "\[IMG\] UBB Code Not Allowed!";
}
#check to see if this forum is Limited Write Access-----
if ($thisforum[6] eq "yes") {
	&ReplyFormLWAHTML;
	} else {
		&ReplyFormHTML;
}

&GenerateThread;
&ReplyFormBottom;

} #end if/else thread is closed
}  else {
	&FaultyTopicNumber;
} #end if/else topic number verification
}  ## END Reply SR #####


sub PostReply {
#verify that forum fields are complete

if (($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'ReplyMessage'} eq "")) {
	&MissingFields;
	}  else {

@thisforum = &GetForumRecord($number);
$LWA = $thisforum[6];
$LWAPassword = &decodeURL($thisforum[7]);
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
$ModNotify = $thisforum[11];
$ForumStatus = $thisforum[3];
chomp($ModNotify);

## See if this is an LWA Forum
if ($LWA eq "yes") {
&GetMemberListArray;
$NameFound = "no";
foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK
if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
	if ($in{'Password'} eq "$theprofile[1]") {
		$Permission = "$theprofile[4]";
		$Status = $theprofile[8];
		$ForumPassword = &decodeURL($in{'ForumPassword'});
		&CheckTheStatus;
		&CheckPermissions;
	   	if (($AdminPermission eq "true") || ($ModStatus eq "true")) {
	   &DoPostTheReply;
	   }
	   elsif ($ForumPassword eq "$LWAPassword") {
	   &DoPostTheReply;
	   }  else {
	   &DontProcessLWA;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK
} else {
	   &DoPostTheReply;
}#end if/else LWA = yes
} # end if/else missing fields
}  ## END Post Reply SR



sub DoPostTheReply {
##get current date/time
&GetDateTime;
##verify user name/password
$match = "no";
$verified = "false";


&GetMemberListArray; #returns @members

CHECKPROFILES: foreach $member(@members) {
	if ($member eq "$UserNameFile.cgi") {
		$match = "yes";
			
	@profilestats = &OpenProfile("$UserName.cgi");
	
		if ($profilestats[1] eq "$in{'Password'}") {
				$verified = "true";
				$Email = &PipeCleaner("$profilestats[2]");
				$UserName = &PipeCleaner("$profilestats[0]");
				$TotalPosts = &PipeCleaner("$profilestats[7]");
				$Permission = &PipeCleaner("$profilestats[4]");
				$Password = &PipeCleaner("$profilestats[1]");
				$URL = &PipeCleaner("$profilestats[3]"); 
				$Occupation = &PipeCleaner("$profilestats[5]");
				$Location = &PipeCleaner("$profilestats[6]");
				$Status = &PipeCleaner("$profilestats[8]");
				$Interests = &PipeCleaner("$profilestats[9]");
				$DateRegistered = &PipeCleaner("$profilestats[10]");
				$EmailView = "$profilestats[11]";
			last CHECKPROFILES;
		}  #END IF profilestats
	
	} #END IF $MEMBER
		
}  #end FOREACH $member

chomp($EmailView);

&CheckPermissions;

if ($match eq "no") {
&NoMatch
}

if ($match eq "yes" && $verified eq "false") {
&WrongPassword;
}

if ($match eq "yes" && $verified eq "true") {
   if ($PermissionToWrite eq "true") {

##create filenumber for reply based on father message

## recheck topic number, in case someone
## posted reply while user was typing
$TopicNumber = substr($topic, 0, 13);
&GrabTopic;  #this returns $TopicFile
####

($father, $replynum, $dater, $replytotal) = split(/\-/, $TopicFile);

($junk, $Extension) = split(/\./, $replytotal);
chomp($Extension);

$replytotal = substr($replytotal, 0, 6);
$oldreplytotal = $replytotal;
$oldreplytotal++;
$newreplynum = sprintf("%6d", $oldreplytotal);
$newreplynum =~tr/ /0/;
$father = sprintf("%6d", $father);
$father =~tr/ /0/;
$ReplyFile = ("$father" . "-" . "$newreplynum" . "-" . "$RunonDate" . "-" . "000000.m");

#now we have to add the message to the forum directory

## IF HTML is not allowed, render HTML useless
if ($HTMLAllow eq "is not") {
		$ReplyMessage =~ s/</&lt;/g;
		$ReplyMessage =~ s/>/&gt;/g;
 }
 
if ($Censor eq "ON") {
	for (@censored) {
		if (m/({)(.*)(})/) {
			$_ = ("$2 ");
			$wordlength = length($_);
			$wordlength = $wordlength - 1;
			$replaceword = "*" x $wordlength;
			$replaceword = "$replaceword ";
		}  else {
		$wordlength = length($_);
		$replaceword = "*" x $wordlength;
		}
		$ReplyMessage =~ s/$_/$replaceword/isg;
	}
}

$ReplyMessage2 = "$ReplyMessage";

#convert newlines/carriage returns to HTML
$ReplyMessage = &ConvertReturns("$ReplyMessage");

#UBB Code-ify (if allowed)
if ($UBBCodeAllow eq "is") {
$ReplyMessage = &UBBCode("$ReplyMessage");
} #END UBB CODE 

#Smiley/Frown conversion---
$ReplyMessage = &Smilies("$ReplyMessage");

&Lock ("lock.file");
open (THISFILE, ">$ForumsPath/Forum$number/$ReplyFile");
print THISFILE ("$UserName\n");
print THISFILE ("$HyphenDate\n");
print THISFILE ("$Time\n");
print THISFILE ("$TopicSubject\n");
print THISFILE ("$Email\n");
print THISFILE ("$ReplyMessage\n");
close (THISFILE);

## Amend father message to reflect new reply
$newFileName = "$father-000000-$RunonDate-$newreplynum.$Extension";

### can't use rename for certain NT systems, thus, here's the fix:
open (THISFILE, "$ForumsPath/Forum$number/$TopicFile");
@topicstuff = <THISFILE>;
close(THISFILE);

open (RENAME, ">$ForumsPath/Forum$number/$newFileName");
for $line(@topicstuff) {
chomp($line);
print RENAME "$line\n";
}
close(RENAME);

unlink ("$ForumsPath/Forum$number/$TopicFile");
### END NEW RENAME ALTERNATIVE SECTION
&Unlock ("lock.file");

$UserInfo = ("$UserName" . "|$in{'Password'}");

##Add reply to user's profile (total posts)
$TotalPosts++;
#Bump user up to Member if Total Posts reaches $MemberMinimum
if (($TotalPosts >= $MemberMinimum)  && ($Status eq "Junior Member")) {
$Status = "Member";
}

&Lock ("lock.file");
open (MEMBERSHIP, ">$MembersPath/$UserNameFile.cgi") or die("Unable to open Members directory.");

	print MEMBERSHIP ("$UserName|");
	print MEMBERSHIP ("$Password|");
	print MEMBERSHIP ("$Email|");
	print MEMBERSHIP ("$URL|");
	print MEMBERSHIP ("$Permission|");
	print MEMBERSHIP ("$Occupation|");
	print MEMBERSHIP ("$Location|");
	print MEMBERSHIP ("$TotalPosts|");
	print MEMBERSHIP ("$Status|");
	print MEMBERSHIP ("$Interests|");
	print MEMBERSHIP ("$DateRegistered|");
	print MEMBERSHIP ("$EmailView\n");
close (MEMBERSHIP);
&Unlock ("lock.file");


#update last time file
&Lock ("lock.file");
open (LASTTIME, ">$ForumsPath/Forum$number/lasttime.file") or die("Unable to open LastTime.file");
print LASTTIME ("$HyphenDate\n");
print LASTTIME ("$Time\n");
close (LASTTIME);
&Unlock ("lock.file");

##CREATE HTML FILE FOR NEW THREAD
&CreateThreadHTML("Forum$number", "$newFileName");

## UPDATE INDEX
$Message = "$ReplyMessage";
if ($ForumStatus eq "On") {
&AppendIndex("$number", "$ReplyFile");
}

# If Forum is set to Moderator Notify,
# need to send notification to forum moderator
if ($ModNotify eq "yes") {
$ModName = ("Forum" . "$number" . "Moderator");
$ModName = $$ModName;
@ModProfile = &OpenProfile("$ModName.cgi");
$sendto = $ModProfile[2];
$subject = "Moderator Notification: New Post in $Forum";
$message = "Hello, $ModName!  \n\r\n$UserName has just replied to the topic entitled - $TopicSubject - in the $Forum forum of $BBName. \n\r\n This BB is located at $CGIURL/Ultimate.cgi";

if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}

} #end mod notify block

## IF TOPIC SET TO NOTIFY, THEN WE NEED TO GENERATE AN
## EMAIL MESSAGE TO SEND TO THE AUTHOR OF THE TOPIC

if ($Extension =~ /nm/) {

$sendto = $topicstuff[4];
chomp($sendto);

$subject = "Notification: Reply to Your BB Topic";
$message = "Hello, \n\r\n $UserName has just replied to your topic entitled - $TopicSubject - in the $Forum forum of $BBName. \n\r\n This BB is located at $CGIURL/Ultimate.cgi";
if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
}  # end if extension = nmsg

&ReplyConfirmHTML;

} else {

&PermissionDeniedHTML;

} #END Check Permission block
}  ## END match yes and verified true block
} # end Do Post The Reply


sub NewTopic {
@thisforum = &GetForumRecord($number);
$CustomTitle = "$thisforum[9]";
$UBBImages = "$thisforum[10]";

if ($CustomTitle eq "") {
$CustomTitle = "$BBTitle";
}

if ($thisforum[4] eq "is") {
	$ISHTML = "*HTML is ON";
	$HTMLAllowed = "yes";
}  else {
	$ISHTML = "*HTML is OFF";
	$HTMLAllowed = "no";
}
 
if ($thisforum[5] eq "is") {
	$ISUBB = "*UBB Code is ON";
	$UBBAllowed = "yes";
}  else {
	$ISUBB = "*UBB Code is OFF";
	$UBBAllowed = "no";
}
if (($UBBImages eq "OFF") && ($UBBAllowed eq "yes")) {
	$UBBImagesWording = "\[IMG\] UBB Code Not Allowed!";
}

## if email is enabled, show notification wording

	if ($UseEmail eq "ON") {
	$EmailNotificationHTML = "<CENTER><FONT FACE=\"$FontFace\" SIZE=\"$TextSize\" COLOR=\"$LinkColor\"><INPUT TYPE=\"CHECKBOX\" NAME=\"EmailNotification\" VALUE=\"yes\">Check here to be notified by email whenever someone replies to your topic.</FONT></CENTER>";
	}  else {
	$EmailNotificationHTML = "";
	}

#check to see if this forum is Limited Write Access-----
if ($thisforum[6] eq "yes") {
	&TopicFormLWAHTML;
	} else {
		&TopicFormHTML;
}
}  ## END NEWTOPIC SR ##

sub PostTopic {
## Verify form input
if (($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'TopicSubject'} eq "") || ($in{'Message'} eq "")) {
	&MissingFields;
	}  else {

@thisforum = &GetForumRecord($number);
$LWA = $thisforum[6];
$LWAPassword = &decodeURL($thisforum[7]);
$UBBCodeAllow = $thisforum[5];
$HTMLAllow = $thisforum[4];
$UBBImages = $thisforum[10];
$ModNotify = $thisforum[11];
$ForumStatus = $thisforum[3];

chomp($ModNotify);
&GetMemberListArray;
## See if this is an LWA Forum
if ($LWA eq "yes") {


$NameFound = "no";
foreach $check(@members) {
   if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK
if ($NameFound eq "yes") {
	@theprofile = &OpenProfile("$UserName.cgi");
	if ($in{'Password'} eq "$theprofile[1]") {
		$Permission = "$theprofile[4]";
		$Status = $theprofile[8];
		$ForumPassword = &decodeURL($in{'ForumPassword'});
		&CheckTheStatus;
		&CheckPermissions;
	   	if (($AdminPermission eq "true") || ($ModStatus eq "true")) {
	   &DoPostTheTopic;
	   }
	   elsif ($ForumPassword eq "$LWAPassword") {
	   &DoPostTheTopic;
	   }  else {
	   &DontProcessLWA;
	   }
	} else {
	&WrongPassword;
	}
}  else {
&WrongUserName;
}  ##END IF/ELSE NAME CHECK BLOCK
} else {
	   &DoPostTheTopic;
}#end if/else LWA = yes
} #end if/else field check
}  ## END POST TOPIC SR ###

sub DoPostTheTopic {

##get current date/time

&GetDateTime;

##verify user name/password
$match = "no";
$verified = "false";

 #already have member list - @members
@thismember = grep(/$UserNameFile.cgi/, @members);

GETUSER: foreach $member2(@thismember) {
	if ($member2 eq "$UserNameFile.cgi") {
		$match = "yes";
		@profilestats2 = &OpenProfile("$UserName.cgi");
	
		if ($profilestats2[1] eq "$in{'Password'}") {
				$verified = "true";
				$Location = "$profilestats2[6]";
				$Occupation = "$profilestats2[5]";
				$Email = "$profilestats2[2]";
				$Status = "$profilestats2[8]";
				$TotalPosts = "$profilestats2[7]";
				$Interests = "$profilestats2[9]";
				$URL = "$profilestats2[3]";
				$Permission = "$profilestats2[4]";
				$DateRegistered = "$profilestats2[10]";
				$EmailView = "$profilestats2[11]";
			last GETUSER;
		}  #END IF profilestats
	
	} #END IF $MEMBER
		
}  #end FOREACH $member

chomp($EmailView);
&CheckPermissions;

if ($match eq "no") {
&NoMatch
}

if ($match eq "yes" && $verified eq "false") {
&WrongPassword;
}

if ($match eq "yes" && $verified eq "true") {

if ($PermissionToWrite eq "true") {
##determine last topic number and increment by 1

opendir (FORUMCOUNT, "$ForumsPath/Forum$number"); 
    @forumcounter = readdir(FORUMCOUNT);
closedir (FORUMCOUNT);

#make sure we are only sorting m files
@forumcounter = grep(/\.(n|m)/, @forumcounter);
$count = @forumcounter;

if ($in{'EmailNotification'} eq "yes") {
	$Extension = "nm";
}  else {
	$Extension = "m";
}

if ($count > 0) {
@sortedforum = sort(@forumcounter);
@sortedforum = reverse(@sortedforum);
$lasttopic = $sortedforum[0];
($lastnumber, $trash, $trash2, $trash3) = split("-", $lasttopic);
$lasttopic++;
$newtopic = sprintf("%6d", $lasttopic);
$newtopic =~tr/ /0/;

##create filenumber for new topic
$newtopicfile = ("$newtopic-000000-$RunonDate-000000.$Extension");
}  else {
$newtopicfile = ("000000-000000-$RunonDate-000000.$Extension");
}
#now we have to add the message to the forum directory

## IF HTML is not allowed, render HTML useless
if ($HTMLAllow eq "is not") {
		$Message =~ s/</&lt;/g;
		$Message =~ s/>/&gt;/g;
    }
	

if ($Censor eq "ON") {
	for (@censored) {
		if (m/({)(.*)(})/) {
			$_ = ("$2 ");
			$wordlength = length($_);
			$wordlength = $wordlength - 1;
			$replaceword = "*" x $wordlength;
			$replaceword = "$replaceword ";
		}  else {
		$wordlength = length($_);
		$replaceword = "*" x $wordlength;
		}
		$Message =~ s/$_/$replaceword/isg;
	}
}
#convert newlines/carriage returns to <br> and <p> html tags
$Message = &ConvertReturns("$Message");
	
#UBB Code-ify (if allowed)
if ($UBBCodeAllow eq "is") {
$Message = &UBBCode("$Message");
} #end if UBB Code allowed

$Message = &Smilies("$Message");

&Lock ("lock.file");
open (FORUM, ">$ForumsPath/Forum$number/$newtopicfile"); 
print FORUM ("$UserName\n");
print FORUM ("$HyphenDate\n");
print FORUM ("$Time\n");
print FORUM ("$TopicSubject\n");
print FORUM ("$Email\n");
print FORUM ("$Message\n");
close (FORUM);
&Unlock ("lock.file");

##CREATE HTML FILE FOR NEW THREAD
&CreateThreadHTML("Forum$number", "$newtopicfile");

&TopicConfirmHTML;


##Add reply to user's profile (total posts)
$TotalPosts++;
#Bump user up to Member if Total Posts reaches $MemberMinimum
if (($TotalPosts == $MemberMinimum)  && ($Status eq "Junior Member")) {
$Status = "Member";
}


&Lock ("lock.file");
open (MEMBERS, ">$MembersPath/$UserNameFile.cgi") or die("Unable to open Members directory.");
	print MEMBERS ("$UserName|");
	print MEMBERS ("$in{'Password'}|");
	print MEMBERS ("$Email|");
	print MEMBERS ("$URL|");
	print MEMBERS ("$Permission|");
	print MEMBERS ("$Occupation|");
	print MEMBERS ("$Location|");
	print MEMBERS ("$TotalPosts|");
	print MEMBERS ("$Status|");
	print MEMBERS ("$Interests|");
	print MEMBERS ("$DateRegistered|");
	print MEMBERS ("$EmailView\n");
close (MEMBERS);
&Unlock ("lock.file");


#update last time file
&Lock ("lock.file");
open (LASTTIME, ">$ForumsPath/Forum$number/lasttime.file") or die("Unable to open LastTime.file");
print LASTTIME ("$HyphenDate\n");
print LASTTIME ("$Time\n");
close (LASTTIME);
&Unlock ("lock.file");

## UPDATE INDEX
if ($ForumStatus eq "On") {
&AppendIndex("$number", "$newtopicfile");
}

# If Forum is set to Moderator Notify,
# need to send notification to forum moderator
if ($ModNotify eq "yes") {
$ModName = ("Forum" . "$number" . "Moderator");
$ModName = $$ModName;
@ModProfile = &OpenProfile("$ModName.cgi");
$sendto = $ModProfile[2];
$subject = "Moderator Notification: New Topic in $Forum";
$message = "Hello, $ModName!  \n\r\n$UserName has just created a new topic entitled - $TopicSubject - in the $Forum forum of $BBName. \n\r\n This BB is located at $CGIURL/Ultimate.cgi";

if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}

} #end mod notify block

} else {

&PermissionDeniedHTML;

} #END Check Permission block
}  # END IF block

} #end do post the topic sr
 
sub GetBio {
@thisprofile = &OpenProfile("$UserName.cgi");
$EmailView = $thisprofile[11];
chomp($EmailView);

if (($EmailBlock eq "ON") || ($EmailView eq "no")) {
$EmailField = "Not available.";
}  else {
$EmailField = "<A HREF=\"mailto:$thisprofile[2]\">$thisprofile[2]</A>";
}
&ViewBioHTML;
}  ## END GET BIO sr




sub CheckBioID {
if (($in{'UserName'} eq "") || ($in{'Password'} eq "")) {
	&MissingFields;

} else {

&GetMemberListArray; #returns @members

GETBIO: foreach $member(@members) {
	if ($member eq "$UserNameFile.cgi") {
		$found = "yes";
		#Check Password Now
		
	@thisprofile = &OpenProfile("$UserName.cgi");
	
         if ($in{'Password'} eq "$thisprofile[1]") {
		     $pwmatch = "true";
			 $Password = $thisprofile[1];
			 $Email = $thisprofile[2];
			 $URL = $thisprofile[3];
			 $Occupation = $thisprofile[5];
			 $Location = $thisprofile[6];
			 $Interests = $thisprofile[9];
			 $Status = $thisprofile[8];
			 $TotalPosts = $thisprofile[7];
			 $Permissions = $thisprofile[4];
			$DateRegistered = $thisprofile[10];
	$EmailView = $thisprofile[11];
	chomp($EmailView);
            &ProcessEdit;
			last GETBIO;
         }
    } ## END IF MEMBER = Username.cgi condition

}  ## END FOREACH MEMBER loop

if ($found ne "yes") {
   &NoMatch;
}
if (($found eq "yes") && ($pwmatch ne "true")) {
   &WrongPassword;
}
} # end check for missing fields
}  ## END CheckBioID SR ###


sub ModifyBio {
if (($Email eq "") || ($in{'NewPassword'} eq "") || ($Email !~ /\@/)) {
&MissingFields;
 }  else {
 
## Confirm UserName and Password to prevent hacking

&OpenProfile("$UserName.cgi");  #returns @profileinfo
$CurrentEmail = "$profileinfo[2]";
$Permissions = "$profileinfo[4]";
$TotalPosts = "$profileinfo[7]";
$Status = "$profileinfo[8]";
$DateRegistered = "$profileinfo[10]";
chomp($DateRegistered);

if ($profileinfo[1] eq "$in{'Password'}") {

## check for duplicate email addresses, if applicable

if ($EmailCheck eq "true") {
&GetMemberListArray;
$duplicate = "";

CHECKEMAIL: for $checkemails(@members) {

open (MEM, "$MembersPath/$checkemails") or die("Unable to open Members directory.");
@checkemail = <MEM>;
close (MEM);

	@profileEM = split (/\|/, $checkemail[0]);
	
if (($Email eq "$profileEM[2]") && ($UserName ne "$profileEM[0]")) {
$duplicate = "yes";
last CHECKEMAIL;
}
} # end for $checkemails

}  #END if Email check eq TRUE

if ($duplicate eq "yes") { 
	&Duplicate;
} else {
# if email verify is on, then we can't let users change
# email address without sending a new password generated
# by system to them
$Password = "$in{'NewPassword'}";
$ModifyWarning = "";

if (($CurrentEmail ne "$Email") && ($UseEmail eq "ON") && ($EmailVerify eq "ON")){
#generate new password
$NewPassword = &GeneratePassword;
$sendto = "$Email";
$from = "$BBEmail";
$subject = "$BBName Registration - Your New Password";
$message = "Hello!\n\r\nBecause you just modified your email address, we have sent you a new password to use for your registration on $BBName.  Your registration information is provided below, including your new password.  You will need this information in order to post any messages in our forums.\n\r\nYour UserName: $UserName\nYourPassword: $NewPassword\nYour Email Address of record is now: $Email";
$Password = "$NewPassword";
$ModifyWarning = "Note: Because you changed your email address, and because we require email verification, a new password has been issued to you.  This new password has been sent to: $Email.  You may change your password, but you may not change your password and email address at the same time.  Thank you!"; 
if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
}  
&Lock ("lock.file");
##print profile fields to file
open (MEMBERSHIP, ">$MembersPath/$UserNameFile.cgi") || die("Unable to open Members directory.");

	print MEMBERSHIP ("$UserName|");
	print MEMBERSHIP ("$Password|");
	print MEMBERSHIP ("$Email|");
	print MEMBERSHIP ("$URL|");
	print MEMBERSHIP ("$Permissions|");
	print MEMBERSHIP ("$Occupation|");
	print MEMBERSHIP ("$Location|");
	print MEMBERSHIP ("$TotalPosts|");
	print MEMBERSHIP ("$Status|");
	print MEMBERSHIP ("$Interests|");
	print MEMBERSHIP ("$DateRegistered|");
	print MEMBERSHIP ("$in{'EmailView'}\n");
close (MEMBERSHIP);
&Unlock ("lock.file");
#confirm processing to user, provide links to other places

&BioModifyConfirmHTML;
}
}  else  {
&UnauthorizedAccess;
}

}
}  ## END Modify Bio SR

sub RegSubmit {

if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {

	if ( ($in{'UserName'} eq "") || ($in{'Email'} eq "") )  {
		&MissingFields;
		} else {
		&GoAhead;
	}

} else {

	if ( ($in{'UserName'} eq "") || ($in{'Email'} eq "") || 	($in{'Password'} eq "") || ($PasswordConfirm eq "") )  {
		&MissingFields;
	}  else {
	
		if ($in{'Password'} eq "$PasswordConfirm") {
			&GoAhead; 
			}  else {
			&GoBack;
		}
	}
}
}  ## END RegSubmit SR ##


sub GoAhead  {	
#check for illegal (non alphanumeric characters)
$_ = "$UserNameFile";
if ((m/\W+/) || (m/\b[_]/) || (m/[_]\b/) || (m/_{2,}/)) {
&IllegalNameHTML;
}  else {
#check to make sure Username is unique

&GetMemberListArray;

$LCUNFile = "$UserNameFile"; #Get ready to lower case it
	$LCUNFile =~ tr/A-Z/a-z/; #convert to lc for check
$duplicate = "no";


CHECKDUPES: for $checkthis(@members) {
	$checkthisLC = "$checkthis";
	$checkthisLC =~ tr/A-Z/a-z/; #convert to lc for check
	if ($checkthisLC eq "$LCUNFile.cgi") {
		$duplicate = "yes";
		&Duplicate;
		last CHECKDUPES;
	}
#CHECK to make sure email isn't a duplicate too

if (($duplicate ne "yes") && ($EmailCheck eq "true")) {

open (MEM, "$MembersPath/$checkthis") or die("Unable to open Members directory.");
@checkemail = <MEM>;
close (MEM);

	@profile = split (/\|/, $checkemail[0]);
	
if ($Email eq "$profile[2]") {
$duplicate = "yes";
&Duplicate;
}
}  #END if duplicate ne yes

}  # end checkdupes loop

if ($duplicate ne "yes") {

	if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {

#generate password
$Password = &GeneratePassword;
}  else {
$Password = "$in{'Password'}";
}

# Get Today's Date so we can log the date of registration

&GetDateTime;

## APPEND NEW REGISTRATION TO REG FILE
&Lock ("lock.file");
open (MEMBERSHIP, ">$MembersPath/$UserNameFile.cgi") or die("Unable to open Members directory.");
	print MEMBERSHIP ("$UserName|");
	print MEMBERSHIP ("$Password|");
	print MEMBERSHIP ("$Email|");
	print MEMBERSHIP ("$URL|");
	print MEMBERSHIP ("Write|");
	print MEMBERSHIP ("$Occupation|");
	print MEMBERSHIP ("$Location|");
	print MEMBERSHIP ("0|");
	print MEMBERSHIP ("Junior Member|");
	print MEMBERSHIP ("$Interests|");
	print MEMBERSHIP ("$HyphenDate|");
	print MEMBERSHIP ("$in{'EmailView'}\n");
close (MEMBERSHIP);
&Unlock ("lock.file");

if (($UseEmail eq "ON") && ($EmailVerify eq "ON")) {
$sendto = "$Email";
$from = "$BBEmail";
$subject = "$BBName Registration - Your Password";
$message = "Hello!\n\r\nThank you for registering on $BBName.  Your registration is provided below, including your new password.  You will need this information in order to post any messages in our forums.\n\r\nYour UserName: $UserName\nYourPassword: $Password\nYour Email Address of record is: $Email\n\r\n  Note that you change this password online using the \"edit profile\" button on our bulletin board.  If you change your registered email address, however, a new random password will be emailed to you so that we can verify any new email address you use.\n\r\nAgain, thank you for registering.";
if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}

$RegWording1 = "You have successfully registered your User Name for $BBName. ";
$RegWording2 = "Your password has been emailed to you at $Email";
&PrintRegistrationHTML;
}  else {
$RegWording1 = "You have successfully registered your User Name and Password for $BBName. ";
$RegWording2 = "$in{'Password'}";
&PrintRegistrationHTML;
	} # end use email/verify on check
} ### end if dupe ne yes

} # end if/else /m
}  # end GoAhead subroutine

sub ProcessClose {

	if ( ($in{'UserName'} eq "") || ($in{'Password'} eq "") )  {
		&MissingFields;
		} else {
# verify admin or mod status
&GetMemberListArray;  #returns @members

$NameFound = "no";

foreach $check(@members) {
  if ($check eq "$UserNameFile.cgi") {
      $NameFound = "yes";
    } 
}  # END FOREACH CHECK

if ($NameFound eq "yes") {
@profilestats = &OpenProfile("$UserName.cgi");
	
	if ($in{'Password'} eq "$profilestats[1]") {
	$Status = "$profilestats[8]";
	&CheckTheStatus;
	
	#get moderator for this forum
	$Moderator = ("Forum" . "$number" . "Moderator");
	$Moderator = $$Moderator;

	   if (($AdminStatus eq "true") || ($Moderator eq "$UserName")) {
			## get most current topic file name (in case someone posted new reply)
$TopicNumber = substr($topic, 0, 13);
&GrabTopic; #returns $TopicFile

### can't use rename for certain NT systems, thus, here's the fix:
open (THISFILE, "$ForumsPath/Forum$number/$TopicFile");
@topicfile = <THISFILE>;
close(THISFILE);

($Part1, $Part2, $Part3, $Part4) = split("-", $TopicFile);
($Foot, $Trash) = split(/\./, $Part4);
$NewFileName = ("$Part1" . "-$Part2" . "-$Part3" . "-$Foot" . "X" . ".m");

# added an X to denote that topic is closed

open (RENAME, ">$ForumsPath/Forum$number/$NewFileName");
for (@topicfile) {
chomp($_);
print RENAME "$_\n";
}
close(RENAME);

unlink ("$ForumsPath/Forum$number/$TopicFile");


# re-do the HTML page associated with this file

&CreateThreadHTML("Forum$number", "$NewFileName");

# Send confirmation screen
print <<CONFIRMHTML;
<HTML><HEAD>
<meta http-equiv="Refresh" content="3; URL=Ultimate.cgi?action=topics&DaysPrune=$DaysPrune&number=$number&forum=$ForumCoded&LastLogin=$in{'LastLogin'}">
</HEAD>
<BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace">
<B>The following thread has been closed:<P>
<font color="$LinkColor"></FONT>$TopicSubject
<P>
You are being automatically transported to the $Forum forum.  Please wait three seconds.
<P>
</B><br><br>
</FONT>
</ul></body></html>
CONFIRMHTML


	   }  else  {
	   &NotAllowed;
	   }
	   
	} else {
	&WrongPassword;
	}
	
}  else {
&WrongUserName;

}  ##END IF/ELSE NAME CHECK BLOCK
} # end missing fields check
} # end process close sr




sub PWRequest {
# Find the right registration
&GetMemberListArray;  # returns @members array
$Found = "";
CHECKPROFILES: foreach $eachmember(@members) {
				
			@thisprofile = &OpenProfile("$eachmember");
			
				if ($thisprofile[2] eq "$sendto") {
					$YourName = "$thisprofile[0]";
					$YourPassword = "$thisprofile[1]";
					$Found = "yes";
					last CHECKPROFILES;
				}
}

if ($Found eq "yes") {

#Send the Email

$from = "$BBEmail";
$subject = "Your UserName and Password - $BBName";
$message = ("Here is the registration information you requested for $BBName. \n\n Your UserName is: $YourName\n Your Password is: $YourPassword \n\n This bulletin board is located at $CGIURL/Ultimate.cgi \n\nThank you!");
if ($SMTPEmail eq "On") {
&SendEmail;
}  else {
&send_mail("$BBEmail", "$sendto", "$subject", "$message");
}
#Notify user that email has been sent

print<<DUMMY;
<HTML><head>
<meta http-equiv="Refresh" content="5; URL=Ultimate.cgi?action=intro&BypassCookie=true&LastLogin=$in{'LastLogin'}"></head>
<BODY BGCOLOR="$BGColor"  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0>
<P><BR><blockquote>
<B><FONT FACE="$FontFace" size="2">Your username and password for this bulletin board have just been emailed to you!
<P>
You are now being automatically returned to the main forums page.</FONT></B></blockquote>
</BODY></HTML>
DUMMY
}  else {
print<<DUMMY;
<HTML><head>
</head>
<BODY BGCOLOR="$BGColor"  text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<IMG SRC="$NonCGIURL/$BBTitle" BORDER=0>
<P><BR><blockquote>
<B><FONT FACE="$FontFace" size=2>We have no one registered with the email address you listed.  Use your back button to try again.
</FONT></B></blockquote>
</BODY></HTML>
DUMMY
}
} #end PWRequest sr

sub SubmitEdit {

#verify that forum fields are complete

if (($in{'UserName'} eq "") || ($in{'Password'} eq "") || ($in{'EditedMessage'} eq "")) {
	&MissingFields;
	}  else {

## check UBB and HTML status for this forum
@thisforum = &GetForumRecord($number);
 chomp($thisforum[10]);
$UBBImages = "$thisforum[10]";
$ForumStatus = "$thisforum[3]";

if ($thisforum[4] eq "is") {
	$HTMLAllowed = "yes";
}  else {
	$HTMLAllowed = "no";
}
 
if ($thisforum[5] eq "is") {
	$UBBAllowed = "yes";
}  else {
	$UBBAllowed = "no";
}

if (($UBBImages eq "OFF") && ($UBBAllowed eq "yes")) {
	$UBBImagesWording = "\[IMG\] UBB Code Not Allowed!";
}

$Moderator = ("Forum" . "$number" . "Moderator");
$Moderator = $$Moderator;

## Get current message from file
open (POST, "$ForumsPath/Forum$number/$topic");
@thispost = <POST>;
close (POST);

$postUserName = $thispost[0];
chomp($postUserName);
$postdate = $thispost[1];
chomp($postdate);
$posttime = $thispost[2];
chomp($posttime);
$postemail = $thispost[4];
chomp($postemail);
$author = $thispost[0];
chomp($author);
$TopicSubject = $thispost[3];
chomp($TopicSubject);

$Password = &decodeURL($in{'Password'});

@profileinfo = &OpenProfile("$UserName.cgi");   
	
if (($author eq "$UserName")  || ($Moderator eq "$UserName") || ($profileinfo[4] =~ m/Admin/)) {
#check password
	if ($profileinfo[1] eq "$Password") {
		&DoTheEdit;
	}  else {
	&WrongPassword;
	}

}  else {
&NotAllowed;
}
} #end Missing fields check if/else
}  #end SubmitEdit sr


sub DoTheEdit {

## format the edited message
$EditedMessage = $in{'EditedMessage'};

## IF HTML is not allowed, render HTML useless
if ($HTMLAllowed eq "no") {

		$EditedMessage =~ s/</&lt;/g;
		$EditedMessage =~ s/>/&gt;/g;

 }
 
if ($Censor eq "ON") {
	for (@censored) {
		if (m/({)(.*)(})/) {
			$_ = ("$2 ");
			$wordlength = length($_);
			$wordlength = $wordlength - 1;
			$replaceword = "*" x $wordlength;
			$replaceword = "$replaceword ";
		}  else {
		$wordlength = length($_);
		$replaceword = "*" x $wordlength;
		}
		$EditedMessage =~ s/$_/$replaceword/isg;
	}
}

#convert newlines/carriage returns to HTML
$EditedMessage = &ConvertReturns("$EditedMessage");

#UBB Code-ify (if allowed)
if ($UBBAllowed eq "yes") {
$EditedMessage = &UBBCode("$EditedMessage");
} #END UBB CODE 

#Smiley/Frown conversion---
$EditedMessage = &Smilies("$EditedMessage");

&GetDateTime;

if ($DateFormat eq "US") {
	$EditDate = "$HyphenDate";
} else {
	$EditDate = "$EuroDate";
}
# append edit note to the message
$EditedMessage .= "<p>[This message has been edited by $UserName (edited $EditDate).]";

#open post for writing
&Lock ("lock.file");
open (POST, ">$ForumsPath/Forum$number/$topic");
print POST ("$postUserName\n");
print POST ("$postdate\n");
print POST ("$posttime\n");
print POST ("$TopicSubject\n");
print POST ("$postemail\n");
print POST ("$EditedMessage\n");
close (POST);
&Unlock ("lock.file");
#grab topic (father)
$TopicNumber = substr($topic, 0, 6);
$TopicNumber = ("$TopicNumber" . "-000000");
&GrabTopic;  #returns $TopicFile

chomp($thispost[5]);
$OrigText = &Indexify("$thispost[5]");

##CREATE HTML FILE FOR Revised THREAD
&CreateThreadHTML("Forum$number", "$TopicFile");

## Update Index
if ($ForumStatus eq "On") {
&UpdateIndex("$number", "$TopicFile", "$OrigText", "$EditedMessage");
}
# send onscreen confirmation to user

print <<CONFIRM;
<HTML><HEAD>
<meta http-equiv="Refresh" content="2; URL=$NonCGIURL/Forum$number/HTML/$ThreadNumber.html">
</HEAD>
 <BODY BGCOLOR="$BGColor"  $PageBackground text="$TextColor" link="$LinkColor" vlink="$VisitedLinkColor">
<br><br>
<ul><FONT SIZE="$TextSize" FACE="$FontFace" COLOR="$LinkColor">
<B>Thanks for editing the message, $UserName!  We are now sending you back automatically to the thread list for this topic.  Please wait two seconds.
</B><br><br>
</FONT>
</ul></body></html>
CONFIRM


}  # end DoTheEdit sr


