/*
edd.h

Author: Antti Huima <huima@ssh.fi>

Copyright (c) 1996 SSH Communications Security Oy, Espoo, Finland <info@ssh.fi>
                   All rights reserved

  Header file for the Encrypting Data Dumper.

*/

/*
 * $Id: edd.h,v 1.3 1997/05/08 03:05:04 kivinen Exp $
 * $Log: edd.h,v $
 * Revision 1.3  1997/05/08 03:05:04  kivinen
 * 	Added cvs-log.
 * 	Added #ifndef EDD_H around file.
 *
 * $Endlog$
 */

#ifndef EDD_H
#define EDD_H

#define HEADER_LENGTH 0x1000

#define EDD_VERSION "1.0"

#define VERSION_HEADER "EDD FILE V1.0\n"

/* Protocol specifies the null character as a part of the
   header string also */

#define VERSION_HEADER_LENGTH (strlen(VERSION_HEADER) + 1)
#define VERSION_NUMBER 0

#define MIN_BLOCK_SIZE 0x0010
#define MAX_BLOCK_SIZE 0xf0000

#define RANDOM_SEED_FILE "~/.ssh/random_seed"

#define DEFAULT_DIAGNOSTICS "efn"
#define DEFAULT_BLOCK_SIZE 0x1000

#define STREAM_COMMENT_MAX_LENGTH 1024
#define KEY_COMMENT_MAX_LENGTH 1024

#define PR_KEYFILE_ENV "EDD_PRIVATE"
#define PUB_KEYFILE_ENV "EDD_PUBLIC"

#define FILE_SUFFIX ".edd"

#endif /* EDD_H */
