//////////////////////////////////////////////////////////////////////
//
// This source code is a part of GeometryManager library from 
// Stonehorse Software and may not be redistributed in any form.
//
// Copyright (C) 1998 Stonehorse Software
// All rights reserved.
//
// GeometryManager.h : Interface to the Geometry Manager
//
//////////////////////////////////////////////////////////////////////

#ifndef __GEOMETRYMANAGER_H__
#define __GEOMETRYMANAGER_H__

#ifdef _cplusplus
extern "C" {
#endif

typedef HANDLE	HGEOM;
typedef HANDLE	HGMGROUP;

// GeomAdd... dwFlag values
#define GM_GROW_X				0x00000001		// group can grow in width
#define GM_GROW_Y				0x00000002		// group can grow in height
#define GM_GROW					0x00000003		// group can grow in width and height

#define GM_LEFT					0x00000000		// align this group to the left
#define GM_HCENTER				0x00000010		// horizontally center this group
#define GM_RIGHT				0x00000020		// align this group to the right
#define GM_TOP					0x00000000		// align this group to the top
#define GM_VCENTER				0x00000040		// vertically center this group
#define GM_BOTTOM				0x00000080		// align this group to the bottom

#define GM_HORIZONTAL			0x00000000		// children are arranged horizontally
#define GM_VERTICAL				0x80000000		// children are arranged vertically
#define GM_OVERLAPPED			0x40000000		// children are arranged overlapped

// GmStartDefinition dwFlags values
#ifndef _WIN32_WCE
#define GM_NO_TRACK_MIN_SIZE	0x00000001		// do not limit the minimum size of the top level window
#endif //_WIN32_WCE

// register this instance of GeometryManager
bool GmRegister(char* pCodeString);

// start the definition of the geometry management
HGEOM GmStartDefinition(DWORD dwFlags);

// end the definition
bool GmEndDefinition(HGEOM hGeom);

// top level groups
HGMGROUP GmAddTopFrameWnd(HGEOM hGeom, HWND hWnd, DWORD dwFlags);
HGMGROUP GmAddTopDialog(HGEOM hGeom, HWND hWnd, DWORD dwFlags);

// child groups
HGMGROUP GmAddGroup(HGEOM hGeom, HGMGROUP hParent, DWORD dwFlags, WORD wWeight);
HGMGROUP GmAddWnd(HGEOM hGeom, HGMGROUP hParent, HWND hWnd, DWORD dwFlags, WORD wWeight);
HGMGROUP GmAddGroupBox(HGEOM hGeom, HGMGROUP hParent, HWND hWnd, DWORD dwFlags, WORD wWeight);
HGMGROUP GmAddStaticFrame(HGEOM hGeom, HGMGROUP hParent, HWND hWnd, DWORD dwFlags, WORD wWeight);
HGMGROUP GmAddTabControl(HGEOM hGeom, HGMGROUP hParent, HWND hWnd, DWORD dwFlags, WORD wWeight);
HGMGROUP GmAddChildDialog(HGEOM hGeom, HGMGROUP hParent, HWND hWnd, DWORD dwFlags, WORD wWeight);

#ifdef _cplusplus
}
#endif

#endif //__GEOMETRYMANAGER_H__
