@echo off
rem :::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
rem : The following variables may be changed to customize this utility
rem : to a specific system configuration:

rem : The folder to store copies of the registry files:
set _BACKUPDIR_=C:\REGBKUP

rem : The folder in which Windows is installed:
set _WINDIR_=C:\WINDOWS

rem : The root folder for user profiles
set _PROFILESDIR_=%_WINDIR_%\Profiles
rem : uncomment the following line to skip processing user profiles
rem set _PROFILESDIR_=_

rem : The rest of this file does not need to be modified
rem :::::::::::::::::::::::::::::::::::::::::::::::::::::::

echo --------------------------------------------------------------------
echo Registry Backup/Restore utility (a part of Folder Guard)
echo Copyright (c) 1997-98, WinAbility.Com. All rights reserved.
echo --------------------------------------------------------------------

goto _start

:_message

echo --------------------------------------------------------------------
echo Usage: enter at the MS-DOS command prompt (in MS-DOS mode only!):
echo   REGISTRY BACKUP  - to back up the registry
echo   REGISTRY RESTORE - to restore the registry
echo --------------------------------------------------------------------
echo Attention: this utility is set up to use the following folders:
echo           Registry backup folder: %_BACKUPDIR_%
echo                   Windows folder: %_WINDIR_%
echo    Root folder for user profiles: %_PROFILESDIR_%
echo If your system configuration is different, edit 'REGISTRY.BAT'!
echo ---------------------------------------------------------------------

goto _exit

:_start

rem : Verify that _WINDIR_ specifies valid Windows folder
rem : (the folder must contain WIN.COM)

if exist %_WINDIR_%\WIN.COM goto _01
echo E R R O R : Invalid Windows folder specified: '%_WINDIR_%'
echo Edit 'REGISTRY.BAT' !
goto _exit
:_01

rem : Verify that the Profiles folder exists, if specified
if [%_PROFILESDIR_%]==[_] goto _02
if exist %_PROFILESDIR_%\NUL goto _02
echo Cannot find the Profiles folder specified: '%_PROFILESDIR_%'
echo Press any key to continue and SKIP processing the user profiles
echo or press Ctrl+Break to abort
pause > NUL
set _PROFILESDIR_=_
:_02

rem: Analyze the command line arguments supplied

if [%2]==[] goto _04
echo E R R O R : Too many command line arguments specified
goto _message
:_04

if not [%1]==[] goto _05
echo E R R O R : No command line argument specified
goto _message
:_05

rem : Validate the argument passed

if [%1]==[BACKUP] goto _do_work
if [%1]==[backup] goto _do_work
if [%1]==[RESTORE] goto _do_work
if [%1]==[restore] goto _do_work

echo E R R O R: Invalid command line argument: '%1'
goto _message

:_do_work

rem : Make sure we are running in MS-DOS mode
if [%windir%]==[] goto _06
echo E R R O R: Cannot backup/restore registry while Windows is running.
goto _exit
:_06

if [%1]==[BACKUP] goto _backup
if [%1]==[backup] goto _backup
if [%1]==[RESTORE] goto _restore
if [%1]==[restore] goto _restore

rem :::::::::::::::::::::::::::::::
rem ::  Backing up the Registry  ::
rem :::::::::::::::::::::::::::::::

:_backup

echo This will backup the Registry into folder:
echo   %_BACKUPDIR_%
echo assuming Windows is installed in folder:
echo   %_WINDIR_%

if [%_PROFILESDIR_%]==[_] goto _07
echo assuming user profiles are located in subfolders of:
echo   %_PROFILESDIR_%
:_07

echo Press any key to continue or Ctrl+Break to abort.
echo --------------------------------------------------------------------
pause > NUL

rem : create the backup folder if it does not exist

if exist %_BACKUPDIR_%\NUL goto _09
md %_BACKUPDIR_%
:_09

echo * Backing up System.dat...
attrib -R -S -H %_WINDIR_%\System.dat
copy /Y %_WINDIR_%\System.dat %_BACKUPDIR_%
attrib +R +S +H %_WINDIR_%\System.dat

echo * Backing up User.dat...
attrib -R -S -H %_WINDIR_%\User.dat
copy /Y %_WINDIR_%\User.dat %_BACKUPDIR_%
attrib +R +S +H %_WINDIR_%\User.dat

if [%_PROFILESDIR_%]==[_] goto _11

rem : Create subfolder to store user profiles
if exist %_BACKUPDIR_%\NUL goto _10
md %_BACKUPDIR_%\PROFILES
:_10

echo * Backing up user profiles...
attrib -R -S -H %_PROFILESDIR_%\*.dat /S
echo d | xcopy %_PROFILESDIR_%\*.dat %_BACKUPDIR_%\PROFILES /S
attrib +R +S +H %_PROFILESDIR_%\*.dat /S

:_11

goto _exit

rem ::::::::::::::::::::::::::::::
rem ::  Restoring the Registry  ::
rem ::::::::::::::::::::::::::::::

:_restore

if exist %_BACKUPDIR_%\NUL goto _12
echo E R R O R: Backup folder '%_BACKUPDIR_%' does not exist.
echo Edit 'REGISTRY.BAT' !
goto _exit
:_12

echo This will restore the Registry from folder:
echo   %_BACKUPDIR_%
echo assuming Windows is installed in folder:
echo   %_WINDIR_%

if [%_PROFILESDIR_%]==[_] goto _13
echo assuming user profiles are located in subfolders of:
echo   %_PROFILESDIR_%
:_13

echo Press any key to continue or Ctrl+Break to abort.
echo --------------------------------------------------------------------
pause > NUL

echo * Restoring System.dat...
attrib -R -S -H %_WINDIR_%\System.dat
copy /Y %_BACKUPDIR_%\System.dat %_WINDIR_%
attrib +R +S +H %_WINDIR_%\System.dat

echo * Restoring User.dat...
attrib -R -S -H %_WINDIR_%\User.dat
copy /Y %_BACKUPDIR_%\User.dat %_WINDIR_%
attrib +R +S +H %_WINDIR_%\User.dat

if [%_PROFILESDIR_%]==[_] goto _15
echo * Restoring user profiles...
attrib -R -S -H %_PROFILESDIR_%\*.dat /S
echo d | xcopy %_BACKUPDIR_%\PROFILES\*.dat %_PROFILESDIR_% /S
attrib +R +S +H %_PROFILESDIR_%\*.dat /S
:_15

goto _exit

:_exit

rem : Clean up the environment

set _BACKUPDIR_=
set _WINDIR_=
set _PROFILESDIR_=

pause
