	<!--- Ensure username is not blank. --->
	<CFIF #Form.username# EQ "">
		<CFSET reUsername = "empty">
	<CFELSE><!--- Ensure username is not already taken. --->
		<CFQUERY NAME=checkUser DATASOURCE="#CFdatasource#">
			SELECT userID FROM User WHERE username = '#Form.username#'
		</CFQUERY>
		<CFIF #checkUser.RecordCount# GT 0>
			<CFSET reUsername = "taken">
		</CFIF>
	</CFIF>

	<CFIF #Form.password# EQ ""><!--- Ensure password is not blank --->
		<CFSET rePassword = "empty">
	<CFELSEIF #Form.password# NEQ #Form.passwordVerify#><!--- Ensure password is verified correctly --->
		<CFSET rePassword = "verify">
	</CFIF>

	<!--- Problem with username or password. Redisplay new user form with original field values. --->
	<CFIF IsDefined("reUsername") OR IsDefined("rePassword")>
		<CFQUERY NAME=getGroups DATASOURCE="#CFdatasource#">
			SELECT groupID, groupName FROM Grp ORDER BY groupName
		</CFQUERY>
		<CFQUERY NAME=getForums DATASOURCE="#CFdatasource#">
			SELECT forumID, forumName FROM Forum ORDER BY forumName
		</CFQUERY>

		<HTML>
		<HEAD><TITLE>Emaze Forums: Add user</TITLE></HEAD>
		<CFIF #Form.confID# EQ 0>
			<CFINCLUDE TEMPLATE="../system/systemBody.cfm">
		<CFELSE>
			<CFINCLUDE TEMPLATE="../conf/#Form.confID#Body.cfm">
		</CFIF>

		<CFIF IsDefined("reUsername")>
			<CFIF #reUsername# EQ "empty">
				<H3>You must enter a username.</H3>
			<CFELSEIF #reUsername# EQ "taken">
				<H3>Username <I><CFOUTPUT>#Form.username#</CFOUTPUT></I> already taken. Please choose another one.</H3>
			</CFIF>		
		</CFIF>
		<CFIF IsDefined("rePassword")>
			<CFIF #rePassword# EQ "empty">
				<H3>You must enter a password.</H3>
			<CFELSEIF #rePassword# EQ "verify">
				<H3>Your password was not verified correctly. Please try again.</H3>
			</CFIF>		
		</CFIF>
		<CFIF #Form.confID# EQ 0>
			<CFINCLUDE TEMPLATE="../system/systemAdduserHeader.cfm">
		<CFELSE>
			<CFINCLUDE TEMPLATE="../conf/#Form.confID#AdduserHeader.cfm">
		</CFIF>
		<P>
		<CFOUTPUT><FORM METHOD=POST ACTION="#systemURL#/program/adduser.cfm"></CFOUTPUT>
		<INPUT TYPE=hidden NAME=first VALUE=0>
		<CFOUTPUT><INPUT TYPE=hidden NAME=confID VALUE=#Form.confID#></CFOUTPUT>
		<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>	
		<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Username: </TD>
		<CFIF IsDefined("reUsername")>
			<TD><INPUT TYPE=text NAME=username SIZE=20 MAXLENGTH=25></TD></TR>
		<CFELSE>
			<TD><CFOUTPUT><INPUT TYPE=text NAME=username VALUE="#Form.username#" SIZE=20 MAXLENGTH=25></CFOUTPUT></TD></TR>
		</CFIF>
		<CFIF IsDefined("rePassword")>
			<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Password: </TD><TD><INPUT TYPE=password NAME=password SIZE=20 MAXLENGTH=25></TD></TR>
			<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> (Verify) </TD><TD><INPUT TYPE=password NAME=passwordVerify SIZE=20 MAXLENGTH=25></TD></TR>
		<CFELSE>
			<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Password: </TD><TD><CFOUTPUT><INPUT TYPE=password NAME=password VALUE="#Form.password#" SIZE=20 MAXLENGTH=25></CFOUTPUT></TD></TR>
			<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> (Verify) </TD><TD><CFOUTPUT><INPUT TYPE=password NAME=passwordVerify VALUE="#Form.passwordVerify#" SIZE=20 MAXLENGTH=25></CFOUTPUT></TD></TR>
		</CFIF>
		<TR><TD COLSPAN=2>&nbsp;</TD></TR>
		<TR><TD ALIGN=right>First Name: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=firstName VALUE="#Form.firstName#" SIZE=20 MAXLENGTH=25></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right>Last Name: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=lastName VALUE="#Form.lastName#" SIZE=20  MAXLENGTH=35></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right>Email: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=email VALUE="#Form.email#" SIZE=20 MAXLENGTH=50></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right>Cookie login: </TD><TD><INPUT TYPE=checkbox NAME=useCookie VALUE=1<CFIF IsDefined("Form.useCookie")> CHECKED</CFIF>> Enables you to enter conference without logging in</TD></TR>

		<TR><TD COLSPAN=2 ALIGN=center HEIGHT=40><INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit VALUE="Create User"></TD></TR>
		</TABLE>
		</FORM>

		<CFINCLUDE TEMPLATE="copyright.cfm">
		</BODY></HTML>
	<CFELSE><!--- Username and password are fine. Create user. --->
		<!--- Get next useID. Increment next userID. --->
		<CFINCLUDE TEMPLATE="../system/nextUserID.cfm">
		<CFSET nextUserID = userID + 1>
		<CFFILE ACTION=Write FILE="#systemPath#\system\nextUserID.cfm" OUTPUT="<CFSET userID = #nextUserID#>">

		<!--- For each field, if blank, write space to database. --->
		<CFIF #Form.firstName# EQ ""><CFSET fName = " ">
		<CFELSE><CFSET fName = "#Form.firstName#">
		</CFIF>

		<CFIF #Form.lastName# EQ ""><CFSET lName = " ">
		<CFELSE><CFSET lName = "#Form.lastName#">
		</CFIF>

		<CFIF #Form.email# EQ ""><CFSET  mail = " ">
		<CFELSE><CFSET mail = "#Form.email#">
		</CFIF>

		<CFIF IsDefined("Form.useCookie")>
			<CFSET cookieLogin = 1>
			<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
			<!--- Write permanent cookie to user's browser cookie file --->
			<CFCOOKIE NAME="EmazeForums_login"
				VALUE="#userID#,#username#"
				EXPIRES="NEVER"
				DOMAIN="#systemDomain#">
		<CFELSE><CFSET cookieLogin = 0>
		</CFIF>

		<!--- Write new user to database --->
		<CFQUERY NAME="CreateUser" DATASOURCE="#CFdatasource#">
			INSERT INTO User (email, firstName, lastName, password, useCookie, userID, username)
			VALUES ('#mail#', '#fName#', '#lName#', '#Form.password#', #cookieLogin#, #userID#, '#Form.username#')
        </CFQUERY>

		<!--- Determine groups for new user. Add to groups. --->
		<CFIF #Form.confID# EQ 0><!--- If system add user page, not conference --->
			<CFINCLUDE TEMPLATE="../system/systemNewUserGroup.cfm">
		<CFELSE>
			<CFINCLUDE TEMPLATE="../conf/#confID#NewUserGroup.cfm">
		</CFIF>
		<CFIF #newUserGroup# NEQ " " AND #ListLen("#newUserGroup#")# NEQ 0>
			<CFLOOP INDEX=groupCount LIST="#newUserGroup#">
				<CFQUERY NAME="JoinGroups" DATASOURCE="#CFdatasource#">
					INSERT INTO UserGrp (userID, groupID)
					VALUES (#userID#, '#groupCount#')
		        </CFQUERY>
			</CFLOOP>
		</CFIF>
	<!--- End of IF statement which determines whether to add user or
		redisplay add user form due to username and/or password problem. --->
	</CFIF>
