<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<HTML>
<HEAD>
<CFIF IsDefined("confID")>
	<!--- Ensure user has read permission for this conference. --->
	<CFSET checkPermission = "read">
	<CFINCLUDE TEMPLATE="secure.cfm">

	<CFINCLUDE TEMPLATE="../conf/#confID#Name.cfm">
	<TITLE>Emaze Forums: Search - <CFOUTPUT>#confName#</CFOUTPUT></TITLE>
	</HEAD>
	<CFINCLUDE TEMPLATE="../conf/#confID#Body.cfm">
<CFELSE>
	<TITLE>Emaze Forums: Search</TITLE>
	</HEAD>
	<CFINCLUDE TEMPLATE="../system/systemBody.cfm">
</CFIF>

<CFSET navAlign = "top">
<CFINCLUDE TEMPLATE="navigate.cfm">

<CFOUTPUT><IMG SRC="#systemURL#/images/searchbanner.gif" ALT="Search Messages" BORDER="0"></CFOUTPUT>
<P>
<!--- Get search permissions --->
<CFIF IsDefined("confID")>
	<CFINCLUDE TEMPLATE="../conf/#confID#Search.cfm">
<CFELSE>
	<CFINCLUDE TEMPLATE="../system/systemSearch.cfm">
</CFIF>
<!--- If allowed to search by at least one field, display search fields --->
<CFIF #ListLen("#search#")# NEQ 0 AND #search# NEQ " ">
	<FORM METHOD=post ACTION="search.cfm">
	<INPUT TYPE=hidden NAME=first VALUE=0>

	<!--- Display search query header for conference --->
	<CFIF IsDefined("confID")>
		<CFINCLUDE TEMPLATE="../conf/#confID#SearchQueryHeader.cfm">
		<CFOUTPUT><INPUT TYPE=hidden NAME=confID VALUE=#confID#></CFOUTPUT>
	<CFELSE>
		<CFINCLUDE TEMPLATE="../system/systemSearchQueryHeader.cfm">
	</CFIF>
	<P>

	<!--- Display search fields which are permitted --->
	<!---
	Each has a CFIF which prints the form field if it exists.
	This is because the search options are listed at the top of the page
	when listing the search results.
	--->
	<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2>
	<CFIF #ListContains("#search#","subject")#>
		<TR><TD ALIGN=right>Subject: </TD>
		<TD><INPUT TYPE=text NAME="searchSubject" SIZE=20<CFIF IsDefined("Form.searchSubject")><CFOUTPUT> VALUE="#Form.searchSubject#"</CFOUTPUT></CFIF>></TD></TR>
	</CFIF>
	<CFIF #ListContains("#search#","message")#>
		<TR><TD ALIGN=right>Message: </TD>
		<TD><INPUT TYPE=text NAME="searchMessage" SIZE=20<CFIF IsDefined("Form.message")><CFOUTPUT> VALUE="#Form.message#"</CFOUTPUT></CFIF>></TD></TR>
	</CFIF>
	<CFIF #ListContains("#search#","author")#>
		<TR><TD ALIGN=right>Author: </TD>
		<TD><INPUT TYPE=text NAME="searchAuthor" SIZE=20<CFIF IsDefined("Form.author")><CFOUTPUT> VALUE="#Form.author#"</CFOUTPUT></CFIF>></TD></TR>
	</CFIF>
	<CFIF #ListContains("#search#","date")#>
		<TR><TD ALIGN=right>From date: </TD><TD>
		<CFIF IsDefined("Form.fromMonth")>
			<CFOUTPUT><INPUT TYPE=text NAME="fromMonth" SIZE=2 MAXLENGTH=2 VALUE="#Form.fromMonth#"> 
			<B>/</B> <INPUT TYPE=text NAME="fromDay" SIZE=2 MAXLENGTH=2 VALUE="#Form.fromDay#"> 
			<B>/</B> <INPUT TYPE=text NAME="fromYear" SIZE=4 MAXLENGTH=4 VALUE="#Form.fromYear#"></CFOUTPUT>
		<CFELSE>
			<INPUT TYPE=text NAME="fromMonth" SIZE=2 MAXLENGTH=2 VALUE="MM"> 
			<B>/</B> <INPUT TYPE=text NAME="fromDay" SIZE=2 MAXLENGTH=2 VALUE="DD"> 
			<B>/</B> <INPUT TYPE=text NAME="fromYear" SIZE=4 MAXLENGTH=4 VALUE="YYYY">
		</CFIF>
		&nbsp; &nbsp; To date: 
		<CFIF IsDefined("Form.fromMonth")>
			<CFOUTPUT><INPUT TYPE=text NAME="toMonth" SIZE=2 MAXLENGTH=2 VALUE="#Form.toMonth#"> 
			<B>/</B> <INPUT TYPE=text NAME="toDay" SIZE=2 MAXLENGTH=2 VALUE="#Form.toDay#"> 
			<B>/</B> <INPUT TYPE=text NAME="toYear" SIZE=4 MAXLENGTH=4 VALUE="#Form.toYear#"></CFOUTPUT>
		<CFELSE>
			<CFOUTPUT><INPUT TYPE=text NAME="toMonth" SIZE=2 MAXLENGTH=2 VALUE="#Month(Now())#"> 
			<B>/</B> <INPUT TYPE=text NAME="toDay" SIZE=2 MAXLENGTH=2 VALUE="#Day(Now())#"> 
			<B>/</B> <INPUT TYPE=text NAME="toYear" SIZE=4 MAXLENGTH=4 VALUE="#Year(Now())#"></CFOUTPUT>
		</CFIF>
		</TD></TR>
	</CFIF>
	<CFIF NOT IsDefined("confID")>
		<CFQUERY NAME=getConferenceNames DATASOURCE="#CFdatasource#">
			SELECT confID, confName FROM Conference ORDER BY confName
		</CFQUERY>
		<TR><TD VALIGN=top ALIGN=right>Conference(s): </TD>
		<TD><SELECT NAME=conferences SIZE=4 MULTIPLE>
		<CFIF IsDefined("Cookie.EmazeForums_confs")>
			<CFOUTPUT QUERY="getConferenceNames">
				<CFIF #ListContains("#Cookie.EmazeForums_confs#",#getConferenceNames.confID#)# NEQ 0>
					<OPTION VALUE=#getConferenceNames.confID#>#confName#
				</CFIF>
			</CFOUTPUT>
		<CFELSE>
			<CFINCLUDE TEMPLATE="../system/confAnonSelect.cfm">
			<CFOUTPUT QUERY="getConferenceNames">
				<CFIF #ListContains("#confs#",#getConferenceNames.confID#)# NEQ 0>
					<OPTION VALUE=#getConferenceNames.confID#>#confName#
				</CFIF>
			</CFOUTPUT>
		</CFIF>
		</SELECT></TD></TR>
	</CFIF>
	<CFIF #ListLen("#search#")# GT 1>
		<TR>
		<CFIF IsDefined("Form.andor")><!--- "and" search OR "or" search --->
		<TD ALIGN=right><INPUT TYPE=radio NAME="andor" VALUE="AND"<CFIF #Form.andor# EQ "and"> CHECKED</CFIF>><BR>
		<INPUT TYPE=radio NAME="andor" VALUE="OR"<CFIF #Form.andor# EQ "or"> CHECKED</CFIF>></TD>
		<CFELSE>
		<TD ALIGN=right><INPUT TYPE=radio NAME="andor" VALUE="AND" CHECKED><BR>
		<INPUT TYPE=radio NAME="andor" VALUE="OR"></TD>
		</CFIF>
		<TD>AND (<I>Find messages which satisfy all search fields</I>)<BR>
		OR (<I>Find messages which satisfy at least one search field</I>)</TD></TR>
	</CFIF>
	<TR><TD></TD><TD><INPUT TYPE=reset VALUE=Clear> <INPUT TYPE=submit VALUE="Search"></TD></TR>
	</TABLE>
	</FORM>
</CFIF>

<!---  Beginning of show results section --->
<CFIF IsDefined("Form.first")>

<HR NOSHADE><!--- Display search results header --->
<CFIF NOT IsDefined("Form.confID") AND NOT IsDefined("Form.conferences")>
	<H3>You did not choose the conference(s) to search. Please choose the conference(s) and try your search again.</H3>
</CFIF>

<CFIF IsDefined("Form.confID")>
	<CFINCLUDE TEMPLATE="../conf/#confID#SearchResultsHeader.cfm">
	<CFINCLUDE TEMPLATE="../conf/#Form.confID#Moderated.cfm">
<CFELSE>
	<CFINCLUDE TEMPLATE="../system/systemSearchResultsHeader.cfm">
	<CFIF IsDefined("Form.conferences")>
		<CFIF #ListLen("#Form.conferences#")# GT 1>
			<CFSET confCount = 2>
		</CFIF>
	<CFELSE>
		<CFSET conferences = 0>
	</CFIF>
</CFIF>
<P>
<!--- Search messages based on search criteria
This is a confusing query.
1. We get the forum name, message, and user info.
2. Search only forum in this conference.
3. If moderated conference, search only approved messages
4. Search permitted criteria if not blank
5. Search for messages which satisfy all (AND) or at least criteria (OR)
6. Order results in reverse chronological order, latest message at top
--->

<CFQUERY NAME="searchMsgs" DATASOURCE="#CFdatasource#">
	<CFIF IsDefined("Form.confID")>
		SELECT Forum.forumName, User.firstName, User.lastName, Message.userID, 
			Message.forumID, Message.msgID, Message.subject, Message.msgDateTime, 
			Message.message, Message.anonName
		FROM ((Forum INNER JOIN Message ON Forum.forumID = Message.forumID)
			INNER JOIN User ON Message.userID = User.userID)
			INNER JOIN ConfForum ON Forum.forumID = ConfForum.forumID
		WHERE Forum.forumStatus <> 0 AND ConfForum.confID = #Form.confID#
		<CFIF #moderated# EQ 1>AND Message.approved = 1</CFIF>
	<CFELSE>
		SELECT ConfForum.confID, Conference.confName, Message.forumID, Forum.forumName,
			User.firstName, User.lastName, Message.msgID, Message.userID,
			Message.anonName, Message.msgDateTime, Message.message, Message.subject
		FROM (((Conference INNER JOIN ConfForum ON Conference.confID = ConfForum.confID)
			INNER JOIN Forum ON ConfForum.forumID = Forum.forumID)
			INNER JOIN Message ON Forum.forumID = Message.forumID)
			INNER JOIN User ON Message.userID = User.userID
		WHERE Forum.forumStatus <> 0 AND Message.approved = 1 
			AND (ConfForum.confID = #ListGetAt("#conferences#",1)#
		<CFIF IsDefined("confCount")>
			<CFLOOP INDEX="confCount" LIST="#Form.conferences#">
				OR ConfForum.confID = #confCount#
			</CFLOOP>)
		</CFIF>
	</CFIF>
	<CFIF IsDefined("Form.searchAuthor")>
		<CFIF #Form.searchAuthor# NEQ "" AND #Form.searchAuthor# NEQ " ">
			#Form.andor# (Message.anonName LIKE '%#Form.searchAuthor#%'
				OR User.firstName LIKE '%#Form.searchAuthor#%'
				OR User.lastName LIKE '%#Form.searchAuthor#%')
		</CFIF>
	</CFIF>
	<CFIF IsDefined("Form.searchSubject")>
		<CFIF #Form.searchSubject# NEQ "" AND #Form.searchSubject# NEQ " ">
			#Form.andor# Message.subject LIKE '%#Form.searchSubject#%'
		</CFIF>
	</CFIF>
	<CFIF IsDefined("Form.searchMessage")>
		<CFIF #Form.searchMessage# NEQ "" AND #Form.searchMessage# NEQ " ">
			#Form.andor# Message.message LIKE '%#Form.searchMessage#%'
		</CFIF>
	</CFIF>
	<CFIF IsDefined("Form.fromMonth")>
		<CFIF #Form.fromMonth# NEQ "MM" AND #Form.fromDay# NEQ "DD" AND #Form.fromYear# NEQ "YYYY">
			#Form.andor# (Message.msgDateTime >= #CreateODBCDateTime(CreateDate(Form.fromYear, Form.fromMonth, Form.fromDay))#
				AND Message.msgDateTime <= #CreateODBCDateTime(CreateDateTime(Form.toYear, Form.toMonth, Form.toDay, 23, 59, 59))#)
		</CFIF>
	</CFIF>
ORDER BY Message.msgDateTime DESC
</CFQUERY>

<P>

<!--- Display number of results returned and each message with link to message in forum.
Eventually, we will only display X messages per page rather than return
them in one long list. --->
<H3><CFOUTPUT>#searchMsgs.RecordCount#</CFOUTPUT> messages found. Most recent message is listed first.</H3>

<CFOUTPUT QUERY="searchMsgs">
	<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=600>
	<CFIF NOT IsDefined("Form.confID")>
		<TR><TD COLSPAN=2><FONT SIZE=2>Conference:</FONT> #confName#</TD></TR>
		<TR><TD COLSPAN=2><FONT SIZE=2>Forum:</FONT> #forumName#</TD></TR>
		<TR><TD COLSPAN=2><FONT SIZE=2>Subject:</FONT> <A HREF="#systemURL#/program/readForum.cfm?confID=#confID#&forumID=#forumID#&msgID=#msgID#">#subject#</A></TD></TR>
	<CFELSE>
		<TR><TD COLSPAN=2><FONT SIZE=2>Forum:</FONT> #forumName#</TD></TR>
		<TR><TD COLSPAN=2><FONT SIZE=2>Subject:</FONT> <A HREF="#systemURL#/program/readForum.cfm?confID=#Form.confID#&forumID=#forumID#&msgID=#msgID#">#subject#</A></TD></TR>
	</CFIF>
	<TR><TD><FONT SIZE=2>Posted by:</FONT>
	<CFIF #userID# EQ -1><!--- anon --->#anonName#
	<CFELSEIF #firstName# NEQ "" AND #firstName# NEQ " " AND #lastName# NEQ "" AND #lastName# NEQ " ">#firstName# #lastName#
	<CFELSEIF #lastName# NEQ "" AND #lastName# NEQ " "><!--- only last name --->#lastName#
	<CFELSE><!--- only first name --->#firstName#
	</CFIF>
	</TD>
	<TD ALIGN=right>#DateFormat("#msgDateTime#", "Mm-dd-yyyy")# / #TimeFormat("#msgDateTime#")#</TD></TR>
	<TR><TD COLSPAN=2><BR>#message#</TD></TR>
	<TR><TD COLSPAN=2><HR NOSHADE></TD></TR>
	</TABLE>
</CFOUTPUT>

</CFIF><!---  End of show results section --->

<CFSET navAlign = "bottom">
<CFINCLUDE TEMPLATE="navigate.cfm">

<CFINCLUDE TEMPLATE="copyright.cfm">
</BODY></HTML>