<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<!---
If from navigation buttons, determine if:
1. Reading new forum in this conference
2. Go to conference homepage
3. Go to system homepage
--->
<CFIF IsDefined("Form.forumNavButton")>
	<CFSET confID = #Form.forumConfID#>
<CFELSEIF IsDefined("Form.confNavButton") AND #confID# EQ 0>
	<CFLOCATION URL="#systemURL#/program/homepage.cfm">
<CFELSEIF IsDefined("Form.confNavButton") AND #confID# NEQ 0>
	<CFLOCATION URL="#systemURL#/program/confHomepage.cfm?confID=#Form.confID#">
</CFIF>

<CFINCLUDE TEMPLATE="../conf/#confID#Name.cfm">

<!---
Check for userID and permissions.
Does anon login if not logged in.
If login, checks whether permissions are for this conference.
If not, get user permissions for this conference.
--->
<CFINCLUDE TEMPLATE="confCheck.cfm">

<!--- Page layout
1. Conference name in title
2. Conference body tag
3. Navigation buttons
4. Conference header
5. Custom forum header
6. Forum index
7. Messages
8. Post new message (if post permission)
9. Custom forum footer
10. Conference footer
11. Navigation buttons
--->

<CFINCLUDE TEMPLATE="../forum/#forumID#Name.cfm">
<HTML>
<HEAD><TITLE>Emaze Forums: <CFOUTPUT>#confName#</CFOUTPUT></TITLE></HEAD>
<CFINCLUDE TEMPLATE="../conf/#confID#Body.cfm">

<!--- confHeaderFooter can be deleted later when BasicInfo comes on line --->
<CFINCLUDE TEMPLATE="../conf/#confID#HeaderFooter.cfm">
<CFINCLUDE TEMPLATE="../forum/#forumID#HeaderFooter.cfm">

<!--- Display navigation buttons. --->
<CFSET navAlign = "top">
<CFINCLUDE TEMPLATE="navigate.cfm">

<!--- Insert conference header. 1 = Include internal file. 2 = Include external file --->
<CFIF #confHeader# EQ 1><!--- include internal conference header --->
	<CFINCLUDE TEMPLATE="../conf/#confID#ForumHeader.cfm"><P>
<CFELSEIF #confHeader# EQ 2><!--- include external conference footer --->
	<CFFILE ACTION=Read FILE="#systemPath#\conf\#confID#ForumHeader.cfm" VARIABLE="confHeaderPath">
	<CFINCLUDE TEMPLATE="#confHeaderPath#"><P>
</CFIF>

<!--- Insert forum header. 1 = Include internal file. 2 = Include external file --->
<CFIF #forumHeader# EQ 1><!--- include internal forum header --->
	<CFINCLUDE TEMPLATE="../forum/#forumID#Header.cfm"><P>
<CFELSEIF #forumHeader# EQ 2><!--- include external forum footer --->
	<CFFILE ACTION=Read FILE="#systemPath#\forum\#forumID#Header.cfm" VARIABLE="forumHeaderPath">
	<CFINCLUDE TEMPLATE="#forumHeaderPath#"><P>
</CFIF>

<!--- Get index status, message order, and moderated status. --->
<CFINCLUDE TEMPLATE="../conf/#confID#IncludeIndex.cfm">
<CFINCLUDE TEMPLATE="../conf/#confID#MsgOrder.cfm">
<CFINCLUDE TEMPLATE="../conf/#confID#Moderated.cfm">

<!--- Get forum messages in proper order --->
<!--- 0 = threaded, 1 = chronological, 2 = reverse chronological  --->
<CFQUERY NAME=getMessages DATASOURCE="#CFdatasource#">
	SELECT Message.msgID, Message.subject, Message.msgDateTime, Message.message,
		Message.attachment, Message.anonEmail, Message.anonName, Message.userID,
		User.firstName, User.lastName, User.email,
		Message.approved, Message.indent, Message.responses
	FROM User INNER JOIN Message ON Message.userID = User.userID
	WHERE forumID = #forumID#
	<CFIF #msgOrder# EQ 0>ORDER BY msgID
	  <CFELSEIF #msgOrder# EQ 1>ORDER BY msgDateTime
	  <CFELSE><!--- #msgOrder# EQ 2 --->ORDER BY msgDateTime DESC
	</CFIF>
</CFQUERY>

<!--- Display forum index if includeIndex=1 or user is admin in moderated conference --->
<CFIF IsDefined("Cookie.EmazeForums_permissions")>
	<CFSET permissions = "#ListRest("#Cookie.EmazeForums_permissions#")#">
	<CFIF #moderated# EQ 1 AND (#Cookie.EmazeForums_userID# EQ 0
			OR #ListContains("#permissions#",#forumID#)#)>
		<CFSET includeIndex = 1>
	</CFIF>
<CFELSE>
	<CFINCLUDE TEMPLATE="../conf/#confID#AnonPermissions.cfm">
	<CFSET permissions = "#confAnonPermissions#">
</CFIF>

<CFIF #includeIndex# EQ 1>
	<CFINCLUDE TEMPLATE="forumIndex.cfm">
</CFIF>

<!--- If forumStatus=1 (active) display "Post Message" and "Post Reply" buttons --->
<CFINCLUDE TEMPLATE="../forum/#forumID#Status.cfm">

<P><CFOUTPUT><IMG SRC="#systemURL#/images/messages.gif" ALT="Messages" BORDER="0"></CFOUTPUT><P>

<!--- Display messages --->
<CFINCLUDE TEMPLATE="printMsg.cfm">

<!--- If user has post permission, include Post Message form at bottom of screen --->
<CFIF (#forumStatus# EQ 1 AND #ListContains("#permissions#","post")#) OR IsDefined("master")>
	<P><CFOUTPUT><IMG SRC="#systemURL#/images/postmessage.gif" ALT="Post New Message" BORDER="0"></CFOUTPUT><P>
	<CFINCLUDE TEMPLATE="postMsgTemplate.cfm">
</CFIF>

<P>

<!--- Insert forum footer --->
<CFIF #forumFooter# EQ 1><!--- include internal forum header --->
	<CFINCLUDE TEMPLATE="../forum/#forumID#Header.cfm">
<CFELSEIF #forumFooter# EQ 2><!--- include external forum footer --->
	<CFFILE ACTION=Read FILE="#systemPath#\forum\#forumID#Footer.cfm" VARIABLE="forumFooterPath">
	<CFINCLUDE TEMPLATE="#forumFooterPath#">
</CFIF>

<P>

<!--- Insert conference footer --->
<CFIF #confFooter# EQ 1><!--- include internal conference footer --->
	<CFINCLUDE TEMPLATE="../conf/#confID#ForumFooter.cfm">
<CFELSEIF #confFooter# EQ 2><!--- include external conference footer --->
	<CFFILE ACTION=Read FILE="#systemPath#\conf\#confID#ForumFooter.cfm" VARIABLE="confFooterPath">
	<CFINCLUDE TEMPLATE="#confFooterPath#">
</CFIF>

<!--- Incluce navigation buttons. --->
<CFSET navAlign = "bottom">
<CFINCLUDE TEMPLATE="navigate.cfm">

<CFINCLUDE TEMPLATE="copyright.cfm">
</BODY>
</HTML>