<!--- Ensure user read permission in this conference--->
<CFSET checkPermission = "read">
<CFINCLUDE TEMPLATE="secure.cfm">

<!---
Puts permissions and admin permissions in separate variable.
First value is confID, which could overlap with forumID and
cause a problem since Cold Fusion only finds the first occurrence.
--->
<CFIF IsDefined("Cookie.EmazeForums_permissions")>
	<CFSET permissions = "#ListRest("#Cookie.EmazeForums_permissions#")#">
	<CFIF #Cookie.EmazeForums_userID# EQ 0>
		<CFSET master = 1>
	<CFELSEIF #Cookie.EmazeForums_userID# EQ -1>
		<CFSET confAnonPermissions = 1>
	</CFIF>
<CFELSE>
	<CFINCLUDE TEMPLATE="../conf/#confID#AnonPermissions.cfm">
	<CFSET permissions = "#confAnonPermissions#">
</CFIF>

<!---
If not moderated, display all messages.
If moderated conference and user has admin permission to this forum, display all messages.
If moderated and not admin, display only approved messages.
--->
<CFOUTPUT QUERY="getMessages">
	<CFIF #moderated# EQ 0 OR #getMessages.approved# EQ 1
			OR #ListContains("#permissions#",#forumID#)# OR IsDefined("master")>
		<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2 WIDTH=600>
		<TR>
		<CFIF #msgOrder# EQ 0><!--- threaded. determine indent level. --->
			<CFIF #indent# EQ 1><TD ROWSPAN=5 WIDTH=25><IMG SRC="#systemURL#/images/clearpixel.gif" HEIGHT=5 WIDTH=25></TD>
			<CFELSEIF #indent# EQ 2><TD ROWSPAN=5 WIDTH=50><IMG SRC="#systemURL#/images/clearpixel.gif" HEIGHT=5 WIDTH=50></TD>
			<CFELSEIF #indent# EQ 3><TD ROWSPAN=5 WIDTH=75><IMG SRC="#systemURL#/images/clearpixel.gif" HEIGHT=5 WIDTH=75></TD>
			</CFIF>
		</CFIF>
		<TD COLSPAN=2 WIDTH=#Evaluate(600 - (25*indent))#><A NAME="#msgID#"></A><!--- Anchor tag from forum index --->
		<!--- If threaded and message is not indented, make subject bigger --->
		<CFIF #msgOrder# EQ 0 AND #indent# EQ 0><FONT SIZE=4>#subject#</FONT>
		<CFELSE>#subject#
		</CFIF>
		</TD></TR>
		
		<TR><TD>
		<CFIF #userID# EQ -1><!--- anon --->
			<CFIF #anonEmail# NEQ "" AND #anonEmail# NEQ " "><A HREF="mailto:#anonEmail#">#anonName#</A>
			<CFELSE>#anonName#
			</CFIF>
		<CFELSE><!--- username. print only non-empty fields. --->
			<CFIF #email# NEQ "" AND #email# NEQ " "><A HREF="mailto:#email#"></CFIF>
			<CFIF #firstName# NEQ "" AND #firstName# NEQ " " AND #lastName# NEQ "" AND #lastName# NEQ " ">#firstName# #lastName#
			<CFELSEIF #lastName# NEQ "" AND #lastName# NEQ " "><!--- only last name --->#lastName#
			<CFELSE><!--- only first name --->#firstName#
			</CFIF>
			<CFIF #email# NEQ "" AND #email# NEQ " "></A></CFIF>
		</CFIF>
		</TD>
		<TD ALIGN=right>#DateFormat("#msgDateTime#", "Mm-dd-yyyy")# / #TimeFormat("#msgDateTime#")#</TD></TR>
		<TR><TD COLSPAN=2><BR>#message#<BR><BR></TD></TR>
		<TR><TD COLSPAN=2 VALIGN=center>
			<!--- If user has post permission, include Reply to Post button at each message --->
			<CFIF #forumStatus# EQ 1 AND #indent# NEQ 3 AND (#ListContains("#permissions#","post")# NEQ 0 OR IsDefined("master"))>
				<A HREF="reply.cfm?confID=#confID#&forumID=#forumID#&r_msgID=#msgID#"><IMG SRC="#systemURL#/images/reply.gif" ALT="Reply" BORDER="0"></A>
			</CFIF>
			<!--- If user has email subscription permission and not already subscribed, include image at each message to subscribe --->
			<CFIF #forumStatus# EQ 1 AND (#ListContains("#permissions#","emailSubscription")# NEQ 0 OR IsDefined("master")) AND NOT IsDefined("confAnonPermissions")>
				<A HREF="subscribe.cfm?confID=#confID#&forumID=#forumID#&s_msgID=#msgID#"><IMG SRC="#systemURL#/images/subscribe.gif" ALT="Subscribe" BORDER="0"></A>
			</CFIF>
			<!--- If attachment, display Download Attachment button --->
			<CFIF #attachment# NEQ "" AND #attachment# NEQ " ">
				<A HREF="getAttachment.cfm?confID=#confID#&forumID=#forumID#&msgID=#msgID#"><IMG SRC="#systemURL#/images/download.gif" ALT="Download attachment" BORDER="0"></A>
			</CFIF>
			<!--- If user has delete permission, include Delete button at each message they posted --->
			<!--- If user has admin permission for this forum, include Delete button at each message --->
			<CFIF #ListContains("#permissions#","#forumID#")# OR IsDefined("master")>
				<A HREF="delete.cfm?confID=#confID#&forumID=#forumID#&msgID=#msgID#"><IMG SRC="#systemURL#/images/delete.gif" ALT="Delete" BORDER="0"></A>
			<CFELSEIF #forumStatus# EQ 1 AND #ListContains("#permissions#","delete")# NEQ 0 AND NOT IsDefined("confAnonPermissions")>
				<CFIF #getMessages.userID# EQ #Cookie.EmazeForums_userID#>
					<A HREF="delete.cfm?confID=#confID#&forumID=#forumID#&msgID=#msgID#"><IMG SRC="#systemURL#/images/delete.gif" ALT="Delete" BORDER="0"></A>
				</CFIF>
			</CFIF>
			<CFIF IsDefined("master")>
				<A HREF="move.cfm?oldConfID=#confID#&oldForumID=#forumID#&oldMsgID=#msgID#"><IMG SRC="#systemURL#/images/move.gif" ALT="Move" BORDER="0"></A>
			</CFIF>
		</TD></TR>
		<!--- If not last message, include HR to separate messages. --->
		<CFIF #getMessages.CurrentRow# LT #getMessages.RecordCount#>
			<TR><TD COLSPAN=2><HR NOSHADE></TD></TR>
		</CFIF>
		</TABLE>
	</CFIF>
</CFOUTPUT>
