<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<!--- Ensure user has permission to post messages in this conference. --->
<CFSET checkPermission = "post">
<CFINCLUDE TEMPLATE="secure.cfm">

<!---
1. Get next msgiD
2. Increment next msgID
3. Set indent and reply value
4. Status:
	a. If moderated and not admin, approved=2 (ignored)
	b. If moderated and admin, or not moderated, approved=1 (approved)
5. Get datetime
6. Add message to msg table
7. If attachment, ensure name is not already taken; write to attachment/forum directory.
8. Update Forum msgCount and lastMsgDate
9. Reload forum at new message.
--->

<!---
If post to new forum:
1. Check name is not taken by forum in that conference
2. If name is taken, ask to enter a different forum name.
3. If name is not taken, call newForum.cfm to create the new forum.
--->

<!---
Stores forumID where message is being posted. Used to avoid constantly
having to check whether the message is being posted in the original
forum or a new forum.
--->

<CFIF #Form.message# EQ "">
	<CFLOCATION URL="readForum.cfm?confID=#Form.confID#&forumID=#Form.forumID#">
</CFIF>

<CFIF NOT IsDefined("nextForumID")>
	<CFSET nextForumID = #Form.forumID#>
</CFIF>

<CFIF IsDefined("Form.newForum")><!--- -If posting to a new forum --->
	<CFSET newForumName = #Replace("#Form.newForumName#", """", "&quot;", "ALL")#>
	<!--- Check that forum name is not already being used in conference --->
	<CFIF #newForumName# NEQ "" AND #newForumName# NEQ " ">
		<CFQUERY NAME=checkForumName DATASOURCE="#CFdatasource#">
			SELECT Forum.forumName
			FROM ConfForum INNER JOIN Forum ON ConfForum.forumID = Forum.forumID
			WHERE ConfForum.confID = #Form.confID#
				AND Forum.forumName = '#newForumName#'
		</CFQUERY>
		<CFIF #checkForumName.RecordCount# EQ 0>
			<!--- Forum nane is ok. Create forum. --->
			<CFINCLUDE TEMPLATE="newForum.cfm">
		<CFELSE><CFSET forumNameTaken = 1>
		</CFIF>
	</CFIF>

	<CFIF IsDefined("forumNameTaken") OR #newForumName# EQ "" OR #newForumName# EQ " ">
		<!--- Forum name is already being used. Re-display post message form. --->
		<CFINCLUDE TEMPLATE="../conf/#confID#Name.cfm">
		<CFINCLUDE TEMPLATE="../forum/#forumID#Name.cfm">
		<HTML><HEAD><TITLE>Emaze Forums: <CFOUTPUT>#confName#</CFOUTPUT></TITLE></HEAD>
		<CFINCLUDE TEMPLATE="../conf/#confID#Body.cfm">
		<CFSET navAlign = "top">
		<CFINCLUDE TEMPLATE="navigate.cfm">
		<CFIF IsDefined("forumNameTaken")>
			<H3>Forum name is already being used in this conference. Please choose another name.</H3>
		<CFELSE>
			<H3>Forum name canont be blank. Please choose a forum name.</H3>
		</CFIF>
		<CFINCLUDE TEMPLATE="postMsgTemplate.cfm">
		<CFSET navAlign = "bottom">
		<CFINCLUDE TEMPLATE="navigate.cfm">
		<CFINCLUDE TEMPLATE="copyright.cfm">
		</BODY></HTML>
		<CFABORT>
	</CFIF>
</CFIF>

<CFIF NOT IsDefined("Form.r_msgID")><!--- -If posting a new message (not a reply) --->
	<!--- Determine next msgID. Increment next msgID counter. --->
	<CFINCLUDE TEMPLATE="../system/nextMsgID.cfm">
	<CFSET newNextMsgID = nextMsgID + 1>
	<CFFILE ACTION="Write" FILE="#systemPath#\system\nextMsgID.cfm"
		OUTPUT="<CFSET nextMsgID = #NumberFormat(newNextMsgID, ""000000"")#>">

	<!--- Create msgID for a new message. --->
	<CFSET newMsgID = "#NumberFormat(nextMsgID, "000000")#-000000-000000-000000">
	<CFSET newIndent = 0><!--- Message is not indented --->
<CFELSE><!--- -If replying to a particular message --->
	<!--- Determine indent number. Increment, update number of responses for original message. --->
	<CFQUERY Name="ResponseNumber" Datasource="#CFdatasource#">
		SELECT responses, indent FROM Message WHERE msgID = '#Form.r_msgID#'
	</CFQUERY>
	<CFSET newResponseNumber = ResponseNumber.responses + 1>

	<!--- <CFSET newIndent = ResponseNumber.indent + 1> --->
	<CFIF #ListGetAt("#Form.r_msgID#",4,"-")# NEQ "000000">
		<CFSET newIndent = 4>
	<CFELSEIF #ListGetAt("#Form.r_msgID#",3,"-")# NEQ "000000">
		<CFSET newIndent = 4>
	<CFELSEIF #ListGetAt("#Form.r_msgID#",2,"-")# NEQ "000000">
		<CFSET newIndent = 3>
	<CFELSE>
		<CFSET newIndent = 2>
	</CFIF>

	<CFQUERY Name="ResponseNumberSet" Datasource="#CFdatasource#">
		UPDATE Message
		SET responses = #newResponseNumber#
		WHERE msgID = '#r_msgID#'
	</CFQUERY>
	<!--- Create msgID for the reply. --->
	<CFSET newMsgID = ListSetAt(Form.r_msgID, newIndent + 1, NumberFormat(newResponseNumber, "000000"), "-")>
</CFIF>

<!--- Determine whether conference is moderated. --->
<CFINCLUDE TEMPLATE="../conf/#Form.confID#Moderated.cfm">
<CFIF #moderated# EQ 0>
	<CFSET approved = 1>
<CFELSE>
	<CFSET approved = 2>
	<CFIF IsDefined("Cookie.EmazeForums_permissions")>
		<CFIF #ListContains("#Cookie.EmazeForums_permissions#","#forumID#")# OR #Cookie.EmazeForums_userID# EQ 0>
			<CFSET approved = 1>
		</CFIF>
	</CFIF>
</CFIF>

<!---
Here is where we will insert code to automatically hypertext URLs
and email addresses. It is not currently implemented though.
--->

<!--- ATTACHMENTS:
1. Check that file meets extension requirements
2. If no, re-create Post Message screen with notice.
3. Check that attachment/forum directory exists. If not, create it.
4. Upload attachment. Rename is necessary.

At this time, we do not notify the user if their attachment was
rejected or renamed. We could, but decided that the conference header
would likely contain a list of which attachment extensions are or are
not allowed.
--->
<CFIF NOT IsDefined("Form.includeAttachment")>
	<!--- No attachment. Insert blank space into database. --->
	<CFSET attachmentFile = " ">
<CFELSE>
	<!--- Get restrictions on attachment extensions. Get path to attachment directory. --->
	<CFINCLUDE TEMPLATE="../system/attachment01.cfm">
	<CFINCLUDE TEMPLATE="../system/attachmentExtensions.cfm">
	<CFINCLUDE TEMPLATE="../system/attachmentPath.cfm">

	<!--- Extensions which will automatically be renamed to avoid being executed on server. --->
	<CFSET badExtensions = "cfm,cgi,dll,exe,pl">

	<!--- Check whether forum directory exists in attachment directory --->
	<CFDIRECTORY ACTION=List DIRECTORY="#attachmentPath#" NAME="listDirs">
	<CFLOOP QUERY=listDirs>
		<CFIF #listDirs.Type# EQ "Dir" AND #listDirs.Name# EQ #nextForumID#>
			<CFSET dirExists = 1>
			<CFBREAK>
		</CFIF>
	</CFLOOP>
	<!--- If directory does not exist, create it. --->
	<CFIF NOT IsDefined("dirExists")>
		<CFDIRECTORY ACTION=Create DIRECTORY="#attachmentPath#\#nextForumID#">
	</CFIF>
	<!--- Upload attachment. Rename if necessary. --->
	<CFFILE ACTION=Upload FILEFIELD="attachment"
		DESTINATION="#attachmentPath#\#nextForumID#\"
		NAMECONFLICT="MakeUnique">

	<!---
	Temporary variables which store name of file after uploaded (in case renamed)
	and extension to determine if it is allowed. If not allowed, delete attachment.
	If allowed, leave alone. If executable extension, add .doc (MS Word) to make
	it harmless.

	There is probably a better way to do this, but we could not figure out a way
	to test the filename before uploading it. So we simply delete it is necessary.
	--->
	<CFSET attachmentFile = "#File.ServerFile#">
	<CFSET attachmentExt = "#File.ServerFileExt#">

	<CFIF #ListContainsNoCase("#badExtensions#","#attachmentExt#")# NEQ 0>
		<CFFILE ACTION=Rename SOURCE="#attachmentPath#\#nextForumID#\#attachmentFile#"
			DESTINATION="#attachmentPath#\#nextForumID#\#attachmentFile#.doc">
		<CFSET attachmentFile = "#attachmentFile#.doc">
	</CFIF>

	<CFIF #attachment01# EQ 0><!--- Extensions permitted only --->
		<CFIF #ListContainsNoCase("#attachmentExtensions#","#attachmentExt#")# NEQ 0>
			<CFFILE ACTION=Delete FILE="#attachmentPath#\#nextForumID#\#attachmentFile#">
			<CFSET attachmentFile = " ">
		</CFIF>
	<CFELSEIF #attachment01# EQ 1><!--- Extensions not permitted --->
		<CFIF #ListContainsNoCase("#attachmentExtensions#","#attachmentExt#")# EQ 0>
			<CFFILE ACTION=Delete FILE="#attachmentPath#\#nextForumID#\#attachmentFile#">
			<CFSET attachmentFile = " "><!--- Write blank space to database. --->
		</CFIF>
	</CFIF>
</CFIF>

<!--- Get date and time of message --->
<CFSET dateTime = #CreateODBCDateTime(Now())#>

<!---
The following are used to determine what is being written into
the anonName and anonEmail database fields. If normal user, write
blanks spaces since you cannot write nothing to a field. You could
ignore the field, but this would require another If statement.
--->

<!--- Replace carriage returns with BR so message displays correctly. --->
<CFINCLUDE TEMPLATE="../system/htmlPost.cfm">
<CFIF #htmlPost# EQ 0>
	<CFSET messageBR = #Replace("#Form.message#", "&", "&amp;", "ALL")#>
	<CFSET messageBR = #Replace("#messageBR#", """", "&quot;", "ALL")#>
	<CFSET messageBR = #Replace("#messageBR#", "<", "&lt;", "ALL")#>
	<CFSET messageBR = #Replace("#messageBR#", ">", "&gt;", "ALL")#>
</CFIF>
<CFSET messageBR = #Replace("#messageBR#", "
", "<BR>", "ALL")#>

<CFIF #Form.subject# EQ ""><CFSET newSubject = " ">
	<CFELSE><CFSET newSubject = "#Form.subject#"></CFIF>
<CFIF #Form.message# EQ ""><CFSET messageBR = " "></CFIF>
<CFIF IsDefined("Form.anonName")>
	<CFIF #Form.anonName# EQ ""><CFSET newAnonName = " ">
		<CFELSE><CFSET newAnonName = "#Form.anonName#"></CFIF>
<CFELSE><CFSET newAnonName = " ">
</CFIF>
<CFIF IsDefined("Form.anonEmail")>
	<CFIF #Form.anonEmail# EQ ""><CFSET newAnonEmail = " ">
		<CFELSE><CFSET newAnonEmail = "#Form.anonEmail#"></CFIF>
<CFELSE><CFSET newAnonEmail = " ">
</CFIF>
<CFIF IsDefined("Cookie.EmazeForums_userID")><CFSET userID = #Cookie.EmazeForums_userID#>
	<CFELSE><CFSET userID = -1></CFIF>

<CFQUERY NAME="InsertMessage" DATASOURCE="#CFdatasource#">
	INSERT INTO Message (msgID, anonEmail, anonName, approved, attachment,
		msgDateTime, forumID, indent, message, responses, subject, userID)
	VALUES ('#newMsgID#', '#newAnonEmail#', '#newAnonName#', #approved#, '#attachmentFile#',
		#dateTime#, #nextForumID#, #newIndent#, '#messageBR#', 0, '#newSubject#', #userID#)
</CFQUERY>

<!---
Get current # of messages in forum, increment, update.
Update date/time of last message posted to forum.
If first message, set date/time of first message as well.
--->
<CFQUERY Name="getMsgCount" Datasource="#CFdatasource#">
	SELECT msgCount FROM Forum WHERE forumID = #nextForumID#
</CFQUERY>
<CFSET newMsgCount = getMsgCount.msgCount + 1>
<CFQUERY Name="updateForum" Datasource="#CFdatasource#">
	UPDATE Forum
	SET msgCount = #newMsgCount#,
		<CFIF #newMsgCount# EQ 1>firstMsgDate = #dateTime#,</CFIF>
		lastMsgDate = #dateTime#
	WHERE forumID = #nextForumID#
</CFQUERY>

<CFIF IsDefined("Form.emailSubscribe")>
	<CFQUERY NAME="subscribe" DATASOURCE="#CFdatasource#">
		INSERT INTO UserMsgSubscribe (msgID, userID)
		VALUES ('#newMsgID#', #userID#)
	</CFQUERY>
</CFIF>

<!---
1. If message was reply, get email address of users who have subscribed to the message.
2. Get name, email address of person posting reply either from User table or anon fields.
3. Loop through query which got email addresses. Send notice to each person.
4. Include the proper information in the email.
--->

<CFIF IsDefined("Form.r_msgID")>
	<CFQUERY NAME=getEmailSubscribers DATASOURCE="#CFdatasource#">
		SELECT UserMsgSubscribe.userID, User.email
		FROM User INNER JOIN UserMsgSubscribe ON User.userID = UserMsgSubscribe.userID
		WHERE UserMsgSubscribe.msgID = '#Form.r_msgID#'
	</CFQUERY>

	<CFIF #getEmailSubscribers.RecordCount# GT 0>
		<CFINCLUDE TEMPLATE="../system/email.cfm">
		<CFIF #okName# EQ 1 OR #okEmail# EQ 1>
			<CFIF #userID# EQ -1>
				<CFSET posterName = "#Form.anonName#">
				<CFSET posterEmail = "#Form.anonEmail#">
			<CFELSE>
				<CFQUERY NAME=getUserEmail DATASOURCE="#CFdatasource#">
					SELECT firstName, lastName, email FROM User WHERE userID = #userID#
				</CFQUERY>
				<CFSET posterName = "#getUserEmail.firstName# #getUserEmail.lastName#">
				<CFSET posterEmail = "#getUserEmail.email#">
			</CFIF>
		</CFIF>

		<CFMAIL QUERY="getEmailSubscribers"
			TO="#getEmailSubscribers.email#"
       		FROM="#e_fromname# <#e_fromemail#>"
        	SUBJECT="#e_subject#"
	        SERVER="#e_emailserver#"
>
#e_body#

<CFIF #okName# EQ 1>Name: #posterName#</CFIF>
<CFIF #okEmail# EQ 1>Email: #posterEmail#</CFIF>
<CFIF #okDatetime# EQ 1>Date: #DateFormat("#msgDateTime#", "mmm-dd-yyyy")# / #TimeFormat("#msgDateTime#")#</CFIF>
<CFIF #okSubject# EQ 1>Subject: #Form.subject#</CFIF>

<CFIF #okMessage# EQ 1>Message:
#messageBR#</CFIF>

<CFIF #okURL# EQ 1>To view the message, go to:
#systemURL#/program/readForum.cfm?confID=#Form.confID#&forumID=#nextForumID#&msgID=#newMsgID#</CFIF>
</CFMAIL>
	</CFIF>
</CFIF>

<!--- Reload forum, pointing to new message if approved. --->
<CFIF #approved# NEQ 0>
	<CFLOCATION URL="readForum.cfm?confID=#Form.confID#&forumID=#nextForumID####newMsgID#">
<CFELSEIF IsDefined("Form.r_msgID")>
	<CFLOCATION URL="readForum.cfm?confID=#Form.confID#&forumID=#nextForumID####r_msgID#">
<CFELSE>
	<CFLOCATION URL="readForum.cfm?confID=#Form.confID#&forumID=#nextForumID#">
</CFIF>