<!--- Ensure user has create permission in this conference. --->
<CFSET checkPermission = "create">
<CFINCLUDE TEMPLATE="secure.cfm">

<!--- Determine next forumID. Increment next forumID counter. --->
<CFINCLUDE TEMPLATE="../system/nextForumID.cfm">
<CFSET newNextForumID = nextForumID + 1>
<CFFILE ACTION=Write FILE="#systemPath#\system\nextForumID.cfm"
	OUTPUT="<CFSET nextForumID = #newNextForumID#>">

<!--- Get default forum header and footer options. Create new forum. --->
<CFINCLUDE TEMPLATE="../default/forumHeaderFooter.cfm">
<CFQUERY NAME="CreateForum" DATASOURCE="#CFdatasource#">
	INSERT INTO Forum (forumID, forumDescription, forumName, forumStatus, msgCount, useForumFooter, useForumHeader)
	VALUES (#nextForumID#, ' ', '#newForumName#', 1, 0, #forumFooter#, #forumHeader#)
</CFQUERY>

<!--- Add forum to this conference. --->
<CFQUERY NAME="addConfForum" DATASOURCE="#CFdatasource#">
	INSERT INTO ConfForum (confID, forumID) VALUES (#Form.confID#, #nextForumID#)
</CFQUERY>

<!--- Create new select list of forums in this conference for navigation bar --->
<CFSET confID = #Form.confID#>
<CFINCLUDE TEMPLATE="../admin/forumSelectList.cfm">

<!--- Write forum files. Mirrors database. Used to minimize SQL queries. --->
<CFFILE ACTION=Write FILE="#systemPath#\forum\#nextForumID#Status.cfm"
	OUTPUT="<CFSET forumStatus = 1>">
<CFFILE ACTION=Write FILE="#systemPath#\forum\#nextForumID#Name.cfm"
	OUTPUT="<CFSET forumName = ""#newForumName#"">">
<CFFILE ACTION=Write FILE="#systemPath#\forum\#nextForumID#Description.cfm" OUTPUT=" ">
<CFFILE ACTION=Write FILE="#systemPath#\forum\#nextForumID#HeaderFooter.cfm"
	OUTPUT="<CFSET forumHeader = #forumHeader#>
<CFSET forumFooter = #forumFooter#>">

<!--- Copies default forum header and footer options. --->
<CFFILE ACTION=Copy SOURCE="#systemPath#\default\forumFooter.cfm" DESTINATION="#systemPath#\forum\">
	<CFFILE ACTION=Rename SOURCE="#systemPath#\forum\forumFooter.cfm" DESTINATION="#systemPath#\forum\#nextForumID#Footer.cfm">
<CFFILE ACTION=Copy SOURCE="#systemPath#\default\forumHeader.cfm" DESTINATION="#systemPath#\forum\">
	<CFFILE ACTION=Rename SOURCE="#systemPath#\forum\forumHeader.cfm" DESTINATION="#systemPath#\forum\#nextForumID#Header.cfm">

<!--- Get forum order. If custom order, add forum to end of custom forum list. --->
<CFINCLUDE TEMPLATE="../conf/#Form.confID#ForumOrder.cfm">
<CFIF #forumOrder# EQ 4>
	<CFINCLUDE TEMPLATE="../conf/#Form.confID#Forums.cfm">
	<CFSET forums = #ListAppend("#forums#","#nextForumID#")#>
	<CFFILE ACTION=Write FILE="#systemPath#\conf\#Form.confID#Forums.cfm"
		OUTPUT="<CFSET forums = ""#forums#"">">
</CFIF>

<!---
Determine if user creating new forum had admin permission to original forum.
If yes, grant user admin permission to this forum as well.
--->
<CFIF IsDefined("Cookie.EmazeForums_permissions")>
	<CFSET permissions = "#ListRest("#Cookie.EmazeForums_permissions#")#">
	<CFIF #ListContains("#permissions#",#Form.forumID#)# NEQ 0>
		<CFSET newUserPermissions = #ListAppend("#EmazeForums_permissions#",#nextForumID#)#>
		<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
		<CFCOOKIE NAME="EmazeForums_permissions" VALUE="#newUserPermissions#"
			 DOMAIN="#systemDomain#">
		<CFQUERY NAME="addAdminForum" DATASOURCE="#CFdatasource#">
			INSERT INTO UserForumAdmin (userID, forumID)
			VALUES (#Cookie.EmazeForums_userID#, #nextForumID#)
		</CFQUERY>
	</CFIF>
</CFIF>