<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<!--- If this is not the first time the file was called, process the login info --->
<CFIF NOT IsDefined("Form.first")>
	<!--- Login either via cookie or form --->
	<!---
	1. Determine whether cookie login is allowed in this conference.
	2. If no, display login screen
	3. If yes, check whether login cookie exists in user's browser cookie file
	4. If cookie does not exist, display login screen
	5. If cookie exists, check that the userID and username combination exists
	6. If valid user, log them in. Call getPermissions.cfm to determine permissions
		and display conference homepage.
	7. If not valid user, display login screen.
	--->
	<CFINCLUDE TEMPLATE="../conf/#confID#LoginCookie.cfm">
	<CFIF #loginUserCookie# NEQ 1>
		<CFSET showLoginForm = 1>
	<CFELSEIF NOT IsDefined("Cookie.EmazeForums_login")>
		<CFSET showLoginForm = 1>
	<CFELSE>
		<!---  Check that userID and username combination exists --->
		<CFQUERY NAME="checkCookie" DATASOURCE="#CFdatasource#">
			SELECT userID
			FROM User
			WHERE username = '#ListGetAt("#Cookie.EmazeForums_login#",2)#'
				AND userID = #ListGetAt("#Cookie.EmazeForums_login#",1)#
		</CFQUERY>
		<CFIF #checkCookie.RecordCount# EQ 1><!--- user exists --->
			<CFSET goConfID = #confID#>
			<CFSET goUserID = #checkCookie.userID#>
			<CFINCLUDE TEMPLATE="getPermissions.cfm">
		<CFELSE>
			<CFSET showLoginForm = 1>
		</CFIF>
	</CFIF>

	<!--- Need to display login screen because not a cookie login. --->	
	<CFIF IsDefined("showLoginForm")>
		<CFINCLUDE TEMPLATE="../conf/#confID#Name.cfm">
		<HTML><HEAD><TITLE>Emaze Forums: Login - <CFOUTPUT>#confName#</CFOUTPUT></TITLE></HEAD>
		<CFINCLUDE TEMPLATE="../conf/#confID#Body.cfm">
		<CFINCLUDE TEMPLATE="../conf/#confID#LoginHeader.cfm">
		<CFOUTPUT>
		<FORM METHOD=post ACTION="#systemURL#/program/login.cfm">
		<INPUT TYPE=hidden NAME=confID VALUE=#confID#>
		</CFOUTPUT>
		<INPUT TYPE=hidden NAME=first VALUE=1>
		<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2>
		<TR><TD ALIGN=right>Username: </TD>
		<TD><INPUT TYPE=text NAME=username SIZE=20></TD></TR>
		<TR><TD ALIGN=right>Password: </TD>
		<TD><INPUT TYPE=password NAME=password SIZE=20></TD></TR>
		<TR><TD></TD><TD><INPUT TYPE=submit VALUE="Log In"></TD>
		</TABLE></FORM>
		<CFINCLUDE TEMPLATE="../conf/#confID#LoginFooter.cfm">
		<CFINCLUDE TEMPLATE="copyright.cfm">
		</BODY></HTML>
	</CFIF>
	<!--- End of login via cookie or form --->

<CFELSE>
	<!---
	1. Check that username and password are correct
		If not correct, include badLogin.cfm, re-display login screen.
	2. If correct, call getPermissions.cfm to determine user permissions
		and display conference homepage.
	3. If no read permission to this conference, display noPermissions.cfm
	--->
	
	<CFQUERY NAME="getUserInfo" DATASOURCE="#CFdatasource#">
		SELECT userID, password FROM User WHERE username = '#Form.username#'
	</CFQUERY>

	<CFIF #getUserInfo.RecordCount# EQ 0 OR #Form.password# NEQ #getUserInfo.password#>
		<CFINCLUDE TEMPLATE="../conf/#confID#Name.cfm">
		<HTML><HEAD><TITLE>Emaze Forums: Login - <CFOUTPUT>#confName#</CFOUTPUT></TITLE></HEAD>
		<CFINCLUDE TEMPLATE="../conf/#confID#Body.cfm">
		<CFINCLUDE TEMPLATE="../system/badLogin.cfm"><P>
		<CFINCLUDE TEMPLATE="../conf/#confID#LoginHeader.cfm"><P>
		<CFOUTPUT>
		<FORM METHOD=post ACTION="#systemURL#/program/login.cfm">
		<INPUT TYPE=hidden NAME=confID VALUE=#confID#>
		</CFOUTPUT>
		<INPUT TYPE=hidden NAME=first VALUE=1>
		<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=2>
		<TR><TD ALIGN=right>Username: </TD>
		<TD><INPUT TYPE=text NAME=username SIZE=20></TD></TR>
		<TR><TD ALIGN=right>Password: </TD>
		<TD><INPUT TYPE=password NAME=password SIZE=20></TD></TR>
		<TR><TD></TD><TD><INPUT TYPE=submit VALUE="Log In"></TD>
		</TABLE></FORM>
		<CFINCLUDE TEMPLATE="../conf/#confID#LoginFooter.cfm">
		<CFINCLUDE TEMPLATE="copyright.cfm">
		</BODY></HTML>
	<CFELSE><!--- Username and password were fine. Check their permissions. --->
		<CFSET goConfID = #Form.confID#>
		<CFSET goUserID = #getUserInfo.userID#>
		<CFINCLUDE TEMPLATE="getPermissions.cfm">
	</CFIF>

</CFIF>