<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">
<!---
If userID cookie does not exist, they are an anon user sent directly to this page.
Determine conference for which anon users have read permission.
--->
<CFIF NOT IsDefined("Cookie.EmazeForums_userID")>
	<CFINCLUDE TEMPLATE="../system/confAnonSelect.cfm">
	<!--- If read permission for at least one conference, write userID and confs cookies. --->
	<CFIF #ListLen("#confs#")# GT 0>
		<CFIF #anonCookie# EQ 1>
			<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
			<CFCOOKIE NAME="EmazeForums_userID" VALUE="-1" DOMAIN="#systemDomain#">
			<CFCOOKIE NAME="EmazeForums_confs" VALUE="#confs#" DOMAIN="#systemDomain#">
		</CFIF>
	<CFELSE><!--- No read permission for anon in any conference. Go away. --->
		<HTML>
		<HEAD><TITLE>Emaze Forums</TITLE></HEAD>
		<CFINCLUDE TEMPLATE="../system/systemBody.cfm">
		<CFINCLUDE TEMPLATE="../system/noPermission.cfm">
		<CFINCLUDE TEMPLATE="copyright.cfm">
		</BODY></HTML>
		<CFABORT>
	</CFIF>
</CFIF>

<!--- User has read permission to at least one conference. Display system homepage. --->
<!---
Here is the basic layout of the system homepage:
1. Navigation buttons
2. System homepage header
3. For each conference for which user has read permission,
	list of forums with forum information
4. System homepage footer
5. Navigation buttons
--->

<HTML>
<HEAD><TITLE>Emaze Forums: Home</TITLE></HEAD>
<CFINCLUDE TEMPLATE="../system/systemBody.cfm">

<!--- Include navigation buttons at top of homepage --->
<CFSET navAlign = "top">
<CFINCLUDE TEMPLATE="navigate.cfm">

<!--- Include system homepage header --->
<CFINCLUDE TEMPLATE="../system/systemHomepageHeader.cfm">
<P>

<!---
For each conference for which user has read permission
1. Get forum info (name, date/time of first and last messages, # of posts)
2. Order by forum order:
	0 = chronological
	1 = reverse chronological
	2 = alphabetical
	3 = reverse alphabetical
	4 = custom order
	If custom order, get order of forums and then get forum info
3. Output list of forums in that conference.

We probably could have used the same basic query for custom forum order as well.
But we figured not doing an inner join with the ConfForum table would be quicker.
The confForum.cfm file contains only the active and archived forums anyway, so we
also do not have to check that the forum is not inactive.
--->
<CFIF IsDefined("Cookie.EmazeForums_confs")>
	<CFSET confs = "#Cookie.EmazeForums_confs#">
</CFIF>

<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5>
<CFLOOP INDEX="confCount" LIST="#confs#">
	<CFINCLUDE TEMPLATE="../conf/#confCount#ForumOrder.cfm">
	<CFIF #forumOrder# NEQ 4><!--- If not custom order --->
		<CFQUERY NAME="getForumInfo" DATASOURCE="#CFdatasource#">
			SELECT Forum.forumName, Forum.firstMsgDate, Forum.lastMsgDate, Forum.msgCount, ConfForum.forumID
			FROM ConfForum INNER JOIN Forum ON ConfForum.forumID = Forum.forumID
			WHERE NOT Forum.forumStatus = 0 AND ConfForum.confID = #confCount#
			<CFIF #forumOrder# EQ 0>ORDER BY ConfForum.forumID
			<CFELSEIF #forumOrder# EQ 1>ORDER BY ConfForum.forumID DESC
			<CFELSEIF #forumOrder# EQ 2>ORDER BY Forum.forumName
			<CFELSE><!--- #forumOrder# EQ 3 --->ORDER BY Forum.forumName DESC
			</CFIF>
		</CFQUERY>
	<CFELSE>
		<CFINCLUDE TEMPLATE="../conf/#confCount#Forums.cfm">
		<CFQUERY NAME="getForumInfo" DATASOURCE="#CFdatasource#">
			SELECT forumID, forumName, firstMsgDate, lastMsgDate, msgCount
			FROM Forum
			WHERE NOT forumStatus = 0
				AND forumID = #ListGetAt("#forums#",1)#
				<CFLOOP INDEX=count LIST="#forums#">
					OR forumID = #count#
				</CFLOOP>
		</CFQUERY>
	</CFIF>

	<!--- Read conference name. Create table for list of forums in this conference. --->
	<CFINCLUDE TEMPLATE="../conf/#confCount#Name.cfm">
	<TH COLSPAN=4><CFOUTPUT><FONT SIZE=4 FACE="Arial"><B><A HREF="#systemURL#/program/confHomepage.cfm?confID=#confCount#">#confName#</A></B></FONT></CFOUTPUT></TH>
	<TR>
	<TH ALIGN=left><FONT FACE="Arial"><B>Forum</B></FONT></TH>
	<TH><FONT FACE="Arial"><B>First Post</B></FONT></TH>
	<TH><FONT FACE="Arial"><B>Last Post</B></FONT></TH>
	<TH><FONT FACE="Arial"><B># Posts</B></FONT></TH>
	</TR>
	
	<CFIF #forumOrder# NEQ 4>
		<!--- If not custom forum order, simply output query since we already ordered them --->
		<CFOUTPUT QUERY="getForumInfo">
			<TR>
			<TD><A HREF="#systemURL#/program/readForum.cfm?confID=#confCount#&forumID=#forumID#">#forumName#</A></TD>
			<TD ALIGN=center VALIGN=top><FONT SIZE=2>#DateFormat("#firstMsgDate#", "mmm-dd-yyyy")# / #TimeFormat("#firstMsgDate#")#</FONT></TD>
			<TD ALIGN=center VALIGN=top><FONT SIZE=2>#DateFormat("#lastMsgDate#", "mmm-dd-yyyy")# / #TimeFormat("#lastMsgDate#")#</FONT></TD>
			<TD ALIGN=center VALIGN=top>#msgCount#</TD>
			</TR>
		</CFOUTPUT>
	<CFELSE><!--- Custom forum order. --->
		<!---
		Rather than perform an ODBC query for each forum, we do one query and then
		run thru a loop to output the forums in the custom order. The problem is
		in outputting the forums in the proper order regardless of the order in which
		the query returned them. Here is how it works:
			1. Loop through the custom forum order
			2. Within the forum order loop, loop through the query results
			3. If the forumID in the query equals the forumID in the custom forum order,
				output the forum information and break out of the loop.
				Otherwise, keep looping through the query results until you reach the correct forum.
			4. Read the next custom forum in the forum order, and loop through the query results again.
		Just as with confHomepage.cfm, there is probably a more efficient way to do this.
		--->
		<CFSET fCount = 1>
		<CFLOOP INDEX=fCount LIST="#forums#">
			<CFLOOP QUERY="getForumInfo">
				<CFIF #forumID# EQ #fCount#>
					<TR>
					<TD><CFOUTPUT><A HREF="#systemURL#/program/readForum.cfm?confID=#confCount#&forumID=#forumID#">#forumName#</A></CFOUTPUT></TD>
					<TD ALIGN=center VALIGN=top><FONT SIZE=2><CFOUTPUT>#DateFormat("#firstMsgDate#", "mmm-dd-yyyy")# / #TimeFormat("#firstMsgDate#")#</CFOUTPUT></FONT></TD>
					<TD ALIGN=center VALIGN=top><FONT SIZE=2><CFOUTPUT>#DateFormat("#lastMsgDate#", "mmm-dd-yyyy")# / #TimeFormat("#lastMsgDate#")#</CFOUTPUT></FONT></TD>
					<TD ALIGN=center VALIGN=top><CFOUTPUT>#msgCount#</CFOUTPUT></TD>
					</TR>
					<CFBREAK>
				</CFIF>
			</CFLOOP>
		</CFLOOP>
	</CFIF>
	<TR><TD COLSPAN=4><BR></TD></TR>
</CFLOOP><!--- End of loop for each conference. --->
</TABLE>
<P>
<!--- Include system homepage footer. --->
<CFINCLUDE TEMPLATE="../system/systemHomepageFooter.cfm">

<!--- Include navigation buttons at bottom of page. --->
<CFSET navAlign = "bottom">
<CFINCLUDE TEMPLATE="navigate.cfm">
<CFINCLUDE TEMPLATE="copyright.cfm">
</BODY></HTML>