<!--- Get groups to which user belongs and group permissions for this conference. --->
<CFQUERY NAME="getGroups" DATASOURCE="#CFdatasource#">
	SELECT UserGrp.groupID, GrpConf.groupPermissions
	FROM UserGrp INNER JOIN GrpConf ON UserGrp.groupID = GrpConf.groupID
	WHERE UserGrp.userID = #goUserID# AND GrpConf.confID = #goConfID#
	ORDER BY UserGrp.groupID
</CFQUERY>

<!--- First element in permissions list is confID. --->
<CFSET userPermissions = "#confID#">
<!---
Because a user can belong to multiple groups, you must determine the user's
combined permissions for this conference by checking each group's permissions.
Technically, you could just append each list of permissions and list a particular
permission more than once. This is not a problem, and may be a good idea to 
implement if user login takes too long. However, looping through the permissions
of each group shouldn't take too long.

For each group user belongs to:
1. Loop through group permissions for that conference
2. If user has not already been granted that permission, append it to the list.
	If already granted permission, move on.
--->
<CFLOOP QUERY="getGroups">
	<CFLOOP INDEX=count LIST="#getGroups.groupPermissions#">
		<CFIF #ListContains("#userPermissions#",#count#)# EQ 0>
			<CFSET userPermissions = #ListAppend("#userPermissions#","#count#")#>
		</CFIF>
	</CFLOOP>
</CFLOOP>

<!---
If user has at least read permission to this conference
1. Write userID cookie
2. Determine if user has admin permissions to any forums.
	If so, append forumID(s) to permissions list.
3. Write permissions cookie.
4. Determine conferences where user has at least read permission.
5. Write confs cookie.
6. Display conference home page.

If user does not have read permission to this conference, go away.
--->
<CFIF #ListContains("#userPermissions#","read")# NEQ 0 OR #goUserID# EQ 0>
	<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
	<CFCOOKIE NAME="EmazeForums_userID" VALUE="#goUserID#" DOMAIN="#systemDomain#">

	<!--- Determine forum admin permissions, add to permission list, write cookie --->
	<CFQUERY NAME="getAdmin" DATASOURCE="#CFdatasource#">
		SELECT forumID FROM UserForumAdmin WHERE userID = #goUserID#
	</CFQUERY>
	<CFLOOP QUERY="getAdmin">
		<CFSET userPermissions = #ListAppend("#userPermissions#","#forumID#")#>
	</CFLOOP>
	<CFCOOKIE NAME="EmazeForums_permissions" VALUE="#userPermissions#"
		DOMAIN="#systemDomain#">

	<CFIF #goUserID# EQ 0>
		<CFQUERY NAME="getConfs" DATASOURCE="#CFdatasource#">
			SELECT confID FROM Conference WHERE confStatus <> 0
		</CFQUERY>
		<CFSET confList = "#ValueList(getConfs.confID)#">
	<CFELSE>
		<!--- Determine conferences where they have read access, write cookie --->
		<CFQUERY NAME="getConfs" DATASOURCE="#CFdatasource#">
			SELECT GrpConf.confID
			FROM UserGrp INNER JOIN GrpConf ON UserGrp.groupID = GrpConf.groupID
			WHERE UserGrp.userID = #goUserID#
				AND GrpConf.groupPermissions LIKE '%read%'
			GROUP BY GrpConf.confID
		</CFQUERY>
		<CFSET confList = " ">
		<!--- If confs list is blank, write first conf. Otherwise, append conf. --->
		<CFLOOP QUERY="getConfs">
			<CFIF #confList# EQ " "><CFSET confList = #confID#>
			<CFELSE><CFSET confList = #ListAppend("#confList#",#confID#)#>
			</CFIF>
		</CFLOOP>
	</CFIF>
	<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
	<CFCOOKIE NAME="EmazeForums_confs" VALUE="#confList#" DOMAIN="#systemDomain#">

	<!--- Display conference homepage. --->
	<CFINCLUDE TEMPLATE="confHomepage.cfm">

<CFELSE><!--- No read permission for this conference. Go away. --->
	<CFINCLUDE TEMPLATE="../conf/#confID#Name.cfm">
	<HTML>
	<HEAD><TITLE>Emaze Forums: <CFOUTPUT>#confName#</CFOUTPUT></TITLE></HEAD>
	<CFINCLUDE TEMPLATE="../conf/#goConfID#Body.cfm">
	<CFINCLUDE TEMPLATE="../system/noPermission.cfm">
	<CFINCLUDE TEMPLATE="copyright.cfm">
	</BODY></HTML>
</CFIF>