<!---
This file serves 2 purposes:
1. Ensure a file exists before trying to let user download it
2. Prevents displaying full URL where attachment is stored for added security.
	(Not much added security, but more than just displaying the URL.)
--->

<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">
<CFINCLUDE TEMPLATE="secure.cfm">

<!--- Get attachment filename from database --->
<CFQUERY NAME=getAttachmentFile DATASOURCE="#CFdatasource#">
	SELECT attachment FROM Message WHERE msgID = '#msgID#'
</CFQUERY>

<!--- Get path to directory where attachments are stored --->
<CFINCLUDE TEMPLATE="../system/attachmentPath.cfm">

<!--- If the file still exists, get URL to attachments directory and download it. --->
<CFIF #FileExists("#attachmentPath#\#forumID#\#getAttachmentFile.attachment#")# EQ "YES">
	<CFINCLUDE TEMPLATE="../system/attachmentURL.cfm">
	<CFLOCATION URL="#attachmentURL#/#forumID#/#getAttachmentFile.attachment#">
<CFELSE><!--- Attachment is not there. Reload forum. --->
	<CFQUERY NAME=dropAttachment DATASOURCE="#CFdatasource#">
		UPDATE Message
		SET attachment = ' '
		WHERE msgID = '#msgID#'
	</CFQUERY>
	<CFLOCATION URL="readForum.cfm?confID=#confID#&forumID=#forumID####msgID#">
</CFIF>