<!--- Check that user has read permission in this conference. --->
<CFSET checkPermission = "read">
<CFINCLUDE TEMPLATE="secure.cfm">

<CFOUTPUT><IMG SRC="#systemURL#/images/forumindex.gif" ALT="Index of Messages"></CFOUTPUT>

<!---
Puts permissions and admin permissions in separate variable.
First value is confID, which could overlap with forumID and
cause a problem since Cold Fusion only finds the first occurrence.
--->
<CFIF IsDefined("Cookie.EmazeForums_permissions")>
	<CFIF #ListContains("#Cookie.EmazeForums_permissions#",#forumID#)# OR #Cookie.EmazeForums_userID# EQ 0>
		<CFSET okAdmin = 1>
	</CFIF>
<CFELSE>
	<CFSET permissions = "read">
</CFIF>

<!---
If moderated conference and user has admin permission to this forum,
display moderation options: accept, reject, ignore for all unapproved messages.
--->
<CFIF #moderated# EQ 1 AND IsDefined("okAdmin")>
	<!--- Lists used to track which messages need moderation. --->
	<CFSET msgList = " "><!--- List of msgIDs --->
	<CFSET modCounterList = " "><!--- Counter for number of messages awaiting moderation --->
	<CFSET modCounter = 1>
	<FORM METHOD=post ACTION="moderate.cfm">
	<CFOUTPUT>
	<INPUT TYPE=hidden NAME=confID VALUE=#confID#>
	<INPUT TYPE=hidden NAME=forumID VALUE=#forumID#>
	</CFOUTPUT>
	Moderate options: Approve (+), Reject (-), Ignore (I)<P>
</CFIF>

<TABLE BORDER=0 CELLPADDING=4 CELLSPACING=0 WIDTH=600>
<CFIF #moderated# EQ 1 AND IsDefined("okAdmin")>
	<TH NOWRAP><FONT SIZE=4><B>+ - I</B></FONT></TH>
</CFIF>
<TH WIDTH=330 COLSPAN=4 ALIGN=left><FONT SIZE=3 FACE="Arial"><B>Subject</B></FONT></TH>
<TH WIDTH=150 ALIGN=left><FONT SIZE=3 FACE="Arial"><B>Author</B></FONT></TH>
<TH WIDTH=120 ALIGN=left><FONT SIZE=3 FACE="Arial"><B>Date/Time</B></FONT></TH>

<CFOUTPUT QUERY="getMessages"><!--- For each message in forum --->
	<!--- If conference is not moderated OR if message is approved OR admin user --->
	<CFIF #moderated# EQ 0 OR #approved# EQ 1 OR IsDefined("okAdmin")>
		<TR><!--- If admin user and message is not approved/rejected, display moderation options --->
		<CFIF #moderated# EQ 1 AND IsDefined("okAdmin")>
			<CFIF #approved# EQ 2>
				<TD NOWRAP VALIGN=top><INPUT TYPE=radio NAME="msg#modCounter#" VALUE=1> <INPUT TYPE=radio NAME="msg#modCounter#" VALUE=0> <INPUT TYPE=radio NAME="msg#modCounter#" VALUE=2 CHECKED></TD>
				<CFIF #msgList# EQ " ">
					<!--- If first message to be moderated (list is empty) --->
					<CFSET msgList = "#msgID#">
					<CFSET modCounterList = "msg#modCounter#">
				<CFELSE>
					<!--- If not first message to be moderated, append to lists --->
					<CFSET msgList = #ListAppend("#msgList#","#msgID#",",")#>
					<CFSET modCounterList = #ListAppend("#modCounterList#","msg#modCounter#",",")#>
				</CFIF>
				<CFSET modCounter = modCounter + 1>
			<CFELSE><TD>&nbsp;</TD><!--- Blank cell when message has already been moderated --->
			</CFIF>
		</CFIF>

		<!--- If messages are threaded, indent using 25 pixel-wide table cells for each indent. --->
		<CFIF #msgOrder# EQ 0>
			<CFIF #indent# EQ 0><TD VALIGN=top COLSPAN=4>
			<CFELSEIF #indent# EQ 1><TD WIDTH=25>&nbsp;</TD><TD VALIGN=top COLSPAN=3>
			<CFELSEIF #indent# EQ 2><TD WIDTH=25>&nbsp;</TD><TD WIDTH=25>&nbsp;</TD><TD VALIGN=top COLSPAN=2>
			<CFELSE><!--- #indent# EQ 3 ---><TD WIDTH=25>&nbsp;</TD><TD WIDTH=25>&nbsp;</TD><TD WIDTH=25>&nbsp;</TD><TD VALIGN=top>
			</CFIF>
		<CFELSE><TD VALIGN=top COLSPAN=4>
		</CFIF>
		<A HREF="###msgID#">#subject#</A></TD><!--- Link subject to full message below --->
		<TD VALIGN=top WIDTH=150><FONT SIZE=2>
		<CFIF userID EQ -1>#anonName#<!--- If anon user, display anonName --->
		<!--- If login user, display non-blank firstName and/or lastName fields only --->
		<CFELSEIF #firstName# NEQ "" AND #firstName# NEQ " " AND #lastName# NEQ "" AND #lastName# NEQ " ">#firstName# #lastName#
		<CFELSEIF #lastName# NEQ "" AND #lastName# NEQ " "><!--- only last name --->#lastName#
		<CFELSE><!--- only first name --->#firstName#
		</CFIF>
		</FONT></TD>
		<!--- Date and time of message --->
		<TD VALIGN=top WIDTH=120><FONT SIZE=2>#DateFormat("#msgDateTime#", "Mm-dd-yyyy")# / #TimeFormat("#msgDateTime#")#</FONT></TD>
		</TR>
	</CFIF>
</CFOUTPUT>
<TR>
<TD WIDTH=25><CFOUTPUT><IMG SRC="#systemURL#/images/clearpixel.gif" WIDTH=25 HEIGHT=2></CFOUTPUT></TD>
<TD WIDTH=25><CFOUTPUT><IMG SRC="#systemURL#/images/clearpixel.gif" WIDTH=25 HEIGHT=2></CFOUTPUT></TD>
<TD WIDTH=25><CFOUTPUT><IMG SRC="#systemURL#/images/clearpixel.gif" WIDTH=25 HEIGHT=2></CFOUTPUT></TD>
<TD WIDTH=280><CFOUTPUT><IMG SRC="#systemURL#/images/clearpixel.gif" WIDTH=280 HEIGHT=2></CFOUTPUT></TD>
<TD WIDTH=150>&nbsp;</TD>
<TD WIDTH=120>&nbsp;</TD>
</TR>

</TABLE>
<!--- End of index --->
<!--- If moderated and admin user, display Moderate submit button --->
<CFIF #moderated# EQ 1 AND IsDefined("okAdmin")>
	<P>
	<CFOUTPUT><INPUT TYPE=hidden NAME=msgList VALUE="#msgList#">
	<INPUT TYPE=hidden NAME=modCounterList VALUE="#modCounterList#">
	</CFOUTPUT>
	<INPUT TYPE=reset VALUE="Clear"> <INPUT TYPE=submit VALUE="Moderate">
	</FORM>
</CFIF>
