<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">
<CFINCLUDE TEMPLATE="secure.cfm">

<!---
1. Edit username, password, first name, last name, email, cookie.
2. Unsubscribe to email subscriptions, if any exist.
--->

<!--- If anon user, they should not be here.
	Return them to conference or system homepage. --->
<CFIF NOT IsDefined("Cookie.EmazeForums_userID")>
	<CFIF IsDefined("confID")><CFINCLUDE TEMPLATE="confHomepage.cfm">
		<CFELSE><CFINCLUDE TEMPLATE="homepage.cfm"></CFIF>
	<CFABORT>
<CFELSEIF #Cookie.EmazeForums_userID# EQ -1>
	<CFIF IsDefined("confID")><CFINCLUDE TEMPLATE="confHomepage.cfm">
		<CFELSE><CFINCLUDE TEMPLATE="homepage.cfm"></CFIF>
	<CFABORT>
</CFIF>

<HTML><HEAD><TITLE>Emaze Forums: Edit user</TITLE></HEAD>

<CFIF IsDefined("Form.confID")><!--- Conference or system? --->
	<!--- Display conference body tag --->
	<CFINCLUDE TEMPLATE="../conf/#Form.confID#Body.cfm">
<CFELSE>
	<!--- Display system body tag --->
	<CFINCLUDE TEMPLATE="../system/systemBody.cfm">
</CFIF>

<!--- Navigation buttons at top of page. --->
<CFSET navAlign = "top">
<CFINCLUDE TEMPLATE="navigate.cfm">

<!--- Processes changes. If "first" is not defined, edit user options are displayed. --->
<CFIF IsDefined("first")>
	<!--- Check for problem with username, either none or already exists if choosing new one. --->
	<CFIF #Form.username# EQ ""><!--- Username is empty --->
		<CFSET reUsername = 1>
		<H3>You must enter a username.</H3>
	<CFELSEIF #Form.username# NEQ #Form.cUsername#><!--- New username already exists. --->
		<CFQUERY NAME=checkUser DATASOURCE="#CFdatasource#">SELECT userID FROM User WHERE username = '#Form.username#'</CFQUERY>
		<CFIF #checkUser.RecordCount# GT 0>
			<CFSET reUsername = 1>
			<H3>Username <I><CFOUTPUT>#Form.username#</CFOUTPUT></I> already taken. Please choose another one.</H3>
		</CFIF>
	</CFIF>

	<!--- Checks whether user changed password and ensures new one was verified correctly. --->
	<CFIF #Form.password# NEQ "" AND #Form.password# NEQ #Form.passwordVerify#>
		<CFSET rePassword = 1>
		<H3>Your password was not verified correctly. Please try again.</H3>
	</CFIF>

	<!--- If username or password problem, re-display edit user form. --->
	<CFIF IsDefined("reUsername") OR IsDefined("rePassword")>
		<CFQUERY NAME=getGroups DATASOURCE="#CFdatasource#">
			SELECT groupID, groupName FROM Grp ORDER BY groupName
		</CFQUERY>
		<CFQUERY NAME=getForums DATASOURCE="#CFdatasource#">
			SELECT forumID, forumName FROM Forum ORDER BY forumName
		</CFQUERY>

		<FORM METHOD=POST ACTION="edituser.cfm">
		<INPUT TYPE=hidden NAME=first VALUE=0>
		<!--- Stores original username in case new username choice is already being used. --->
		<CFOUTPUT><INPUT TYPE=hidden NAME=cUsername VALUE="#Form.cUsername#"></CFOUTPUT>
		<CFIF IsDefined("Form.confID")>
			<CFOUTPUT><INPUT TYPE=hidden NAME=confID VALUE=#Form.confID#></CFOUTPUT>
		</CFIF>

		<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
		<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Username: </TD>
		<TD>
		<!--- If problem with username, display original username. Otherwise, display new username choice. --->
		<CFIF IsDefined("reUsername")>
			<CFOUTPUT><INPUT TYPE=text NAME=username VALUE="#Form.cUsername#" SIZE=20 MAXLENGTH=25></CFOUTPUT>
		<CFELSE>
			<CFOUTPUT><INPUT TYPE=text NAME=username VALUE="#Form.username#" SIZE=20 MAXLENGTH=25></CFOUTPUT>
		</CFIF>
		</TD></TR>
		<!--- If problem with new password, display blank fields. Otherwise, display new password choice. --->
		<CFIF IsDefined("rePassword")>
			<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Password: </TD><TD><INPUT TYPE=password NAME=password SIZE=20 MAXLENGTH=25></TD></TR>
			<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Verify Password: </TD><TD><INPUT TYPE=password NAME=passwordVerify SIZE=20 MAXLENGTH=25></TD></TR>
		<CFELSE>
			<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Password: </TD><TD><CFOUTPUT><INPUT TYPE=password NAME=password VALUE="#Form.password#" SIZE=20 MAXLENGTH=25></CFOUTPUT></TD></TR>
			<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> (Verify) </TD><TD><CFOUTPUT><INPUT TYPE=password NAME=passwordVerify VALUE="#Form.passwordVerify#" SIZE=20 MAXLENGTH=25></CFOUTPUT></TD></TR>
		</CFIF>
		<TR><TD COLSPAN=2>&nbsp;</TD></TR>
		<TR><TD ALIGN=right>First Name: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=firstName VALUE="#Form.firstName#" SIZE=20 MAXLENGTH=25></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right>Last Name: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=lastName VALUE="#Form.lastName#" SIZE=20 MAXLENGTH=35></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right>Email: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=email VALUE="#Form.email#" SIZE=20 MAXLENGTH=50></CFOUTPUT></TD></TR>
		<TR><TD ALIGN=right>Cookie login: </TD><TD><INPUT TYPE=checkbox NAME=useCookie VALUE=1<CFIF IsDefined("Form.useCookie")> CHECKED</CFIF>> Enables you to enter conference without logging in</TD></TR>
		</TABLE>

		<!--- Get messages to which they subscribed. --->
		<CFQUERY NAME="getMsgSubscribe" DATASOURCE="#CFdatasource#">
			SELECT UserMsgSubscribe.msgID, Message.subject, Message.message, Forum.forumName
			FROM (Forum INNER JOIN Message ON Forum.forumID = Message.forumID)
				INNER JOIN UserMsgSubscribe ON Message.msgID = UserMsgSubscribe.msgID
			WHERE UserMsgSubscribe.userID = #Cookie.EmazeForums_userID#
		</CFQUERY>

		<!--- Display messages to which user is subscribed --->
		<CFIF #getMsgSubscribe.RecordCount# GT 0>
			<H3>Delete subscriptions to messages</H3><DL>
			<CFOUTPUT QUERY="getMsgSubscribe">
				<DT><INPUT TYPE=checkbox NAME=unsubscribe VALUE=#msgID#> <B>Unsubscribe to this message</B>
				<INPUT TYPE=checkbox NAME=unsubscribe VALUE="#msgID#"
				<CFIF IsDefined("Form.unsubscribe")>
					<CFIF #ListContains("#Form.unsubscribe#","#msgID#",",")#> CHECKED</CFIF>
				</CFIF>> <B>Unsubscribe to this message</B>
				<DD><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0>
				<TR><TD ALIGN=right VALIGN=top>Forum: </TD><TD>#forumName#</TD></TR>
				<TR><TD ALIGN=right VALIGN=top>Subject: </TD><TD>#subject#</TD></TR>
				<TR><TD ALIGN=right VALIGN=top>Message: </TD><TD>#message#</TD></TR>
				</TABLE><P>
			</CFOUTPUT></DL>
		</CFIF>

		<P><INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit VALUE="Edit User">
		</FORM>
		<CFINCLUDE TEMPLATE="copyright.cfm">
		</BODY></HTML>
		<CFABORT>

	<CFELSE><!--- All is well. Update info. --->
		<!--- Can't update blank fields. So check if field is blank.
			If blank, use a space. If not blank, use the forum value. --->
		<CFIF #Form.firstName# EQ ""><CFSET fName = " ">
		<CFELSE><CFSET fName = "#Form.firstName#">
		</CFIF>

		<CFIF #Form.lastName# EQ ""><CFSET lName = " ">
		<CFELSE><CFSET lName = "#Form.lastName#">
		</CFIF>

		<CFIF #Form.email# EQ ""><CFSET  mail = " ">
		<CFELSE><CFSET mail = "#Form.email#">
		</CFIF>

		<!---
		If chose automatic login via cookie, write cookie to browser.
		Login cookie contains userID and username.
		We decided it should not contain the password for security reasons.
		But just a username was not secure enough as it would be easy enough
		to guess another user's usename. Letting a user know their userID is
		relatively harmless.
		--->
		<CFIF IsDefined("Form.useCookie")>
			<CFSET cookieLogin = 1>
			<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
			<CFCOOKIE NAME="EmazeForums_login"
				VALUE="#Cookie.EmazeForums_userID#,#Form.username#"
				EXPIRES="NEVER"
				DOMAIN="#systemDomain#">
		<CFELSE>
			<CFSET cookieLogin = 0>
			<!--- If chose to cancel automatic login, delete cookie. --->
			<CFIF IsDefined("Cookie.EmazeForums_login")>
				<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
				<CFCOOKIE NAME="EmazeForums_login" DOMAIN="#systemDomain#" EXPIRES=Now>
			</CFIF>
		</CFIF>

		<!--- Update user info in database. --->
		<CFQUERY NAME=updateUserInfo DATASOURCE="#CFdatasource#">
			UPDATE User
			SET username = '#Form.username#',
			<CFIF #Form.password# NEQ "">
				password = '#Form.password#',
			</CFIF>
				firstName = '#fName#',
				lastName = '#lName#',
				email = '#mail#',
				useCookie = #cookieLogin#
			WHERE userID = #Cookie.EmazeForums_userID#
		</CFQUERY>

		<!--- If user unsubscribed to any messages, unsubscribe them. --->
		<CFIF IsDefined("Form.unsubscribe")>
			<CFSET subLen = #ListLen("#Form.unsubscribe#",",")#>
			<CFSET msgSubCount = 2>
			<CFQUERY NAME=deleteSubscription DATASOURCE="#CFdatasource#">
				DELETE
				FROM UserMsgSubscribe
				WHERE userID = #Cookie.EmazeForums_userID#
				AND (msgID = '#ListGetAt("#Form.unsubscribe#",1,",")#'
				<CFLOOP INDEX=msgSubCount LIST="#Form.unsubscribe#">
					OR msgID = '#msgSubCount#'
				</CFLOOP>)
			</CFQUERY>
		</CFIF>

		<!--- User information updated. Display new edit user page. --->
		<H2><I>User information updated.</I><HR NOSHADE ALIGN=left WIDTH=600></H2>
	</CFIF>
</CFIF>

<CFQUERY NAME=getUserInfo DATASOURCE="#CFdatasource#">
	SELECT username, firstName, lastName, email, useCookie
	FROM User
	WHERE userID = #Cookie.EmazeForums_userID#
</CFQUERY>

<CFINCLUDE TEMPLATE="../system/systemEdituserHeader.cfm">
<P>
<FORM METHOD=POST ACTION="edituser.cfm">
<INPUT TYPE=hidden NAME=first VALUE=0>
<!--- Store current username in case new username choice is already taken. --->
<CFOUTPUT><INPUT TYPE=hidden NAME=cUsername VALUE="#getUserInfo.username#"></CFOUTPUT>
<!--- If coming from a conference, store confID --->
<CFIF IsDefined("confID")>
	<CFOUTPUT><INPUT TYPE=hidden NAME=confID VALUE=#confID#></CFOUTPUT>
</CFIF>

<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0>
<TR><TD ALIGN=right><FONT COLOR=red><B>*</B></FONT> Username: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=username VALUE="#getUserInfo.username#" SIZE=20 MAXLENGTH=25></CFOUTPUT></TD></TR>
<TR><TD ALIGN=right>Password: </TD><TD><INPUT TYPE=password NAME=password SIZE=20 MAXLENGTH=25></TD></TR>
<TR><TD ALIGN=right>(Verify) </TD><TD><INPUT TYPE=password NAME=passwordVerify SIZE=20 MAXLENGTH=25></TD></TR>
<TR><TD COLSPAN=2>&nbsp;</TD></TR>
<TR><TD ALIGN=right>First Name: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=firstName VALUE="#getUserInfo.firstName#" SIZE=20 MAXLENGTH=25></CFOUTPUT></TD></TR>
<TR><TD ALIGN=right>Last Name: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=lastName VALUE="#getUserInfo.lastName#" SIZE=20 MAXLENGTH=35></CFOUTPUT></TD></TR>
<TR><TD ALIGN=right>Email: </TD><TD><CFOUTPUT><INPUT TYPE=text NAME=email VALUE="#getUserInfo.email#" SIZE=20 MAXLENGTH=50></CFOUTPUT></TD></TR>
<TR><TD ALIGN=right>Cookie login: </TD><TD><INPUT TYPE=checkbox NAME=useCookie VALUE=1<CFIF #getUserInfo.useCookie# EQ 1> CHECKED</CFIF>> Enables you to enter conference without logging in (when allowed)</TD></TR>
</TABLE>

<!--- Get messages to which user has subscribed. --->
<CFQUERY NAME="getMsgSubscribe" DATASOURCE="#CFdatasource#">
	SELECT UserMsgSubscribe.msgID, Message.subject, Message.message, Forum.forumName
	FROM (Forum INNER JOIN Message ON Forum.forumID = Message.forumID)
		INNER JOIN UserMsgSubscribe ON Message.msgID = UserMsgSubscribe.msgID
	WHERE UserMsgSubscribe.userID = #Cookie.EmazeForums_userID#
</CFQUERY>

<!--- Output messages to which user has subscribed. Option to unsubscribe. --->
<CFIF #getMsgSubscribe.RecordCount# GT 0>
	<H3>Delete subscriptions to messages</H3><DL>
	<CFOUTPUT QUERY="getMsgSubscribe">
		<DT><INPUT TYPE=checkbox NAME=unsubscribe VALUE=#msgID#> <B>Unsubscribe to this message</B>
		<DD><TABLE BORDER=1 CELLSPACING=0 CELLPADDING=0>
		<TR><TD ALIGN=right VALIGN=top>Forum: </TD><TD>#forumName#</TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Subject: </TD><TD>#subject#</TD></TR>
		<TR><TD ALIGN=right VALIGN=top>Message: </TD><TD>#message#</TD></TR>
		</TABLE><P>
	</CFOUTPUT></DL>
</CFIF>
<P>
<INPUT TYPE=reset VALUE=Clear> &nbsp; <INPUT TYPE=submit VALUE="Edit User Info">
</FORM>

<CFSET navAlign = "bottom">
<CFINCLUDE TEMPLATE="navigate.cfm">
<CFINCLUDE TEMPLATE="copyright.cfm">
</BODY>
</HTML>