<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<!--- Ensure user cookie exists. If not, person is not welcome here. --->
<CFINCLUDE TEMPLATE="secure.cfm">

<!---
Ensure user has permission to delete message,
either because user has permission to delete own messages AND
this is their message, or user has admin permission for this forum.
--->
	<!--- Get list of permissions, admin permissions.
		Drop confID since it may be the same as the forumID. --->
<CFIF IsDefined("Cookie.EmazeForums_permissions")>
	<CFSET permissions = "#ListRest("#Cookie.EmazeForums_permissions#")#">
</CFIF>

<CFIF NOT IsDefined("Cookie.EmazeForums_permissions")>
	<!--- If anon user, go away --->
	<H3>You do not have permission to access this file.</H3>
	<CFABORT>
<CFELSEIF #Cookie.EmazeForums_userID# EQ 0>
	<CFSET okDelete = 1>
<CFELSEIF #Cookie.EmazeForums_userID# EQ -1>
	<!--- If anon user, go away --->
	<H3>You do not have permission to access this file.</H3>
	<CFABORT>
<CFELSEIF #ListGetAt("#Cookie.EmazeForums_permissions#",1)# NEQ #confID#>
	<!--- If permissions not for this conference, go away --->
	<H3>You do not have permission to access this file.</H3>
	<CFABORT>
<CFELSEIF #ListContains("#permissions#",#forumID#)# NEQ 0>
	<!--- If admin user, you may delete. --->
	<CFSET okDelete = 1>
<CFELSEIF #ListContains("#permissions#","delete")# EQ 0>
	<!--- If user does not have delete permission, go away --->
	<H3>You do not have permission to access this file.</H3>
	<CFABORT>
<CFELSE>
	<!--- Get userID of message. Check if this is the same user. --->
	<CFQUERY NAME="getUserID" DATASOURCE="#CFdatasource#">
		SELECT userID FROM Message WHERE msgID = '#msgID#'
	</CFQUERY>
	<CFIF #Cookie.EmazeForums_userID# NEQ #getUserID.userID#>
		<!--- Not the same user. Go away. --->
		<H3>You do not have permission to access this file.</H3>
		<CFABORT>
	</CFIF>
</CFIF>

<!---
1. Delete message from Message table
2. Reduce msgCount in Forum table
3. Delete all msgID from UserMsgSubscribe table
4. If message has replies, un-indent the responses by one
--->

<!---
Get indent level to reduce indent of responses, if there are any.
Get attachment to determine whether it needs to be deleteed.
--->
<CFQUERY NAME="getResponses" DATASOURCE="#CFdatasource#">
	SELECT indent, responses, attachment FROM Message where msgID = '#msgID#'
</CFQUERY>

<!--- Delete the message. --->
<CFQUERY NAME="deleteMsg" DATASOURCE="#CFdatasource#">
	DELETE FROM Message WHERE msgID = '#msgID#'
</CFQUERY>

<!--- Unsubscribe any users who have subscribed to the deleted message. --->
<CFQUERY NAME="deleteMsgSubscribe" DATASOURCE="#CFdatasource#">
	DELETE FROM UserMsgSubscribe WHERE msgID = '#msgID#'
</CFQUERY>

<!--- Get msgCount of forum. Reduce it by 1. Write new msgCount. --->
<CFQUERY Name="getMsgCount" Datasource="#CFdatasource#">
	SELECT msgCount FROM Forum WHERE forumID = #forumID#
</CFQUERY>
<CFSET newMsgCount = getMsgCount.msgCount - 1>
<CFQUERY Name="updateForum" Datasource="#CFdatasource#">
	UPDATE Forum
	SET msgCount = #newMsgCount#
	WHERE forumID = #forumID#
</CFQUERY>

<!--- If attachment, delete the attachment. Check that it exists first, just in case. --->
<CFIF #getResponses.attachment# NEQ "" AND #getResponses.attachment# NEQ " ">
	<CFINCLUDE TEMPLATE="../system/attachmentPath.cfm">
	<CFIF #FileExists("#attachmentPath#\#forumID#\#getResponses.attachment#")# EQ "YES">
		<CFFILE ACTION=Delete FILE="#attachmentPath#\#forumID#\#getResponses.attachment#">
	</CFIF>
</CFIF>

<!--- If any responses, reduce indent value by 1. --->
<CFIF #getResponses.responses# GT 0 AND #getResponses.indent# NEQ 3>
	<CFIF #getResponses.indent# EQ 0>
		<CFSET responseMsgID = #ListGetAt("#msgID#",1,"-")#>
	<CFELSEIF #getResponses.indent# EQ 1>
		<CFSET responseMsgID = "#ListGetAt("#msgID#",1,"-")#-#ListGetAt("#msgID#",2,"-")#">
	<CFELSE><!--- #getResponses.indent# EQ 2 --->
		<CFSET responseMsgID = "#ListGetAt("#msgID#",1,"-")#-#ListGetAt("#msgID#",2,"-")#-#ListGetAt("#msgID#",3,"-")#">
	</CFIF>

	<CFQUERY NAME=getResponseMsgs DATASOURCE="#CFdatasource#">
		SELECT msgID, indent FROM Message WHERE msgID LIKE '#responseMsgID#-%'
	</CFQUERY>
	<CFLOOP QUERY=getResponseMsgs>
		<CFIF #getResponseMsgs.indent# EQ 1>
			<CFIF NOT IsDefined("indent0")>
				<CFSET indent0 = "#getResponseMsgs.msgID#">
			<CFELSE>
				<CFSET indent0 = #ListAppend("#indent0#","#getResponseMsgs.msgID#",",")#>
			</CFIF>
		<CFELSEIF #getResponseMsgs.indent# EQ 2>
			<CFIF NOT IsDefined("indent1")>
				<CFSET indent1 = "#getResponseMsgs.msgID#">
			<CFELSE>
				<CFSET indent1 = #ListAppend("#indent1#","#getResponseMsgs.msgID#",",")#>
			</CFIF>
		<CFELSEIF #getResponseMsgs.indent# EQ 3>
			<CFIF NOT IsDefined("indent2")>
				<CFSET indent2 = "#getResponseMsgs.msgID#">
			<CFELSE>
				<CFSET indent2 = #ListAppend("#indent2#","#getResponseMsgs.msgID#",",")#>
			</CFIF>
		</CFIF>
	</CFLOOP>

	<CFSET msgCount = 2>
	<CFIF IsDefined("indent0")>
		<CFQUERY NAME=updateResponseMsgs0 DATASOURCE="#CFdatasource#">
			UPDATE Message
			SET indent = 0
			WHERE msgID = '#ListGetAt("#indent0#",1,",")#'
				<CFLOOP INDEX="msgCount" LIST="#indent0#">
					OR msgID = '#msgCount#'
				</CFLOOP>
		</CFQUERY>
	</CFIF>

	<CFSET msgCount = 2>
	<CFIF IsDefined("indent1")>
		<CFQUERY NAME=updateResponseMsgs1 DATASOURCE="#CFdatasource#">
			UPDATE Message
			SET indent = 1
			WHERE msgID = '#ListGetAt("#indent1#",1,",")#'
				<CFLOOP INDEX="msgCount" LIST="#indent1#">
					OR msgID = '#msgCount#'
				</CFLOOP>
		</CFQUERY>
	</CFIF>

	<CFSET msgCount = 2>
	<CFIF IsDefined("indent2")>
		<CFQUERY NAME=updateResponseMsgs2 DATASOURCE="#CFdatasource#">
			UPDATE Message
			SET indent = 2
			WHERE msgID = '#ListGetAt("#indent2#",1,",")#'
				<CFLOOP INDEX="msgCount" LIST="#indent2#">
					OR msgID = '#msgCount#'
				</CFLOOP>
		</CFQUERY>
	</CFIF>
</CFIF>

<!--- Reload forum. --->
<CFLOCATION URL="readForum.cfm?confID=#confID#&forumID=#forumID#">