<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">
<CFINCLUDE TEMPLATE="../conf/#confID#Name.cfm">

<!---
Check for userID and permissions.
Does anon login if not logged in.
Determines user permissions for this conference if login user.
--->
<CFINCLUDE TEMPLATE="confCheck.cfm">

<!---
Here is the basic layout of the conference homepage:
1. Navigation buttons
2. Conference homepage header
3. List of forums with forum information
4. If perission to create new forums, Post Message form
5. Conference homepage footer
6. Navigation buttons
--->

<HTML>
<HEAD><TITLE>Emaze Forums: Home - <CFOUTPUT>#confName#</CFOUTPUT></TITLE></HEAD>
<CFINCLUDE TEMPLATE="../conf/#confID#Body.cfm">

<!--- Include navigation buttons at top of page. --->
<CFSET navAlign = "top">
<CFINCLUDE TEMPLATE="navigate.cfm">

<!--- Inlclude conference homepage header for this conference. --->
<CFINCLUDE TEMPLATE="../conf/#confID#HomepageHeader.cfm">
<P>

<!--- Read order in which to display forums in this conference.
0 = chronological (oldest to newest)
1 = reverse chronological (newest to oldest)
2 = alphabetical (A - Z)
3 = reverse alphabetical (Z - A)
4 = custom forum order (defined in Admin screens)
--->
<CFINCLUDE TEMPLATE="../conf/#confID#ForumOrder.cfm">

<!---
This is not currently used. Eventually, the idea is to display the number of
moderated messages waiting to be approved in those forums in which the user
has admin permission

<CFIF IsDefined("Cookie.EmazeForums_permissions")>
	<CFSET permissions = "#ListRest("#Cookie.EmazeForums_permissions#")#">
	<CFIF #moderated# EQ 1 AND #ListContains("#permissions#",#forumID#)#>
	</CFIF>
</CFIF>
--->

<CFIF #forumOrder# NEQ 4><!--- If not custom forum order --->
	<!--- Get forum information for all forums in conference in proper order. --->
	<CFQUERY NAME="getForumInfo" DATASOURCE="#CFdatasource#">
		SELECT Forum.forumName, Forum.firstMsgDate, Forum.lastMsgDate, Forum.msgCount, ConfForum.forumID
		FROM ConfForum INNER JOIN Forum ON ConfForum.forumID = Forum.forumID
		WHERE NOT Forum.forumStatus = 0 AND ConfForum.confID = #confID#
		<CFIF #forumOrder# EQ 0>ORDER BY ConfForum.forumID
		<CFELSEIF #forumOrder# EQ 1>ORDER BY ConfForum.forumID DESC
		<CFELSEIF #forumOrder# EQ 2>ORDER BY forumName
		<CFELSE><!--- #forumOrder# EQ 3 --->ORDER BY forumName DESC
		</CFIF>
	</CFQUERY>
<CFELSE><!--- custom forum order --->
	<!--- Get custom forum order in confForums.cfm file for that conference. --->
	<CFINCLUDE TEMPLATE="../conf/#confID#Forums.cfm">
	<!--- Get forum information for all forums in conference. --->
	<CFQUERY NAME="getForumInfo" DATASOURCE="#CFdatasource#">
		SELECT forumID, forumName, firstMsgDate, lastMsgDate, msgCount
		FROM Forum
		WHERE NOT forumStatus = 0
			AND forumID = #ListGetAt("#forums#",1)#
			<CFLOOP INDEX=count LIST="#forums#">
				OR forumID = #count#
			</CFLOOP>
	</CFQUERY>
</CFIF>

<TABLE BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TH ALIGN=left><FONT SIZE=4 FACE="Arial"><B>Forum</B></FONT></TH>
<TH><FONT FACE="Arial"><B>First Post</B></FONT></TH>
<TH><FONT FACE="Arial"><B>Last Post</B></FONT></TH>
<TH><FONT FACE="Arial"><B># Posts</B></FONT></TH>

<!---
Output forum info in the appropriate order.
1. forum name with link to forum
2. Date and time of first message posted to forum.
3. Date and time of last message posted to forum.
4. Total number of messages in forum.

The link to read the forum calls readForum.cfm and includes the
confID and forumID, which are the unique identifiers of the
conference and forum, respectively.
 --->

<CFIF #forumOrder# NEQ 4><!--- If not custom forum order --->
	<CFOUTPUT QUERY="getForumInfo">
		<TR>
		<TD><A HREF="#systemURL#/program/readForum.cfm?confID=#confID#&forumID=#forumID#">#forumName#</A></TD>
		<TD ALIGN=center VALIGN=top><FONT SIZE=2>#DateFormat("#firstMsgDate#", "mmm-dd-yyyy")# / #TimeFormat("#firstMsgDate#")#</FONT></TD>
		<TD ALIGN=center VALIGN=top><FONT SIZE=2>#DateFormat("#lastMsgDate#", "mmm-dd-yyyy")# / #TimeFormat("#lastMsgDate#")#</FONT></TD>
		<TD ALIGN=center VALIGN=top>#msgCount#</TD>
		</TR>
	</CFOUTPUT>
<CFELSE><!--- If the annoying custom forum order. --->
	<!---
	Rather than perform an ODBC query for each forum, we do one query and then
	run thru a loop to output the forums in the custom order. The problem is
	in outputting the forums in the proper order regardless of the order in which
	the query returned them. Here is how it works:
		1. Loop through the custom forum order
		2. Within the forum order loop, loop through the query results
		3. If the forumID in the query equals the forumID in the custom forum order,
			output the forum information and break out of the loop.
			Otherwise, keep looping through the query results until you reach the correct forum.
		4. Read the next custom forum in the forum order, and loop through the query results again.

	There is probably a more efficient way to do this. So if you have a better
	idea, please let us know. One other option is to use the query as the outer loop
	and the custom forum order list as the inner loop. But this will probably not make
	much of a difference in speed. This is definitely much quicker than looping through
	the forum order and doing a separate query for each forum.
	--->

	<CFSET fCount = 1>
	<CFLOOP INDEX=fCount LIST="#forums#">
		<CFLOOP QUERY="getForumInfo">
			<CFIF #forumID# EQ #fCount#>
				<TR>
				<TD><CFOUTPUT><A HREF="#systemURL#/program/readForum.cfm?confID=#confID#&forumID=#forumID#">#forumName#</A></CFOUTPUT></TD>
				<TD ALIGN=center VALIGN=top><FONT SIZE=2><CFOUTPUT>#DateFormat("#firstMsgDate#", "mmm-dd-yyyy")# / #TimeFormat("#firstMsgDate#")#</CFOUTPUT></FONT></TD>
				<TD ALIGN=center VALIGN=top><FONT SIZE=2><CFOUTPUT>#DateFormat("#lastMsgDate#", "mmm-dd-yyyy")# / #TimeFormat("#lastMsgDate#")#</CFOUTPUT></FONT></TD>
				<TD ALIGN=center VALIGN=top><CFOUTPUT>#msgCount#</CFOUTPUT></TD>
				</TR>
				<CFBREAK>
			</CFIF>
		</CFLOOP>
	</CFLOOP>
</CFIF>
</TABLE>

<!--- If user has permission to create new forums, include Post Message form. --->
<CFIF IsDefined("Cookie.EmazeForums_permissions")>
	<CFIF #ListContains("#Cookie.EmazeForums_permissions#","create")# NEQ 0 OR #Cookie.EmazeForums_userID# EQ 0>
		<P><HR NOSHADE WIDTH=600 ALIGN=left><H2>Create a new forum</H2>
		<CFSET postFromHomepage = 1>
		<CFSET forumID = 0>
		<CFINCLUDE TEMPLATE="postMsgTemplate.cfm">
	</CFIF>
<CFELSE>
	<CFINCLUDE TEMPLATE="../conf/#confID#AnonPermissions.cfm">
	<CFIF #ListContains("#confAnonPermissions#","create")#>
		<P><HR NOSHADE WIDTH=600 ALIGN=left><H2>Create a new forum</H2>
		<CFSET postFromHomepage = 1>
		<CFSET forumID = 0>
		<CFINCLUDE TEMPLATE="postMsgTemplate.cfm">
	</CFIF>
</CFIF>
<P>

<!--- Include the homepage footer for this conference. --->
<CFINCLUDE TEMPLATE="../conf/#confID#HomepageFooter.cfm">

<!--- Include navigation buttons at bottom of page. --->
<CFSET navAlign = "bottom">
<CFINCLUDE TEMPLATE="navigate.cfm">

<CFINCLUDE TEMPLATE="copyright.cfm">
</BODY></HTML>