<!---
Included in the confHomepage.cfm and readForum.cfm .
If user calls either file, ensures user has already logged in.
Checks for userID cookie. If does not exist, logs them in as anon user.
If userID does exist, but not permissions cookie, determines conference permissions.
(They could be coming from a system page or another conference.)
--->

	<!--- IF COOKIE DOES NOT EXIST, ANON LOGIN REAL QUICK --->
<CFIF NOT IsDefined("Cookie.EmazeForums_userID")>
	<CFINCLUDE TEMPLATE="../conf/#confID#AnonPermissions.cfm">
	<CFIF #ListContains("#confAnonPermissions#","read")# NEQ 0>
		<CFSET permissions = "#confAnonPermissions#">
		<CFIF #anonCookie# EQ 1>
			<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
			<CFCOOKIE NAME="EmazeForums_userID" VALUE="-1" DOMAIN="#systemDomain#">
			<CFCOOKIE NAME="EmazeForums_permissions" VALUE="#confID#,#confAnonPermissions#"
				DOMAIN="#systemDomain#">
			<CFINCLUDE TEMPLATE="../system/confAnonSelect.cfm">
			<CFCOOKIE NAME="EmazeForums_confs" VALUE="#confs#" DOMAIN="#systemDomain#">
		</CFIF>
	</CFIF>

<!---
If userID already exists, check for permissions.
If they do not exist, they have not yet been to any conference pages.
Determine conference permissions below.
--->
<CFELSEIF NOT IsDefined("Cookie.EmazeForums_permissions")>
	<CFSET getPermissions = 1>
<!---
If userID and permissions already exists, determine whether permissions are for this conference.
If not, determine permissions below.
--->
<CFELSEIF #ListFirst("#Cookie.EmazeForums_permissions#")# NEQ #confID#>
	<CFSET getPermissions = 1>
<CFELSEIF IsDefined("Cookie.EmazeForums_permissions")>
	<CFSET permissions = "#Cookie.EmazeForums_permissions#">
</CFIF>

<CFIF IsDefined("getPermissions")>
	<CFIF #Cookie.EmazeForums_userID# EQ -1><!--- Write anon user permissions cookie --->
		<CFINCLUDE TEMPLATE="../conf/#confID#AnonPermissions.cfm">
		<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
		<CFCOOKIE NAME="EmazeForums_permissions" VALUE="#confID#,#confAnonPermissions#"
			DOMAIN="#systemDomain#">
		<CFSET permissions = "#confAnonPermissions#">
	<CFELSEIF #Cookie.EmazeForums_userID# EQ 0><!--- master user --->
		<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
		<CFCOOKIE NAME="EmazeForums_permissions" VALUE="#confID#,master" DOMAIN="#systemDomain#">
		<CFSET permissions = "read,post">
	<CFELSE><!--- Get groups user is a member of --->
		<CFQUERY NAME="getGroups" DATASOURCE="#CFdatasource#">
			SELECT UserGrp.groupID, GrpConf.groupPermissions
			FROM UserGrp INNER JOIN GrpConf ON UserGrp.groupID = GrpConf.groupID
			WHERE UserGrp.userID = #Cookie.EmazeForums_userID#
				AND GrpConf.confID = #confID#
			ORDER BY UserGrp.groupID
		</CFQUERY>

		<!--- Determine user permissions for this conference. --->
		<CFSET userPermissions = "#confID#">
		<CFLOOP QUERY="getGroups">
			<CFLOOP INDEX=count LIST="#getGroups.groupPermissions#">
				<CFIF #ListContains("#userPermissions#",#count#)# EQ 0>
					<CFSET userPermissions = "#ListAppend("#userPermissions#","#count#")#">
				</CFIF>
			</CFLOOP>
		</CFLOOP>

		<CFIF #ListContains("#userPermissions#","read")# NEQ 0>
			<!--- Determine forum admin permissions, add to permission list, write cookie --->
			<CFQUERY NAME="getAdmin" DATASOURCE="#CFdatasource#">
				SELECT forumID FROM UserForumAdmin WHERE userID = #Cookie.EmazeForums_userID#
			</CFQUERY>
			<CFLOOP QUERY="getAdmin">
				<CFSET userPermissions = "#ListAppend("#userPermissions#","#forumID#")#">
			</CFLOOP>
		</CFIF>
		<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
		<CFCOOKIE NAME="EmazeForums_permissions" VALUE="#userPermissions#"
			 DOMAIN="#systemDomain#">
		<CFSET permissions = "#userPermissions#">
	</CFIF>
</CFIF>

<!--- If user or anon user does not have read permission, kick them out. --->
<CFIF IsDefined("Cookie.EmazeForums_userID")>
	<CFIF #Cookie.EmazeForums_userID# EQ 0>
		<CFSET permissions = "read,post">
	</CFIF>
</CFIF>

<CFIF #ListContains("#permissions#","read")# EQ 0>
	<HTML><HEAD><TITLE>Emaze Forums: Home - <CFOUTPUT>#confName#</CFOUTPUT></TITLE></HEAD>
	<CFINCLUDE TEMPLATE="../system/noPermission.cfm">
	<CFINCLUDE TEMPLATE="copyright.cfm">
	</BODY></HTML>
	<CFABORT>
</CFIF>
