<!---
Sends anon users to conference home page. Determines permissions and
creates cookie. Conference anon alias files point to it.

1. Checks anon user permissions for the conference.
2. If read permission, displays conference homepage.
3. Writes userID cookie (-1 for anon), permissions cookie, and confs cookie.
--->

<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">
<!--- Read anon permissions for this conference --->
<CFINCLUDE TEMPLATE="../conf/#confID#AnonPermissions.cfm">

<!--- If anon has at least read permission --->
<CFIF #ListContains("#confAnonPermissions#","read")# NEQ 0>
	<CFIF #anonCookie# EQ 1>
		<CFINCLUDE TEMPLATE="../system/systemDomain.cfm">
		<CFCOOKIE NAME="EmazeForums_userID" VALUE="-1" DOMAIN="#systemDomain#">
		<CFCOOKIE NAME="EmazeForums_permissions" VALUE="#confID#,#confAnonPermissions#"
			 DOMAIN="#systemDomain#">
		<CFINCLUDE TEMPLATE="../system/confAnonSelect.cfm">
		<CFCOOKIE NAME="EmazeForums_confs" VALUE="#confs#" DOMAIN="#systemDomain#">
	</CFIF>

	<!--- Display the conference hoempage --->
	<CFINCLUDE TEMPLATE="confHomepage.cfm">

<CFELSE><!--- No anon read permission for this conference --->
	<CFINCLUDE TEMPLATE="../conf/#confID#Name.cfm">
	<HTML>
	<HEAD><TITLE>Emaze Forums: Home - <CFOUTPUT>#confName#</CFOUTPUT></TITLE></HEAD>
	<CFINCLUDE TEMPLATE="../conf/#confID#Body.cfm">
	<CFINCLUDE TEMPLATE="../system/noPermission.cfm">
	<CFINCLUDE TEMPLATE="copyright.cfm">
	</BODY></HTML>
</CFIF>