<CFINCLUDE TEMPLATE="system/systemInfo.cfm">

<HTML>
<HEAD><TITLE>Emaze Forums: Create Database</TITLE></HEAD>
<BODY BGCOLOR=white>

<H1 ALIGN=center><FONT COLOR=purple>Create Database</FONT></H1>

<CFQUERY NAME=Conference DATASOURCE="#CFdatasource#">
	CREATE TABLE Conference
	([confID] long,
	[bodyAlink] text (20),
	[bodyBackground] text (50),
	[bodyBgcolor] text (20),
	[bodyLink] text (20),
	[bodyText] text (20),
	[bodyVlink] text (20),
	[confDescription] memo,
	[confFooter] short,
	[confHeader] short,
	[confName] text (50),
	[confStatus] short,
	[logoutURL] text (50),
	[hypertextURL] short,
	[includeIndex] short,
	[confAnonPermissions] text (100),
	[loginUserCookie] short,
	[mailtoEmails] short,
	[moderated] short,
	[msgOrder] short,
	[bodyOther] text (100),
	[search] text (50),
	[urlAnonAlias] text (50),
	[urlLoginAlias] text (50),
	[forumOrder] short,
	[newUserGroup] text (20),
	[urlAdduserAlias] text (50),
	CONSTRAINT [Index1] PRIMARY KEY ([confID]))
</CFQUERY>

Conference table created.<BR>

<CFQUERY NAME=ConfForum DATASOURCE="#CFdatasource#">
	CREATE TABLE ConfForum
	([confID] long,
	[forumID] long,
	CONSTRAINT [Index1] PRIMARY KEY ([confID], [forumID]))
</CFQUERY>

ConfForum table created.<BR>

<CFQUERY NAME=Forum DATASOURCE="#CFdatasource#">
	CREATE TABLE Forum
	([forumID] long,
	[firstMsgDate] datetime,
	[forumDescription] memo,
	[forumName] text (50),
	[forumStatus] short,
	[lastMsgDate] datetime,
	[msgCount] short,
	[useForumFooter] short,
	[useForumHeader] short,
	CONSTRAINT [Index1] PRIMARY KEY ([forumID]))
</CFQUERY>

Forum table created.<BR>

<CFQUERY NAME=Grp DATASOURCE="#CFdatasource#">
	CREATE TABLE Grp
	([groupID] long,
	[groupName] text (50),
	[groupDescription] memo,
	CONSTRAINT [Index1] PRIMARY KEY ([groupID]))
</CFQUERY>

Group table created.<BR>

<CFQUERY NAME=insertGrp DATASOURCE="#CFdatasource#">
	INSERT INTO Grp (groupID, groupName, groupDescription)
	VALUES (1, 'Everyone', 'Default group for new users')
</CFQUERY>

<I>Group table initial data inserted.</I><BR>

<CFQUERY NAME=GrpConf DATASOURCE="#CFdatasource#">
	CREATE TABLE GrpConf
	([confID] long,
	[groupID] long,
	[groupPermissions] text (100),
	CONSTRAINT [Index1] PRIMARY KEY ([confID], [groupID]))
</CFQUERY>

GrpConf table created.<BR>

<CFQUERY NAME=Message DATASOURCE="#CFdatasource#">
	CREATE TABLE Message
	([anonEmail] text (50),
	[anonName] text (50),
	[approved] short,
	[attachment] text (50),
	[forumID] long,
	[indent] short,
	[message] memo,
	[msgDateTime] datetime,
	[msgID] text (50),
	[responses] short,
	[subject] text (50),
	[userID] long,
	CONSTRAINT [Index1] PRIMARY KEY ([msgID]))
</CFQUERY>

Message table created.<BR>

<CFQUERY NAME=User DATASOURCE="#CFdatasource#">
	CREATE TABLE User
	([email] text (50),
	[firstName] text (50),
	[lastName] text (25),
	[password] text (35),
	[useCookie] short,
	[userID] long,
	[username] text (25),
	CONSTRAINT [Index1] PRIMARY KEY ([userID]))
</CFQUERY>

User table created.<BR>

<CFQUERY NAME=insertUserAnon DATASOURCE="#CFdatasource#">
	INSERT INTO User (userID, email, firstName, lastName, password, useCookie, username)
	VALUES (-1, 'anon', 'anon', 'anon', ' ', 0, ' ')
</CFQUERY>

<CFQUERY NAME=insertUserMaster DATASOURCE="#CFdatasource#">
	INSERT INTO User (userID, email, firstName, lastName, password, useCookie, username)
	VALUES (0, 'webmaster@emaze.com', 'Emaze', 'Webmaster', 'emaze', 0, 'master')
</CFQUERY>

<I>User table initial data inserted.</I><BR>

<CFQUERY NAME=UserGrp DATASOURCE="#CFdatasource#">
	CREATE TABLE UserGrp
	([userID] long,
	[groupID] long,
	CONSTRAINT [Index1] PRIMARY KEY ([userID], [groupID]))
</CFQUERY>

UserGrp table created.<BR>

<CFQUERY NAME=UserForumAdmin DATASOURCE="#CFdatasource#">
	CREATE TABLE UserForumAdmin
	([userID] long,
	[forumID] long,
	CONSTRAINT [Index1] PRIMARY KEY ([forumID], [userID]))
</CFQUERY>

UserForumAdmin table created.<BR>

<CFQUERY NAME=UserMsgSubscribe DATASOURCE="#CFdatasource#">
	CREATE TABLE UserMsgSubscribe
	([msgID] text (50),
	[userID] long,
	CONSTRAINT [Index1] PRIMARY KEY ([msgID], [userID]))
</CFQUERY>

UserMsgSubscribe table created.<BR>

<H1>Database set up completed!</H1>

</BODY>
</HTML>