<!---
Get the list of active and archived forums in this conference
in the proper order for navigation.
Output all forums IDs and names in conf/#confID#ForumSelect.cfm
--->

<CFIF NOT IsDefined("confID")>
	<CFINCLUDE TEMPLATE="security.cfm">
</CFIF>

<CFINCLUDE TEMPLATE="../system/systemInfo.cfm">

<CFINCLUDE TEMPLATE="../conf/#confID#ForumOrder.cfm">
<CFIF #forumOrder# NEQ 4><!--- If not custom forum order --->
	<!--- Get forum information for all forums in conference in proper order. --->
	<CFQUERY NAME="getForumInfo" DATASOURCE="#CFdatasource#">
		SELECT Forum.forumName, ConfForum.forumID
		FROM ConfForum INNER JOIN Forum ON ConfForum.forumID = Forum.forumID
		WHERE NOT Forum.forumStatus = 0 AND ConfForum.confID = #confID#
		<CFIF #forumOrder# EQ 0>ORDER BY ConfForum.forumID
		<CFELSEIF #forumOrder# EQ 1>ORDER BY ConfForum.forumID DESC
		<CFELSEIF #forumOrder# EQ 2>ORDER BY forumName
		<CFELSE><!--- #forumOrder# EQ 3 --->ORDER BY forumName DESC
		</CFIF>
	</CFQUERY>

	<CFLOOP QUERY="getForumInfo">
		<CFIF #getForumInfo.CurrentRow# EQ 1>
			<CFFILE ACTION=Write FILE="#systemPath#\conf\#confID#ForumSelect.cfm"
				OUTPUT="<OPTION VALUE=#forumID#>#forumName#">
		<CFELSE>
			<CFFILE ACTION=Append FILE="#systemPath#\conf\#confID#ForumSelect.cfm"
				OUTPUT="<OPTION VALUE=#forumID#>#forumName#">
		</CFIF>
	</CFLOOP>

<CFELSE><!--- custom forum order --->
	<!--- Get custom forum order in confForums.cfm file for that conference. --->
	<CFINCLUDE TEMPLATE="../conf/#confID#Forums.cfm">
	<!--- Get forum information for all forums in conference. --->
	<CFSET count = 2>
	<CFQUERY NAME="getForumInfo" DATASOURCE="#CFdatasource#">
		SELECT forumID, forumName
		FROM Forum
		WHERE NOT forumStatus = 0
			AND (forumID = #ListGetAt("#forums#",1)#
			<CFLOOP INDEX=count LIST="#forums#">
				OR forumID = #count#
			</CFLOOP>)
	</CFQUERY>

	<CFSET firstForum = 1>
	<CFLOOP INDEX="fCount" LIST="#forums#">
		<CFLOOP QUERY="getForumInfo">
			<CFIF #forumID# EQ #fCount# AND #firstForum# EQ 1>
				<CFFILE ACTION=Write FILE="#systemPath#\conf\#confID#ForumSelect.cfm"
					OUTPUT="<OPTION VALUE=#forumID#>#forumName#">
				<CFSET firstForum = 0>
				<CFBREAK>
			<CFELSEIF #forumID# EQ #fCount#>
				<CFFILE ACTION=Append FILE="#systemPath#\conf\#confID#ForumSelect.cfm"
					OUTPUT="<OPTION VALUE=#forumID#>#forumName#">
				<CFBREAK>
			</CFIF>
		</CFLOOP>
	</CFLOOP>

</CFIF>